/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class NcStreamIosp
extends AbstractIOServiceProvider {
    private static final boolean debug = false;
    private int version;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
            return false;
        }
        byte[] b = new byte[4];
        raf.read(b);
        return this.test(b, NcStream.MAGIC_HEADER) || this.test(b, NcStream.MAGIC_DATA);
    }

    @Override
    public String getFileTypeId() {
        return "ncstream";
    }

    @Override
    public String getFileTypeDescription() {
        return "netCDF streaming protocol";
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.openDebug(raf, ncfile, null);
    }

    @Override
    public Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        List storage = (List)v.getSPobject();
        ByteBuffer result = null;
        for (DataStorage dataStorage : storage) {
            if (!dataStorage.section.intersects(section)) continue;
            this.raf.seek(dataStorage.filePos);
            byte[] data = new byte[dataStorage.size];
            this.raf.read(data);
            if (dataStorage.isDeflate) {
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                InflaterInputStream in = new InflaterInputStream(bin);
                ByteArrayOutputStream bout = new ByteArrayOutputStream(data.length * 7);
                IO.copy(in, bout);
                byte[] resultb = bout.toByteArray();
                result = ByteBuffer.wrap(resultb);
                System.out.printf(" uncompressedLen header=%d actual=%d%n", dataStorage.uncompressedLen, resultb.length);
                continue;
            }
            result = ByteBuffer.wrap(data);
        }
        return Array.factory(v.getDataType(), v.getShape(), result);
    }

    public Array readVlenData(Variable v, Section section, DataStorage dataStorage) throws IOException, InvalidRangeException {
        this.raf.seek(dataStorage.filePos);
        int nelems = this.readVInt(this.raf);
        Object[] result = new Object[nelems];
        for (int elem = 0; elem < nelems; ++elem) {
            int dsize = this.readVInt(this.raf);
            byte[] data = new byte[dsize];
            this.raf.read(data);
            Array dataArray = Array.factory(v.getDataType(), null, ByteBuffer.wrap(data));
            result[elem] = dataArray;
        }
        return new ArrayObject(result[0].getClass(), new int[]{nelems}, result);
    }

    private int readVInt(RandomAccessFile raf) throws IOException {
        byte b = (byte)raf.read();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = (byte)raf.read();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    private boolean readAndTest(RandomAccessFile raf, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        raf.read(b);
        return this.test(b, test);
    }

    private boolean test(byte[] bread, byte[] test) throws IOException {
        if (bread.length != test.length) {
            return false;
        }
        for (int i = 0; i < bread.length; ++i) {
            if (bread[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    public void openDebug(RandomAccessFile raf, NetcdfFile ncfile, List<NcsMess> ncm) throws IOException {
        this.raf = raf;
        raf.seek(0L);
        long pos = raf.getFilePointer();
        if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
            if (ncm != null) {
                ncm.add(new NcsMess(pos, 0, "MAGIC_START missing - abort"));
                return;
            }
            throw new IOException("Data corrupted on " + ncfile.getLocation());
        }
        if (ncm != null) {
            ncm.add(new NcsMess(pos, 4, "MAGIC_START"));
        }
        pos = raf.getFilePointer();
        if (!this.readAndTest(raf, NcStream.MAGIC_HEADER)) {
            if (ncm != null) {
                ncm.add(new NcsMess(pos, 0, "MAGIC_HEADER missing - abort"));
                return;
            }
            throw new IOException("Data corrupted on " + ncfile.getLocation());
        }
        if (ncm != null) {
            ncm.add(new NcsMess(pos, 4, "MAGIC_HEADER"));
        }
        int msize = this.readVInt(raf);
        byte[] m = new byte[msize];
        raf.read(m);
        NcStreamProto.Header proto = NcStreamProto.Header.parseFrom(m);
        if (ncm != null) {
            ncm.add(new NcsMess(pos, msize, proto));
        }
        this.version = proto.getVersion();
        NcStreamProto.Group root = proto.getRoot();
        NcStream.readGroup(root, ncfile, ncfile.getRootGroup());
        ncfile.finish();
        while (!raf.isAtEndOfFile()) {
            ArrayList<DataStorage> storage;
            byte[] dp;
            pos = raf.getFilePointer();
            byte[] b = new byte[4];
            raf.read(b);
            if (this.test(b, NcStream.MAGIC_END)) {
                if (ncm == null) break;
                ncm.add(new NcsMess(pos, 4, "MAGIC_END"));
                break;
            }
            if (this.test(b, NcStream.MAGIC_ERR)) {
                int esize = this.readVInt(raf);
                dp = new byte[esize];
                raf.read(dp);
                NcStreamProto.Error error = NcStreamProto.Error.parseFrom(dp);
                if (ncm == null) break;
                ncm.add(new NcsMess(pos, esize, error.getMessage()));
                break;
            }
            if (!this.test(b, NcStream.MAGIC_DATA)) {
                if (ncm == null) break;
                ncm.add(new NcsMess(pos, 4, "MAGIC_DATA missing - abort"));
                break;
            }
            if (ncm != null) {
                ncm.add(new NcsMess(pos, 4, "MAGIC_DATA".intern()));
            }
            pos = raf.getFilePointer();
            int psize = this.readVInt(raf);
            dp = new byte[psize];
            raf.read(dp);
            NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
            Variable v = ncfile.findVariable(dproto.getVarName());
            if (v == null) {
                System.out.printf(" ERR cant find var %s%n%s%n", dproto.getVarName(), dproto);
                continue;
            }
            if (ncm != null) {
                ncm.add(new NcsMess(pos, psize, dproto));
            }
            if ((storage = (ArrayList<DataStorage>)v.getSPobject()) == null) {
                storage = new ArrayList<DataStorage>();
                v.setSPobject(storage);
            }
            if (!dproto.getVdata()) {
                int dsize = this.readVInt(raf);
                DataStorage dataStorage = new DataStorage();
                dataStorage.size = dsize;
                dataStorage.filePos = raf.getFilePointer();
                dataStorage.section = NcStream.decodeSection(dproto.getSection());
                dataStorage.nelems = (int)dataStorage.section.computeSize();
                boolean bl = dataStorage.isDeflate = dproto.getCompress() == NcStreamProto.Compress.DEFLATE;
                if (dataStorage.isDeflate) {
                    dataStorage.uncompressedLen = dproto.getUncompressedSize();
                }
                if (ncm != null) {
                    ncm.add(new NcsMess(dataStorage.filePos, dsize, dataStorage));
                }
                storage.add(dataStorage);
                raf.skipBytes(dsize);
                continue;
            }
            DataStorage dataStorage = new DataStorage();
            dataStorage.filePos = raf.getFilePointer();
            int nelems = this.readVInt(raf);
            int totalSize = 0;
            for (int i = 0; i < nelems; ++i) {
                int dsize = this.readVInt(raf);
                totalSize += dsize;
                raf.skipBytes(dsize);
            }
            dataStorage.isVlen = true;
            dataStorage.nelems = nelems;
            dataStorage.size = totalSize;
            dataStorage.section = NcStream.decodeSection(dproto.getSection());
            if (ncm != null) {
                ncm.add(new NcsMess(dataStorage.filePos, totalSize, dataStorage));
            }
            storage.add(dataStorage);
        }
    }

    public class NcsMess {
        public long filePos;
        public int len;
        public int nelems;
        public Object what;

        public NcsMess(long filePos, int len, Object what) {
            this.filePos = filePos;
            this.len = len;
            this.what = what;
            if (what instanceof DataStorage) {
                this.nelems = ((DataStorage)what).nelems;
            }
        }

        public String showDeflate() {
            if (!(this.what instanceof DataStorage)) {
                return "Must select a NcStreamIosp.DataStorage object";
            }
            Formatter f = new Formatter();
            try {
                DataStorage dataStorage = (DataStorage)this.what;
                NcStreamIosp.this.raf.seek(dataStorage.filePos);
                byte[] data = new byte[dataStorage.size];
                NcStreamIosp.this.raf.read(data);
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DeflaterOutputStream dout = new DeflaterOutputStream(bout);
                IO.copy(bin, dout);
                dout.close();
                int deflatedSize = bout.size();
                float ratio = (float)data.length / (float)deflatedSize;
                f.format("Original size = %d bytes, deflated = %d bytes ratio = %f %n", data.length, deflatedSize, Float.valueOf(ratio));
                return f.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }
    }

    private class DataStorage {
        int size;
        long filePos;
        Section section;
        boolean isVlen;
        boolean isDeflate;
        int nelems;
        int uncompressedLen;

        private DataStorage() {
        }

        public String toString() {
            return "size=" + this.size + ", filePos=" + this.filePos + ", section=" + this.section + ", nelems=" + this.nelems + ", isVlen=" + this.isVlen + ", isDeflate=" + this.isDeflate;
        }
    }
}

