/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamWriterChannel {
    private static long maxChunk = 1000000L;
    private static int sizeToCache = 100;
    private NetcdfFile ncfile;
    private NcStreamProto.Header header;
    private boolean show = false;

    public NcStreamWriterChannel(NetcdfFile ncfile, String location) throws IOException {
        this.ncfile = ncfile;
        NcStreamProto.Group.Builder rootBuilder = NcStream.encodeGroup(ncfile.getRootGroup(), sizeToCache);
        NcStreamProto.Header.Builder headerBuilder = NcStreamProto.Header.newBuilder();
        headerBuilder.setLocation(location == null ? ncfile.getLocation() : location);
        if (ncfile.getTitle() != null) {
            headerBuilder.setTitle(ncfile.getTitle());
        }
        if (ncfile.getId() != null) {
            headerBuilder.setId(ncfile.getId());
        }
        headerBuilder.setRoot(rootBuilder);
        this.header = headerBuilder.build();
    }

    public long sendStart(WritableByteChannel wbc) throws IOException {
        return this.writeBytes(wbc, NcStream.MAGIC_START);
    }

    public long sendEnd(WritableByteChannel wbc) throws IOException {
        return this.writeBytes(wbc, NcStream.MAGIC_END);
    }

    public long sendHeader(WritableByteChannel wbc) throws IOException {
        long size = 0L;
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_HEADER);
        byte[] b = this.header.toByteArray();
        size += (long)NcStream.writeVInt(wbc, b.length);
        if (this.show) {
            System.out.println("Write Header len=" + b.length);
        }
        size += (long)this.writeBytes(wbc, b);
        if (this.show) {
            System.out.println(" header size=" + size);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendData(Variable v, Section section, WritableByteChannel wbc, boolean deflate) throws IOException, InvalidRangeException {
        if (this.show) {
            System.out.printf(" %s section=%s%n", v.getFullName(), section);
        }
        long size = 0L;
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_DATA);
        NcStreamProto.Data dataProto = NcStream.encodeDataProto(v, section, deflate, 0);
        byte[] datab = dataProto.toByteArray();
        size += (long)NcStream.writeVInt(wbc, datab.length);
        size += (long)this.writeBytes(wbc, datab);
        if (v.getDataType() == DataType.SEQUENCE) {
            int count = 0;
            DataOutputStream os = new DataOutputStream(Channels.newOutputStream(wbc));
            Structure seq = (Structure)v;
            StructureDataIterator iter = seq.getStructureIterator(-1);
            try {
                while (iter.hasNext()) {
                    size += (long)this.writeBytes(wbc, NcStream.MAGIC_VDATA);
                    ArrayStructureBB abb = IospHelper.copyToArrayBB(iter.next());
                    size += NcStream.encodeArrayStructure(abb, os);
                    ++count;
                }
            }
            finally {
                iter.finish();
            }
            size += (long)this.writeBytes(wbc, NcStream.MAGIC_VEND);
            if (this.show) {
                System.out.printf(" NcStreamWriter sent %d sdata bytes = %d%n", count, size);
            }
            return size;
        }
        long len = section.computeSize();
        if (v.getDataType() != DataType.STRING && v.getDataType() != DataType.OPAQUE && !v.isVariableLength()) {
            len *= (long)v.getElementSize();
        }
        size += (long)NcStream.writeVInt(wbc, (int)len);
        if (this.show) {
            System.out.printf("  %s proto=%d data=%d%n", v.getFullName(), datab.length, len);
        }
        return size += v.readToByteChannel(section, wbc);
    }

    private int writeBytes(WritableByteChannel wbc, byte[] b) throws IOException {
        return wbc.write(ByteBuffer.wrap(b));
    }

    public long streamAll(WritableByteChannel wbc) throws IOException, InvalidRangeException {
        long size = this.writeBytes(wbc, NcStream.MAGIC_START);
        size += this.sendHeader(wbc);
        if (this.show) {
            System.out.printf(" data starts at= %d%n", size);
        }
        for (Variable v : this.ncfile.getVariables()) {
            Object chunkAtt = null;
            Attribute compressAtt = v.findAttribute("_Compress");
            boolean deflate = compressAtt != null && compressAtt.isString() && compressAtt.getStringValue().equalsIgnoreCase("deflate");
            long vsize = v.getSize() * (long)v.getElementSize();
            if (this.show) {
                System.out.printf(" var %s len=%d starts at= %d%n", v.getFullName(), vsize, size);
            }
            if (chunkAtt != null) {
                size += this.copyChunks(wbc, v, compressAtt.getStringValue(), deflate);
                continue;
            }
            if (vsize > maxChunk) {
                size += this.copyChunks(wbc, v, maxChunk, deflate);
                continue;
            }
            size += this.sendData(v, v.getShapeAsSection(), wbc, deflate);
        }
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_END);
        if (this.show) {
            System.out.printf("total size= %d%n", size);
        }
        return size;
    }

    private long copyChunks(WritableByteChannel wbc, Variable oldVar, long maxChunkSize, boolean deflate) throws IOException {
        long maxChunkElems = maxChunkSize / (long)oldVar.getElementSize();
        FileWriter.ChunkingIndex index = new FileWriter.ChunkingIndex(oldVar.getShape());
        long size = 0L;
        while ((long)index.currentElement() < index.getSize()) {
            try {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                size += this.sendData(oldVar, new Section(chunkOrigin, chunkShape), wbc, deflate);
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        return size;
    }

    private long copyChunks(WritableByteChannel wbc, Variable oldVar, String chunk, boolean deflate) throws IOException {
        return 0L;
    }

    public static void main2(String[] args) throws InvalidRangeException {
        int[] totalShape = new int[]{1, 40, 530, 240};
        int[] chunkShape = new int[]{1, 1, 530, 240};
        FileWriter.ChunkingIndex index = new FileWriter.ChunkingIndex(totalShape);
        long size = 0L;
        while ((long)index.currentElement() < index.getSize()) {
            int[] chunkOrigin = index.getCurrentCounter();
            System.out.printf(" %s%n", new Section(chunkOrigin, chunkShape));
            index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
        }
    }

    public static void main(String[] args) throws InvalidRangeException {
        long maxChunkElems = maxChunk / 4L;
        int[] totalShape = new int[]{1, 40, 530, 240};
        FileWriter.ChunkingIndex index = new FileWriter.ChunkingIndex(totalShape);
        long size = 0L;
        while ((long)index.currentElement() < index.getSize()) {
            int[] chunkOrigin = index.getCurrentCounter();
            int[] chunkShape = index.computeChunkShape(maxChunkElems);
            System.out.printf(" %s%n", new Section(chunkOrigin, chunkShape));
            index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
        }
    }
}

