/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.DebugFlagsImpl;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class Hdf5ObjectTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted objectTable;
    private BeanTableSorted messTable;
    private BeanTableSorted attTable;
    private JSplitPane splitH;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane dumpTA;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private H5iosp iosp;
    private String location;

    public Hdf5ObjectTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.objectTable = new BeanTableSorted(ObjectBean.class, (PreferencesExt)prefs.node("Hdf5Object"), false, "H5header.DataObject", "Level 2A data object header");
        this.objectTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Hdf5ObjectTable.this.messTable.setBeans(new ArrayList());
                ArrayList<MessageBean> beans = new ArrayList<MessageBean>();
                ObjectBean ob = (ObjectBean)Hdf5ObjectTable.this.objectTable.getSelectedBean();
                for (H5header.HeaderMessage m : ob.m.getMessages()) {
                    beans.add(new MessageBean(m));
                }
                Hdf5ObjectTable.this.messTable.setBeans(beans);
                ArrayList<AttributeBean> attBeans = new ArrayList<AttributeBean>();
                for (H5header.MessageAttribute m : ob.m.getAttributes()) {
                    attBeans.add(new AttributeBean(m));
                }
                Hdf5ObjectTable.this.attTable.setBeans(attBeans);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.objectTable.getJTable(), "Options");
        varPopup.addAction("show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectBean mb = (ObjectBean)Hdf5ObjectTable.this.objectTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Hdf5ObjectTable.this.dumpTA.clear();
                Formatter f = new Formatter();
                try {
                    mb.show(f);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                Hdf5ObjectTable.this.dumpTA.appendLine(f.toString());
                Hdf5ObjectTable.this.dumpTA.gotoTop();
            }
        });
        this.messTable = new BeanTableSorted(MessageBean.class, (PreferencesExt)prefs.node("MessBean"), false, "H5header.HeaderMessage", "Level 2A1 and 2A2 (part of Data Object)");
        this.messTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MessageBean mb = (MessageBean)Hdf5ObjectTable.this.messTable.getSelectedBean();
                Hdf5ObjectTable.this.dumpTA.setText(mb.m.toString());
            }
        });
        varPopup = new PopupMenu(this.messTable.getJTable(), "Options");
        varPopup.addAction("Show FractalHeap", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)Hdf5ObjectTable.this.messTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                if (Hdf5ObjectTable.this.infoTA == null) {
                    Hdf5ObjectTable.this.makeInfoWindow();
                }
                Hdf5ObjectTable.this.infoTA.clear();
                Formatter f = new Formatter();
                mb.m.showFractalHeap(f);
                Hdf5ObjectTable.this.infoTA.appendLine(f.toString());
                Hdf5ObjectTable.this.infoTA.gotoTop();
                Hdf5ObjectTable.this.infoWindow.show();
            }
        });
        this.attTable = new BeanTableSorted(AttributeBean.class, (PreferencesExt)prefs.node("AttBean"), false, "H5header.HeaderAttribute", "Message Type 12/0xC : define an Atribute");
        this.attTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AttributeBean mb = (AttributeBean)Hdf5ObjectTable.this.attTable.getSelectedBean();
                Formatter f = new Formatter();
                mb.show(f);
                Hdf5ObjectTable.this.dumpTA.setText(f.toString());
            }
        });
        this.dumpTA = new TextHistoryPane();
        this.splitH = new JSplitPane(1, false, this.objectTable, this.dumpTA);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 600));
        this.split = new JSplitPane(0, false, this.splitH, this.messTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.split2 = new JSplitPane(0, false, this.split, this.attTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.objectTable.saveState(false);
        this.messTable.saveState(false);
        this.attTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
    }

    private void makeInfoWindow() {
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds(new Rectangle(300, 300, 500, 800));
    }

    public void closeOpenFiles() throws IOException {
        if (this.iosp != null) {
            this.iosp.close();
        }
        this.iosp = null;
    }

    public void setHdf5File(RandomAccessFile raf) throws IOException {
        this.closeOpenFiles();
        this.location = raf.getLocation();
        long start = System.nanoTime();
        ArrayList<ObjectBean> beanList = new ArrayList<ObjectBean>();
        this.iosp = new H5iosp();
        MyNetcdfFile ncfile = new MyNetcdfFile(this.iosp, this.location);
        ncfile.sendIospMessage("IncludeOrgAttributes");
        try {
            this.iosp.open(raf, ncfile, null);
        }
        catch (Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(20000);
            PrintStream s = new PrintStream(bos);
            t.printStackTrace(s);
            this.dumpTA.setText(bos.toString());
        }
        H5header header = (H5header)this.iosp.sendIospMessage("header");
        for (H5header.DataObject dataObj : header.getDataObjects()) {
            beanList.add(new ObjectBean(dataObj));
        }
        this.objectTable.setBeans(beanList);
    }

    public void showInfo(Formatter f) throws IOException {
        if (this.iosp == null) {
            return;
        }
        ByteArrayOutputStream ff = new ByteArrayOutputStream(100000);
        PrintStream ps = new PrintStream(ff);
        H5header.setDebugFlags(new DebugFlagsImpl("H5header/header H5header/headerDetails H5header/symbolTable H5header/memTracker"));
        H5header headerEmpty = (H5header)this.iosp.sendIospMessage("headerEmpty");
        headerEmpty.read(ps);
        H5header.setDebugFlags(new DebugFlagsImpl(""));
        ps.flush();
        f.format("%s", ff.toString());
    }

    public class AttributeBean {
        H5header.MessageAttribute att;

        public AttributeBean() {
        }

        public AttributeBean(H5header.MessageAttribute att) {
            this.att = att;
        }

        public byte getVersion() {
            return this.att.getVersion();
        }

        public String getAttributeName() {
            return this.att.getName();
        }

        public String getMdt() {
            return this.att.getMdt().toString();
        }

        public String getMds() {
            return this.att.getMds().toString();
        }

        public long getDataPos() {
            return this.att.getDataPosAbsolute();
        }

        void show(Formatter f) {
            f.format("hdf5 att = %s%n%n", this.att);
            try {
                f.format("netcdf attribute%n %s;%n", this.att.getNcAttribute());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class MessageBean {
        H5header.HeaderMessage m;

        public MessageBean() {
        }

        public MessageBean(H5header.HeaderMessage m) {
            this.m = m;
        }

        public String getMessageType() {
            return this.m.getMtype().toString();
        }

        public String getName() {
            return this.m.getName();
        }

        public int getSize() {
            return this.m.getSize();
        }

        public byte getFlags() {
            return this.m.getFlags();
        }

        public long getStart() {
            return this.m.getStart();
        }
    }

    public class ObjectBean {
        H5header.DataObject m;

        public ObjectBean() {
        }

        public ObjectBean(H5header.DataObject m) {
            this.m = m;
        }

        public long getAddress() {
            return this.m.getAddress();
        }

        public String getName() {
            return this.m.getName();
        }

        void show(Formatter f) throws IOException {
            f.format("HDF5 object name '%s'%n", this.m.getName());
            for (H5header.MessageAttribute mess : this.m.getAttributes()) {
                Attribute att = mess.getNcAttribute();
                f.format("  %s%n", att);
            }
        }
    }

    private class MyNetcdfFile
    extends NetcdfFile {
        private MyNetcdfFile(H5iosp iosp, String location) {
            this.spi = iosp;
            this.location = location;
        }
    }
}

