/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.bounce.text.LineNumberMargin;
import org.bounce.text.ScrollableEditorPanel;
import org.bounce.text.xml.XMLEditorKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDataset;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.MController;
import thredds.inventory.bdb.MetadataManager;
import ucar.ma2.Array;
import ucar.nc2.FileWriter;
import ucar.nc2.FileWriter2;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.fmrc.FmrcDefinition;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.PointConfigXML;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.FeatureDatasetPointXML;
import ucar.nc2.geotiff.GeoTiff;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.grib.grib2.table.WmoTemplateTable;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.ui.AggTable;
import ucar.nc2.ui.BufrMessageViewer;
import ucar.nc2.ui.BufrTableBViewer;
import ucar.nc2.ui.BufrTableDViewer;
import ucar.nc2.ui.BufrWmoCodesPanel;
import ucar.nc2.ui.CollectionTable;
import ucar.nc2.ui.CoordSysTable;
import ucar.nc2.ui.DatasetViewer;
import ucar.nc2.ui.Fmrc2Panel;
import ucar.nc2.ui.GeoGridTable;
import ucar.nc2.ui.Grib1ReportPanel;
import ucar.nc2.ui.Grib1TablesViewer;
import ucar.nc2.ui.Grib2ReportPanel;
import ucar.nc2.ui.Grib2TablesViewer;
import ucar.nc2.ui.GribWmoCodesPanel;
import ucar.nc2.ui.GribWmoTemplatesPanel;
import ucar.nc2.ui.Hdf4Table;
import ucar.nc2.ui.Hdf5DataTable;
import ucar.nc2.ui.Hdf5ObjectTable;
import ucar.nc2.ui.PointFeatureDatasetViewer;
import ucar.nc2.ui.RadialDatasetTable;
import ucar.nc2.ui.StationRadialViewer;
import ucar.nc2.ui.ThreddsUI;
import ucar.nc2.ui.WmoCommonCodesPanel;
import ucar.nc2.ui.WmsViewer;
import ucar.nc2.ui.gis.shapefile.ShapeFileBean;
import ucar.nc2.ui.gis.worldmap.WorldMapBean;
import ucar.nc2.ui.grid.GridUI;
import ucar.nc2.ui.image.ImageViewPanel;
import ucar.nc2.ui.util.Resource;
import ucar.nc2.ui.util.SocketMessage;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PLAF;
import ucar.nc2.ui.widget.ProgressMonitor;
import ucar.nc2.ui.widget.ProgressMonitorTask;
import ucar.nc2.ui.widget.StopButton;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.ui.widget.URLDumpPane;
import ucar.nc2.ui.widget.UrlAuthenticatorDialog;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateFromString;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.net.HTTPSession;
import ucar.nc2.util.xml.RuntimeConfigParser;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.Debug;

public class ToolsUI
extends JPanel {
    private static Logger log = LoggerFactory.getLogger(ToolsUI.class);
    private static final String WorldDetailMap = "/resources/nj22/ui/maps/Countries.zip";
    private static final String USMap = "/resources/nj22/ui/maps/US.zip";
    private static final String FRAME_SIZE = "FrameSize";
    private static final String GRIDVIEW_FRAME_SIZE = "GridUIWindowSize";
    private static final String GRIDIMAGE_FRAME_SIZE = "GridImageWindowSize";
    private static boolean debugListen = false;
    private PreferencesExt mainPrefs;
    private AggPanel aggPanel;
    private BufrPanel bufrPanel;
    private BufrTableBPanel bufrTableBPanel;
    private BufrTableDPanel bufrTableDPanel;
    private BufrCodePanel bufrCodePanel;
    private CdmremotePanel cdmremotePanel;
    private CoordSysPanel coordSysPanel;
    private CollectionPanel collectionPanel;
    private FeatureScanPanel ftPanel;
    private FmrcPanel fmrcPanel;
    private GeoGridPanel gridPanel;
    private GribFilesPanel gribFilesPanel;
    private Grib2CollectionPanel gribNewPanel;
    private GribCollectionIndexPanel gribIdxPanel;
    private Grib1CollectionPanel grib1RawPanel;
    private Grib1ReportPanel grib1ReportPanel;
    private Grib2ReportPanel grib2ReportPanel;
    private GribCodePanel gribCodePanel;
    private GribTemplatePanel gribTemplatePanel;
    private Grib1TablePanel grib1TablePanel;
    private Grib2TablePanel grib2TablePanel;
    private GribRenamePanel gribVariableRenamePanel;
    private Hdf5ObjectPanel hdf5ObjectPanel;
    private Hdf5DataPanel hdf5DataPanel;
    private Hdf4Panel hdf4Panel;
    private ImagePanel imagePanel;
    private NcStreamPanel ncStreamPanel;
    private NCdumpPanel ncdumpPanel;
    private OpPanel ncmlEditorPanel;
    private OpPanel geotiffPanel;
    private PointFeaturePanel pointFeaturePanel;
    private StationRadialPanel stationRadialPanel;
    private RadialPanel radialPanel;
    private ThreddsUI threddsUI;
    private UnitsPanel unitsPanel;
    private URLDumpPane urlPanel;
    private ViewerPanel viewerPanel;
    private WmoCCPanel wmoCommonCodePanel;
    private WmsPanel wmsPanel;
    private JTabbedPane tabbedPane;
    private JTabbedPane iospTabPane;
    private JTabbedPane bufrTabPane;
    private JTabbedPane grib2TabPane;
    private JTabbedPane grib1TabPane;
    private JTabbedPane hdf5TabPane;
    private JTabbedPane ftTabPane;
    private JTabbedPane fmrcTabPane;
    private JTabbedPane ncmlTabPane;
    private JFrame parentFrame;
    private FileManager fileChooser;
    private AboutWindow aboutWindow = null;
    private ThreddsDataFactory threddsDataFactory = new ThreddsDataFactory();
    private DateFormatter formatter = new DateFormatter();
    private boolean setUseRecordStructure = false;
    private JMenu debugFlagMenu;
    private DebugFlags debugFlags;
    private boolean debug = false;
    private boolean debugTab = false;
    private boolean debugNcmlWrite = false;
    private boolean debugCB = false;
    private String downloadStatus = null;
    private FileManager bufrFileChooser = null;
    private static ToolsUI ui;
    private static JFrame frame;
    private static PreferencesExt prefs;
    private static XMLStore store;
    private static boolean done;
    private static MController cacheManager;
    private static String wantDataset;
    static boolean isCacheInit;
    static boolean isDiskCacheInit;

    public ToolsUI(PreferencesExt prefs, JFrame parentFrame) {
        this.mainPrefs = prefs;
        this.parentFrame = parentFrame;
        FileFilter[] filters = new FileFilter[]{new FileManager.HDF5ExtFilter(), new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parentFrame, null, filters, (PreferencesExt)prefs.node("FileManager"));
        this.tabbedPane = new JTabbedPane(1);
        this.iospTabPane = new JTabbedPane(1);
        this.grib2TabPane = new JTabbedPane(1);
        this.grib1TabPane = new JTabbedPane(1);
        this.bufrTabPane = new JTabbedPane(1);
        this.ftTabPane = new JTabbedPane(1);
        this.fmrcTabPane = new JTabbedPane(1);
        this.hdf5TabPane = new JTabbedPane(1);
        this.ncmlTabPane = new JTabbedPane(1);
        this.viewerPanel = new ViewerPanel((PreferencesExt)this.mainPrefs.node("varTable"));
        this.tabbedPane.addTab("Viewer", this.viewerPanel);
        this.tabbedPane.addTab("NCDump", new JLabel("NCDump"));
        this.tabbedPane.addTab("Iosp", this.iospTabPane);
        this.tabbedPane.addTab("CoordSys", new JLabel("CoordSys"));
        this.tabbedPane.addTab("FeatureTypes", this.ftTabPane);
        this.tabbedPane.addTab("THREDDS", new JLabel("THREDDS"));
        this.tabbedPane.addTab("Fmrc", this.fmrcTabPane);
        this.tabbedPane.addTab("GeoTiff", new JLabel("GeoTiff"));
        this.tabbedPane.addTab("Units", new JLabel("Units"));
        this.tabbedPane.addTab("NcML", this.ncmlTabPane);
        this.tabbedPane.addTab("URLdump", new JLabel("URLdump"));
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.tabbedPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.tabbedPane.getSelectedIndex();
                    String title = ToolsUI.this.tabbedPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.tabbedPane, title);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.iospTabPane.addTab("BUFR", this.bufrTabPane);
        this.iospTabPane.addTab("GRIB2", this.grib2TabPane);
        this.iospTabPane.addTab("GRIB1", this.grib1TabPane);
        this.iospTabPane.addTab("HDF5", this.hdf5TabPane);
        this.iospTabPane.addTab("HDF4", new JLabel("HDF4"));
        this.iospTabPane.addTab("CdmRemote", new JLabel("CdmRemote"));
        this.iospTabPane.addTab("NcStream", new JLabel("NcStream"));
        this.iospTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.iospTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.iospTabPane.getSelectedIndex();
                    String title = ToolsUI.this.iospTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.iospTabPane, title);
                }
            }
        });
        this.iospTabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = ToolsUI.this.iospTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.iospTabPane.getSelectedIndex();
                    String title = ToolsUI.this.iospTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.iospTabPane, title);
                }
            }
        });
        this.bufrTabPane.addTab("BUFR", new JLabel("BUFR"));
        this.bufrTabPane.addTab("BUFRTableB", new JLabel("BUFRTableB"));
        this.bufrTabPane.addTab("BUFRTableD", new JLabel("BUFRTableD"));
        this.bufrTabPane.addTab("BUFR-CODES", new JLabel("BUFR-CODES"));
        this.bufrTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.bufrTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.bufrTabPane.getSelectedIndex();
                    String title = ToolsUI.this.bufrTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.bufrTabPane, title);
                }
            }
        });
        this.bufrTabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = ToolsUI.this.bufrTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.bufrTabPane.getSelectedIndex();
                    String title = ToolsUI.this.bufrTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.bufrTabPane, title);
                }
            }
        });
        this.grib2TabPane.addTab("GRIB2collection", new JLabel("GRIB2collection"));
        this.grib2TabPane.addTab("GRIBindex", new JLabel("GRIBindex"));
        this.grib2TabPane.addTab("GRIB2-REPORT", new JLabel("GRIB2-REPORT"));
        this.grib2TabPane.addTab("WMO-COMMON", new JLabel("WMO-COMMON"));
        this.grib2TabPane.addTab("WMO-CODES", new JLabel("WMO-CODES"));
        this.grib2TabPane.addTab("WMO-TEMPLATES", new JLabel("WMO-TEMPLATES"));
        this.grib2TabPane.addTab("GRIB2-TABLES", new JLabel("GRIB2-TABLES"));
        this.grib2TabPane.addTab("GRIB-RENAME", new JLabel("GRIB-RENAME"));
        this.grib2TabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.grib2TabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.grib2TabPane.getSelectedIndex();
                    String title = ToolsUI.this.grib2TabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.grib2TabPane, title);
                }
            }
        });
        this.grib2TabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = ToolsUI.this.grib2TabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.grib2TabPane.getSelectedIndex();
                    String title = ToolsUI.this.grib2TabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.grib2TabPane, title);
                }
            }
        });
        this.grib1TabPane.addTab("GRIB1collection", new JLabel("GRIB1collection"));
        this.grib1TabPane.addTab("GRIB-FILES", new JLabel("GRIB-FILES"));
        this.grib1TabPane.addTab("GRIB1-REPORT", new JLabel("GRIB1-REPORT"));
        this.grib1TabPane.addTab("GRIB1-TABLES", new JLabel("GRIB1-TABLES"));
        this.grib1TabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.grib1TabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.grib1TabPane.getSelectedIndex();
                    String title = ToolsUI.this.grib1TabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.grib1TabPane, title);
                }
            }
        });
        this.grib1TabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = ToolsUI.this.grib1TabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.grib1TabPane.getSelectedIndex();
                    String title = ToolsUI.this.grib1TabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.grib1TabPane, title);
                }
            }
        });
        this.hdf5TabPane.addTab("HDF5-Objects", new JLabel("HDF5-Objects"));
        this.hdf5TabPane.addTab("HDF5-Data", new JLabel("HDF5-Data"));
        this.hdf5TabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.hdf5TabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.hdf5TabPane.getSelectedIndex();
                    String title = ToolsUI.this.hdf5TabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.hdf5TabPane, title);
                }
            }
        });
        this.hdf5TabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = ToolsUI.this.hdf5TabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.hdf5TabPane.getSelectedIndex();
                    String title = ToolsUI.this.hdf5TabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.hdf5TabPane, title);
                }
            }
        });
        this.ftTabPane.addTab("Grids", new JLabel("Grids"));
        this.ftTabPane.addTab("WMS", new JLabel("WMS"));
        this.ftTabPane.addTab("PointFeature", new JLabel("PointFeature"));
        this.ftTabPane.addTab("Trajectory", new JLabel("Trajectory"));
        this.ftTabPane.addTab("Images", new JLabel("Images"));
        this.ftTabPane.addTab("Radial", new JLabel("Radial"));
        this.ftTabPane.addTab("FeatureScan", new JLabel("FeatureScan"));
        this.ftTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.ftTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.ftTabPane.getSelectedIndex();
                    String title = ToolsUI.this.ftTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.ftTabPane, title);
                }
            }
        });
        this.ftTabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = ToolsUI.this.ftTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.ftTabPane.getSelectedIndex();
                    String title = ToolsUI.this.ftTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.ftTabPane, title);
                }
            }
        });
        this.fmrcTabPane.addTab("Fmrc", new JLabel("Fmrc"));
        this.fmrcTabPane.addTab("Collections", new JLabel("Collections"));
        this.fmrcTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.fmrcTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.fmrcTabPane.getSelectedIndex();
                    String title = ToolsUI.this.fmrcTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.fmrcTabPane, title);
                }
            }
        });
        this.fmrcTabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = ToolsUI.this.fmrcTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.fmrcTabPane.getSelectedIndex();
                    String title = ToolsUI.this.fmrcTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.fmrcTabPane, title);
                }
            }
        });
        this.ncmlTabPane.addTab("NcmlEditor", new JLabel("NcmlEditor"));
        this.ncmlTabPane.addTab("Aggregation", new JLabel("Aggregation"));
        this.ncmlTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.ncmlTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.ncmlTabPane.getSelectedIndex();
                    String title = ToolsUI.this.ncmlTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.ncmlTabPane, title);
                }
            }
        });
        this.ncmlTabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = ToolsUI.this.ncmlTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.ncmlTabPane.getSelectedIndex();
                    String title = ToolsUI.this.ncmlTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.ncmlTabPane, title);
                }
            }
        });
        this.debugFlags = (DebugFlags)Proxy.newProxyInstance(DebugFlags.class.getClassLoader(), new Class[]{DebugFlags.class}, (InvocationHandler)new DebugProxyHandler());
        this.makeMenuBar();
        this.setDebugFlags();
    }

    private void makeComponent(JTabbedPane parent, String title) {
        JPanel c;
        String cTitle;
        int idx;
        if (parent == null) {
            parent = this.tabbedPane;
        }
        int n = parent.getTabCount();
        for (idx = 0; idx < n && !(cTitle = parent.getTitleAt(idx)).equals(title); ++idx) {
        }
        if (idx >= n) {
            if (this.debugTab) {
                System.out.println("Cant find " + title + " in " + parent);
            }
            return;
        }
        if (title.equals("Aggregation")) {
            c = this.aggPanel = new AggPanel((PreferencesExt)this.mainPrefs.node("NcMLAggregation"));
        } else if (title.equals("BUFR")) {
            this.bufrPanel = new BufrPanel((PreferencesExt)this.mainPrefs.node("bufr"));
            c = this.bufrPanel;
        } else if (title.equals("BUFRTableB")) {
            this.bufrTableBPanel = new BufrTableBPanel((PreferencesExt)this.mainPrefs.node("bufr2"));
            c = this.bufrTableBPanel;
        } else if (title.equals("BUFRTableD")) {
            this.bufrTableDPanel = new BufrTableDPanel((PreferencesExt)this.mainPrefs.node("bufrD"));
            c = this.bufrTableDPanel;
        } else if (title.equals("BUFR-CODES")) {
            this.bufrCodePanel = new BufrCodePanel((PreferencesExt)this.mainPrefs.node("bufr-codes"));
            c = this.bufrCodePanel;
        } else if (title.equals("CdmRemote")) {
            this.cdmremotePanel = new CdmremotePanel((PreferencesExt)this.mainPrefs.node("CdmRemote"));
            c = this.cdmremotePanel;
        } else if (title.equals("NcStream")) {
            this.ncStreamPanel = new NcStreamPanel((PreferencesExt)this.mainPrefs.node("NcStream"));
            c = this.ncStreamPanel;
        } else if (title.equals("GRIB1collection")) {
            this.grib1RawPanel = new Grib1CollectionPanel((PreferencesExt)this.mainPrefs.node("grib1raw"));
            c = this.grib1RawPanel;
        } else if (title.equals("GRIB-FILES")) {
            this.gribFilesPanel = new GribFilesPanel((PreferencesExt)this.mainPrefs.node("gribFiles"));
            c = this.gribFilesPanel;
        } else if (title.equals("GRIB2collection")) {
            this.gribNewPanel = new Grib2CollectionPanel((PreferencesExt)this.mainPrefs.node("gribNew"));
            c = this.gribNewPanel;
        } else if (title.equals("GRIBindex")) {
            this.gribIdxPanel = new GribCollectionIndexPanel((PreferencesExt)this.mainPrefs.node("gribIdx"));
            c = this.gribIdxPanel;
        } else if (title.equals("GRIB1-REPORT")) {
            this.grib1ReportPanel = new Grib1ReportPanel((PreferencesExt)this.mainPrefs.node("grib1Report"));
            c = this.grib1ReportPanel;
        } else if (title.equals("GRIB2-REPORT")) {
            this.grib2ReportPanel = new Grib2ReportPanel((PreferencesExt)this.mainPrefs.node("gribReport"));
            c = this.grib2ReportPanel;
        } else if (title.equals("WMO-COMMON")) {
            this.wmoCommonCodePanel = new WmoCCPanel((PreferencesExt)this.mainPrefs.node("wmo-common"));
            c = this.wmoCommonCodePanel;
        } else if (title.equals("WMO-CODES")) {
            this.gribCodePanel = new GribCodePanel((PreferencesExt)this.mainPrefs.node("wmo-codes"));
            c = this.gribCodePanel;
        } else if (title.equals("WMO-TEMPLATES")) {
            this.gribTemplatePanel = new GribTemplatePanel((PreferencesExt)this.mainPrefs.node("wmo-templates"));
            c = this.gribTemplatePanel;
        } else if (title.equals("GRIB1-TABLES")) {
            this.grib1TablePanel = new Grib1TablePanel((PreferencesExt)this.mainPrefs.node("grib1-tables"));
            c = this.grib1TablePanel;
        } else if (title.equals("GRIB2-TABLES")) {
            this.grib2TablePanel = new Grib2TablePanel((PreferencesExt)this.mainPrefs.node("grib2-tables"));
            c = this.grib2TablePanel;
        } else if (title.equals("GRIB-RENAME")) {
            this.gribVariableRenamePanel = new GribRenamePanel((PreferencesExt)this.mainPrefs.node("grib-rename"));
            c = this.gribVariableRenamePanel;
        } else if (title.equals("CoordSys")) {
            this.coordSysPanel = new CoordSysPanel((PreferencesExt)this.mainPrefs.node("CoordSys"));
            c = this.coordSysPanel;
        } else if (title.equals("FeatureScan")) {
            this.ftPanel = new FeatureScanPanel((PreferencesExt)this.mainPrefs.node("ftPanel"));
            c = this.ftPanel;
        } else if (title.equals("GeoTiff")) {
            this.geotiffPanel = new GeotiffPanel((PreferencesExt)this.mainPrefs.node("WCS"));
            c = this.geotiffPanel;
        } else if (title.equals("Grids")) {
            this.gridPanel = new GeoGridPanel((PreferencesExt)this.mainPrefs.node("grid"));
            c = this.gridPanel;
        } else if (title.equals("HDF5-Objects")) {
            this.hdf5ObjectPanel = new Hdf5ObjectPanel((PreferencesExt)this.mainPrefs.node("hdf5"));
            c = this.hdf5ObjectPanel;
        } else if (title.equals("HDF5-Data")) {
            this.hdf5DataPanel = new Hdf5DataPanel((PreferencesExt)this.mainPrefs.node("hdf5data"));
            c = this.hdf5DataPanel;
        } else if (title.equals("HDF4")) {
            this.hdf4Panel = new Hdf4Panel((PreferencesExt)this.mainPrefs.node("hdf4"));
            c = this.hdf4Panel;
        } else if (title.equals("Images")) {
            this.imagePanel = new ImagePanel((PreferencesExt)this.mainPrefs.node("images"));
            c = this.imagePanel;
        } else if (title.equals("Fmrc")) {
            this.fmrcPanel = new FmrcPanel((PreferencesExt)this.mainPrefs.node("fmrc2"));
            c = this.fmrcPanel;
        } else if (title.equals("Collections")) {
            this.collectionPanel = new CollectionPanel((PreferencesExt)this.mainPrefs.node("collections"));
            c = this.collectionPanel;
        } else if (title.equals("NCDump")) {
            this.ncdumpPanel = new NCdumpPanel((PreferencesExt)this.mainPrefs.node("NCDump"));
            c = this.ncdumpPanel;
        } else if (title.equals("NcmlEditor")) {
            this.ncmlEditorPanel = new NcmlEditorPanel((PreferencesExt)this.mainPrefs.node("NcmlEditor"));
            c = this.ncmlEditorPanel;
        } else if (title.equals("PointFeature")) {
            this.pointFeaturePanel = new PointFeaturePanel((PreferencesExt)this.mainPrefs.node("pointFeature"));
            c = this.pointFeaturePanel;
        } else if (title.equals("Radial")) {
            this.radialPanel = new RadialPanel((PreferencesExt)this.mainPrefs.node("radial"));
            c = this.radialPanel;
        } else if (title.equals("StationRadial")) {
            this.stationRadialPanel = new StationRadialPanel((PreferencesExt)this.mainPrefs.node("stationRadar"));
            c = this.stationRadialPanel;
        } else if (title.equals("THREDDS")) {
            this.threddsUI = new ThreddsUI(this.parentFrame, (PreferencesExt)this.mainPrefs.node("thredds"));
            this.threddsUI.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("InvAccess")) {
                        InvAccess access = (InvAccess)e.getNewValue();
                        ToolsUI.this.setThreddsDatatype(access);
                    }
                    if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                        InvDataset ds = (InvDataset)e.getNewValue();
                        ToolsUI.this.setThreddsDatatype(ds, e.getPropertyName());
                    }
                }
            });
            c = this.threddsUI;
        } else if (title.equals("Units")) {
            this.unitsPanel = new UnitsPanel((PreferencesExt)this.mainPrefs.node("units"));
            c = this.unitsPanel;
        } else if (title.equals("URLdump")) {
            this.urlPanel = new URLDumpPane((PreferencesExt)this.mainPrefs.node("urlDump"));
            c = this.urlPanel;
        } else if (title.equals("Viewer")) {
            c = this.viewerPanel;
        } else if (title.equals("WMS")) {
            this.wmsPanel = new WmsPanel((PreferencesExt)this.mainPrefs.node("wms"));
            c = this.wmsPanel;
        } else {
            System.out.println("tabbedPane unknown component " + title);
            return;
        }
        parent.setComponentAt(idx, c);
        if (this.debugTab) {
            System.out.println("tabbedPane changed " + title + " added ");
        }
    }

    private void makeMenuBar() {
        JMenuBar mb = new JMenuBar();
        JRootPane rootPane = this.parentFrame.getRootPane();
        rootPane.setJMenuBar(mb);
        JMenu sysMenu = new JMenu("System");
        sysMenu.setMnemonic('S');
        mb.add(sysMenu);
        AbstractAction act = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataManager.closeAll();
            }
        };
        BAMutil.setActionProperties(act, null, "Close BDB database", false, 83, -1);
        BAMutil.addActionToMenu(sysMenu, act);
        AbstractAction clearHttpStateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties(clearHttpStateAction, null, "Clear Http State", false, 83, -1);
        BAMutil.addActionToMenu(sysMenu, clearHttpStateAction);
        AbstractAction showCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                f.format("NetcdfFileCache contents\n", new Object[0]);
                FileCache cache = NetcdfDataset.getNetcdfFileCache();
                if (null != cache) {
                    cache.showCache(f);
                }
                ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.setText(f.toString());
                ((ToolsUI)ToolsUI.this).viewerPanel.detailWindow.show();
            }
        };
        BAMutil.setActionProperties(showCacheAction, null, "Show Caches", false, 83, -1);
        BAMutil.addActionToMenu(sysMenu, showCacheAction);
        AbstractAction clearCacheAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCache cache = NetcdfDataset.getNetcdfFileCache();
                if (cache != null) {
                    cache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties(clearCacheAction, null, "Clear NetcdfDatasetCache", false, 67, -1);
        BAMutil.addActionToMenu(sysMenu, clearCacheAction);
        AbstractAction enableCache = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state == isCacheInit) {
                    return;
                }
                isCacheInit = state;
                if (isCacheInit) {
                    FileCache cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.enable();
                    } else {
                        NetcdfDataset.initNetcdfFileCache(10, 20, 600);
                    }
                } else {
                    FileCache cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.disable();
                    }
                }
            }
        };
        BAMutil.setActionPropertiesToggle(enableCache, null, "enable NetcdfDatasetCache", isCacheInit, 78, -1);
        BAMutil.addActionToMenu(sysMenu, enableCache);
        AbstractAction showPropertiesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.setText("System Properties\n");
                Properties sysp = System.getProperties();
                Enumeration<?> eprops = sysp.propertyNames();
                ArrayList<?> list = Collections.list(eprops);
                Collections.sort(list);
                for (Object aList : list) {
                    String name = (String)aList;
                    String value = System.getProperty(name);
                    ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.appendLine("  " + name + " = " + value);
                }
                ((ToolsUI)ToolsUI.this).viewerPanel.detailWindow.show();
            }
        };
        BAMutil.setActionProperties(showPropertiesAction, null, "System Properties", false, 80, -1);
        BAMutil.addActionToMenu(sysMenu, showPropertiesAction);
        JMenu plafMenu = new JMenu("Look and Feel");
        plafMenu.setMnemonic('L');
        sysMenu.add(plafMenu);
        PLAF plaf = new PLAF(rootPane);
        plaf.addToMenu(plafMenu);
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsUI.exit();
            }
        };
        BAMutil.setActionProperties(exitAction, "Exit", "Exit", false, 88, -1);
        BAMutil.addActionToMenu(sysMenu, exitAction);
        JMenu modeMenu = new JMenu("Modes");
        modeMenu.setMnemonic('M');
        mb.add(modeMenu);
        this.makeModesMenu(modeMenu);
        JMenu debugMenu = new JMenu("Debug");
        debugMenu.setMnemonic('D');
        mb.add(debugMenu);
        this.debugFlagMenu = (JMenu)debugMenu.add(new JMenu("Debug Flags"));
        this.debugFlagMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ToolsUI.this.setDebugFlags();
                Debug.constructMenu(ToolsUI.this.debugFlagMenu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                ToolsUI.this.setDebugFlags();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        AbstractAction clearDebugFlagsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debug.removeAll();
            }
        };
        BAMutil.setActionProperties(clearDebugFlagsAction, null, "Delete All Debug Flags", false, 67, -1);
        BAMutil.addActionToMenu(debugMenu, clearDebugFlagsAction);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        mb.add(helpMenu);
        AbstractAction aboutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ToolsUI.this.aboutWindow == null) {
                    ToolsUI.this.aboutWindow = new AboutWindow();
                }
                ToolsUI.this.aboutWindow.setVisible(true);
            }
        };
        BAMutil.setActionProperties(aboutAction, null, "About", false, 65, 0);
        BAMutil.addActionToMenu(helpMenu, aboutAction);
        AbstractAction logoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new SplashScreen();
            }
        };
        BAMutil.setActionProperties(logoAction, null, "Logo", false, 76, 0);
        BAMutil.addActionToMenu(helpMenu, logoAction);
    }

    public void setDebugFlags() {
        if (this.debug) {
            System.out.println("checkDebugFlags ");
        }
        NetcdfFile.setDebugFlags(this.debugFlags);
        H5iosp.setDebugFlags(this.debugFlags);
        NcMLReader.setDebugFlags(this.debugFlags);
        DODSNetcdfFile.setDebugFlags(this.debugFlags);
        CdmRemote.setDebugFlags(this.debugFlags);
        GribServiceProvider.setDebugFlags(this.debugFlags);
        ThreddsDataFactory.setDebugFlags(this.debugFlags);
        FileWriter.setDebugFlags(this.debugFlags);
        FileWriter2.setDebugFlags(this.debugFlags);
        PointDatasetStandardFactory.setDebugFlags(this.debugFlags);
    }

    private void makeModesMenu(JMenu modeMenu) {
        JMenu ncMenu = new JMenu("NetcdfFile");
        modeMenu.add(ncMenu);
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                ToolsUI.this.setUseRecordStructure = state;
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "nc3UseRecords", this.setUseRecordStructure, 86, -1);
        BAMutil.addActionToMenu(ncMenu, a);
        JMenu dsMenu = new JMenu("NetcdfDataset");
        modeMenu.add(dsMenu);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoordSysBuilder.setUseMaximalCoordSys(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "set Use Maximal CoordSystem", CoordSysBuilder.getUseMaximalCoordSys(), 78, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setUseNaNs(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "set NaNs for missing values", NetcdfDataset.getUseNaNs(), 78, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setFillValueIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use _FillValue attribute for missing values", NetcdfDataset.getFillValueIsMissing(), 70, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setInvalidDataIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use valid_range attribute for missing values", NetcdfDataset.getInvalidDataIsMissing(), 86, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setMissingDataIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use missing_value attribute for missing values", NetcdfDataset.getMissingDataIsMissing(), 77, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        ncMenu = new JMenu("GRIB-1");
        modeMenu.add(ncMenu);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                Grib1ParamTables.setStrict(state);
            }
        };
        boolean strictMode = Grib1ParamTables.isStrict();
        a.putValue("state", new Boolean(strictMode));
        BAMutil.setActionPropertiesToggle(a, null, "strict", strictMode, 83, -1);
        BAMutil.addActionToMenu(ncMenu, a);
        ncMenu = new JMenu("FMRC");
        modeMenu.add(ncMenu);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                FeatureCollectionConfig.setRegularizeDefault(state);
            }
        };
        FeatureCollectionConfig.setRegularizeDefault(true);
        a.putValue("state", new Boolean(true));
        BAMutil.setActionPropertiesToggle(a, null, "regularize", true, 82, -1);
        BAMutil.addActionToMenu(ncMenu, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                ThreddsDataFactory.setPreferCdm(state);
            }
        };
        ThreddsDataFactory.setPreferCdm(true);
        a.putValue("state", new Boolean(true));
        BAMutil.setActionPropertiesToggle(a, null, "preferCdm", true, 80, -1);
        BAMutil.addActionToMenu(ncMenu, a);
    }

    public void save() {
        this.fileChooser.save();
        if (this.bufrFileChooser != null) {
            this.bufrFileChooser.save();
        }
        if (this.aggPanel != null) {
            this.aggPanel.save();
        }
        if (this.bufrPanel != null) {
            this.bufrPanel.save();
        }
        if (this.bufrTableBPanel != null) {
            this.bufrTableBPanel.save();
        }
        if (this.bufrTableDPanel != null) {
            this.bufrTableDPanel.save();
        }
        if (this.bufrCodePanel != null) {
            this.bufrCodePanel.save();
        }
        if (this.coordSysPanel != null) {
            this.coordSysPanel.save();
        }
        if (this.cdmremotePanel != null) {
            this.cdmremotePanel.save();
        }
        if (this.ftPanel != null) {
            this.ftPanel.save();
        }
        if (this.fmrcPanel != null) {
            this.fmrcPanel.save();
        }
        if (this.collectionPanel != null) {
            this.collectionPanel.save();
        }
        if (this.geotiffPanel != null) {
            this.geotiffPanel.save();
        }
        if (this.gribFilesPanel != null) {
            this.gribFilesPanel.save();
        }
        if (this.gribNewPanel != null) {
            this.gribNewPanel.save();
        }
        if (this.gribIdxPanel != null) {
            this.gribIdxPanel.save();
        }
        if (this.grib1RawPanel != null) {
            this.grib1RawPanel.save();
        }
        if (this.grib1ReportPanel != null) {
            this.grib1ReportPanel.save();
        }
        if (this.grib2ReportPanel != null) {
            this.grib2ReportPanel.save();
        }
        if (this.gribCodePanel != null) {
            this.gribCodePanel.save();
        }
        if (this.gribTemplatePanel != null) {
            this.gribTemplatePanel.save();
        }
        if (this.grib1TablePanel != null) {
            this.grib1TablePanel.save();
        }
        if (this.grib2TablePanel != null) {
            this.grib2TablePanel.save();
        }
        if (this.gribVariableRenamePanel != null) {
            this.gribVariableRenamePanel.save();
        }
        if (this.gridPanel != null) {
            this.gridPanel.save();
        }
        if (this.hdf5ObjectPanel != null) {
            this.hdf5ObjectPanel.save();
        }
        if (this.hdf5DataPanel != null) {
            this.hdf5DataPanel.save();
        }
        if (this.hdf4Panel != null) {
            this.hdf4Panel.save();
        }
        if (this.imagePanel != null) {
            this.imagePanel.save();
        }
        if (this.ncdumpPanel != null) {
            this.ncdumpPanel.save();
        }
        if (this.ncStreamPanel != null) {
            this.ncStreamPanel.save();
        }
        if (this.ncmlEditorPanel != null) {
            this.ncmlEditorPanel.save();
        }
        if (this.pointFeaturePanel != null) {
            this.pointFeaturePanel.save();
        }
        if (this.radialPanel != null) {
            this.radialPanel.save();
        }
        if (this.stationRadialPanel != null) {
            this.stationRadialPanel.save();
        }
        if (this.threddsUI != null) {
            this.threddsUI.storePersistentData();
        }
        if (this.unitsPanel != null) {
            this.unitsPanel.save();
        }
        if (this.urlPanel != null) {
            this.urlPanel.save();
        }
        if (this.viewerPanel != null) {
            this.viewerPanel.save();
        }
        if (this.wmoCommonCodePanel != null) {
            this.wmoCommonCodePanel.save();
        }
        if (this.wmsPanel != null) {
            this.wmsPanel.save();
        }
    }

    private void openNetcdfFile(String datasetName) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    private void openNetcdfFile(NetcdfFile ncfile) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.setDataset(ncfile);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    private void openCoordSystems(String datasetName) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    private void openCoordSystems(NetcdfDataset dataset) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    private void openNcML(String datasetName) {
        this.makeComponent(this.ncmlTabPane, "NcmlEditor");
        this.ncmlEditorPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ncmlTabPane);
        this.ncmlTabPane.setSelectedComponent(this.ncmlEditorPanel);
    }

    private void openPointFeatureDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "PointFeature");
        this.pointFeaturePanel.setPointFeatureDataset(null, datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.pointFeaturePanel);
    }

    private void openGrib2n(String collection) {
        this.makeComponent(this.grib2TabPane, "GRIB2collection");
        this.gribNewPanel.setCollection(collection);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib2TabPane);
        this.grib2TabPane.setSelectedComponent(this.gribNewPanel);
    }

    private void openGrib1Raw(String filename) {
        this.makeComponent(this.grib1TabPane, "GRIB-RAW");
        this.grib1RawPanel.process(filename);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib1TabPane);
        this.grib1TabPane.setSelectedComponent(this.grib1RawPanel);
    }

    private void openGridDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    private void openGridDataset(NetcdfDataset dataset) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    private void openGridDataset(ucar.nc2.dt.GridDataset dataset) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    private void openRadialDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Radial");
        this.radialPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.radialPanel);
    }

    private void openWMSDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "WMS");
        this.wmsPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.wmsPanel);
    }

    private void setThreddsDatatype(InvDataset invDataset, String wants) {
        if (invDataset == null) {
            return;
        }
        boolean wantsViewer = wants.equals("File");
        boolean wantsCoordSys = wants.equals("CoordSys");
        try {
            if (wantsViewer) {
                this.openNetcdfFile(this.threddsDataFactory.openDataset(invDataset, true, (CancelTask)null, (Formatter)null));
                return;
            }
            if (wantsCoordSys) {
                NetcdfDataset ncd = this.threddsDataFactory.openDataset(invDataset, true, (CancelTask)null, (Formatter)null);
                ncd.enhance();
                this.openCoordSystems(ncd);
                return;
            }
            ThreddsDataFactory.Result threddsData = this.threddsDataFactory.openFeatureDataset(invDataset, null);
            if (threddsData == null) {
                JOptionPane.showMessageDialog(null, "Unknown datatype");
                return;
            }
            this.setThreddsDatatype(threddsData);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
        }
    }

    private void setThreddsDatatype(InvAccess invAccess) {
        if (invAccess == null) {
            return;
        }
        InvService s = invAccess.getService();
        if (s.getServiceType() == ServiceType.HTTPServer) {
            this.downloadFile(invAccess.getStandardUrlName());
            return;
        }
        if (s.getServiceType() == ServiceType.WMS) {
            this.openWMSDataset(invAccess.getStandardUrlName());
            return;
        }
        InvDataset ds = invAccess.getDataset();
        if (ds.getDataType() == null) {
            try {
                this.openNetcdfFile(this.threddsDataFactory.openDataset(invAccess, true, (CancelTask)null, (Formatter)null));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
            }
            return;
        }
        try {
            ThreddsDataFactory.Result threddsData = this.threddsDataFactory.openFeatureDataset(invAccess, null);
            this.setThreddsDatatype(threddsData);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
        }
    }

    private void setThreddsDatatype(ThreddsDataFactory.Result threddsData) {
        if (threddsData.fatalError) {
            JOptionPane.showMessageDialog(this, "Cant open dataset=" + threddsData.errLog);
            return;
        }
        if (threddsData.featureType == FeatureType.GRID) {
            this.makeComponent(this.ftTabPane, "Grids");
            this.gridPanel.setDataset((NetcdfDataset)threddsData.featureDataset.getNetcdfFile());
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.gridPanel);
        } else if (threddsData.featureType == FeatureType.IMAGE) {
            this.makeComponent(this.ftTabPane, "Images");
            this.imagePanel.setImageLocation(threddsData.imageURL);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.imagePanel);
        } else if (threddsData.featureType == FeatureType.RADIAL) {
            this.makeComponent(this.ftTabPane, "Radial");
            this.radialPanel.setDataset((RadialDatasetSweep)threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.radialPanel);
        } else if (threddsData.featureType.isPointFeatureType()) {
            this.makeComponent(this.ftTabPane, "PointFeature");
            this.pointFeaturePanel.setPointFeatureDataset((PointDatasetImpl)threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.pointFeaturePanel);
        } else if (threddsData.featureType == FeatureType.STATION_RADIAL) {
            this.makeComponent(this.ftTabPane, "StationRadial");
            this.stationRadialPanel.setStationRadialDataset(threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.stationRadialPanel);
        }
    }

    private NetcdfDataset openDataset(String location, boolean addCoords, CancelTask task) {
        try {
            NetcdfDataset ncd = NetcdfDataset.openDataset(location, addCoords, task);
            if (this.setUseRecordStructure) {
                ncd.sendIospMessage("AddRecordStructure");
            }
            return ncd;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + ioe.getMessage());
            ioe.printStackTrace();
            return null;
        }
    }

    private NetcdfFile openFile(String location, boolean addCoords, CancelTask task) {
        NetcdfFile ncfile = null;
        try {
            ncfile = addCoords ? NetcdfDataset.acquireDataset(location, task) : NetcdfDataset.acquireFile(location, task);
            if (ncfile == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location);
            } else if (this.setUseRecordStructure) {
                ncfile.sendIospMessage("AddRecordStructure");
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (null == message && ioe instanceof EOFException) {
                message = "Premature End of File";
            }
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location + "\n" + message);
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
            ncfile = null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location + "\n" + e.getMessage());
            log.error("NetcdfDataset.open cant open " + location, e);
            e.printStackTrace();
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
            ncfile = null;
        }
        return ncfile;
    }

    private void downloadFile(String urlString) {
        int pos = urlString.lastIndexOf(47);
        String defFilename = pos >= 0 ? urlString.substring(pos) : urlString;
        String fileOutName = this.fileChooser.chooseFilename(defFilename);
        if (fileOutName == null) {
            return;
        }
        String[] values = new String[]{fileOutName, urlString};
        GetDataRunnable runner = new GetDataRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(Object o) {
                String[] values = (String[])o;
                BufferedOutputStream out = null;
                try {
                    FileOutputStream fos = new FileOutputStream(values[0]);
                    out = new BufferedOutputStream(fos, 60000);
                }
                catch (IOException ioe) {
                    ToolsUI.this.downloadStatus = "Error opening" + values[0] + "\n" + ioe.getMessage();
                    return;
                }
                try {
                    IO.copyUrlB(values[1], out, 60000);
                    ToolsUI.this.downloadStatus = values[1] + " written to " + values[0];
                }
                catch (IOException ioe) {
                    ToolsUI.this.downloadStatus = "Error reading " + values[1] + "\n" + ioe.getMessage();
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        };
        GetDataTask task = new GetDataTask(runner, urlString, values);
        ProgressMonitor pm = new ProgressMonitor(task);
        pm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, e.getActionCommand() + "\n" + ToolsUI.this.downloadStatus);
                ToolsUI.this.downloadStatus = null;
            }
        });
        pm.start(this, "Download", 30);
    }

    private void initBufrFileChooser() {
        this.bufrFileChooser = new FileManager(this.parentFrame, null, null, (PreferencesExt)prefs.node("bufrFileManager"));
    }

    private String getVersion() {
        String version;
        try {
            InputStream is = Resource.getFileResource("/README");
            if (is == null) {
                return "4.3";
            }
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(is));
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                sbuff.append(dataIS.readLine());
                sbuff.append("<br>");
            }
            version = sbuff.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            version = "version unknown";
        }
        return version;
    }

    private static void exit() {
        ui.save();
        Rectangle bounds = frame.getBounds();
        prefs.putBeanObject(FRAME_SIZE, bounds);
        try {
            store.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        done = true;
        FileCache cache = NetcdfDataset.getNetcdfFileCache();
        if (cache != null) {
            cache.clearCache(true);
        }
        FileCache.shutdown();
        if (cacheManager != null) {
            cacheManager.close();
        }
        MetadataManager.closeAll();
        System.exit(0);
    }

    private static void setDataset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int pos = wantDataset.indexOf(35);
                if (pos > 0) {
                    String catName = wantDataset.substring(0, pos);
                    if (catName.endsWith(".xml")) {
                        ui.makeComponent(null, "THREDDS");
                        ui.threddsUI.setDataset(wantDataset);
                        ui.tabbedPane.setSelectedComponent(ui.threddsUI);
                    }
                    return;
                }
                ui.openNetcdfFile(wantDataset);
            }
        });
    }

    public static void main(String[] args) {
        String filename;
        File f;
        FileInputStream fis;
        StringBuilder errlog;
        final SplashScreen splash = new SplashScreen();
        if (debugListen) {
            System.out.println("Arguments:");
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                System.out.println(" " + arg);
            }
        }
        if (args.length > 0) {
            SocketMessage sm;
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                sbuff.append(args[i]);
                sbuff.append(" ");
            }
            String arguments = sbuff.toString();
            System.out.println("ToolsUI arguments=" + arguments);
            if (arguments.startsWith("http:") && (sm = new SocketMessage(14444, wantDataset = arguments)).isAlreadyRunning()) {
                System.out.println("ToolsUI already running - pass argument= '" + wantDataset + "' to it and exit");
                System.exit(0);
            }
        } else {
            SocketMessage sm = new SocketMessage(14444, null);
            if (sm.isAlreadyRunning()) {
                System.out.println("ToolsUI already running - start up another copy");
                sm = null;
            } else {
                sm.addEventListener(new SocketMessage.EventListener(){

                    @Override
                    public void setMessage(SocketMessage.Event event) {
                        wantDataset = event.getMessage();
                        if (debugListen) {
                            System.out.println(" got message= '" + wantDataset);
                        }
                        ToolsUI.setDataset();
                    }
                });
            }
        }
        ClassPathXmlApplicationContext springContext = new ClassPathXmlApplicationContext("classpath:resources/nj22/ui/spring/application-config.xml");
        boolean configRead = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-nj22Config") || i >= args.length - 1) continue;
            String runtimeConfig = args[i + 1];
            ++i;
            try {
                errlog = new StringBuilder();
                fis = new FileInputStream(runtimeConfig);
                RuntimeConfigParser.read(fis, errlog);
                configRead = true;
                System.out.println(errlog);
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Error reading " + runtimeConfig + "=" + ioe.getMessage());
            }
        }
        if (!configRead && (f = new File(filename = XMLStore.makeStandardFilename(".unidata", "nj22Config.xml"))).exists()) {
            try {
                errlog = new StringBuilder();
                fis = new FileInputStream(filename);
                RuntimeConfigParser.read(fis, errlog);
                configRead = true;
                System.out.println(errlog);
            }
            catch (IOException ioe) {
                System.out.println("Error reading " + filename + "=" + ioe.getMessage());
            }
        }
        try {
            String prefStore = XMLStore.makeStandardFilename(".unidata", "NetcdfUI22.xml");
            store = XMLStore.createFromFile(prefStore, null);
            prefs = store.getPreferences();
            Debug.setStore(prefs.node("Debug"));
        }
        catch (IOException e) {
            System.out.println("XMLStore Creation failed " + e);
        }
        BAMutil.setResourcePath("/resources/nj22/ui/icons/");
        DiskCache2 cacheDir = new DiskCache2(".unidata/ehcache", true, -1, -1);
        CollectionManagerAbstract.enableMetadataManager();
        Aggregation.setPersistenceCache(new DiskCache2("/.unidata/aggCache", true, 43200, 60));
        frame = new JFrame("NetCDF (4.3) Tools");
        ui = new ToolsUI(prefs, frame);
        frame.setIconImage(BAMutil.getImage("netcdfUI"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                splash.setVisible(false);
                splash.dispose();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!done) {
                    ToolsUI.exit();
                }
            }
        });
        frame.getContentPane().add(ui);
        Rectangle bounds = (Rectangle)prefs.getBean(FRAME_SIZE, new Rectangle(50, 50, 800, 450));
        frame.setBounds(bounds);
        frame.pack();
        frame.setBounds(bounds);
        frame.setVisible(true);
        UrlAuthenticatorDialog provider = new UrlAuthenticatorDialog(frame);
        HTTPSession.setGlobalCredentialsProvider(provider);
        HTTPSession.setGlobalUserAgent("ToolsUI v4.3");
        Authenticator.setDefault(provider);
        DODSNetcdfFile.setAllowCompression(true);
        DODSNetcdfFile.setAllowSessions(true);
        GribCollection.initDataRafCache(100, 200, -1);
        if (wantDataset != null) {
            ToolsUI.setDataset();
        }
    }

    static {
        done = false;
        wantDataset = null;
        isCacheInit = false;
        isDiskCacheInit = false;
    }

    private static class SplashScreen
    extends JWindow {
        public SplashScreen() {
            Image image = Resource.getImage("/resources/nj22/ui/pix/ring2.jpg");
            ImageIcon icon = new ImageIcon(image);
            JLabel lab = new JLabel(icon);
            this.getContentPane().add(lab);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            this.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SplashScreen.this.setVisible(false);
                }
            });
            this.setVisible(true);
        }
    }

    private class AboutWindow
    extends JWindow {
        public AboutWindow() {
            super(ToolsUI.this.parentFrame);
            JLabel lab1 = new JLabel("<html> <body bgcolor=\"#FFECEC\"> <center><h1>Netcdf Tools User Interface (ToolsUI)</h1><b>" + ToolsUI.this.getVersion() + "</b>" + "<br><i>http://www.unidata.ucar.edu/software/netcdf-java/</i>" + "<br><b><i>Developers:</b>John Caron, Ethan Davis, Robb Kambic, Yuan Ho</i></b>" + "</center>" + "<br><br>With thanks to these <b>Open Source</b> contributers:" + "<ul>" + "<li><b>ADDE/VisAD</b>: Bill Hibbard, Don Murray, Tom Whittaker, et al (http://www.ssec.wisc.edu/~billh/visad.html)</li>" + "<li><b>Apache Jakarta Commons</b> libraries: (http://http://jakarta.apache.org/commons/)</li>" + "<li><b>Apache Log4J</b> library: (http://logging.apache.org/log4j/) </li>" + "<li><b>IDV:</b> Don Murray, Jeff McWhirter (http://www.unidata.ucar.edu/software/IDV/)</li>" + "<li><b>JDOM</b> library: Jason Hunter, Brett McLaughlin et al (www.jdom.org)</li>" + "<li><b>JGoodies</b> library: Karsten Lentzsch (www.jgoodies.com)</li>" + "<li><b>JPEG-2000</b> Java library: (http://www.jpeg.org/jpeg2000/)</li>" + "<li><b>JUnit</b> library: Erich Gamma, Kent Beck, Erik Meade, et al (http://sourceforge.net/projects/junit/)</li>" + "<li><b>OPeNDAP Java</b> library: Nathan Potter, James Gallagher, Don Denbo, et. al.(http://opendap.org)</li>" + "<li><b>Spring lightweight framework</b> library: Rod Johnson, et. al.(http://www.springsource.org/)</li>" + "<li><b>Imaging utilities:</b>: Richard Eigenmann</li>" + "</ul><center>Special thanks to <b>Sun Microsystems</b> (java.sun.com) for the platform on which we stand." + "</center></body></html> ");
            JPanel main = new JPanel(new BorderLayout());
            main.setBorder(new LineBorder(Color.BLACK));
            main.setBackground(new Color(0xFFECEC));
            JLabel icon = new JLabel(new ImageIcon(BAMutil.getImage("netcdfUI")));
            icon.setOpaque(true);
            icon.setBackground(new Color(0xFFECEC));
            JLabel threddsLogo = new JLabel(Resource.getIcon(BAMutil.getResourcePath() + "threddsLogo.png", false));
            threddsLogo.setBackground(new Color(0xFFECEC));
            threddsLogo.setOpaque(true);
            main.add((Component)icon, "North");
            main.add((Component)lab1, "Center");
            main.add((Component)threddsLogo, "South");
            this.getContentPane().add(main);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = this.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AboutWindow.this.setVisible(false);
                }
            });
            this.setVisible(true);
        }
    }

    private class DebugProxyHandler
    implements InvocationHandler {
        private DebugProxyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return super.toString();
            }
            if (method.getName().equals("isSet")) {
                return new Boolean(Debug.isSet((String)args[0]));
            }
            if (method.getName().equals("set")) {
                Debug.set((String)args[0], (Boolean)args[1]);
                return null;
            }
            return Boolean.FALSE;
        }
    }

    private class GetDataTask
    extends ProgressMonitorTask
    implements CancelTask {
        GetDataRunnable getData;
        Object o;
        String name;
        String errMsg = null;
        Exception ex;

        GetDataTask(GetDataRunnable getData, String name, Object o) {
            this.getData = getData;
            this.name = name;
            this.o = o;
        }

        @Override
        public void run() {
            try {
                this.getData.run(this.o);
            }
            catch (FileNotFoundException ioe) {
                this.errMsg = "Cant open " + this.name + " " + ioe.getMessage();
                this.success = false;
                this.done = true;
                return;
            }
            catch (Exception e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                this.errMsg = bos.toString();
                this.ex = e;
                this.success = false;
                this.done = true;
                return;
            }
            this.success = true;
            this.done = true;
        }
    }

    private static interface GetDataRunnable {
        public void run(Object var1) throws IOException;
    }

    private class GeotiffPanel
    extends OpPanel {
        TextHistoryPane ta;

        GeotiffPanel(PreferencesExt p) {
            super(p, "netcdf:", true, false);
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
            JButton readButton = new JButton("read geotiff");
            readButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String item = GeotiffPanel.this.cb.getSelectedItem().toString();
                    String fname = item.trim();
                    GeotiffPanel.this.read(fname);
                }
            });
            this.buttPanel.add(readButton);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean process(Object o) {
            String filename = (String)o;
            GridDataset gridDs = null;
            try {
                gridDs = GridDataset.open(filename);
                List<GridDatatype> grids = gridDs.getGrids();
                if (grids.size() == 0) {
                    System.out.println("No grids found.");
                    boolean bl = false;
                    return bl;
                }
                GridDatatype grid = grids.get(0);
                Array data = grid.readDataSlice(0, 0, -1, -1);
                String fileOut = ToolsUI.this.fileChooser.chooseFilenameToSave(filename + ".tif");
                if (fileOut == null) {
                    boolean bl = false;
                    return bl;
                }
                GeotiffWriter writer = new GeotiffWriter(fileOut);
                writer.writeGrid(gridDs, grid, data, false);
                this.read(fileOut);
                JOptionPane.showMessageDialog(null, "File written to " + fileOut);
                return true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (gridDs != null) {
                        gridDs.close();
                    }
                }
                catch (IOException ioe) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(String filename) {
            GeoTiff geotiff = null;
            try {
                geotiff = new GeoTiff(filename);
                geotiff.read();
                this.ta.setText(geotiff.showInfo());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (geotiff != null) {
                        geotiff.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        void closeOpenFiles() throws IOException {
        }
    }

    private class ImagePanel
    extends OpPanel {
        ImageViewPanel imagePanel;
        JSplitPane split;

        ImagePanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.imagePanel = new ImageViewPanel(this.buttPanel);
            this.add((Component)this.imagePanel, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (null != command) {
                    this.imagePanel.setImageFromUrl(command);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                return false;
            }
            return true;
        }

        void setImageLocation(String location) {
            this.imagePanel.setImageFromUrl(location);
            this.setSelectedItem(location);
        }

        @Override
        void closeOpenFiles() throws IOException {
        }
    }

    private class StationRadialPanel
    extends OpPanel {
        StationRadialViewer radialViewer;
        JSplitPane split;
        FeatureDataset radarCollectionDataset;

        StationRadialPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.radarCollectionDataset = null;
            this.radialViewer = new StationRadialViewer(dbPrefs);
            this.add((Component)this.radialViewer, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StationRadialPanel.this.radarCollectionDataset != null) {
                        Formatter info = new Formatter();
                        StationRadialPanel.this.radarCollectionDataset.getDetailInfo(info);
                        StationRadialPanel.this.detailTA.setText(info.toString());
                        StationRadialPanel.this.detailTA.gotoTop();
                        StationRadialPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String location = (String)o;
            return this.setStationRadialDataset(location);
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.radarCollectionDataset != null) {
                this.radarCollectionDataset.close();
            }
            this.radarCollectionDataset = null;
        }

        @Override
        void save() {
        }

        boolean setStationRadialDataset(String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.radarCollectionDataset != null) {
                    this.radarCollectionDataset.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            StringBuilder log = new StringBuilder();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                ThreddsDataFactory.Result result = ToolsUI.this.threddsDataFactory.openFeatureDataset(FeatureType.STATION_RADIAL, location, null);
                if (result.fatalError) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + result.errLog.toString());
                    return false;
                }
                this.setStationRadialDataset(result.featureDataset);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(log.toString());
                this.detailTA.appendLine(bos.toString());
                this.detailWindow.show();
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        boolean setStationRadialDataset(FeatureDataset dataset) {
            if (dataset == null) {
                return false;
            }
            try {
                if (this.radarCollectionDataset != null) {
                    this.radarCollectionDataset.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.radarCollectionDataset = dataset;
            this.radialViewer.setDataset(this.radarCollectionDataset);
            this.setSelectedItem(this.radarCollectionDataset.getLocation());
            return true;
        }
    }

    private class WmsPanel
    extends OpPanel {
        WmsViewer wmsViewer;
        JSplitPane split;
        JComboBox types;

        WmsPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.wmsViewer = new WmsViewer(dbPrefs, frame);
            this.add((Component)this.wmsViewer, "Center");
            this.buttPanel.add(new JLabel("version:"));
            this.types = new JComboBox();
            this.types.addItem("1.3.0");
            this.types.addItem("1.1.1");
            this.types.addItem("1.0.0");
            this.buttPanel.add(this.types);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WmsPanel.this.detailTA.setText(WmsPanel.this.wmsViewer.getDetailInfo());
                    WmsPanel.this.detailTA.gotoTop();
                    WmsPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String location = (String)o;
            return this.wmsViewer.setDataset((String)this.types.getSelectedItem(), location);
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        void save() {
            super.save();
            this.wmsViewer.save();
        }
    }

    private class PointFeaturePanel
    extends OpPanel {
        PointFeatureDatasetViewer pfViewer;
        JSplitPane split;
        FeatureDatasetPoint pfDataset;
        JComboBox types;

        PointFeaturePanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.pfDataset = null;
            this.pfViewer = new PointFeatureDatasetViewer(dbPrefs);
            this.add((Component)this.pfViewer, "Center");
            this.types = new JComboBox();
            for (FeatureType ft : FeatureType.values()) {
                this.types.addItem(ft);
            }
            this.types.getModel().setSelectedItem((Object)FeatureType.ANY_POINT);
            this.buttPanel.add(this.types);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PointFeaturePanel.this.pfDataset == null) {
                        return;
                    }
                    Formatter f = new Formatter();
                    PointFeaturePanel.this.pfDataset.getDetailInfo(f);
                    PointFeaturePanel.this.detailTA.setText(f.toString());
                    PointFeaturePanel.this.detailTA.appendLine("-----------------------------");
                    PointFeaturePanel.this.detailTA.appendLine(PointFeaturePanel.this.getCapabilities(PointFeaturePanel.this.pfDataset));
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton collectionButton = BAMutil.makeButtcon("Information", "Collection Parsing Info", false);
            collectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    PointFeaturePanel.this.pfViewer.showCollectionInfo(f);
                    PointFeaturePanel.this.detailTA.setText(f.toString());
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(collectionButton);
            AbstractButton xmlButton = BAMutil.makeButtcon("XML", "pointConfig.xml", false);
            xmlButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PointFeaturePanel.this.pfDataset == null) {
                        return;
                    }
                    Formatter f = new Formatter();
                    PointConfigXML.writeConfigXML(PointFeaturePanel.this.pfDataset, f);
                    PointFeaturePanel.this.detailTA.setText(f.toString());
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(xmlButton);
            AbstractButton calcButton = BAMutil.makeButtcon("V3", "CalcBounds", false);
            calcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PointFeaturePanel.this.pfDataset == null) {
                        return;
                    }
                    Formatter f = new Formatter();
                    try {
                        PointFeaturePanel.this.pfDataset.calcBounds();
                        PointFeaturePanel.this.pfDataset.getDetailInfo(f);
                        PointFeaturePanel.this.detailTA.setText(f.toString());
                    }
                    catch (IOException ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                        ioe.printStackTrace(new PrintStream(bos));
                        PointFeaturePanel.this.detailTA.setText(bos.toString());
                    }
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(calcButton);
            AbstractAction netcdfAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename;
                    int pos;
                    String location = PointFeaturePanel.this.pfDataset.getLocation();
                    if (location == null) {
                        location = "test";
                    }
                    if ((pos = location.lastIndexOf(".")) > 0) {
                        location = location.substring(0, pos);
                    }
                    if ((filename = ToolsUI.this.fileChooser.chooseFilenameToSave(location + ".nc")) == null) {
                        return;
                    }
                    PointFeaturePanel.this.doWriteCF(filename);
                }
            };
            BAMutil.setActionProperties(netcdfAction, "netcdf", "Write netCDF-CF", false, 78, -1);
            BAMutil.addActionToContainer(this.buttPanel, netcdfAction);
        }

        @Override
        boolean process(Object o) {
            String location = (String)o;
            return this.setPointFeatureDataset((FeatureType)((Object)this.types.getSelectedItem()), location);
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.pfDataset != null) {
                this.pfDataset.close();
            }
            this.pfDataset = null;
        }

        @Override
        void save() {
            super.save();
            this.pfViewer.save();
        }

        void doWriteCF(String filename) {
            try {
                int count = CFPointWriter.writeFeatureCollection(this.pfDataset, filename);
                JOptionPane.showMessageDialog(this, count + " records written");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "ERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }

        private boolean setPointFeatureDataset(FeatureType type, String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.pfDataset != null) {
                    this.pfDataset.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.detailTA.clear();
            Formatter log = new Formatter();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                FeatureDataset featureDataset = FeatureDatasetFactoryManager.open(type, location, null, log);
                if (featureDataset == null) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + log);
                    return false;
                }
                if (!(featureDataset instanceof FeatureDatasetPoint)) {
                    JOptionPane.showMessageDialog(null, location + " could not be opened as a PointFeatureDataset");
                    return false;
                }
                this.pfDataset = (FeatureDatasetPoint)featureDataset;
                this.pfViewer.setDataset(this.pfDataset);
                this.setSelectedItem(location);
                return true;
            }
            catch (IOException e) {
                String message = e.getClass().getName() + ": " + e.getMessage();
                JOptionPane.showMessageDialog(this, message);
                return false;
            }
            catch (Throwable e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(log.toString());
                this.detailTA.appendLine(bos.toString());
                this.detailWindow.show();
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        private boolean setPointFeatureDataset(FeatureDatasetPoint pfd) {
            try {
                if (this.pfDataset != null) {
                    this.pfDataset.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.detailTA.clear();
            Formatter log = new Formatter();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.pfDataset = pfd;
                this.pfViewer.setDataset(this.pfDataset);
                this.setSelectedItem(this.pfDataset.getLocation());
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(log.toString());
                this.detailTA.appendLine(bos.toString());
                this.detailWindow.show();
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        private String getCapabilities(FeatureDatasetPoint fdp) {
            FeatureDatasetPointXML xmlWriter = new FeatureDatasetPointXML(fdp, null);
            return xmlWriter.getCapabilities();
        }
    }

    private class FeatureScanPanel
    extends OpPanel {
        ucar.nc2.ui.FeatureScanPanel ftTable;
        final FileManager dirChooser;

        FeatureScanPanel(PreferencesExt p) {
            super(p, "dir:", false, false);
            this.dirChooser = new FileManager(ToolsUI.this.parentFrame);
            this.ftTable = new ucar.nc2.ui.FeatureScanPanel(this.prefs);
            this.add((Component)this.ftTable, "Center");
            this.ftTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openPointFeatureDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openPointFeatureDataset(datasetName);
                    } else if (e.getPropertyName().equals("openNetcdfFile")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openNetcdfFile(datasetName);
                    } else if (e.getPropertyName().equals("openCoordSystems")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openCoordSystems(datasetName);
                    } else if (e.getPropertyName().equals("openNcML")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openNcML(datasetName);
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openGridDataset(datasetName);
                    } else if (e.getPropertyName().equals("openRadialDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openRadialDataset(datasetName);
                    }
                }
            });
            this.dirChooser.getFileChooser().setFileSelectionMode(2);
            this.dirChooser.setCurrentDirectory(this.prefs.get("currDir", "."));
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = FeatureScanPanel.this.dirChooser.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    FeatureScanPanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            return this.ftTable.setScanDirectory(command);
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        void save() {
            this.ftTable.save();
            this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
            super.save();
        }
    }

    private class ViewerPanel
    extends OpPanel {
        DatasetViewer dsViewer;
        JSplitPane split;
        NetcdfFile ncfile;

        ViewerPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:");
            this.ncfile = null;
            this.dsViewer = new DatasetViewer(dbPrefs, ToolsUI.this.fileChooser);
            this.add((Component)this.dsViewer, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ViewerPanel.this.ncfile != null) {
                        ViewerPanel.this.detailTA.setText(ViewerPanel.this.ncfile.getDetailInfo());
                        ViewerPanel.this.detailTA.gotoTop();
                        ViewerPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
            AbstractAction dumpAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetcdfFile ds = ViewerPanel.this.dsViewer.getDataset();
                    if (ds != null) {
                        if (ToolsUI.this.ncdumpPanel == null) {
                            ToolsUI.this.makeComponent(ToolsUI.this.tabbedPane, "NCDump");
                        }
                        ToolsUI.this.ncdumpPanel.setNetcdfFile(ds);
                        ToolsUI.this.tabbedPane.setSelectedComponent(ToolsUI.this.ncdumpPanel);
                    }
                }
            };
            BAMutil.setActionProperties(dumpAction, "Dump", "NCDump", false, 68, -1);
            BAMutil.addActionToContainer(this.buttPanel, dumpAction);
            this.dsViewer.addActions(this.buttPanel);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                NetcdfFile ncnew = ToolsUI.this.openFile(command, this.addCoords, null);
                if (ncnew != null) {
                    this.setDataset(ncnew);
                }
            }
            catch (Exception ioe) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                ioe.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
        }

        void setDataset(NetcdfFile nc) {
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
                this.ncfile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ncfile = nc;
            if (this.ncfile != null) {
                this.dsViewer.setDataset(nc);
                this.setSelectedItem(nc.getLocation());
            }
        }

        @Override
        void save() {
            super.save();
            this.dsViewer.save();
        }
    }

    private class RadialPanel
    extends OpPanel {
        RadialDatasetTable dsTable;
        JSplitPane split;
        RadialDatasetSweep ds;

        RadialPanel(PreferencesExt prefs) {
            super(prefs, "dataset:", true, false);
            this.ds = null;
            this.dsTable = new RadialDatasetTable(prefs);
            this.add((Component)this.dsTable, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String info;
                    RadialDatasetSweep radialDataset = RadialPanel.this.dsTable.getRadialDataset();
                    if (radialDataset != null && (info = radialDataset.getDetailInfo()) != null) {
                        RadialPanel.this.detailTA.setText(info);
                        RadialPanel.this.detailTA.gotoTop();
                        RadialPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                NetcdfDataset newds = NetcdfDataset.openDataset(command, true, null);
                if (newds == null) {
                    JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command);
                    return false;
                }
                Formatter errlog = new Formatter();
                RadialDatasetSweep rds = (RadialDatasetSweep)FeatureDatasetFactoryManager.wrap(FeatureType.RADIAL, newds, null, errlog);
                if (rds == null) {
                    JOptionPane.showMessageDialog(null, "FeatureDatasetFactoryManager cant open " + command + "as RADIAL dataset\n" + errlog.toString());
                    err = true;
                } else {
                    this.setDataset(rds);
                }
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command + "\n" + ioe.getMessage());
                ioe.printStackTrace();
                err = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        void setDataset(RadialDatasetSweep newds) {
            if (newds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ds = newds;
            this.dsTable.setDataset(newds);
            this.setSelectedItem(newds.getLocationURI());
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
        }

        @Override
        void save() {
            super.save();
            this.dsTable.save();
        }
    }

    private class GeoGridPanel
    extends OpPanel {
        GeoGridTable dsTable;
        JSplitPane split;
        IndependentWindow viewerWindow;
        IndependentWindow imageWindow;
        GridUI gridUI;
        ImageViewPanel imageViewer;
        NetcdfDataset ds;

        GeoGridPanel(PreferencesExt prefs) {
            super(prefs, "dataset:", true, false);
            this.gridUI = null;
            this.ds = null;
            this.dsTable = new GeoGridTable(prefs, true);
            this.add((Component)this.dsTable, "Center");
            AbstractButton viewButton = BAMutil.makeButtcon("alien", "Grid Viewer", false);
            viewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeoGridPanel.this.ds != null) {
                        ucar.nc2.dt.GridDataset gridDataset = GeoGridPanel.this.dsTable.getGridDataset();
                        if (GeoGridPanel.this.gridUI == null) {
                            GeoGridPanel.this.makeGridUI();
                        }
                        GeoGridPanel.this.gridUI.setDataset(gridDataset);
                        GeoGridPanel.this.viewerWindow.show();
                    }
                }
            });
            this.buttPanel.add(viewButton);
            AbstractButton imageButton = BAMutil.makeButtcon("VCRMovieLoop", "Image Viewer", false);
            imageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeoGridPanel.this.ds != null) {
                        GridDatatype grid = GeoGridPanel.this.dsTable.getGrid();
                        if (grid == null) {
                            return;
                        }
                        if (GeoGridPanel.this.imageWindow == null) {
                            GeoGridPanel.this.makeImageWindow();
                        }
                        GeoGridPanel.this.imageViewer.setImageFromGrid(grid);
                        GeoGridPanel.this.imageWindow.show();
                    }
                }
            });
            this.buttPanel.add(imageButton);
            this.dsTable.addExtra(this.buttPanel, ToolsUI.this.fileChooser);
        }

        private void makeGridUI() {
            this.viewerWindow = new IndependentWindow("Grid Viewer", BAMutil.getImage("netcdfUI"));
            this.gridUI = new GridUI((PreferencesExt)this.prefs.node("GridUI"), this.viewerWindow, ToolsUI.this.fileChooser, 800);
            this.gridUI.addMapBean(new WorldMapBean());
            this.gridUI.addMapBean(new ShapeFileBean("WorldDetailMap", "Global Detailed Map", "WorldDetailMap", ToolsUI.WorldDetailMap));
            this.gridUI.addMapBean(new ShapeFileBean("USDetailMap", "US Detailed Map", "USMap", ToolsUI.USMap));
            this.viewerWindow.setComponent(this.gridUI);
            this.viewerWindow.setBounds((Rectangle)ToolsUI.this.mainPrefs.getBean(ToolsUI.GRIDVIEW_FRAME_SIZE, new Rectangle(77, 22, 700, 900)));
        }

        private void makeImageWindow() {
            this.imageWindow = new IndependentWindow("Grid Image Viewer", BAMutil.getImage("netcdfUI"));
            this.imageViewer = new ImageViewPanel(null);
            this.imageWindow.setComponent(this.imageViewer);
            this.imageWindow.setBounds((Rectangle)ToolsUI.this.mainPrefs.getBean(ToolsUI.GRIDIMAGE_FRAME_SIZE, new Rectangle(77, 22, 700, 900)));
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                NetcdfDataset newds = NetcdfDataset.openDataset(command, true, null);
                if (newds == null) {
                    JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command);
                    return false;
                }
                this.setDataset(newds);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Throwable ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
        }

        void setDataset(NetcdfDataset newds) {
            if (newds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            Formatter parseInfo = new Formatter();
            this.ds = newds;
            try {
                this.dsTable.setDataset(newds, parseInfo);
            }
            catch (IOException e) {
                String info = parseInfo.toString();
                if (info.length() > 0) {
                    this.detailTA.setText(info);
                    this.detailWindow.show();
                }
                e.printStackTrace();
                return;
            }
            this.setSelectedItem(newds.getLocation());
        }

        void setDataset(ucar.nc2.dt.GridDataset gds) {
            if (gds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.ds = (NetcdfDataset)gds.getNetcdfFile();
            try {
                this.dsTable.setDataset(gds);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.setSelectedItem(gds.getLocationURI());
        }

        @Override
        void save() {
            super.save();
            this.dsTable.save();
            if (this.gridUI != null) {
                this.gridUI.storePersistentData();
            }
            if (this.viewerWindow != null) {
                ToolsUI.this.mainPrefs.putBeanObject(ToolsUI.GRIDVIEW_FRAME_SIZE, this.viewerWindow.getBounds());
            }
            if (this.imageWindow != null) {
                ToolsUI.this.mainPrefs.putBeanObject(ToolsUI.GRIDIMAGE_FRAME_SIZE, this.imageWindow.getBounds());
            }
        }
    }

    private class CollectionPanel
    extends OpPanel {
        CollectionTable table;

        CollectionPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "collection:", true, false);
            this.table = new CollectionTable(this.prefs);
            this.add((Component)this.table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        CollectionPanel.this.table.showInfo(f);
                    }
                    catch (IOException e1) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                        e1.printStackTrace(new PrintStream(bos));
                        f.format("%s", bos.toString());
                    }
                    CollectionPanel.this.detailTA.setText(f.toString());
                    CollectionPanel.this.detailTA.gotoTop();
                    CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton refreshButton = BAMutil.makeButtcon("Undo", "Refresh", false);
            refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        CollectionPanel.this.table.refresh();
                    }
                    catch (Exception e1) {
                        Formatter f = new Formatter();
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                        e1.printStackTrace(new PrintStream(bos));
                        f.format("%s", bos.toString());
                        CollectionPanel.this.detailTA.setText(f.toString());
                        CollectionPanel.this.detailTA.gotoTop();
                        CollectionPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(refreshButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            if (command == null) {
                return false;
            }
            try {
                return true;
            }
            catch (Exception ioe) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                return false;
            }
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        void save() {
            this.table.save();
            super.save();
        }
    }

    private class FmrcPanel
    extends OpPanel {
        Fmrc2Panel table;

        FmrcPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "collection:", true, false);
            this.table = new Fmrc2Panel(this.prefs);
            this.table.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openNetcdfFile")) {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.this.openNetcdfFile((String)e.getNewValue());
                        } else {
                            ToolsUI.this.openNetcdfFile((NetcdfFile)e.getNewValue());
                        }
                    } else if (e.getPropertyName().equals("openCoordSys")) {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.this.openCoordSystems((String)e.getNewValue());
                        } else {
                            ToolsUI.this.openCoordSystems((NetcdfDataset)e.getNewValue());
                        }
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.this.openGridDataset((String)e.getNewValue());
                        } else {
                            ToolsUI.this.openGridDataset((ucar.nc2.dt.GridDataset)e.getNewValue());
                        }
                    }
                }
            });
            this.add((Component)this.table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        FmrcPanel.this.table.showInfo(f);
                    }
                    catch (IOException e1) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                        e1.printStackTrace(new PrintStream(bos));
                        f.format("%s", bos.toString());
                    }
                    FmrcPanel.this.detailTA.setText(f.toString());
                    FmrcPanel.this.detailTA.gotoTop();
                    FmrcPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton collectionButton = BAMutil.makeButtcon("Information", "Collection Parsing Info", false);
            collectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FmrcPanel.this.table.showCollectionInfo(true);
                }
            });
            this.buttPanel.add(collectionButton);
            AbstractButton viewButton = BAMutil.makeButtcon("Dump", "Show in Netcdf Viewer", false);
            viewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FmrcPanel.this.table.showDataset();
                    }
                    catch (IOException e1) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                        e1.printStackTrace(new PrintStream(bos));
                        FmrcPanel.this.detailTA.setText(bos.toString());
                        FmrcPanel.this.detailTA.gotoTop();
                        FmrcPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(viewButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            if (command == null) {
                return false;
            }
            try {
                this.table.setFmrc(command);
                return true;
            }
            catch (Exception ioe) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                return false;
            }
        }

        @Override
        void save() {
            this.table.save();
            super.save();
        }

        @Override
        void closeOpenFiles() throws IOException {
            this.table.closeOpenFiles();
        }
    }

    private class NcStreamPanel
    extends OpPanel {
        ucar.nc2.ui.NcStreamPanel panel;

        NcStreamPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.panel = new ucar.nc2.ui.NcStreamPanel(this.prefs);
            this.add((Component)this.panel, "Center");
            AbstractAction infoAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        NcStreamPanel.this.panel.showInfo(f);
                    }
                    catch (Exception ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        ioe.printStackTrace(new PrintStream(bos));
                        NcStreamPanel.this.detailTA.setText(bos.toString());
                        NcStreamPanel.this.detailWindow.show();
                        return;
                    }
                    NcStreamPanel.this.detailTA.setText(f.toString());
                    NcStreamPanel.this.detailTA.gotoTop();
                    NcStreamPanel.this.detailWindow.show();
                }
            };
            BAMutil.setActionProperties(infoAction, "Information", "show Info", false, 73, -1);
            BAMutil.addActionToContainer(this.buttPanel, infoAction);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.panel.setNcStreamFile(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "CdmremotePanel cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.panel.save();
            super.save();
        }

        @Override
        void closeOpenFiles() throws IOException {
            this.panel.closeOpenFiles();
        }
    }

    private class CdmremotePanel
    extends OpPanel {
        ucar.nc2.ui.CdmremotePanel panel;

        CdmremotePanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.panel = new ucar.nc2.ui.CdmremotePanel(this.prefs);
            this.add((Component)this.panel, "Center");
            AbstractAction infoAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        CdmremotePanel.this.panel.showInfo(f);
                    }
                    catch (Exception ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        ioe.printStackTrace(new PrintStream(bos));
                        CdmremotePanel.this.detailTA.setText(bos.toString());
                        CdmremotePanel.this.detailWindow.show();
                        return;
                    }
                    CdmremotePanel.this.detailTA.setText(f.toString());
                    CdmremotePanel.this.detailTA.gotoTop();
                    CdmremotePanel.this.detailWindow.show();
                }
            };
            BAMutil.setActionProperties(infoAction, "Information", "show Info", false, 73, -1);
            BAMutil.addActionToContainer(this.buttPanel, infoAction);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.panel.setNcStream(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "CdmremotePanel cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.panel.save();
            super.save();
        }

        @Override
        void closeOpenFiles() throws IOException {
            this.panel.closeOpenFiles();
        }
    }

    private class NcmlEditorPanel
    extends OpPanel {
        NetcdfDataset ds;
        String ncmlLocation;
        JEditorPane editor;
        Map<String, String> protoMap;
        ComboBox protoChooser;

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
        }

        NcmlEditorPanel(PreferencesExt p) {
            super(p, "dataset:");
            this.ds = null;
            this.ncmlLocation = null;
            this.protoMap = new HashMap<String, String>(10);
            this.protoChooser = new ComboBox((PreferencesExt)this.prefs.node("protoChooser"));
            this.addProtoChoices();
            this.buttPanel.add(this.protoChooser);
            this.protoChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String ptype = (String)NcmlEditorPanel.this.protoChooser.getSelectedItem();
                    String proto = NcmlEditorPanel.this.protoMap.get(ptype);
                    if (proto != null) {
                        NcmlEditorPanel.this.editor.setText(proto);
                    }
                }
            });
            this.editor = new JEditorPane();
            XMLEditorKit kit = new XMLEditorKit(false);
            kit.setWrapStyleWord(true);
            this.editor.setEditorKit(kit);
            this.editor.setFont(new Font("Courier", 0, 12));
            this.editor.getDocument().putProperty("tabSize", 2);
            this.editor.getDocument().putProperty("autoIndentation", true);
            this.editor.getDocument().putProperty("tagCompletion", true);
            kit.setFolding(true);
            kit.setStyle("attribute-name", Color.RED, 1);
            ScrollableEditorPanel editorPanel = new ScrollableEditorPanel(this.editor);
            JScrollPane scroller = new JScrollPane(editorPanel);
            scroller.setRowHeaderView(new LineNumberMargin(this.editor));
            AbstractAction wrapAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XMLEditorKit kit;
                    kit.setLineWrappingEnabled(!(kit = (XMLEditorKit)NcmlEditorPanel.this.editor.getEditorKit()).isLineWrapping());
                    NcmlEditorPanel.this.editor.updateUI();
                }
            };
            BAMutil.setActionProperties(wrapAction, "Wrap", "Toggle Wrapping", false, 87, -1);
            BAMutil.addActionToContainer(this.buttPanel, wrapAction);
            AbstractAction saveAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename;
                    int pos;
                    String location;
                    String string = location = NcmlEditorPanel.this.ds == null ? NcmlEditorPanel.this.ncmlLocation : NcmlEditorPanel.this.ds.getLocation();
                    if (location == null) {
                        location = "test";
                    }
                    if ((pos = location.lastIndexOf(".")) > 0) {
                        location = location.substring(0, pos);
                    }
                    if ((filename = ToolsUI.this.fileChooser.chooseFilenameToSave(location + ".ncml")) == null) {
                        return;
                    }
                    if (NcmlEditorPanel.this.doSave(NcmlEditorPanel.this.editor.getText(), filename)) {
                        NcmlEditorPanel.this.ncmlLocation = filename;
                    }
                }
            };
            BAMutil.setActionProperties(saveAction, "Save", "Save NcML", false, 83, -1);
            BAMutil.addActionToContainer(this.buttPanel, saveAction);
            AbstractAction netcdfAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename;
                    int pos;
                    String location;
                    String string = location = NcmlEditorPanel.this.ds == null ? NcmlEditorPanel.this.ncmlLocation : NcmlEditorPanel.this.ds.getLocation();
                    if (location == null) {
                        location = "test";
                    }
                    if ((pos = location.lastIndexOf(".")) > 0) {
                        location = location.substring(0, pos);
                    }
                    if ((filename = ToolsUI.this.fileChooser.chooseFilenameToSave(location + ".nc")) == null) {
                        return;
                    }
                    NcmlEditorPanel.this.doWriteNetCDF(NcmlEditorPanel.this.editor.getText(), filename);
                }
            };
            BAMutil.setActionProperties(netcdfAction, "netcdf", "Write netCDF", false, 78, -1);
            BAMutil.addActionToContainer(this.buttPanel, netcdfAction);
            AbstractAction transAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NcmlEditorPanel.this.doTransform(NcmlEditorPanel.this.editor.getText());
                }
            };
            BAMutil.setActionProperties(transAction, "Import", "read textArea through NcMLReader\n write NcML back out via resulting dataset", false, 84, -1);
            BAMutil.addActionToContainer(this.buttPanel, transAction);
            AbstractButton compareButton = BAMutil.makeButtcon("Select", "Check NcML", false);
            compareButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    NcmlEditorPanel.this.checkNcml(f);
                    NcmlEditorPanel.this.detailTA.setText(f.toString());
                    NcmlEditorPanel.this.detailTA.gotoTop();
                    NcmlEditorPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(compareButton);
            this.add((Component)scroller, "Center");
        }

        @Override
        boolean process(Object o) {
            this.ncmlLocation = (String)o;
            if (this.ncmlLocation.endsWith(".xml") || this.ncmlLocation.endsWith(".ncml")) {
                if (!this.ncmlLocation.startsWith("http:") && !this.ncmlLocation.startsWith("file:")) {
                    this.ncmlLocation = "file:" + this.ncmlLocation;
                }
                String text = IO.readURLcontents(this.ncmlLocation);
                this.editor.setText(text);
            } else {
                this.writeNcml(this.ncmlLocation);
            }
            return true;
        }

        boolean writeNcml(String location) {
            boolean err = false;
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.ds = ToolsUI.this.openDataset(location, this.addCoords, null);
                if (this.ds == null) {
                    this.editor.setText("Failed to open <" + location + ">");
                } else {
                    String result = new NcMLWriter().writeXML(this.ds);
                    this.editor.setText(result);
                    this.editor.setCaretPosition(0);
                }
            }
            catch (FileNotFoundException ioe) {
                this.editor.setText("Failed to open <" + location + ">");
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.editor.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void doWriteNetCDF(String text, String filename) {
            if (ToolsUI.this.debugNcmlWrite) {
                System.out.println("filename=" + filename);
                System.out.println("text=" + text);
            }
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(text.getBytes());
                NcMLReader.writeNcMLToFile(bis, filename);
                JOptionPane.showMessageDialog(this, "File successfully written");
            }
            catch (Exception ioe) {
                JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }

        void doTransform(String text) {
            try {
                StringReader reader = new StringReader(text);
                NetcdfDataset ncd = NcMLReader.readNcML(reader, null);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                ncd.writeNcML(bos, null);
                this.editor.setText(bos.toString());
                this.editor.setCaretPosition(0);
                JOptionPane.showMessageDialog(this, "File successfully transformed");
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }

        private void checkNcml(Formatter f) {
            if (this.ncmlLocation == null) {
                return;
            }
            try {
                NetcdfDataset ncd = NetcdfDataset.openDataset(this.ncmlLocation);
                ncd.check(f);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }

        boolean doSave(String text, String filename) {
            int val;
            File out;
            if (ToolsUI.this.debugNcmlWrite) {
                System.out.println("filename=" + filename);
                System.out.println("text=" + text);
            }
            if ((out = new File(filename)).exists() && (val = JOptionPane.showConfirmDialog(ToolsUI.this.parentFrame, filename + " already exists. Do you want to overrwrite?", "WARNING", 0)) != 0) {
                return false;
            }
            try {
                IO.writeToFile(text, out);
                JOptionPane.showMessageDialog(this, "File successfully written");
                return true;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
                ioe.printStackTrace();
                return false;
            }
        }

        void addProtoChoices() {
            String xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <variable name='time' type='int' shape='time'>\n    <attribute name='long_name' type='string' value='time coordinate' />\n    <attribute name='units' type='string' value='days since 2001-8-31 00:00:00 UTC' />\n    <values start='0' increment='10' />\n  </variable>\n  <aggregation dimName='time' type='joinNew'>\n    <variableAgg name='T'/>\n    <scan location='src/test/data/ncml/nc/' suffix='.nc' subdirs='false'/>\n  </aggregation>\n</netcdf>";
            this.protoMap.put("joinNew", xml);
            this.protoChooser.addItem("joinNew");
            xml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='time' type='joinExisting'>\n    <scan location='ncml/nc/pfeg/' suffix='.nc' />\n  </aggregation>\n</netcdf>";
            this.protoMap.put("joinExisting", xml);
            this.protoChooser.addItem("joinExisting");
        }
    }

    private class Hdf4Panel
    extends OpPanel {
        RandomAccessFile raf;
        Hdf4Table hdf4Table;

        @Override
        void closeOpenFiles() throws IOException {
            this.hdf4Table.closeOpenFiles();
        }

        Hdf4Panel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.hdf4Table = new Hdf4Table(this.prefs);
            this.add((Component)this.hdf4Table, "Center");
            AbstractButton eosdump = BAMutil.makeButtcon("alien", "Show EOS processing", false);
            eosdump.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Formatter f = new Formatter();
                        Hdf4Panel.this.hdf4Table.getEosInfo(f);
                        Hdf4Panel.this.detailTA.setText(f.toString());
                        Hdf4Panel.this.detailWindow.show();
                    }
                    catch (IOException ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        ioe.printStackTrace(new PrintStream(bos));
                        Hdf4Panel.this.detailTA.setText(bos.toString());
                        Hdf4Panel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(eosdump);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.hdf4Table.setHdf4File(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.hdf4Table.save();
            super.save();
        }
    }

    private class Hdf5DataPanel
    extends OpPanel {
        RandomAccessFile raf;
        Hdf5DataTable hdf5Table;

        @Override
        void closeOpenFiles() throws IOException {
            this.hdf5Table.closeOpenFiles();
        }

        Hdf5DataPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.hdf5Table = new Hdf5DataTable(this.prefs, this.buttPanel);
            this.add((Component)this.hdf5Table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        Hdf5DataPanel.this.hdf5Table.showInfo(f);
                    }
                    catch (IOException ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        ioe.printStackTrace(new PrintStream(bos));
                        Hdf5DataPanel.this.detailTA.setText(bos.toString());
                        Hdf5DataPanel.this.detailWindow.show();
                        return;
                    }
                    Hdf5DataPanel.this.detailTA.setText(f.toString());
                    Hdf5DataPanel.this.detailTA.gotoTop();
                    Hdf5DataPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.hdf5Table.setHdf5File(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "Hdf5DataTable cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.hdf5Table.save();
            super.save();
        }
    }

    private class Hdf5ObjectPanel
    extends OpPanel {
        RandomAccessFile raf;
        Hdf5ObjectTable hdf5Table;

        @Override
        void closeOpenFiles() throws IOException {
            this.hdf5Table.closeOpenFiles();
        }

        Hdf5ObjectPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.hdf5Table = new Hdf5ObjectTable(this.prefs);
            this.add((Component)this.hdf5Table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Compact Representation", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        Hdf5ObjectPanel.this.hdf5Table.showInfo(f);
                    }
                    catch (IOException ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        ioe.printStackTrace(new PrintStream(bos));
                        Hdf5ObjectPanel.this.detailTA.setText(bos.toString());
                        Hdf5ObjectPanel.this.detailWindow.show();
                        return;
                    }
                    Hdf5ObjectPanel.this.detailTA.setText(f.toString());
                    Hdf5ObjectPanel.this.detailTA.gotoTop();
                    Hdf5ObjectPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton infoButton2 = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        Hdf5ObjectPanel.this.hdf5Table.showInfo2(f);
                    }
                    catch (IOException ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        ioe.printStackTrace(new PrintStream(bos));
                        Hdf5ObjectPanel.this.detailTA.setText(bos.toString());
                        Hdf5ObjectPanel.this.detailWindow.show();
                        return;
                    }
                    Hdf5ObjectPanel.this.detailTA.setText(f.toString());
                    Hdf5ObjectPanel.this.detailTA.gotoTop();
                    Hdf5ObjectPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton2);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.hdf5Table.setHdf5File(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "Hdf5ObjectTable cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.hdf5Table.save();
            super.save();
        }
    }

    private class GribRenamePanel
    extends OpPanel {
        ucar.nc2.ui.GribRenamePanel panel;

        GribRenamePanel(PreferencesExt p) {
            super(p, "", false, false, false);
            this.panel = new ucar.nc2.ui.GribRenamePanel(this.prefs, this.buttPanel);
            this.add((Component)this.panel, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.panel.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class Grib2TablePanel
    extends OpPanel {
        Grib2TablesViewer codeTable;

        Grib2TablePanel(PreferencesExt p) {
            super(p, "table:", false, false);
            this.codeTable = new Grib2TablesViewer(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class Grib1TablePanel
    extends OpPanel {
        Grib1TablesViewer codeTable;

        Grib1TablePanel(PreferencesExt p) {
            super(p, "table:", true, false);
            this.codeTable = new Grib1TablesViewer(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            try {
                this.codeTable.setTable((String)command);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class WmoCCPanel
    extends OpPanel {
        WmoCommonCodesPanel codeTable;

        WmoCCPanel(PreferencesExt p) {
            super(p, "table:", false, false);
            this.codeTable = new WmoCommonCodesPanel(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class BufrCodePanel
    extends OpPanel {
        BufrWmoCodesPanel codeTable;

        BufrCodePanel(PreferencesExt p) {
            super(p, "table:", false, false, false);
            this.codeTable = new BufrWmoCodesPanel(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class GribCodePanel
    extends OpPanel {
        GribWmoCodesPanel codeTable;

        GribCodePanel(PreferencesExt p) {
            super(p, "table:", false, false, false);
            final JComboBox<WmoCodeTable.Version> modes = new JComboBox<WmoCodeTable.Version>(WmoCodeTable.Version.values());
            modes.setSelectedItem((Object)WmoCodeTable.standard);
            this.topPanel.add(modes, "Center");
            modes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GribCodePanel.this.codeTable.setTable((WmoCodeTable.Version)((Object)modes.getSelectedItem()));
                }
            });
            this.codeTable = new GribWmoCodesPanel(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class GribTemplatePanel
    extends OpPanel {
        GribWmoTemplatesPanel codeTable;

        GribTemplatePanel(PreferencesExt p) {
            super(p, "table:", false, false, false);
            final JComboBox<WmoTemplateTable.Version> modes = new JComboBox<WmoTemplateTable.Version>(WmoTemplateTable.Version.values());
            modes.setSelectedItem((Object)WmoTemplateTable.standard);
            this.topPanel.add(modes, "Center");
            modes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GribTemplatePanel.this.codeTable.setTable((WmoTemplateTable.Version)((Object)modes.getSelectedItem()));
                }
            });
            this.codeTable = new GribWmoTemplatesPanel(this.prefs, this.buttPanel);
            this.add((Component)this.codeTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void save() {
            this.codeTable.save();
            super.save();
        }

        @Override
        void closeOpenFiles() {
        }
    }

    private class Grib1ReportPanel
    extends OpPanel {
        ucar.nc2.ui.Grib1ReportPanel gribReport;
        boolean useIndex;
        JComboBox reports;

        Grib1ReportPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.useIndex = true;
            this.gribReport = new ucar.nc2.ui.Grib1ReportPanel(this.prefs, this.buttPanel);
            this.add((Component)this.gribReport, "Center");
            this.reports = new JComboBox<Grib1ReportPanel.Report>(Grib1ReportPanel.Report.values());
            this.buttPanel.add(this.reports);
            AbstractAction useIndexButt = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    Grib1ReportPanel.this.useIndex = state;
                }
            };
            useIndexButt.putValue("state", this.useIndex);
            BAMutil.setActionProperties(useIndexButt, "Doit", "use default table", true, 67, -1);
            BAMutil.addActionToContainer(this.buttPanel, useIndexButt);
            AbstractAction doitButt = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Grib1ReportPanel.this.process();
                }
            };
            BAMutil.setActionProperties(doitButt, "alien", "make report", false, 67, -1);
            BAMutil.addActionToContainer(this.buttPanel, doitButt);
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        boolean process(Object o) {
            return this.gribReport.setCollection((String)o);
        }

        boolean process() {
            boolean err = false;
            String command = (String)this.cb.getSelectedItem();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.gribReport.doReport(command, this.useIndex, (Grib1ReportPanel.Report)((Object)this.reports.getSelectedItem()));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Grib2ReportPanel cant open " + command + "\n" + ioe.getMessage());
                ioe.printStackTrace();
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribReport.save();
            super.save();
        }
    }

    private class Grib2ReportPanel
    extends OpPanel {
        ucar.nc2.ui.Grib2ReportPanel gribReport;
        boolean useIndex;
        JComboBox reports;

        Grib2ReportPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.useIndex = true;
            this.gribReport = new ucar.nc2.ui.Grib2ReportPanel(this.prefs, this.buttPanel);
            this.add((Component)this.gribReport, "Center");
            this.reports = new JComboBox<Grib2ReportPanel.Report>(Grib2ReportPanel.Report.values());
            this.buttPanel.add(this.reports);
            AbstractAction useIndexButt = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    Grib2ReportPanel.this.useIndex = state;
                }
            };
            useIndexButt.putValue("state", this.useIndex);
            BAMutil.setActionProperties(useIndexButt, "Doit", "use Index", true, 67, -1);
            BAMutil.addActionToContainer(this.buttPanel, useIndexButt);
            AbstractAction doitButt = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Grib2ReportPanel.this.process();
                }
            };
            BAMutil.setActionProperties(doitButt, "alien", "make report", false, 67, -1);
            BAMutil.addActionToContainer(this.buttPanel, doitButt);
        }

        @Override
        void closeOpenFiles() {
        }

        @Override
        boolean process(Object o) {
            return this.gribReport.setCollection((String)o);
        }

        boolean process() {
            boolean err = false;
            String command = (String)this.cb.getSelectedItem();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.gribReport.doReport(command, this.useIndex, (Grib2ReportPanel.Report)((Object)this.reports.getSelectedItem()));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Grib2ReportPanel cant open " + command + "\n" + ioe.getMessage());
                ioe.printStackTrace();
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribReport.save();
            super.save();
        }
    }

    private class Grib1CollectionPanel
    extends OpPanel {
        ucar.nc2.ui.Grib1CollectionPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
        }

        Grib1CollectionPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.gribTable = new ucar.nc2.ui.Grib1CollectionPanel(this.buttPanel, this.prefs);
            this.add((Component)this.gribTable, "Center");
            AbstractButton writeButton = BAMutil.makeButtcon("netcdf", "Write index", false);
            writeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        if (!Grib1CollectionPanel.this.gribTable.writeIndex(f)) {
                            return;
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Grib1CollectionPanel.this.detailTA.setText(f.toString());
                    Grib1CollectionPanel.this.detailTA.gotoTop();
                    Grib1CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(writeButton);
            this.gribTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib1n")) {
                        String collectionName = (String)e.getNewValue();
                        ToolsUI.this.openGrib1Raw(collectionName);
                    }
                }
            });
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.gribTable.setCollection(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class GribCollectionIndexPanel
    extends OpPanel {
        ucar.nc2.ui.GribCollectionIndexPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
            this.gribTable.closeOpenFiles();
        }

        GribCollectionIndexPanel(PreferencesExt p) {
            super(p, "index file:", true, false);
            this.gribTable = new ucar.nc2.ui.GribCollectionIndexPanel(this.prefs, this.buttPanel);
            this.add((Component)this.gribTable, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.gribTable.setIndexFile(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class Grib2CollectionPanel
    extends OpPanel {
        ucar.nc2.ui.Grib2CollectionPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
        }

        Grib2CollectionPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.gribTable = new ucar.nc2.ui.Grib2CollectionPanel(this.prefs);
            this.add((Component)this.gribTable, "Center");
            this.gribTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib2n")) {
                        String collectionName = (String)e.getNewValue();
                        ToolsUI.this.openGrib2n(collectionName);
                    }
                }
            });
            AbstractButton showButt = BAMutil.makeButtcon("Information", "Show Collection", false);
            showButt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.this.gribTable.showCollection(f);
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(showButt);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Check Problems", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.this.gribTable.checkProblems(f);
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton gdsButton = BAMutil.makeButtcon("Information", "Show GDS use", false);
            gdsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    Grib2CollectionPanel.this.gribTable.showGDSuse(f);
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(gdsButton);
            AbstractButton aggButton = BAMutil.makeButtcon("V3", "Run Rectilyser", false);
            aggButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        Grib2CollectionPanel.this.gribTable.runAggregator(f);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(aggButton);
            AbstractButton writeButton = BAMutil.makeButtcon("netcdf", "Write index", false);
            writeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    try {
                        if (!Grib2CollectionPanel.this.gribTable.writeIndex(f)) {
                            return;
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Grib2CollectionPanel.this.detailTA.setText(f.toString());
                    Grib2CollectionPanel.this.detailTA.gotoTop();
                    Grib2CollectionPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(writeButton);
        }

        void setCollection(String collection) {
            if (this.process(collection) && !this.defer) {
                this.cb.addItem(collection);
            }
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.gribTable.setCollection(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class GribFilesPanel
    extends OpPanel {
        ucar.nc2.ui.GribFilesPanel gribTable;

        @Override
        void closeOpenFiles() throws IOException {
        }

        GribFilesPanel(PreferencesExt p) {
            super(p, "collection:", true, false);
            this.gribTable = new ucar.nc2.ui.GribFilesPanel(this.prefs);
            this.add((Component)this.gribTable, "Center");
            this.gribTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openGrib1Raw")) {
                        String filename = (String)e.getNewValue();
                        ToolsUI.this.openGrib1Raw(filename);
                    }
                }
            });
            AbstractButton showButt = BAMutil.makeButtcon("Information", "Show Collection", false);
            showButt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    GribFilesPanel.this.gribTable.showCollection(f);
                    GribFilesPanel.this.detailTA.setText(f.toString());
                    GribFilesPanel.this.detailTA.gotoTop();
                    GribFilesPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(showButt);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.gribTable.setCollection(command);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class BufrTableDPanel
    extends OpPanel {
        BufrTableDViewer bufrTable;
        JComboBox modes;
        JComboBox tables;

        BufrTableDPanel(PreferencesExt p) {
            super(p, "tableD:", false, false);
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename;
                    if (ToolsUI.this.bufrFileChooser == null) {
                        ToolsUI.this.initBufrFileChooser();
                    }
                    if ((filename = ToolsUI.this.bufrFileChooser.chooseFilename()) == null) {
                        return;
                    }
                    BufrTableDPanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local table...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
            this.modes = new JComboBox<BufrTables.Format>(BufrTables.Format.values());
            this.buttPanel.add(this.modes);
            JButton accept = new JButton("Accept");
            this.buttPanel.add(accept);
            accept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufrTableDPanel.this.accept();
                }
            });
            this.tables = new JComboBox<Object>(BufrTables.getTables().toArray());
            this.buttPanel.add(this.tables);
            this.tables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufrTableDPanel.this.acceptTable((BufrTables.TableConfig)BufrTableDPanel.this.tables.getSelectedItem());
                }
            });
            this.bufrTable = new BufrTableDViewer(this.prefs, this.buttPanel);
            this.add((Component)this.bufrTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void closeOpenFiles() {
        }

        void accept() {
            String command = (String)this.cb.getSelectedItem();
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                Object mode = this.modes.getSelectedItem();
                this.bufrTable.setBufrTableD(command, (BufrTables.Format)((Object)mode));
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrTableViewer cant open " + command + "\n" + ioe.getMessage());
                this.detailTA.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                this.detailTA.setVisible(true);
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.setVisible(true);
                err = true;
            }
        }

        void acceptTable(BufrTables.TableConfig tc) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.bufrTable.setBufrTableD(tc.getTableDname(), tc.getTableDformat());
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrTableViewer cant open " + tc + "\n" + ioe.getMessage());
                this.detailTA.setText("Failed to open <" + tc + ">\n" + ioe.getMessage());
                this.detailTA.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.setVisible(true);
            }
        }

        @Override
        void save() {
            this.bufrTable.save();
            super.save();
        }
    }

    private class BufrTableBPanel
    extends OpPanel {
        BufrTableBViewer bufrTable;
        JComboBox modes;
        JComboBox tables;

        BufrTableBPanel(PreferencesExt p) {
            super(p, "tableB:", false, false);
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename;
                    if (ToolsUI.this.bufrFileChooser == null) {
                        ToolsUI.this.initBufrFileChooser();
                    }
                    if ((filename = ToolsUI.this.bufrFileChooser.chooseFilename()) == null) {
                        return;
                    }
                    BufrTableBPanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local table...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
            this.modes = new JComboBox<BufrTables.Format>(BufrTables.Format.values());
            this.buttPanel.add(this.modes);
            JButton accept = new JButton("Accept");
            this.buttPanel.add(accept);
            accept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufrTableBPanel.this.accept();
                }
            });
            this.tables = new JComboBox<Object>(BufrTables.getTables().toArray());
            this.buttPanel.add(this.tables);
            this.tables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BufrTableBPanel.this.acceptTable((BufrTables.TableConfig)BufrTableBPanel.this.tables.getSelectedItem());
                }
            });
            this.bufrTable = new BufrTableBViewer(this.prefs, this.buttPanel);
            this.add((Component)this.bufrTable, "Center");
        }

        @Override
        boolean process(Object command) {
            return true;
        }

        @Override
        void closeOpenFiles() {
        }

        void accept() {
            String command = (String)this.cb.getSelectedItem();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                Object format = this.modes.getSelectedItem();
                this.bufrTable.setBufrTableB(command, (BufrTables.Format)((Object)format));
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrTableViewer cant open " + command + "\n" + ioe.getMessage());
                this.detailTA.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                this.detailTA.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.setVisible(true);
            }
        }

        void acceptTable(BufrTables.TableConfig tc) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.bufrTable.setBufrTableB(tc.getTableBname(), tc.getTableBformat());
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "BufrTableViewer cant open " + tc + "\n" + ioe.getMessage());
                this.detailTA.setText("Failed to open <" + tc + ">\n" + ioe.getMessage());
                this.detailTA.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.setVisible(true);
            }
        }

        @Override
        void save() {
            this.bufrTable.save();
            super.save();
        }
    }

    private class BufrPanel
    extends OpPanel {
        RandomAccessFile raf;
        BufrMessageViewer bufrTable;

        @Override
        void closeOpenFiles() throws IOException {
            if (this.raf != null) {
                this.raf.close();
            }
            this.raf = null;
        }

        BufrPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.bufrTable = new BufrMessageViewer(this.prefs, this.buttPanel);
            this.add((Component)this.bufrTable, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.bufrTable.setBufrFile(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.bufrTable.save();
            super.save();
        }
    }

    private class AggPanel
    extends OpPanel {
        AggTable aggTable;
        NetcdfDataset ncd;

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ncd != null) {
                this.ncd.close();
            }
            this.ncd = null;
        }

        AggPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.aggTable = new AggTable(this.prefs, this.buttPanel);
            this.aggTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openNetcdfFile")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile != null) {
                            ToolsUI.this.openNetcdfFile(ncfile);
                        }
                    } else if (e.getPropertyName().equals("openCoordSystems")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile == null) {
                            return;
                        }
                        try {
                            NetcdfDataset ncd = NetcdfDataset.wrap(ncfile, NetcdfDataset.getDefaultEnhanceMode());
                            ToolsUI.this.openCoordSystems(ncd);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile == null) {
                            return;
                        }
                        try {
                            NetcdfDataset ncd = NetcdfDataset.wrap(ncfile, NetcdfDataset.getDefaultEnhanceMode());
                            ToolsUI.this.openGridDataset(ncd);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.add((Component)this.aggTable, "Center");
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ncd != null) {
                    try {
                        this.ncd.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                this.ncd = NetcdfDataset.openDataset(command);
                this.aggTable.setAggDataset(this.ncd);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        @Override
        void save() {
            this.aggTable.save();
            super.save();
        }
    }

    private class CoordSysPanel
    extends OpPanel {
        NetcdfDataset ds;
        CoordSysTable coordSysTable;
        boolean useDefinition;
        JComboBox defComboBox;
        IndependentWindow defWindow;
        AbstractButton defButt;

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ds != null) {
                this.ds.close();
            }
            this.ds = null;
        }

        CoordSysPanel(PreferencesExt p) {
            super(p, "dataset:", true, false);
            this.ds = null;
            this.useDefinition = false;
            this.coordSysTable = new CoordSysTable(this.prefs);
            this.add((Component)this.coordSysTable, "Center");
            this.defComboBox = new JComboBox<String>(FmrcDefinition.getDefinitionFiles());
            this.defWindow = new IndependentWindow("GRIB Definition File", null, this.defComboBox);
            this.defWindow.setLocationRelativeTo(this.defButt);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
            infoButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CoordSysPanel.this.ds != null) {
                        NetcdfDatasetInfo info = null;
                        try {
                            info = new NetcdfDatasetInfo(CoordSysPanel.this.ds.getLocation());
                            CoordSysPanel.this.detailTA.setText(info.writeXML());
                            CoordSysPanel.this.detailTA.appendLine("----------------------");
                            CoordSysPanel.this.detailTA.appendLine(info.getParseInfo());
                            CoordSysPanel.this.detailTA.gotoTop();
                        }
                        catch (IOException e1) {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            e1.printStackTrace(new PrintStream(out));
                            CoordSysPanel.this.detailTA.setText(out.toString());
                        }
                        finally {
                            if (info != null) {
                                try {
                                    info.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        CoordSysPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
            JButton dsButton = new JButton("Object dump");
            dsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CoordSysPanel.this.ds != null) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        NetcdfDataset.debugDump(new PrintStream(bos), CoordSysPanel.this.ds);
                        CoordSysPanel.this.detailTA.setText(bos.toString());
                        CoordSysPanel.this.detailTA.gotoTop();
                        CoordSysPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(dsButton);
        }

        @Override
        boolean process(Object o) {
            String currentDef;
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            FmrcDefinition spiObject = null;
            if (this.useDefinition && (currentDef = (String)this.defComboBox.getSelectedItem()) != null) {
                FmrcDefinition fmrc_def = new FmrcDefinition();
                try {
                    fmrc_def.readDefinitionXML(currentDef);
                    spiObject = fmrc_def;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.ds = NetcdfDataset.openDataset(command, true, -1, null, spiObject);
                if (this.ds == null) {
                    JOptionPane.showMessageDialog(null, "Failed to open <" + command + ">");
                } else {
                    this.coordSysTable.setDataset(this.ds);
                }
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        void setDataset(NetcdfDataset ncd) {
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
                this.ds = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ds = ncd;
            this.coordSysTable.setDataset(this.ds);
            this.setSelectedItem(this.ds.getLocation());
        }

        @Override
        void save() {
            this.coordSysTable.save();
            super.save();
        }
    }

    private class DateFormatMark
    extends OpPanel {
        ComboBox testCB;
        DateFormatter dateFormatter;
        TextHistoryPane ta;

        DateFormatMark(PreferencesExt prefs) {
            super(prefs, "dateFormatMark:", false, false);
            this.dateFormatter = new DateFormatter();
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
            this.testCB = new ComboBox(prefs);
            this.buttPanel.add(this.testCB);
            JButton compareButton = new JButton("Apply");
            compareButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DateFormatMark.this.apply(DateFormatMark.this.cb.getSelectedItem(), DateFormatMark.this.testCB.getSelectedItem());
                }
            });
            this.buttPanel.add(compareButton);
        }

        @Override
        boolean process(Object o) {
            return false;
        }

        @Override
        void closeOpenFiles() {
        }

        void apply(Object mark, Object testo) {
            String dateFormatMark = (String)mark;
            String filename = (String)testo;
            try {
                Date coordValueDate = DateFromString.getDateUsingDemarkatedCount(filename, dateFormatMark, '#');
                String coordValue = this.dateFormatter.toDateTimeStringISO(coordValueDate);
                this.ta.setText("got date= " + coordValue);
            }
            catch (Exception e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
            }
        }
    }

    private class UnitConvert
    extends OpPanel {
        TextHistoryPane ta;

        UnitConvert(PreferencesExt prefs) {
            super(prefs, "unit:", false, false);
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
            JButton compareButton = new JButton("Compare");
            compareButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnitConvert.this.compare(UnitConvert.this.cb.getSelectedItem());
                }
            });
            this.buttPanel.add(compareButton);
            JButton dateButton = new JButton("UdunitDate");
            dateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnitConvert.this.checkUdunits(UnitConvert.this.cb.getSelectedItem());
                }
            });
            this.buttPanel.add(dateButton);
            JButton cdateButton = new JButton("CalendarDate");
            cdateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnitConvert.this.checkCalendarDate(UnitConvert.this.cb.getSelectedItem());
                }
            });
            this.buttPanel.add(cdateButton);
        }

        @Override
        boolean process(Object o) {
            String command = (String)o;
            try {
                SimpleUnit su = SimpleUnit.factoryWithExceptions(command);
                this.ta.setText("parse=" + command + "\n");
                this.ta.appendLine("SimpleUnit.toString()          =" + su.toString() + "\n");
                this.ta.appendLine("SimpleUnit.getCanonicalString  =" + su.getCanonicalString());
                this.ta.appendLine("SimpleUnit.getImplementingClass= " + su.getImplementingClass());
                this.ta.appendLine("SimpleUnit.isUnknownUnit       = " + su.isUnknownUnit());
                return true;
            }
            catch (Exception e) {
                if (Debug.isSet("Xdeveloper")) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                    e.printStackTrace(new PrintStream(bos));
                    this.ta.setText(bos.toString());
                } else {
                    this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
                }
                return false;
            }
        }

        @Override
        void closeOpenFiles() {
        }

        void compare(Object o) {
            String command = (String)o;
            StringTokenizer stoke = new StringTokenizer(command);
            ArrayList<String> list = new ArrayList<String>();
            while (stoke.hasMoreTokens()) {
                list.add(stoke.nextToken());
            }
            try {
                String unitS1 = (String)list.get(0);
                String unitS2 = (String)list.get(1);
                SimpleUnit su1 = SimpleUnit.factoryWithExceptions(unitS1);
                SimpleUnit su2 = SimpleUnit.factoryWithExceptions(unitS2);
                this.ta.setText("<" + su1.toString() + "> isConvertable to <" + su2.toString() + ">=" + SimpleUnit.isCompatibleWithExceptions(unitS1, unitS2));
            }
            catch (Exception e) {
                if (Debug.isSet("Xdeveloper")) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                    e.printStackTrace(new PrintStream(bos));
                    this.ta.setText(bos.toString());
                }
                this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
            }
        }

        void checkUdunits(Object o) {
            String command = (String)o;
            boolean isDate = false;
            try {
                DateUnit du = new DateUnit(command);
                this.ta.appendLine("\nFrom udunits:\n <" + command + "> isDateUnit = " + du);
                Date d = du.getDate();
                this.ta.appendLine("getStandardDateString = " + ToolsUI.this.formatter.toDateTimeString(d));
                this.ta.appendLine("getDateOrigin = " + ToolsUI.this.formatter.toDateTimeString(du.getDateOrigin()));
                isDate = true;
                Date d2 = DateUnit.getStandardOrISO(command);
                if (d2 == null) {
                    this.ta.appendLine("\nDateUnit.getStandardOrISO = false");
                } else {
                    this.ta.appendLine("\nDateUnit.getStandardOrISO = " + ToolsUI.this.formatter.toDateTimeString(d2));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.ta.appendLine("isDate = " + isDate);
            if (!isDate) {
                try {
                    SimpleUnit su = SimpleUnit.factory(command);
                    boolean isTime = su instanceof TimeUnit;
                    this.ta.setText("<" + command + "> isDateUnit= " + isDate + " isTimeUnit= " + isTime);
                    if (isTime) {
                        TimeUnit du = (TimeUnit)su;
                        this.ta.appendLine("\nTimeUnit = " + du);
                    }
                }
                catch (Exception e) {
                    if (Debug.isSet("Xdeveloper")) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        e.printStackTrace(new PrintStream(bos));
                        this.ta.setText(bos.toString());
                    }
                    this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
                }
            }
        }

        void checkCalendarDate(Object o) {
            String command = (String)o;
            this.ta.setText("\nParse CalendarDateUnit: <" + command + ">\n");
            try {
                CalendarDateUnit cd = CalendarDateUnit.of(null, command);
                this.ta.appendLine("CalendarDateUnit = " + cd);
                this.ta.appendLine(" Calendar        = " + (Object)((Object)cd.getCalendar()));
                this.ta.appendLine(" PeriodField     = " + (Object)((Object)cd.getTimeUnit().getField()));
                this.ta.appendLine(" PeriodValue     = " + cd.getTimeUnit().getValue());
                this.ta.appendLine(" Base            = " + cd.getBaseCalendarDate());
                this.ta.appendLine(" isCalendarField = " + cd.isCalendarField());
            }
            catch (Exception e) {
                this.ta.appendLine("not a CalendarDateUnit= " + e.getMessage());
                try {
                    String[] s = command.split("%");
                    if (s.length == 2) {
                        Double val = Double.parseDouble(s[0].trim());
                        this.ta.appendLine("\nval= " + val + " unit=" + s[1]);
                        CalendarDateUnit cdu = CalendarDateUnit.of(null, s[1].trim());
                        this.ta.appendLine("CalendarDateUnit= " + cdu);
                        CalendarDate cd = cdu.makeCalendarDate(val);
                        this.ta.appendLine(" CalendarDate = " + cd);
                        Date d = cd.toDate();
                        this.ta.appendLine(" Date.toString() = " + d);
                        DateFormatter format = new DateFormatter();
                        this.ta.appendLine(" DateFormatter= " + format.toDateTimeString(cd.toDate()));
                    }
                }
                catch (Exception ee) {
                    this.ta.appendLine("Failed on CalendarDateUnit " + ee.getMessage());
                }
            }
        }
    }

    private class UnitDatasetCheck
    extends OpPanel {
        NetcdfFile ncfile;
        TextHistoryPane ta;

        UnitDatasetCheck(PreferencesExt p) {
            super(p, "dataset:");
            this.ncfile = null;
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                this.ncfile = NetcdfDataset.openDataset(command, this.addCoords, null);
                this.ta.setText("Variables for " + command + ":");
                for (VariableEnhanced variableEnhanced : this.ncfile.getVariables()) {
                    String units = variableEnhanced.getUnitsString();
                    StringBuilder sb = new StringBuilder();
                    sb.append("   ").append(variableEnhanced.getShortName()).append(" has unit= <").append(units).append(">");
                    if (units != null) {
                        try {
                            SimpleUnit su = SimpleUnit.factoryWithExceptions(units);
                            sb.append(" unit convert = ").append(su.toString());
                            if (su.isUnknownUnit()) {
                                sb.append(" UNKNOWN UNIT");
                            }
                        }
                        catch (Exception ioe) {
                            sb.append(" unit convert failed ");
                            sb.insert(0, "**** Fail ");
                        }
                    }
                    this.ta.appendLine(sb.toString());
                }
            }
            catch (FileNotFoundException ioe) {
                this.ta.setText("Failed to open <" + command + ">");
                err = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                err = true;
            }
            finally {
                try {
                    if (this.ncfile != null) {
                        this.ncfile.close();
                    }
                    this.ncfile = null;
                }
                catch (IOException ioe) {}
            }
            return !err;
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
        }
    }

    private class UnitsPanel
    extends JPanel {
        PreferencesExt prefs;
        JSplitPane split;
        JSplitPane split2;
        UnitDatasetCheck unitDataset;
        UnitConvert unitConvert;
        DateFormatMark dateFormatMark;

        UnitsPanel(PreferencesExt prefs) {
            this.prefs = prefs;
            this.unitDataset = new UnitDatasetCheck((PreferencesExt)prefs.node("unitDataset"));
            this.unitConvert = new UnitConvert((PreferencesExt)prefs.node("unitConvert"));
            this.dateFormatMark = new DateFormatMark((PreferencesExt)prefs.node("dateFormatMark"));
            this.split2 = new JSplitPane(0, this.unitConvert, this.dateFormatMark);
            this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
            this.split = new JSplitPane(1, new JScrollPane(this.unitDataset), this.split2);
            this.split.setDividerLocation(prefs.getInt("splitPos", 500));
            this.setLayout(new BorderLayout());
            this.add((Component)this.split, "Center");
        }

        void save() {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
            this.unitConvert.save();
            this.unitDataset.save();
        }
    }

    private class NCdumpPanel
    extends OpPanel
    implements GetDataRunnable {
        private GetDataTask task;
        NetcdfFile ncfile;
        String filename;
        String command;
        String result;
        TextHistoryPane ta;

        NCdumpPanel(PreferencesExt prefs) {
            super(prefs, "command:");
            this.ncfile = null;
            this.filename = null;
            this.command = null;
            this.ta = new TextHistoryPane(true);
            this.add((Component)this.ta, "Center");
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NCdumpPanel.this.task.isSuccess()) {
                        NCdumpPanel.this.ta.setText(NCdumpPanel.this.result);
                    } else {
                        NCdumpPanel.this.ta.setText(((NCdumpPanel)NCdumpPanel.this).task.errMsg);
                    }
                    if (NCdumpPanel.this.task.isCancel()) {
                        NCdumpPanel.this.ta.appendLine("\n***Cancelled by User");
                    }
                    NCdumpPanel.this.ta.gotoTop();
                    if (NCdumpPanel.this.task.isSuccess() && !NCdumpPanel.this.task.isCancel()) {
                        NCdumpPanel.this.cb.setSelectedItem(NCdumpPanel.this.filename);
                    }
                }
            });
        }

        @Override
        void closeOpenFiles() throws IOException {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
            this.ncfile = null;
        }

        @Override
        boolean process(Object o) {
            int pos;
            String input = ((String)o).trim();
            if (input.indexOf(34) == 0 && (pos = input.indexOf(34, 1)) > 0) {
                this.filename = input.substring(1, pos);
                this.command = input.substring(pos + 1);
            } else if (input.indexOf(39) == 0 && (pos = input.indexOf(39, 1)) > 0) {
                this.filename = input.substring(1, pos);
                this.command = input.substring(pos + 1);
            } else {
                pos = input.indexOf(32);
                if (pos > 0) {
                    this.filename = input.substring(0, pos);
                    this.command = input.substring(pos);
                } else {
                    this.filename = input;
                    this.command = null;
                }
            }
            this.task = new GetDataTask(this, this.filename, null);
            this.stopButton.startProgressMonitorTask(this.task);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Object o) throws IOException {
            try {
                this.ncfile = this.addCoords ? NetcdfDataset.openDataset(this.filename, true, null) : NetcdfDataset.openFile(this.filename, null);
                StringWriter writer = new StringWriter(50000);
                NCdumpW.print(this.ncfile, this.command, writer, this.task);
                this.result = writer.toString();
            }
            finally {
                try {
                    if (this.ncfile != null) {
                        this.ncfile.close();
                    }
                    this.ncfile = null;
                }
                catch (IOException iOException) {}
            }
        }

        void setNetcdfFile(NetcdfFile ncf) {
            this.ncfile = ncf;
            this.filename = ncf.getLocation();
            GetDataRunnable runner = new GetDataRunnable(){

                @Override
                public void run(Object o) throws IOException {
                    StringWriter writer = new StringWriter(50000);
                    NCdumpW.print(NCdumpPanel.this.ncfile, NCdumpPanel.this.command, writer, NCdumpPanel.this.task);
                    NCdumpPanel.this.result = writer.toString();
                }
            };
            this.task = new GetDataTask(runner, this.filename, null);
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private abstract class OpPanel
    extends JPanel {
        PreferencesExt prefs;
        ComboBox cb;
        JPanel buttPanel;
        JPanel topPanel;
        AbstractButton coordButt = null;
        StopButton stopButton;
        boolean addCoords;
        boolean defer;
        boolean busy;
        long lastEvent = -1L;
        boolean eventOK = true;
        IndependentWindow detailWindow;
        TextHistoryPane detailTA;

        OpPanel(PreferencesExt prefs, String command) {
            this(prefs, command, true, true);
        }

        OpPanel(PreferencesExt prefs, String command, boolean addFileButton, boolean addCoordButton) {
            this(prefs, command, true, addFileButton, addCoordButton);
        }

        OpPanel(PreferencesExt prefs, String command, boolean addComboBox, boolean addFileButton, boolean addCoordButton) {
            this.prefs = prefs;
            this.cb = new ComboBox(prefs);
            this.cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ToolsUI.this.debugCB) {
                        System.out.println(" doit " + OpPanel.this.cb.getSelectedItem() + " cmd=" + e.getActionCommand() + " when=" + e.getWhen() + " class=" + OpPanel.this.getClass().getName());
                    }
                    if (OpPanel.this.eventOK && e.getWhen() > OpPanel.this.lastEvent + 10000L) {
                        OpPanel.this.doit(OpPanel.this.cb.getSelectedItem());
                        OpPanel.this.lastEvent = e.getWhen();
                    }
                }
            });
            this.buttPanel = new JPanel(new FlowLayout(0, 5, 0));
            AbstractAction closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        OpPanel.this.closeOpenFiles();
                    }
                    catch (IOException e1) {
                        System.out.printf("close failed", new Object[0]);
                    }
                }
            };
            BAMutil.setActionProperties(closeAction, "Close", "release files", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, closeAction);
            if (addFileButton) {
                AbstractAction fileAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String filename = ToolsUI.this.fileChooser.chooseFilename();
                        if (filename == null) {
                            return;
                        }
                        OpPanel.this.cb.setSelectedItem(filename);
                    }
                };
                BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
                BAMutil.addActionToContainer(this.buttPanel, fileAction);
            }
            if (addCoordButton) {
                AbstractAction coordAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Boolean state = (Boolean)this.getValue("state");
                        OpPanel.this.addCoords = state;
                        String tooltip = OpPanel.this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                        OpPanel.this.coordButt.setToolTipText(tooltip);
                    }
                };
                this.addCoords = prefs.getBoolean("coordState", false);
                String tooltip2 = this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                BAMutil.setActionProperties(coordAction, "addCoords", tooltip2, true, 67, -1);
                coordAction.putValue("state", new Boolean(this.addCoords));
                this.coordButt = BAMutil.addActionToContainer(this.buttPanel, coordAction);
            }
            if (this instanceof GetDataRunnable) {
                this.stopButton = new StopButton("Stop");
                this.buttPanel.add(this.stopButton);
            }
            this.topPanel = new JPanel(new BorderLayout());
            this.topPanel.add((Component)new JLabel(command), "West");
            if (addComboBox) {
                this.topPanel.add((Component)this.cb, "Center");
            }
            this.topPanel.add((Component)this.buttPanel, "East");
            this.setLayout(new BorderLayout());
            this.add((Component)this.topPanel, "North");
            this.detailTA = new TextHistoryPane();
            this.detailTA.setFont(new Font("Monospaced", 0, 12));
            this.detailWindow = new IndependentWindow("Details", BAMutil.getImage("netcdfUI"), new JScrollPane(this.detailTA));
            Rectangle bounds = (Rectangle)prefs.getBean(ToolsUI.FRAME_SIZE, new Rectangle(200, 50, 500, 700));
            this.detailWindow.setBounds(bounds);
        }

        void doit(Object command) {
            if (this.busy) {
                return;
            }
            if (command == null) {
                return;
            }
            if (command instanceof String) {
                command = ((String)command).trim();
            }
            if (ToolsUI.this.debug) {
                System.out.println(this.getClass().getName() + " process=" + command);
            }
            this.busy = true;
            if (this.process(command) && !this.defer) {
                this.cb.addItem(command);
            }
            this.busy = false;
        }

        abstract boolean process(Object var1);

        abstract void closeOpenFiles() throws IOException;

        void save() {
            this.cb.save();
            if (this.coordButt != null) {
                this.prefs.putBoolean("coordState", this.coordButt.getModel().isSelected());
            }
            if (this.detailWindow != null) {
                this.prefs.putBeanObject(ToolsUI.FRAME_SIZE, this.detailWindow.getBounds());
            }
        }

        void setSelectedItem(Object item) {
            this.eventOK = false;
            this.cb.setSelectedItem(item);
            this.eventOK = true;
        }
    }
}

