/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import HTTPClient.UncompressInputStream;
import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class AddeURLConnection
extends URLConnection {
    private InputStream is = null;
    private DataInputStream dis = null;
    private DataOutputStream dos = null;
    private URL url;
    private boolean rawStream = false;
    private final int DEFAULT_LINES = 480;
    private final int DEFAULT_ELEMS = 640;
    public static final String DEFAULT_USER = "XXXX";
    public static final int DEFAULT_PROJ = 0;
    private static final int TRAILER_SIZE = 92;
    private static final int REQUEST_SIZE = 120;
    private static final int ERRMSG_SIZE = 72;
    private static final int ERRMSG_OFFS = 8;
    private static final int COMPRESS = 503;
    private static final int NO_COMPRESS = 500;
    private static final int GZIP = 112;
    private final int UNCOMPRESS_KEY = 1;
    private final int COMPRESS_KEY = 2;
    private final int GZIP_KEY = 3;
    public static final int DEFAULT_PORT = 112;
    public static final int VERSION_1 = 1;
    public static final int AGET = 0;
    public static final int ADIR = 1;
    public static final int LWPR = 2;
    public static final int GDIR = 3;
    public static final int GGET = 4;
    public static final int MDKS = 5;
    public static final int TXTG = 6;
    public static final int WTXG = 7;
    public static final int OBTG = 8;
    private static final int IMAGE = 100;
    private static final int GRID = 101;
    private static final int POINT = 102;
    private static final int TEXT = 103;
    private static final int WXTEXT = 104;
    private static final int OBTEXT = 105;
    private int numBytes = 0;
    private int dataType = 100;
    private byte[] binaryData = null;
    private int reqType = 0;
    private boolean debug = false;
    private int portToUse = 0;
    private int compressionType = 112;
    private static char AMPERSAND = (char)38;
    private static String[] replaceWith = new String[]{"&", "<", ">", "'", "\"", "\r", "\n", " "};
    private static String[] replaceString = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;", "&#13;", "&#10;", "%20"};

    AddeURLConnection(URL url) throws IOException {
        super(url);
        this.url = this.normalizeURL(url);
    }

    public synchronized void connect() throws IOException, AddeURLException {
        int i;
        Socket t;
        String cmd;
        String uCmd;
        String requestOriginal = this.url.getFile().substring(1);
        String request = requestOriginal.toLowerCase();
        String path = this.url.getPath().substring(1).toLowerCase();
        String query = this.url.getQuery();
        boolean bl = this.debug = this.debug || request.indexOf("debug=true") >= 0;
        if (this.debug) {
            System.out.println("host from URL: " + this.url.getHost());
        }
        if (this.debug) {
            System.out.println("file from URL: " + this.url.getFile());
        }
        if (!(path.startsWith("image") || path.startsWith("dataset") || path.startsWith("dsinfo") || path.startsWith("text") || path.startsWith("wxtext") || path.startsWith("obtext") || path.startsWith("grid") || path.startsWith("point"))) {
            throw new AddeURLException("Request for unknown data");
        }
        this.rawStream = request.indexOf("rawstream=true") >= 0;
        byte[] svc = null;
        if (path.startsWith("imagedir") || path.equals("adir")) {
            svc = "adir".getBytes();
            this.reqType = 1;
        } else if (path.startsWith("dataset") || path.startsWith("dsinfo") || path.equals("lwpr")) {
            svc = "lwpr".getBytes();
            this.reqType = 2;
        } else if (path.startsWith("text") || path.equals("txtg")) {
            svc = "txtg".getBytes();
            this.reqType = 6;
        } else if (path.startsWith("wxtext") || path.equals("wtxg")) {
            svc = "wtxg".getBytes();
            this.reqType = 7;
        } else if (path.startsWith("obtext") || path.equals("obtg")) {
            svc = "obtg".getBytes();
            this.reqType = 8;
        } else if (path.startsWith("image") || path.equals("aget")) {
            svc = "aget".getBytes();
            this.reqType = 0;
        } else if (path.startsWith("griddir") || path.equals("gdir")) {
            svc = "gdir".getBytes();
            this.reqType = 3;
        } else if (path.startsWith("grid") || path.equals("gget")) {
            svc = "gget".getBytes();
            this.reqType = 4;
        } else if (path.startsWith("point") || path.equals("mdks")) {
            svc = "mdks".getBytes();
            this.reqType = 5;
        } else {
            throw new AddeURLException("Invalid or unsupported ADDE service= " + svc.toString());
        }
        if (this.debug) {
            System.out.println("Service = " + new String(svc));
        }
        int test = requestOriginal.indexOf("?");
        String string = uCmd = query == null ? requestOriginal : query;
        if (this.debug) {
            System.out.println("uCmd=" + uCmd);
        }
        StringBuffer sb = new StringBuffer();
        switch (this.reqType) {
            case 0: {
                sb = this.decodeAGETString(uCmd);
                break;
            }
            case 1: {
                sb = this.decodeADIRString(uCmd);
                break;
            }
            case 2: {
                sb = this.decodeLWPRString(uCmd);
                break;
            }
            case 3: {
                sb = this.decodeGDIRString(uCmd);
                break;
            }
            case 4: {
                sb = this.decodeGDIRString(uCmd);
                break;
            }
            case 5: {
                sb = this.decodeMDKSString(uCmd);
                break;
            }
            case 6: {
                sb = this.decodeTXTGString(uCmd);
                break;
            }
            case 7: {
                sb = this.decodeWTXGString(uCmd);
                break;
            }
            case 8: {
                sb = this.decodeOBTGString(uCmd);
            }
        }
        sb.append(" VERSION=");
        sb.append(this.reqType == 4 || this.reqType == 7 ? "A" : "1");
        boolean a = Boolean.getBoolean("adde.auto-upcase");
        boolean b = new Boolean(this.getValue(uCmd, "auto-upcase=", "false"));
        String string2 = cmd = a || b ? sb.toString().toUpperCase() : sb.toString();
        if (this.debug) {
            System.out.println(cmd);
        }
        byte[] ob = cmd.getBytes();
        String testStr = this.getValue(uCmd, "user=", DEFAULT_USER);
        if (this.debug) {
            System.out.println("user = " + testStr);
        }
        byte[] usr = testStr.getBytes();
        int proj = 0;
        testStr = this.getValue(uCmd, "proj=", "0");
        if (this.debug) {
            System.out.println("proj = " + testStr);
        }
        try {
            proj = Integer.parseInt(testStr);
        }
        catch (NumberFormatException e) {
            throw new AddeURLException("Invalid project number: " + testStr);
        }
        if (this.url.getPort() == -1) {
            testStr = this.getValue(uCmd, "port=", null);
            if (testStr != null) {
                try {
                    this.portToUse = Integer.parseInt(testStr);
                }
                catch (NumberFormatException e) {
                    System.out.println("Warning: Invalid port number \"" + testStr + "\" specified;  using default port " + this.portToUse + " instead");
                }
            }
        } else {
            this.portToUse = this.url.getPort();
        }
        if ((testStr = this.getValue(uCmd, "compress=", null)) == null) {
            switch (this.portToUse) {
                case 1: 
                case 500: {
                    testStr = "none";
                    break;
                }
                case 2: 
                case 503: {
                    testStr = "compress";
                    break;
                }
                default: {
                    testStr = "gzip";
                }
            }
        }
        if (testStr.equalsIgnoreCase("gzip")) {
            this.compressionType = 112;
        } else if (testStr.equalsIgnoreCase("compress") || testStr.equalsIgnoreCase("true")) {
            try {
                Class<?> c = Class.forName("HTTPClient.UncompressInputStream");
                this.compressionType = 503;
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("Uncompression code not found, turning compression off");
            }
        } else if (testStr.equalsIgnoreCase("none")) {
            this.compressionType = 500;
        }
        if (this.debug) {
            System.out.println("compression = " + testStr);
        }
        if (this.portToUse < 4) {
            this.portToUse = 112;
        }
        byte[] ipa = new byte[4];
        InetAddress ia = InetAddress.getByName(this.url.getHost());
        ipa = ia.getAddress();
        if (ipa[0] == 127 && ipa[1] == 0 && ipa[2] == 0 && ipa[3] == 1) {
            this.compressionType = 500;
        }
        if (this.debug) {
            System.out.println("connecting on port " + this.portToUse + " using " + (this.compressionType == 112 ? "gzip" : (this.compressionType == 503 ? "compress" : "no")) + " compression.");
        }
        try {
            t = new Socket(this.url.getHost(), this.portToUse);
        }
        catch (UnknownHostException e) {
            throw new AddeURLException(e.toString());
        }
        this.dos = new DataOutputStream(t.getOutputStream());
        this.dos.writeInt(1);
        this.dos.write(ipa, 0, ipa.length);
        this.dos.writeInt(this.compressionType);
        this.dos.write(svc, 0, svc.length);
        this.dos.write(ipa, 0, ipa.length);
        this.dos.writeInt(this.compressionType);
        InetAddress lh = InetAddress.getLocalHost();
        ipa = lh.getAddress();
        this.dos.write(ipa, 0, ipa.length);
        if (usr.length <= 4) {
            this.dos.write(usr, 0, usr.length);
            for (int i2 = 0; i2 < 4 - usr.length; ++i2) {
                this.dos.writeByte(32);
            }
        } else {
            throw new AddeURLException("Invalid user id: " + new String(usr));
        }
        this.dos.writeInt(proj);
        byte[] pwd = new byte[12];
        this.dos.write(pwd, 0, pwd.length);
        this.dos.write(svc, 0, svc.length);
        int numBinaryBytes = 0;
        if (this.binaryData != null) {
            numBinaryBytes = this.binaryData.length;
        }
        if (ob.length > 120) {
            if (this.debug) {
                System.out.println("numBinaryBytes= " + numBinaryBytes);
            }
            this.dos.writeInt(ob.length + numBinaryBytes);
            this.dos.writeInt(ob.length);
            for (i = 0; i < 116; ++i) {
                this.dos.writeByte(0);
            }
            this.dos.write(ob, 0, ob.length);
        } else {
            if (this.debug) {
                System.out.println("numBinaryBytes= " + numBinaryBytes);
            }
            this.dos.writeInt(numBinaryBytes);
            this.dos.write(ob, 0, ob.length);
            for (i = 0; i < 120 - ob.length; ++i) {
                this.dos.writeByte(32);
            }
        }
        if (numBinaryBytes > 0) {
            this.dos.write(this.binaryData, 0, numBinaryBytes);
        }
        this.is = this.compressionType == 112 ? new GZIPInputStream(t.getInputStream()) : (this.compressionType == 503 ? new UncompressInputStream(t.getInputStream()) : t.getInputStream());
        this.dis = new DataInputStream(this.is);
        if (this.debug && this.compressionType != this.portToUse) {
            System.out.println("Compression is turned " + (this.compressionType == 500 ? "OFF" : "ON using " + (this.compressionType == 112 ? "GZIP" : "compress")));
        }
        if (!this.rawStream) {
            this.numBytes = this.dis.readInt();
            if (this.debug) {
                System.out.println("server is sending: " + this.numBytes + " bytes");
            }
            if (this.numBytes == 0) {
                byte[] trailer = new byte[92];
                this.dis.readFully(trailer, 0, trailer.length);
                String errMsg = new String(trailer, 8, 72);
                throw new AddeURLException(errMsg);
            }
        }
        this.connected = true;
    }

    private String getValue(String stringToSearch, String key, String deflt) {
        int startIdx = stringToSearch.toLowerCase().lastIndexOf(key);
        String retVal = deflt;
        if (startIdx >= 0) {
            int endIdx = stringToSearch.indexOf(AMPERSAND, startIdx);
            if (endIdx == -1) {
                endIdx = stringToSearch.length();
            }
            retVal = stringToSearch.substring(startIdx + key.length(), endIdx);
        }
        return retVal;
    }

    public int getRequestType() {
        return this.reqType;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    public synchronized DataInputStream getDataInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.dis;
    }

    public int getInitialRecordSize() {
        return this.numBytes;
    }

    private StringBuffer decodeAGETString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        boolean latFlag = false;
        boolean lonFlag = false;
        boolean linFlag = false;
        boolean eleFlag = false;
        String latString = null;
        String lonString = null;
        String linString = null;
        String eleString = null;
        String tempString = null;
        String testString = null;
        String lctestString = null;
        String groupString = null;
        String descrString = "ALL";
        String posString = "0";
        String numlinString = Integer.toString(480);
        String numeleString = Integer.toString(640);
        String magString = "X";
        String traceString = "TRACE=0";
        String spaceString = "SPAC=X";
        String unitString = "UNIT=BRIT";
        String auxString = "AUX=YES";
        String navString = "NAV=X";
        String calString = "CAL=X";
        String docString = "DOC=NO";
        String timeString = "TIME=X X I";
        String lineleType = "A";
        String placement = "C";
        String trackString = "TRACKING=0";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            int i;
            StringTokenizer tok;
            testString = cmdTokens.nextToken();
            lctestString = testString.toLowerCase();
            if (lctestString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("des")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("pos")) {
                posString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("lat")) {
                latString = testString.substring(testString.indexOf("=") + 1).trim();
                latFlag = true;
                if (latString.indexOf(" ") <= 0) continue;
                tok = new StringTokenizer(latString);
                if (tok.countTokens() < 2) break;
                for (i = 0; i < 2; ++i) {
                    tempString = tok.nextToken();
                    if (i == 0) {
                        latString = tempString;
                        continue;
                    }
                    lonString = this.negateLongitude(tempString);
                    lonFlag = true;
                }
                continue;
            }
            if (lctestString.startsWith("lon")) {
                lonFlag = true;
                lonString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("lin")) {
                tempString = testString.substring(testString.indexOf("=") + 1);
                if (tempString.indexOf(" ") > 0) {
                    tok = new StringTokenizer(tempString);
                    if (tok.countTokens() < 2) break;
                    for (i = 0; i < 2; ++i) {
                        tempString = tok.nextToken();
                        if (i == 0) {
                            linString = tempString;
                            linFlag = true;
                            continue;
                        }
                        eleString = tempString;
                        eleFlag = true;
                    }
                    if (!tok.hasMoreTokens() || !(tempString = tok.nextToken().toLowerCase()).startsWith("i")) continue;
                    lineleType = "i";
                    continue;
                }
                numlinString = tempString;
                continue;
            }
            if (lctestString.startsWith("ele")) {
                numeleString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("pla")) {
                if (!testString.substring(testString.indexOf("=") + 1).toLowerCase().startsWith("u")) continue;
                placement = "u";
                continue;
            }
            if (lctestString.startsWith("mag")) {
                tempString = testString.substring(testString.indexOf("=") + 1);
                if (tempString.indexOf(" ") > 0) {
                    tok = new StringTokenizer(tempString);
                    if (tok.countTokens() < 2) break;
                    for (i = 0; i < 2; ++i) {
                        buf.append(" ");
                        tempString = tok.nextToken();
                        if (i == 0) {
                            buf.append("LMAG=" + tempString);
                            continue;
                        }
                        buf.append("EMAG=" + tempString);
                    }
                    continue;
                }
                magString = tempString;
                continue;
            }
            if (lctestString.startsWith("size")) {
                tempString = testString.substring(testString.indexOf("=") + 1);
                if (tempString.trim().equalsIgnoreCase("all")) {
                    numlinString = "99999";
                    numeleString = "99999";
                    continue;
                }
                if (tempString.indexOf(" ") <= 0) continue;
                tok = new StringTokenizer(tempString);
                if (tok.countTokens() < 2) break;
                for (i = 0; i < 2; ++i) {
                    tempString = tok.nextToken();
                    if (i == 0) {
                        numlinString = tempString;
                        continue;
                    }
                    numeleString = tempString;
                }
                continue;
            }
            if (lctestString.startsWith("trace")) {
                traceString = testString;
                continue;
            }
            if (lctestString.startsWith("spa")) {
                spaceString = testString;
                continue;
            }
            if (lctestString.startsWith("nav")) {
                navString = testString;
                continue;
            }
            if (lctestString.startsWith("aux")) {
                auxString = testString;
                continue;
            }
            if (lctestString.startsWith("track")) {
                trackString = testString;
                continue;
            }
            if (lctestString.startsWith("uni")) {
                unitString = testString;
                continue;
            }
            if (lctestString.startsWith("cal")) {
                calString = testString;
                continue;
            }
            if (lctestString.startsWith("doc")) {
                docString = testString;
                continue;
            }
            if (lctestString.startsWith("tim")) {
                timeString = testString;
                continue;
            }
            if (lctestString.startsWith("ban")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("day")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("id")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("lmag")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (!lctestString.startsWith("emag")) continue;
            buf.append(" ");
            buf.append(testString);
        }
        buf.append(" ");
        buf.append(traceString);
        buf.append(" ");
        buf.append(spaceString);
        buf.append(" ");
        buf.append(unitString);
        buf.append(" ");
        buf.append(navString);
        buf.append(" ");
        buf.append(auxString);
        buf.append(" ");
        buf.append(trackString);
        buf.append(" ");
        buf.append(docString);
        buf.append(" ");
        buf.append(timeString);
        buf.append(" ");
        buf.append(calString);
        StringBuffer posParams = new StringBuffer(groupString + " " + descrString + " " + posString.toUpperCase() + " ");
        String locString = "X X X ";
        if (latFlag && lonFlag) {
            locString = "e" + placement + " " + latString + " " + lonString + " ";
        } else if (linFlag && eleFlag) {
            locString = lineleType + placement + "  " + linString + " " + eleString + " ";
        }
        posParams.append(locString.toUpperCase());
        posParams.append(magString + " " + numlinString + " " + numeleString + " ");
        return new StringBuffer(posParams + buf.toString().toUpperCase());
    }

    private StringBuffer decodeGDIRString(String uCmd) {
        StringBuffer subBuf;
        StringBuffer buf = new StringBuffer();
        String groupString = null;
        String descrString = "ALL";
        String sizeString = " 999999 ";
        String traceString = "TRACE=0";
        String numString = "NUM=1";
        String subsetString = null;
        String latString = null;
        String lonString = null;
        String rowString = null;
        String colString = null;
        Object srcString = null;
        String skip = null;
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            String lctestString = testString.toLowerCase();
            if (lctestString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("des")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("num")) {
                numString = testString;
                continue;
            }
            if (lctestString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (lctestString.startsWith("pos")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("par")) {
                buf.append(" ");
                buf.append("parm=");
                buf.append(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (lctestString.startsWith("fho")) {
                buf.append(" ");
                buf.append("vt=");
                String iHMS = testString.substring(testString.indexOf("=") + 1).trim();
                buf.append(iHMS);
                if (iHMS.length() >= 5) continue;
                buf.append("0000");
                continue;
            }
            if (lctestString.startsWith("day")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("time")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("lev")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("fday")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("ftime")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("vt")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("lat")) {
                latString = this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (lctestString.startsWith("lon")) {
                lonString = this.adjustLongitudes(this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1)));
                continue;
            }
            if (lctestString.startsWith("row")) {
                rowString = this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (lctestString.startsWith("col")) {
                colString = this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (lctestString.startsWith("skip")) {
                skip = this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (lctestString.startsWith("src")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("gpro")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("trang")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("frang")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (!lctestString.startsWith("drang")) continue;
            buf.append(" ");
            buf.append(testString);
        }
        buf.append(" ");
        buf.append(numString);
        buf.append(" ");
        buf.append(traceString);
        buf.append(" ");
        if (latString != null && lonString != null) {
            subBuf = new StringBuffer();
            subBuf.append("subset=");
            subBuf.append(latString);
            subBuf.append(" ");
            subBuf.append(lonString);
            subBuf.append(" ");
            subBuf.append(skip == null ? "1 1" : skip);
            subBuf.append(" LATLON");
            subsetString = subBuf.toString();
            if (this.debug) {
                System.out.println(subsetString);
            }
        } else if (rowString != null && colString != null) {
            subBuf = new StringBuffer();
            subBuf.append("subset=");
            subBuf.append(rowString);
            subBuf.append(" ");
            subBuf.append(colString);
            subBuf.append(" ");
            subBuf.append(skip == null ? "1 1" : skip);
            subBuf.append(" ROWCOL");
            subsetString = subBuf.toString();
            if (this.debug) {
                System.out.println(subsetString);
            }
        } else if (skip != null) {
            subBuf = new StringBuffer();
            subBuf.append("subset=1 99999 1 99999");
            subBuf.append(" ");
            subBuf.append(skip);
            subBuf.append(" ROWCOL");
            subsetString = subBuf.toString();
            if (this.debug) {
                System.out.println(subsetString);
            }
        }
        if (subsetString != null) {
            buf.append(subsetString);
        }
        String posParams = groupString + " " + descrString + " " + sizeString + " ";
        return new StringBuffer(posParams + buf.toString().toUpperCase());
    }

    private StringBuffer decodeADIRString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String groupString = null;
        String descrString = "ALL";
        String posString = "0 0";
        String traceString = "TRACE=0";
        String bandString = "BAND=ALL X";
        String auxString = "AUX=YES";
        String trackString = "TRACKING=0";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            String lctestString = testString.toLowerCase();
            if (lctestString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("des")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("pos")) {
                String tempString = testString.substring(testString.indexOf("=") + 1).toLowerCase();
                if (tempString.equals("")) {
                    posString = "0 0";
                    continue;
                }
                StringTokenizer stp = new StringTokenizer(tempString, " ");
                if (stp.countTokens() == 1) {
                    if (tempString.equals("all")) {
                        posString = "1095519264";
                        continue;
                    }
                    if (tempString.equals("x")) {
                        posString = "X X";
                        continue;
                    }
                    int posval = Integer.parseInt(stp.nextToken().trim());
                    if (posval <= 0) {
                        posString = tempString + " 0";
                        continue;
                    }
                    posString = tempString + " " + tempString;
                    continue;
                }
                posString = tempString;
                continue;
            }
            if (lctestString.startsWith("trace")) {
                traceString = testString;
                continue;
            }
            if (lctestString.startsWith("aux")) {
                auxString = testString;
                continue;
            }
            if (lctestString.startsWith("track")) {
                trackString = testString;
                continue;
            }
            if (lctestString.startsWith("ban")) {
                bandString = testString;
                continue;
            }
            if (lctestString.startsWith("tim")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("day")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (!lctestString.startsWith("id")) continue;
            buf.append(" ");
            buf.append(testString);
        }
        buf.append(" ");
        buf.append(traceString);
        buf.append(" ");
        buf.append(bandString);
        buf.append(" ");
        buf.append(auxString);
        buf.append(" ");
        buf.append(trackString);
        String posParams = groupString + " " + descrString + " " + posString + " ";
        return new StringBuffer(posParams + buf.toString().toUpperCase());
    }

    public StringBuffer decodeTXTGString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String groupString = null;
        String filenameString = null;
        String descrString = null;
        String traceString = "TRACE=0";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            String lctestString = testString.toLowerCase();
            if (lctestString.startsWith("desc")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("file")) {
                filenameString = "FILE=" + testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (!lctestString.startsWith("tra")) continue;
            traceString = testString;
        }
        buf.append(groupString);
        buf.append(" ");
        buf.append(descrString);
        buf.append(" ");
        buf.append(filenameString);
        buf.append(" ");
        buf.append(traceString.toUpperCase());
        return buf;
    }

    public StringBuffer decodeWTXGString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String numString = "NUM=1";
        String dTimeString = "DTIME=96.0000";
        String traceString = "TRACE=0";
        String dayString = "DAY=" + McIDASUtil.mcSecsToDayTime(System.currentTimeMillis() / 1000L)[0];
        String groupString = "RTWXTEXT";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            String lctestString = testString.toLowerCase();
            if (lctestString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("apro")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("astn")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("day")) {
                dayString = testString;
                continue;
            }
            if (lctestString.startsWith("mat")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("prod")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("sour")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("wmo")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("wstn")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (lctestString.startsWith("num")) {
                numString = testString;
                continue;
            }
            if (!lctestString.startsWith("dtim")) continue;
            dTimeString = testString;
        }
        buf.append(" ");
        buf.append(dayString);
        buf.append(" ");
        buf.append(dTimeString);
        buf.append(" ");
        buf.append(numString);
        buf.append(" ");
        buf.append(traceString);
        String posParams = groupString + " ";
        return new StringBuffer(posParams + buf.toString().toUpperCase());
    }

    public StringBuffer decodeOBTGString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String numString = "NUM=1";
        String traceString = "TRACE=0";
        String groupString = "RTWXTEXT";
        String descrString = "SFCHOURLY";
        String idreqString = "IDREQ=LIST";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            String lctestString = testString.toLowerCase();
            if (lctestString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("desc")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("id")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("co")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("reg")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("nhou")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("new")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("old")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("type")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (lctestString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (!lctestString.startsWith("num")) continue;
            numString = testString;
        }
        buf.append(" ");
        buf.append(numString);
        buf.append(" ");
        buf.append(traceString);
        String posParams = groupString + " " + descrString + " " + idreqString;
        return new StringBuffer(posParams + buf.toString().toUpperCase());
    }

    public StringBuffer decodeLWPRString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String groupString = null;
        String typeString = "ALA.";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            String lctestString = testString.toLowerCase();
            if (lctestString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
            }
            if (!lctestString.startsWith("type")) continue;
            String tempString = testString.substring(testString.indexOf("=") + 1).toLowerCase();
            if (tempString.startsWith("i")) {
                typeString = "ALA.";
            }
            if (tempString.startsWith("g")) {
                typeString = "ALG.";
                continue;
            }
            if (tempString.startsWith("p")) {
                typeString = "ALM.";
                continue;
            }
            if (tempString.startsWith("t")) {
                typeString = "ALT.";
                continue;
            }
            if (tempString.startsWith("n")) {
                typeString = "ALN.";
                continue;
            }
            if (!tempString.startsWith("s")) continue;
            typeString = "ALN.";
        }
        buf.append(typeString);
        buf.append(groupString);
        return buf;
    }

    private StringBuffer decodeMDKSString(String uCmd) {
        String testString = null;
        String lctestString = null;
        String groupString = null;
        String descrString = null;
        String maxString = "MAX=1";
        String numString = "";
        String posString = "POS=0";
        String traceString = "TRACE=0";
        String selectString = "";
        String parmString = "";
        String justTheParametersString = "";
        String justTheSelectString = "";
        String sBinaryData = "";
        boolean posInDescriptor = false;
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            testString = cmdTokens.nextToken();
            lctestString = testString.toLowerCase();
            if (lctestString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("des")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                int pos = descrString.indexOf(".");
                if (pos < 0) continue;
                posString = "POS=" + descrString.substring(pos + 1);
                descrString = descrString.substring(0, pos);
                posInDescriptor = true;
                continue;
            }
            if (lctestString.startsWith("par")) {
                justTheParametersString = testString.substring(testString.indexOf("=") + 1);
                parmString = "PARM=" + justTheParametersString;
                if (this.debug) {
                    System.out.println("paramString = " + parmString);
                }
                sBinaryData = new String(this.decodePARAMString(justTheParametersString));
                sBinaryData = sBinaryData.toUpperCase();
                this.binaryData = sBinaryData.getBytes();
                continue;
            }
            if (lctestString.startsWith("select")) {
                justTheSelectString = testString.substring(testString.indexOf("=") + 1);
                selectString = "SELECT=" + new String(this.decodeSELECTString(justTheSelectString));
                if (!this.debug) continue;
                System.out.println("Server selectString = " + selectString);
                continue;
            }
            if (lctestString.startsWith("num")) {
                maxString = "MAX=" + testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (lctestString.startsWith("max")) {
                maxString = testString;
                continue;
            }
            if (lctestString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (!lctestString.startsWith("pos") || posInDescriptor) continue;
            posString = testString;
        }
        if (maxString.trim().equalsIgnoreCase("max=all")) {
            maxString = "MAX=99999";
        }
        StringBuffer posParams = new StringBuffer();
        posParams.append(groupString);
        posParams.append(" ");
        posParams.append(descrString);
        posParams.append(" ");
        posParams.append(parmString.toUpperCase());
        posParams.append(" ");
        posParams.append(selectString.toUpperCase());
        posParams.append(" ");
        posParams.append(posString.toUpperCase());
        posParams.append(" ");
        posParams.append(traceString.toUpperCase());
        posParams.append(" ");
        posParams.append(maxString.toUpperCase());
        if (this.debug) {
            System.out.println("String passed to server = " + posParams);
            Exception ett = new Exception("ett");
            ett.printStackTrace();
        }
        return posParams;
    }

    private String decodePARAMString(String justTheParametersString) {
        String testString = null;
        String thisParam = null;
        String thisUnit = null;
        StringBuffer buf = new StringBuffer();
        StringTokenizer paramTokens = new StringTokenizer(justTheParametersString, " ");
        while (paramTokens.hasMoreTokens()) {
            testString = paramTokens.nextToken().trim();
            StringTokenizer thisParamToken = new StringTokenizer(testString, "[]");
            thisParam = new String(thisParamToken.nextToken().trim());
            buf.append(thisParam);
            for (int i = thisParam.length(); i < 4; ++i) {
                buf.append(" ");
            }
            if (!thisParamToken.hasMoreTokens()) continue;
            thisUnit = thisParamToken.nextToken().trim();
            if (!this.debug) continue;
            System.out.println("This Unit = " + thisUnit);
        }
        return buf.toString();
    }

    private String decodeSELECTString(String justTheSelectString) {
        Object testString = null;
        String entireSelectString = null;
        String thisSelect = null;
        String thisUnit = null;
        StringBuffer buf = new StringBuffer();
        StringTokenizer entireSelectToken = new StringTokenizer(justTheSelectString, "'");
        entireSelectString = entireSelectToken.nextToken().trim();
        StringTokenizer selectTokens = new StringTokenizer(entireSelectString, ";");
        while (selectTokens.hasMoreTokens()) {
            thisSelect = selectTokens.nextToken().trim();
            if (this.debug) {
                System.out.println(" this Select = " + thisSelect);
            }
            StringTokenizer thisSelectToken = new StringTokenizer(thisSelect, " ");
            int tokenCount = thisSelectToken.countTokens();
            thisSelect = new String(thisSelectToken.nextToken());
            if (this.debug) {
                System.out.println("this Select = " + thisSelect);
            }
            if (thisSelect.indexOf("[") > 0) {
                StringTokenizer thisUnitToken = new StringTokenizer(thisSelect, "[]");
                if (thisUnitToken.hasMoreTokens()) {
                    thisSelect = new String(thisUnitToken.nextToken().trim());
                    buf.append("'" + thisSelect);
                    if (thisUnitToken.hasMoreTokens()) {
                        thisUnit = new String(thisUnitToken.nextToken().trim());
                    }
                }
            } else {
                buf.append("'" + thisSelect);
            }
            if (thisSelectToken.hasMoreTokens()) {
                thisSelect = thisSelectToken.nextToken();
                if (this.debug) {
                    System.out.println("this Select = " + thisSelect);
                }
                buf.append(" " + thisSelect);
            }
            if (thisSelectToken.hasMoreTokens()) {
                thisSelect = thisSelectToken.nextToken();
                buf.append(" TO " + thisSelect);
                if (this.debug) {
                    System.out.println("this Select = " + thisSelect);
                }
            }
            if (thisUnit != null) {
                buf.append(" " + thisUnit);
                thisUnit = null;
            }
            buf.append("' ");
        }
        return buf.toString();
    }

    private String ensureTwoValues(String s) {
        String retVal = null;
        if (s.trim().indexOf(" ") > 0) {
            StringTokenizer tok = new StringTokenizer(s);
            if (tok.countTokens() == 2) {
                retVal = s;
            }
        } else {
            retVal = s + " " + s;
        }
        return retVal;
    }

    private String adjustLongitudes(String input) {
        input = input.trim();
        String lon1 = this.negateLongitude(input.substring(0, input.trim().indexOf(" ")).trim());
        String lon2 = this.negateLongitude(input.substring(input.trim().indexOf(" ")).trim());
        return lon2 + " " + lon1;
    }

    private String negateLongitude(String eastLong) {
        if (eastLong.indexOf("-") >= 0) {
            return eastLong.substring(eastLong.indexOf("-") + 1);
        }
        return "-" + eastLong;
    }

    private URL normalizeURL(URL url) {
        int pos;
        int i;
        String x;
        try {
            x = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        boolean ok = true;
        for (i = 0; i < replaceString.length; ++i) {
            pos = x.indexOf(replaceString[i]);
            ok &= pos < 0;
        }
        if (!ok) {
            for (i = 0; i < replaceString.length; ++i) {
                pos = -1;
                while ((pos = x.indexOf(replaceString[i])) >= 0) {
                    if (this.debug) {
                        System.out.println("found " + replaceString[i] + " at " + pos);
                    }
                    StringBuffer buf = new StringBuffer(x);
                    buf.replace(pos, pos + replaceString[i].length(), replaceWith[i]);
                    x = buf.toString();
                }
            }
        }
        if (this.debug) {
            System.out.println("normalized url = " + x);
        }
        try {
            return new URL(x);
        }
        catch (Exception e) {
            return url;
        }
    }
}

