/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.grib.GribPds;
import ucar.grib.NoValidGribException;
import ucar.grib.grib1.Grib1Dump;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Record;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GDSVariables;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.Grib2Tables;
import ucar.grib.grib2.ParameterTable;
import ucar.ma2.DataType;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.WmoTemplateTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.Misc;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribOldRawPanel
extends JPanel {
    private static final KMPMatch matcher = new KMPMatch("GRIB".getBytes());
    private PreferencesExt prefs;
    private BeanTableSorted gds2Table;
    private BeanTableSorted param2BeanTable;
    private BeanTableSorted record2BeanTable;
    private BeanTableSorted gds1Table;
    private BeanTableSorted param1BeanTable;
    private BeanTableSorted record1BeanTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane infoPopup3;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private IndependentWindow infoWindow3;
    private FileManager fileChooser;
    private RandomAccessFile raf = null;
    private Map<String, WmoTemplateTable> productTemplates = null;
    private DateFormatter df = new DateFormatter();
    Grib2Customizer tables = null;

    public GribOldRawPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.param2BeanTable = new BeanTableSorted(Grib2ParameterBean.class, (PreferencesExt)prefs.node("Param2Bean"), false, "Grib2PDSVariables", "from Grib2Input.getRecords()");
        this.param2BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)GribOldRawPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    GribOldRawPanel.this.record2BeanTable.setBeans(pb.getRecordBeans());
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.param2BeanTable.getJTable(), "Options");
        varPopup.addAction("Show raw PDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)GribOldRawPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    GribOldRawPanel.this.infoPopup2.setText(pb.toString());
                    GribOldRawPanel.this.infoPopup2.gotoTop();
                    GribOldRawPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show processed PDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)GribOldRawPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    GribOldRawPanel.this.infoPopup3.setText(pb.toProcessedString());
                    GribOldRawPanel.this.infoPopup3.gotoTop();
                    GribOldRawPanel.this.infoWindow3.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Run accum algorithm", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)GribOldRawPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    GribOldRawPanel.this.infoPopup3.gotoTop();
                    GribOldRawPanel.this.infoWindow3.showIfNotIconified();
                }
            }
        });
        this.record2BeanTable = new BeanTableSorted(Grib2RecordBean.class, (PreferencesExt)prefs.node("Record2Bean"), false, "Grib2Record", "from Grib2Input.getRecords()");
        varPopup = new PopupMenu(this.record2BeanTable.getJTable(), "Options");
        varPopup.addAction("Compare GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribOldRawPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2RecordBean bean1 = (Grib2RecordBean)list.get(0);
                    Grib2RecordBean bean2 = (Grib2RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    GribOldRawPanel.this.compare(bean1, bean2, f);
                    GribOldRawPanel.this.infoPopup2.setText(f.toString());
                    GribOldRawPanel.this.infoPopup2.gotoTop();
                    GribOldRawPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show raw PDS bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                List list = GribOldRawPanel.this.record2BeanTable.getSelectedBeans();
                for (int i = 0; i < list.size(); ++i) {
                    Grib2RecordBean bean = (Grib2RecordBean)list.get(i);
                    bean.toRawPdsString(f);
                }
                GribOldRawPanel.this.infoPopup.setText(f.toString());
                GribOldRawPanel.this.infoPopup.gotoTop();
                GribOldRawPanel.this.infoWindow.showIfNotIconified();
            }
        });
        varPopup.addAction("Show complete GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)GribOldRawPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    GribOldRawPanel.this.infoPopup.setText(bean.showComplete());
                    GribOldRawPanel.this.infoPopup.gotoTop();
                    GribOldRawPanel.this.infoWindow.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show Processed GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)GribOldRawPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    GribOldRawPanel.this.infoPopup2.setText(bean.toProcessedString());
                    GribOldRawPanel.this.infoPopup2.gotoTop();
                    GribOldRawPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Compare Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribOldRawPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2RecordBean bean1 = (Grib2RecordBean)list.get(0);
                    Grib2RecordBean bean2 = (Grib2RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    GribOldRawPanel.this.compareData(bean1, bean2, f);
                    GribOldRawPanel.this.infoPopup2.setText(f.toString());
                    GribOldRawPanel.this.infoPopup2.gotoTop();
                    GribOldRawPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Save GribRecord to File", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribOldRawPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() > 0) {
                    GribOldRawPanel.this.writeToFile(list);
                }
            }
        });
        this.gds2Table = new BeanTableSorted(Gds2Bean.class, (PreferencesExt)prefs.node("Gds2Bean"), false, "Grib2GridDefinitionSection", "unique from Grib2Records");
        varPopup = new PopupMenu(this.gds2Table.getJTable(), "Options");
        varPopup.addAction("Show processed GDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gds2Bean bean = (Gds2Bean)GribOldRawPanel.this.gds2Table.getSelectedBean();
                GribOldRawPanel.this.infoPopup.setText(bean.gds.toString());
                GribOldRawPanel.this.infoWindow.setVisible(true);
            }
        });
        varPopup.addAction("Compare GDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribOldRawPanel.this.gds2Table.getSelectedBeans();
                if (list.size() == 2) {
                    Gds2Bean bean1 = (Gds2Bean)list.get(0);
                    Gds2Bean bean2 = (Gds2Bean)list.get(1);
                    Formatter f = new Formatter();
                    GribOldRawPanel.this.compare(bean1.gds, bean2.gds, f);
                    GribOldRawPanel.this.infoPopup2.setText(f.toString());
                    GribOldRawPanel.this.infoPopup2.gotoTop();
                    GribOldRawPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show Products that use GDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gds2Bean bean = (Gds2Bean)GribOldRawPanel.this.gds2Table.getSelectedBean();
                Formatter f = new Formatter();
                for (Object o : GribOldRawPanel.this.param2BeanTable.getBeans()) {
                    Grib2ParameterBean p = (Grib2ParameterBean)o;
                    if (p.gdsKey != bean.getKey()) continue;
                    f.format(" %s%n", p.getName());
                }
                GribOldRawPanel.this.infoPopup2.setText(f.toString());
                GribOldRawPanel.this.infoWindow.setVisible(true);
            }
        });
        this.param1BeanTable = new BeanTableSorted(Grib1ParameterBean.class, (PreferencesExt)prefs.node("Param1Bean"), false, "Grib1PDSVariables", "from Grib1Input.getRecords()");
        this.param1BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Grib1ParameterBean pb = (Grib1ParameterBean)GribOldRawPanel.this.param1BeanTable.getSelectedBean();
                if (pb != null) {
                    GribOldRawPanel.this.record1BeanTable.setBeans(pb.getRecordBeans());
                }
            }
        });
        varPopup = new PopupMenu(this.param1BeanTable.getJTable(), "Options");
        varPopup.addAction("Show raw PDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1ParameterBean pb = (Grib1ParameterBean)GribOldRawPanel.this.param1BeanTable.getSelectedBean();
                if (pb != null) {
                    GribOldRawPanel.this.infoPopup2.setText(pb.toRawString());
                    GribOldRawPanel.this.infoPopup2.gotoTop();
                    GribOldRawPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show processed PDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1ParameterBean pb = (Grib1ParameterBean)GribOldRawPanel.this.param1BeanTable.getSelectedBean();
                if (pb != null) {
                    GribOldRawPanel.this.infoPopup3.setText(pb.toProcessedString());
                    GribOldRawPanel.this.infoPopup3.gotoTop();
                    GribOldRawPanel.this.infoWindow3.showIfNotIconified();
                }
            }
        });
        this.record1BeanTable = new BeanTableSorted(Grib1RecordBean.class, (PreferencesExt)prefs.node("Record1Bean"), false, "Grib1Record", "from Grib1Input.getRecords()");
        varPopup = new PopupMenu(this.record1BeanTable.getJTable(), "Options");
        varPopup.addAction("Show raw PDS bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)GribOldRawPanel.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    GribOldRawPanel.this.infoPopup.setText(bean.toRawString());
                    GribOldRawPanel.this.infoPopup.gotoTop();
                    GribOldRawPanel.this.infoWindow.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show Raw GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)GribOldRawPanel.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    GribOldRawPanel.this.infoPopup.setText(bean.toRawString());
                    GribOldRawPanel.this.infoPopup.gotoTop();
                    GribOldRawPanel.this.infoWindow.showIfNotIconified();
                }
            }
        });
        varPopup.addAction("Show Processed Grib1Record", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)GribOldRawPanel.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    GribOldRawPanel.this.infoPopup2.setText(bean.toProcessedString());
                    GribOldRawPanel.this.infoPopup2.gotoTop();
                    GribOldRawPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        this.gds1Table = new BeanTableSorted(Gds1Bean.class, (PreferencesExt)prefs.node("Gds1Bean"), false, "Grib1GridDefinitionSection", "unique from Grib1Records");
        varPopup = new PopupMenu(this.gds1Table.getJTable(), "Options");
        varPopup.addAction("Show GDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(os);
                List list = GribOldRawPanel.this.gds1Table.getSelectedBeans();
                for (Object bo : list) {
                    Gds1Bean bean = (Gds1Bean)bo;
                    Grib1Dump.printGDS(bean.gds, null, ps);
                    ps.append("\n");
                }
                GribOldRawPanel.this.infoPopup.setText(os.toString());
                GribOldRawPanel.this.infoWindow.setVisible(true);
            }
        });
        varPopup.addAction("Compare GDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribOldRawPanel.this.gds1Table.getSelectedBeans();
                if (list.size() == 2) {
                    Gds1Bean bean1 = (Gds1Bean)list.get(0);
                    Gds1Bean bean2 = (Gds1Bean)list.get(1);
                    Formatter f = new Formatter();
                    GribOldRawPanel.this.compare(bean1.gds, bean2.gds, f);
                    GribOldRawPanel.this.infoPopup2.setText(f.toString());
                    GribOldRawPanel.this.infoPopup2.gotoTop();
                    GribOldRawPanel.this.infoWindow2.showIfNotIconified();
                }
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", new Rectangle(300, 300, 500, 300)));
        this.infoPopup3 = new TextHistoryPane();
        this.infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup3);
        this.infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
    }

    public void checkProblems(Formatter f) {
        this.checkRuntimes(f);
    }

    private void checkRuntimes(Formatter f) {
        HashMap<Date, DateCount> runs = new HashMap<Date, DateCount>();
        List params = this.param2BeanTable.getBeans();
        for (Grib2ParameterBean pb : params) {
            List<Grib2RecordBean> records = pb.getRecordBeans();
            for (Grib2RecordBean record : records) {
                Date d = record.getBaseTime();
                DateCount dc = (DateCount)runs.get(d);
                if (dc == null) {
                    dc = new DateCount(d);
                    runs.put(d, dc);
                }
                ++dc.count;
            }
        }
        ArrayList dcList = new ArrayList(runs.values());
        Collections.sort(dcList);
        f.format("Run Dates%n", new Object[0]);
        for (DateCount dc : dcList) {
            f.format(" %s == %d%n", this.df.toDateTimeStringISO(dc.d), dc.count);
        }
    }

    private void checkDuplicates(Formatter f) {
        HashMap<Date, DateCount> runs = new HashMap<Date, DateCount>();
        List params = this.param2BeanTable.getBeans();
        for (Grib2ParameterBean pb : params) {
            List<Grib2RecordBean> records = pb.getRecordBeans();
            for (Grib2RecordBean record : records) {
                Date d = record.getBaseTime();
                DateCount dc = (DateCount)runs.get(d);
                if (dc == null) {
                    dc = new DateCount(d);
                    runs.put(d, dc);
                }
                ++dc.count;
            }
        }
        ArrayList dcList = new ArrayList(runs.values());
        Collections.sort(dcList);
        f.format("Run Dates%n", new Object[0]);
        for (DateCount dc : dcList) {
            f.format(" %s == %d%n", this.df.toDateTimeStringISO(dc.d), dc.count);
        }
    }

    public void save() {
        this.gds2Table.saveState(false);
        this.param2BeanTable.saveState(false);
        this.record2BeanTable.saveState(false);
        this.gds1Table.saveState(false);
        this.param1BeanTable.saveState(false);
        this.record1BeanTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", this.infoWindow2.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds3", this.infoWindow3.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    private void writeToFile(List<Grib2RecordBean> beans) {
        Grib2RecordBean first = beans.get(0);
        try {
            String filename;
            String defloc;
            String firstHeader = first.gr.getHeader();
            if (firstHeader != null) {
                firstHeader = firstHeader.split(" ")[0];
            }
            if (firstHeader == null) {
                defloc = this.raf.getLocation() == null ? "." : this.raf.getLocation();
                int pos = defloc.lastIndexOf(".");
                if (pos > 0) {
                    defloc = defloc.substring(0, pos);
                }
            } else {
                defloc = firstHeader;
            }
            if (this.fileChooser == null) {
                this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
            }
            if ((filename = this.fileChooser.chooseFilenameToSave(defloc + ".grib2")) == null) {
                return;
            }
            File file = new File(filename);
            FileOutputStream fos = new FileOutputStream(file);
            for (Grib2RecordBean bean : beans) {
                Grib2IndicatorSection is = bean.gr.getIs();
                if (is.getStartPos() < 0L) continue;
                int size = (int)(is.getEndPos() - is.getStartPos());
                byte[] rb = new byte[size];
                this.raf.seek(is.getStartPos());
                this.raf.readFully(rb);
                String header = bean.gr.getHeader();
                if (header != null && !header.contains("GRIB")) {
                    fos.write(bean.gr.getHeader().getBytes());
                }
                fos.write(rb);
            }
            fos.close();
            JOptionPane.showMessageDialog(this, filename + " successfully written");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void compare(Grib2RecordBean bean1, Grib2RecordBean bean2, Formatter f) {
        Grib2IndicatorSection is1 = bean1.gr.getIs();
        Grib2IndicatorSection is2 = bean2.gr.getIs();
        f.format("Indicator Section%n", new Object[0]);
        if (is1.getGribEdition() != is2.getGribEdition()) {
            f.format("getGribEdition differs %d != %d %n", is1.getGribEdition(), is2.getGribEdition());
        }
        if (is1.getDiscipline() != is2.getDiscipline()) {
            f.format("getDiscipline differs %d != %d %n", is1.getDiscipline(), is2.getDiscipline());
        }
        if (is1.getGribLength() != is2.getGribLength()) {
            f.format("getGribLength differs %d != %d %n", is1.getGribLength(), is2.getGribLength());
        }
        f.format("%nId Section%n", new Object[0]);
        Grib2IdentificationSection id1 = bean1.id;
        Grib2IdentificationSection id2 = bean2.id;
        if (id1.getCenter_id() != id2.getCenter_id()) {
            f.format("Center_id differs %d != %d %n", id1.getCenter_id(), id2.getCenter_id());
        }
        if (id1.getSubcenter_id() != id2.getSubcenter_id()) {
            f.format("Subcenter_id differs %d != %d %n", id1.getSubcenter_id(), id2.getSubcenter_id());
        }
        if (id1.getMaster_table_version() != id2.getMaster_table_version()) {
            f.format("Master_table_version differs %d != %d %n", id1.getMaster_table_version(), id2.getMaster_table_version());
        }
        if (id1.getLocal_table_version() != id2.getLocal_table_version()) {
            f.format("Local_table_version differs %d != %d %n", id1.getLocal_table_version(), id2.getLocal_table_version());
        }
        if (id1.getProductStatus() != id2.getProductStatus()) {
            f.format("ProductStatus differs %d != %d %n", id1.getProductStatus(), id2.getProductStatus());
        }
        if (id1.getProductType() != id2.getProductType()) {
            f.format("ProductType differs %d != %d %n", id1.getProductType(), id2.getProductType());
        }
        if (id1.getRefTime() != id2.getRefTime()) {
            f.format("refTime differs %d != %d %n", id1.getRefTime(), id2.getRefTime());
        }
        if (id1.getSignificanceOfRT() != id2.getSignificanceOfRT()) {
            f.format("getSignificanceOfRT differs %d != %d %n", id1.getSignificanceOfRT(), id2.getSignificanceOfRT());
        }
        byte[] lus1 = bean1.gr.getLocalUseSection();
        byte[] lus2 = bean2.gr.getLocalUseSection();
        if (lus1 == null || lus2 == null) {
            if (lus1 == lus2) {
                f.format("%nLus are both null%n", new Object[0]);
            } else {
                f.format("%nLus are different %s != %s %n", lus1, lus2);
            }
        } else {
            f.format("%nCompare LocalUseSection%n", new Object[0]);
            Misc.compare(lus1, lus2, f);
        }
        this.compare(bean1.pdsv, bean2.pdsv, f);
        this.compare(bean1.gds, bean2.gds, f);
    }

    private void compare(Grib2GridDefinitionSection gds1, Grib2GridDefinitionSection gds2, Formatter f) {
        Grib2GDSVariables gdsv1 = gds1.getGdsVars();
        Grib2GDSVariables gdsv2 = gds2.getGdsVars();
        f.format("%nCompare Gds%n", new Object[0]);
        byte[] raw1 = gdsv1.getGDSBytes();
        byte[] raw2 = gdsv2.getGDSBytes();
        Misc.compare(raw1, raw2, f);
    }

    private void compare(Grib1GridDefinitionSection gds1, Grib1GridDefinitionSection gds2, Formatter f) {
        Grib1GDSVariables gdsv1 = gds1.getGdsVars();
        Grib1GDSVariables gdsv2 = gds2.getGdsVars();
        f.format("%nCompare Gds%n", new Object[0]);
        byte[] raw1 = gdsv1.getGDSBytes();
        byte[] raw2 = gdsv2.getGDSBytes();
        Misc.compare(raw1, raw2, f);
    }

    private void compare(GribPds pds1, GribPds pds2, Formatter f) {
        f.format("%nCompare Pds%n", new Object[0]);
        byte[] raw1 = pds1.getPDSBytes();
        byte[] raw2 = pds2.getPDSBytes();
        Misc.compare(raw1, raw2, f);
    }

    void compareData(Grib2RecordBean bean1, Grib2RecordBean bean2, Formatter f) {
        float[] data1 = null;
        float[] data2 = null;
        try {
            Grib2Data g2read = new Grib2Data(this.raf);
            data1 = g2read.getData(bean1.gr.getGdsOffset(), bean1.gr.getPdsOffset(), bean1.id.getRefTime());
            data2 = g2read.getData(bean2.gr.getGdsOffset(), bean2.gr.getPdsOffset(), bean2.id.getRefTime());
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        Misc.compare(data1, data2, f);
    }

    public void setGribFile(RandomAccessFile raf) throws Exception {
        this.raf = raf;
        raf.seek(0L);
        raf.order(0);
        if (!raf.searchForward(matcher, 8000)) {
            return;
        }
        raf.skipBytes(4);
        Grib2IndicatorSection is = new Grib2IndicatorSection(raf);
        int edition = is.getGribEdition();
        if (edition == 1) {
            this.setGribFile1(raf);
        } else if (edition == 2) {
            this.setGribFile2(raf);
        }
    }

    void setGribFile1(RandomAccessFile raf) throws IOException, NoValidGribException {
        this.split2 = new JSplitPane(0, false, this.param1BeanTable, this.record1BeanTable);
        this.split2.setDividerLocation(this.prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, this.gds1Table);
        this.split.setDividerLocation(this.prefs.getInt("splitPos", 500));
        this.removeAll();
        this.add((Component)this.split, "Center");
        this.revalidate();
        HashMap<Integer, Grib1GridDefinitionSection> gdsSet = new HashMap<Integer, Grib1GridDefinitionSection>();
        HashMap<Integer, Grib1ParameterBean> pdsSet = new HashMap<Integer, Grib1ParameterBean>();
        Grib1Input reader = new Grib1Input(raf);
        raf.seek(0L);
        reader.scan(false, false);
        ArrayList<Grib1ParameterBean> products = new ArrayList<Grib1ParameterBean>();
        for (Grib1Record gr : reader.getRecords()) {
            Grib1Pds pds = gr.getPDS().getPdsVars();
            Grib1ParameterBean bean = (Grib1ParameterBean)pdsSet.get(this.makeUniqueId(pds));
            if (bean == null) {
                bean = new Grib1ParameterBean(gr);
                pdsSet.put(this.makeUniqueId(pds), bean);
                products.add(bean);
            }
            bean.addRecord(gr);
            Grib1GridDefinitionSection gds = gr.getGDS();
            gdsSet.put(gds.getGdsKey(), gds);
        }
        this.param1BeanTable.setBeans(products);
        this.record1BeanTable.setBeans(new ArrayList());
        System.out.printf("GribRawPanel products = %d records = %d%n", products.size(), reader.getRecords().size());
        ArrayList<Gds1Bean> gdsList = new ArrayList<Gds1Bean>();
        for (Grib1GridDefinitionSection gds : gdsSet.values()) {
            gdsList.add(new Gds1Bean(gds.getGdsKey(), gds));
        }
        this.gds1Table.setBeans(gdsList);
    }

    public int makeUniqueId(Grib1Pds pds) {
        int result = 17;
        result += result * 37 + pds.getParameterNumber();
        result *= result * 37 + pds.getLevelType1();
        if (pds.isEnsemble()) {
            result *= result * 37 + 1;
        }
        return result;
    }

    void setGribFile2(RandomAccessFile raf) throws IOException {
        this.split2 = new JSplitPane(0, false, this.param2BeanTable, this.record2BeanTable);
        this.split2.setDividerLocation(this.prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, this.gds2Table);
        this.split.setDividerLocation(this.prefs.getInt("splitPos", 500));
        this.removeAll();
        this.add((Component)this.split, "Center");
        this.revalidate();
        HashMap<Integer, Grib2GridDefinitionSection> gdsSet = new HashMap<Integer, Grib2GridDefinitionSection>();
        HashMap<Integer, Grib2ParameterBean> pdsSet = new HashMap<Integer, Grib2ParameterBean>();
        Grib2Input reader = new Grib2Input(raf);
        raf.seek(0L);
        raf.order(0);
        reader.scan(false, false);
        boolean first = true;
        ArrayList<Grib2ParameterBean> products = new ArrayList<Grib2ParameterBean>();
        for (Grib2Record gr : reader.getRecords()) {
            Grib2ProductDefinitionSection pds = gr.getPDS();
            int discipline = gr.getIs().getDiscipline();
            Grib2ParameterBean bean = (Grib2ParameterBean)pdsSet.get(this.makeUniqueId(pds.getPdsVars(), discipline));
            if (bean == null) {
                bean = new Grib2ParameterBean(gr);
                pdsSet.put(this.makeUniqueId(pds.getPdsVars(), discipline), bean);
                products.add(bean);
            }
            bean.addRecord(gr);
            Grib2GridDefinitionSection gds = gr.getGDS();
            gdsSet.put(gds.getGdsKey(), gds);
            if (!first) continue;
            Grib2IdentificationSection ids = gr.getId();
            this.tables = Grib2Customizer.factory(ids.getCenter_id(), ids.getSubcenter_id(), ids.getMaster_table_version(), ids.getLocal_table_version());
            first = false;
        }
        this.param2BeanTable.setBeans(products);
        this.record2BeanTable.setBeans(new ArrayList());
        System.out.printf("GribRawPanel products = %d records = %d%n", products.size(), reader.getRecords().size());
        ArrayList<Gds2Bean> gdsList = new ArrayList<Gds2Bean>();
        for (Grib2GridDefinitionSection gds : gdsSet.values()) {
            gdsList.add(new Gds2Bean(gds));
        }
        this.gds2Table.setBeans(gdsList);
    }

    public int makeUniqueId(Grib2Pds pds, int discipline) {
        int result = 17;
        result += result * 37 + pds.getProductDefinitionTemplate();
        result += result * 37 + discipline;
        result += result * 37 + pds.getParameterCategory();
        result += result * 37 + pds.getParameterNumber();
        result *= result * 37 + pds.getLevelType1();
        result *= result * 37 + pds.getLevelType2();
        return result;
    }

    private void showRawPds(Grib1Pds pds, Formatter f) {
        byte[] raw = pds.getPDSBytes();
        f.format("%n", new Object[0]);
        for (int i = 0; i < raw.length; ++i) {
            f.format(" %3d : %3d%n", i + 1, raw[i]);
        }
    }

    private void showRawPds(String key, byte[] raw, Formatter f) {
        WmoTemplateTable gt;
        if (this.productTemplates == null) {
            try {
                this.productTemplates = WmoTemplateTable.getWmoStandard().map;
            }
            catch (IOException e) {
                f.format("Read template failed = %s%n", e.getMessage());
                return;
            }
        }
        if ((gt = this.productTemplates.get(key)) == null) {
            f.format("Cant find template %s%n", key);
        } else {
            gt.showInfo(this.tables, raw, f);
        }
    }

    private void showRawGds(Grib2GridDefinitionSection gds, Formatter f) {
        Grib2GDSVariables gdsv = gds.getGdsVars();
        int template = gdsv.getGdtn();
        byte[] raw = gdsv.getGDSBytes();
        this.showRawPds("3." + template, raw, f);
    }

    private void showRawPds(Grib2ProductDefinitionSection pds, Formatter f) {
        Grib2Pds pdsv = pds.getPdsVars();
        int template = pdsv.getProductDefinitionTemplate();
        byte[] raw = pdsv.getPDSBytes();
        this.showRawPds("4." + template, raw, f);
    }

    private void showProcessedPds(Grib2Pds pds, int discipline, Formatter f) {
        int template = pds.getProductDefinitionTemplate();
        f.format(" Product Template = %3d %s%n", template, Grib2Tables.codeTable4_0(template));
        f.format(" Parameter Category = %3d %s%n", pds.getParameterCategory(), ParameterTable.getCategoryName(discipline, pds.getParameterCategory()));
        f.format(" Parameter Name     = %3d %s %n", pds.getParameterNumber(), ParameterTable.getParameterName(discipline, pds.getParameterCategory(), pds.getParameterNumber()));
        f.format(" Parameter Units    = %s %n", ParameterTable.getParameterUnit(discipline, pds.getParameterCategory(), pds.getParameterNumber()));
        int tgp = pds.getGenProcessType();
        f.format(" Generating Process Type = %3d %s %n", tgp, Grib2Tables.codeTable4_3(tgp));
        f.format(" Forecast Offset    = %3d %n", pds.getForecastTime());
        f.format(" First Surface Type = %3d %s %n", pds.getLevelType1(), Grib2Tables.codeTable4_5(pds.getLevelType1()));
        f.format(" First Surface value= %3f %n", pds.getLevelValue1());
        f.format(" Second Surface Type= %3d %s %n", pds.getLevelType2(), Grib2Tables.codeTable4_5(pds.getLevelType2()));
        f.format(" Second Surface val = %3f %n", pds.getLevelValue2());
    }

    public class Grib1RecordBean {
        Grib1Record gr;
        Grib1GridDefinitionSection gds;
        Grib1ProductDefinitionSection pds;
        Grib1Pds pdsv;
        int[] interval;

        public Grib1RecordBean() {
        }

        public Grib1RecordBean(Grib1Record m) {
            this.gr = m;
            this.gds = this.gr.getGDS();
            this.pds = this.gr.getPDS();
            this.pdsv = this.pds.getPdsVars();
            this.interval = this.pdsv.getForecastTimeInterval();
            if (this.interval == null) {
                this.interval = new int[]{0, 0};
            }
        }

        public String getHeader() {
            return this.gr.getHeader();
        }

        public final String getTimeUnit() {
            int unit = this.pdsv.getTimeUnit();
            return Grib2Tables.codeTable4_4(unit);
        }

        public final Date getReferenceDate() {
            return this.pdsv.getReferenceDate();
        }

        public final int getForecastTime() {
            return this.pdsv.getForecastTime();
        }

        public String getSurfaceValue() {
            return this.pdsv.getLevelValue1() + "-" + this.pdsv.getLevelValue2();
        }

        public int getStartInterval() {
            return this.interval[0];
        }

        public int getEndInterval() {
            return this.interval[1];
        }

        public int getTimeInterval() {
            return this.interval[1] - this.interval[0];
        }

        public final String getStatType() {
            int code = this.pdsv.getStatisticalProcessType();
            return code >= 0 ? Grib2Tables.codeTable4_10(this.pdsv.getStatisticalProcessType()) : "";
        }

        public final boolean isEnsemble() {
            return this.pdsv.isEnsemble();
        }

        public final int getNForecasts() {
            return this.pdsv.getNumberEnsembleForecasts();
        }

        public final int getPerturbationType() {
            return this.pdsv.getPerturbationType();
        }

        public final String getProbLimit() {
            return this.pdsv.getProbabilityLowerLimit() + "-" + this.pdsv.getProbabilityUpperLimit();
        }

        public final long getDataOffset() {
            return this.gr.getDataOffset();
        }

        public String toRawString() {
            Formatter f = new Formatter();
            GribOldRawPanel.this.showRawPds(this.pdsv, f);
            return f.toString();
        }

        public String toProcessedString() {
            Formatter f = new Formatter();
            Grib1Dump.printPDS(this.pdsv, f);
            return f.toString();
        }
    }

    public class Grib1ParameterBean {
        Grib1ProductDefinitionSection pds;
        Grib1Pds pdsv;
        List<Grib1RecordBean> records;
        String header;

        public Grib1ParameterBean() {
        }

        public Grib1ParameterBean(Grib1Record r) {
            this.pds = r.getPDS();
            this.pdsv = this.pds.getPdsVars();
            this.header = r.getHeader();
            this.records = new ArrayList<Grib1RecordBean>();
        }

        void addRecord(Grib1Record r) {
            this.records.add(new Grib1RecordBean(r));
        }

        List<Grib1RecordBean> getRecordBeans() {
            return this.records;
        }

        public String toRawString() {
            Formatter f = new Formatter();
            GribOldRawPanel.this.showRawPds(this.pdsv, f);
            return f.toString();
        }

        public String toProcessedString() {
            Formatter f = new Formatter();
            Grib1Dump.printPDS(this.pdsv, f);
            return f.toString();
        }

        public String getDesc() {
            return this.pds.getDescription();
        }

        public String getCenter() {
            return CommonCodeTable.getCenterName(this.pds.getCenter(), 1) + " (" + this.pds.getCenter() + "/" + this.pds.getSubCenter() + ")";
        }

        public int getVersion() {
            return this.pds.getTableVersion();
        }

        public final Date getReferenceDate() {
            return this.pdsv.getReferenceDate();
        }

        public int getParamNo() {
            return this.pdsv.getParameterNumber();
        }

        public final int getLevelType() {
            return this.pdsv.getLevelType1();
        }

        public final String getLevelName() {
            return this.pdsv.getLevelName();
        }

        public int getN() {
            return this.records.size();
        }
    }

    public class Gds1Bean {
        Grib1GridDefinitionSection gds;
        int key;

        public Gds1Bean() {
        }

        public Gds1Bean(int key, Grib1GridDefinitionSection m) {
            this.key = key;
            this.gds = m;
        }

        public int getKey() {
            return this.key;
        }

        public int getHashCode() {
            return this.gds.hashCode();
        }

        public int getGridNo() {
            return this.gds.getGdtn();
        }

        public String getGridName() {
            return this.gds.getName();
        }

        public String getScanMode() {
            return Long.toBinaryString(this.gds.getScanMode());
        }

        public String getResolution() {
            return Long.toBinaryString(this.gds.getResolution());
        }

        public double getDx() {
            return this.gds.getDx();
        }

        public double getDy() {
            return this.gds.getDy();
        }

        public int getNx() {
            return this.gds.getNx();
        }

        public int getNy() {
            return this.gds.getNy();
        }
    }

    public class Gds2Bean {
        Grib2GridDefinitionSection gds;
        Grib2GDSVariables gdsv;

        public Gds2Bean() {
        }

        public Gds2Bean(Grib2GridDefinitionSection m) {
            this.gds = m;
            this.gdsv = this.gds.getGdsVars();
        }

        public int getKey() {
            return this.gds.getGdsKey();
        }

        public float getLa1() {
            return this.gdsv.getLa1();
        }

        public float getLo1() {
            return this.gdsv.getLo1();
        }

        public float getLa2() {
            return this.gdsv.getLa2();
        }

        public float getLo2() {
            return this.gdsv.getLo2();
        }

        public float getDx() {
            return this.gdsv.getDx();
        }

        public float getDy() {
            return this.gdsv.getDy();
        }

        public int getGDS() {
            return this.gds.getGdtn();
        }

        public String getGridName() {
            return Grib2Tables.codeTable3_1(this.gds.getGdtn());
        }

        public int getNPoints() {
            return this.gdsv.getNumberPoints();
        }

        public String getScanMode() {
            return Long.toBinaryString(this.gdsv.getScanMode());
        }

        public String getResolution() {
            return Long.toBinaryString(this.gdsv.getResolution());
        }
    }

    public class Grib2RecordBean {
        Grib2Record gr;
        Grib2IdentificationSection id;
        Grib2GridDefinitionSection gds;
        Grib2ProductDefinitionSection pds;
        Grib2Pds pdsv;
        int[] interval;

        public Grib2RecordBean() {
        }

        public Grib2RecordBean(Grib2Record m) {
            this.gr = m;
            this.id = this.gr.getId();
            this.gds = this.gr.getGDS();
            this.pds = this.gr.getPDS();
            this.pdsv = this.pds.getPdsVars();
        }

        public final String getTimeUnit() {
            int unit = this.pdsv.getTimeUnit();
            return Grib2Tables.codeTable4_4(unit);
        }

        public final Date getBaseTime() {
            return this.id.getBaseTime();
        }

        public final int getForecastTime() {
            return this.pdsv.getForecastTime();
        }

        public String getHeader() {
            return this.gr.getHeader();
        }

        public String getSurfaceType() {
            return this.pdsv.getLevelType1() + "-" + this.pdsv.getLevelType2();
        }

        public String getSurfaceValue() {
            return this.pdsv.getLevelValue1() + "-" + this.pdsv.getLevelValue2();
        }

        public String getInterval() {
            if (this.pdsv.isInterval()) {
                int[] intv = this.pdsv.getForecastTimeInterval();
                return intv[0] + "-" + intv[1];
            }
            return "";
        }

        public final String getStatType() {
            int code = this.pdsv.getStatisticalProcessType();
            return code >= 0 ? Grib2Tables.codeTable4_10(this.pdsv.getStatisticalProcessType()) : "";
        }

        public final boolean isEnsemble() {
            return this.pdsv.isEnsemble();
        }

        public final int getEnsN() {
            return this.pdsv.getPerturbationNumber();
        }

        public final int getNForecasts() {
            return this.pdsv.getNumberEnsembleForecasts();
        }

        public final int getPerturbationType() {
            return this.pdsv.getPerturbationType();
        }

        public final String getProbLimit() {
            return this.pdsv.getProbabilityLowerLimit() + "-" + this.pdsv.getProbabilityUpperLimit();
        }

        public final long getGdsOffset() {
            return this.gr.getGdsOffset();
        }

        public final long getPdsOffset() {
            return this.gr.getPdsOffset();
        }

        public void toRawPdsString(Formatter f) {
            byte[] bytes = this.pdsv.getPDSBytes();
            int count = 1;
            for (byte b : bytes) {
                short s = DataType.unsignedByteToShort(b);
                f.format(" %d : %d%n", count++, s);
            }
        }

        public String showComplete() {
            Formatter f = new Formatter();
            f.format("Grib2IndicatorSection%n", new Object[0]);
            f.format(" Discipline = (%d) %s%n", this.gr.getIs().getDiscipline(), this.gr.getIs().getDisciplineName());
            f.format(" Edition    = %d%n", this.gr.getIs().getGribEdition());
            f.format(" Length     = %d%n", this.gr.getIs().getGribLength());
            f.format("%nGrib2IdentificationSection%n", new Object[0]);
            f.format(" Length        = %d%n", this.id.getLength());
            f.format(" Center        = (%d) %s%n", this.id.getCenter_id(), CommonCodeTable.getCenterName(this.id.getCenter_id(), 2));
            f.format(" SubCenter     = (%d) %s%n", this.id.getSubcenter_id(), CommonCodeTable.getSubCenterName(this.id.getCenter_id(), this.id.getSubcenter_id()));
            f.format(" Master Table  = %d%n", this.id.getMaster_table_version());
            f.format(" Local Table   = %d%n", this.id.getLocal_table_version());
            f.format(" RefTimeSignif = %s%n", this.id.getSignificanceOfRTName());
            f.format(" RefTime       = %s%n", GribOldRawPanel.this.df.toDateTimeStringISO(this.id.getBaseTime()));
            f.format(" ProductStatus = %s%n", this.id.getProductStatusName());
            f.format(" ProductType   = %s%n", this.id.getProductTypeName());
            byte[] lus = this.gr.getLocalUseSection();
            if (lus != null) {
                f.format("%nLocal Use Section (grib section 2)%n", new Object[0]);
                f.format("bytes (len=%d) =", lus.length);
                Misc.showBytes(lus, f);
                f.format("%n", new Object[0]);
            }
            f.format("%nGrib2GridDefinitionSection%n", new Object[0]);
            f.format(" Length             = %d%n", this.gds.getLength());
            f.format(" Source  (3.0)      = %d%n", this.gds.getSource());
            f.format(" Npts               = %d%n", this.gds.getNumberPoints());
            f.format(" Template (3.1)     = %d%n", this.gds.getGdtn());
            GribOldRawPanel.this.showRawGds(this.gds, f);
            f.format("%nGrib2ProductDefinitionSection%n", new Object[0]);
            f.format("            Length  = %d%n", this.pds.getLength());
            int[] intv = this.pds.getPdsVars().getForecastTimeInterval();
            if (intv != null) {
                f.format(" Start interval     = %d%n", intv[0]);
                f.format(" End   interval     = %d%n", intv[1]);
            }
            GribOldRawPanel.this.showRawPds(this.pds, f);
            return f.toString();
        }

        public String toProcessedString() {
            Formatter f = new Formatter();
            this.pdsv.show(f);
            return f.toString();
        }
    }

    public class Grib2ParameterBean {
        Grib2IdentificationSection id;
        Grib2ProductDefinitionSection pds;
        Grib2Pds pdsv;
        List<Grib2RecordBean> records;
        int discipline;
        int gdsKey;

        public Grib2ParameterBean() {
        }

        public Grib2ParameterBean(Grib2Record r) {
            this.pds = r.getPDS();
            this.pdsv = this.pds.getPdsVars();
            this.id = r.getId();
            this.discipline = r.getIs().getDiscipline();
            this.records = new ArrayList<Grib2RecordBean>();
            this.gdsKey = r.getGDS().getGdsVars().getGdsKey();
        }

        void addRecord(Grib2Record r) {
            this.records.add(new Grib2RecordBean(r));
        }

        List<Grib2RecordBean> getRecordBeans() {
            return this.records;
        }

        public String toString() {
            Formatter f = new Formatter();
            GribOldRawPanel.this.showRawPds(this.pds, f);
            return f.toString();
        }

        public String toProcessedString() {
            Formatter f = new Formatter();
            GribOldRawPanel.this.showProcessedPds(this.pdsv, this.discipline, f);
            return f.toString();
        }

        public String getName() {
            return ParameterTable.getParameterName(this.discipline, this.pdsv.getParameterCategory(), this.pdsv.getParameterNumber());
        }

        public final Date getBaseTime() {
            return this.id.getBaseTime();
        }

        public String getParamNo() {
            return this.discipline + "-" + this.pdsv.getParameterCategory() + "-" + this.pdsv.getParameterNumber();
        }

        public int getTemplate() {
            return this.pdsv.getProductDefinitionTemplate();
        }

        public final int getLevelType() {
            return this.pdsv.getLevelType1();
        }

        public final String getLevelName() {
            return Grib2Tables.codeTable4_5(this.pdsv.getLevelType1());
        }

        public final String getLevelNameShort() {
            return Grib2Tables.getTypeSurfaceNameShort(this.pdsv.getLevelType1());
        }

        public final String getTypeGenProcess() {
            int tgp = this.pdsv.getGenProcessType();
            return Grib2Tables.codeTable4_3(tgp);
        }

        public int getN() {
            return this.records.size();
        }
    }

    private class DateCount
    implements Comparable<DateCount> {
        Date d;
        int count;

        private DateCount(Date d) {
            this.d = d;
        }

        @Override
        public int compareTo(DateCount o) {
            return this.d.compareTo(o.d);
        }
    }
}

