/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import ucar.nc2.NetcdfFileWriter;

public class NetcdfOutputChooser
extends JDialog {
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label1;
    private JTextField outputFilename;
    private JLabel label2;
    private JComboBox netcdfVersion;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public NetcdfOutputChooser(Frame owner) {
        super(owner);
        this.initComponents();
    }

    public NetcdfOutputChooser(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    public void setOutputFilename(String filename) {
        NetcdfFileWriter.Version version;
        String suffix;
        int pos;
        String location;
        if (filename == null) {
            filename = "test";
        }
        if ((location = filename).startsWith("file:")) {
            location = location.substring(5);
        }
        if ((pos = location.lastIndexOf(".")) > 0) {
            location = location.substring(0, pos);
        }
        String string = suffix = (version = (NetcdfFileWriter.Version)((Object)this.netcdfVersion.getSelectedItem())) == null ? ".nc" : version.getSuffix();
        if (filename.endsWith(".nc") && suffix.equals(".nc")) {
            suffix = ".sub.nc";
        }
        location = location + suffix;
        this.outputFilename.setText(location);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        Data data = new Data(this.outputFilename.getText(), (NetcdfFileWriter.Version)((Object)this.netcdfVersion.getSelectedItem()));
        this.firePropertyChange("OK", null, data);
        this.setVisible(false);
    }

    private void createUIComponents() {
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label1 = new JLabel();
        this.outputFilename = new JTextField();
        this.label2 = new JLabel();
        this.netcdfVersion = new JComboBox<NetcdfFileWriter.Version>(NetcdfFileWriter.Version.values());
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.label1.setText("Output Filename:");
        this.label2.setText("NetCDF Format:");
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.label1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputFilename, -1, 466, Short.MAX_VALUE)).addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.netcdfVersion, -2, 243, -2).addGap(0, 222, Short.MAX_VALUE))).addContainerGap()));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addContainerGap().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1).addComponent(this.outputFilename, -2, -1, -2)).addGap(18, 18, 18).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent(this.netcdfVersion, -2, -1, -2)).addContainerGap(28, Short.MAX_VALUE)));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetcdfOutputChooser.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public class Data {
        public String outputFilename;
        public NetcdfFileWriter.Version version;

        private Data(String outputFilename, NetcdfFileWriter.Version version) {
            this.outputFilename = outputFilename;
            this.version = version;
        }
    }
}

