/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.BaseColorControl;
import visad.CellImpl;
import visad.ColorControl;
import visad.ConstantMap;
import visad.ContourControl;
import visad.Control;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.FieldImpl;
import visad.GraphicsModeControl;
import visad.GriddedSet;
import visad.MathType;
import visad.MessageEvent;
import visad.MessageListener;
import visad.ProjectionControl;
import visad.RangeControl;
import visad.Real;
import visad.RemoteCellImpl;
import visad.RemoteData;
import visad.RemoteDataImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.RemoteSlaveDisplayImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Text;
import visad.ThingReference;
import visad.Tuple;
import visad.ValueControl;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.netcdf.Plain;
import visad.data.visad.VisADForm;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaUtil;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellData;
import visad.ss.SSCellImpl;
import visad.ss.SSCellListener;
import visad.util.DataUtility;
import visad.util.SaveStringTokenizer;
import visad.util.Util;

public class BasicSSCell
extends JPanel
implements DisplayListener,
MessageListener {
    public static boolean DEBUG = false;
    public static int DEBUG_LEVEL = 2;
    protected static final Vector SSCellVector = new Vector();
    protected static int Saving = 0;
    protected static boolean Possible3D;
    protected static boolean CanDo3D;
    protected static final FormulaManager defaultFM;
    protected String Name;
    protected FormulaManager fm;
    public static final int ADD_DATA = 0;
    public static final int ADD_SOURCE = 1;
    public static final int REMOVE_DATA = 2;
    public static final int SET_MAPS = 3;
    public static final int SET_DIM = 4;
    public static final int SET_ERRORS = 5;
    public static final int UPDATE_DATA = 6;
    public static final int UPDATE_DEPENDENCIES = 7;
    public static final int STATUS = 8;
    public static final int MAX_ID = 9;
    public static final String[] messages;
    protected Vector Servers = new Vector();
    protected DisplayImpl MDisplay = null;
    protected RemoteDisplay RemoteMDisplay = null;
    protected RemoteDisplay RemoteVDisplay = null;
    protected RemoteSlaveDisplayImpl RemoteVSlave = null;
    protected RemoteServer RemoteVServer = null;
    protected int CollabID = 0;
    protected boolean IsRemote;
    protected boolean IsSlave;
    protected boolean NewClient;
    protected static final int POLLING_INTERVAL = 100;
    public static final int UNKNOWN_SOURCE = -1;
    public static final int DIRECT_SOURCE = 0;
    public static final int URL_SOURCE = 1;
    public static final int FORMULA_SOURCE = 2;
    public static final int RMI_SOURCE = 3;
    public static final int REMOTE_SOURCE = 4;
    protected int Loading = 0;
    protected Vector CellData = new Vector();
    public static final int JAVA3D_3D = 1;
    public static final int JAVA2D_2D = 2;
    public static final int JAVA3D_2D = 3;
    private static final String j33 = "visad.java3d.DefaultDisplayRendererJ3D";
    private static final String j22 = "visad.java2d.DefaultDisplayRendererJ2D";
    private static final String j32 = "visad.java3d.TwoDDisplayRendererJ3D";
    private static final String jir = "visad.bom.ImageRendererJ3D";
    protected DisplayImpl VDisplay;
    protected int Dim = -1;
    protected boolean HasMappings = false;
    protected Object Lock = new Object();
    protected Component VDPanel;
    protected String[] Errors;
    protected boolean HasDisplay = false;
    protected boolean DisplayEnabled = true;
    private JPanel WaitPanel = null;
    protected Vector SListen = new Vector();
    protected Vector DListen = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicSSCell getSSCellByName(String name) {
        Vector vector = SSCellVector;
        synchronized (vector) {
            int len = SSCellVector.size();
            for (int i = 0; i < len; ++i) {
                BasicSSCell cell = (BasicSSCell)SSCellVector.elementAt(i);
                if (!name.equalsIgnoreCase(cell.Name)) continue;
                return cell;
            }
        }
        return null;
    }

    public static boolean isSaving() {
        return Saving > 0;
    }

    public static boolean possible3D() {
        return Possible3D;
    }

    public static boolean canDo3D() {
        return CanDo3D;
    }

    public static boolean enable3D() {
        if (Possible3D) {
            CanDo3D = true;
        } else {
            Possible3D = CanDo3D = Util.canDoJava3D();
            if (DEBUG && !Possible3D && DEBUG) {
                System.err.println("Warning: Java3D library not found");
            }
        }
        return CanDo3D;
    }

    public static void disable3D() {
        CanDo3D = false;
    }

    public BasicSSCell(String name) throws VisADException, RemoteException {
        this(name, null, null, false, null);
    }

    public BasicSSCell(String name, FormulaManager fman) throws VisADException, RemoteException {
        this(name, fman, null, false, null);
    }

    public BasicSSCell(String name, RemoteServer rs) throws VisADException, RemoteException {
        this(name, null, rs, false, null);
    }

    public BasicSSCell(String name, String save) throws VisADException, RemoteException {
        this(name, null, null, false, save);
    }

    public BasicSSCell(String name, FormulaManager fman, RemoteServer rs, String save) throws VisADException, RemoteException {
        this(name, fman, rs, false, save);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicSSCell(String name, FormulaManager fman, RemoteServer rs, boolean slave, String save) throws VisADException, RemoteException {
        if (name == null) {
            throw new VisADException("BasicSSCell: name cannot be null");
        }
        Vector vector = SSCellVector;
        synchronized (vector) {
            int len = SSCellVector.size();
            for (int i = 0; i < len; ++i) {
                BasicSSCell cell = (BasicSSCell)SSCellVector.elementAt(i);
                if (!name.equalsIgnoreCase(cell.Name)) continue;
                throw new VisADException("BasicSSCell: name already used");
            }
            this.Name = name;
            SSCellVector.add(this);
        }
        FormulaManager formulaManager = this.fm = fman == null ? defaultFM : fman;
        if (rs != null) {
            this.RemoteVServer = rs;
            this.RemoteVDisplay = rs.getDisplay(this.Name);
        }
        this.IsRemote = this.RemoteVDisplay != null;
        this.IsSlave = slave;
        if (this.IsRemote) {
            this.setupClient();
        } else {
            this.setupServer();
        }
        if (save != null) {
            this.setSaveString(save);
        }
        this.initDisplayPanel();
        this.setPreferredSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.setBackground(this.IsSlave ? Color.darkGray : Color.black);
        this.setLayout(new BoxLayout(this, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRemoteServer(RemoteServerImpl rs) throws RemoteException {
        if (rs == null) {
            return;
        }
        if (this.IsRemote) {
            throw new RemoteException("Cannot add a cloned cell to a server");
        }
        Vector vector = this.Servers;
        synchronized (vector) {
            if (!this.Servers.contains(rs)) {
                rs.addDisplay((RemoteDisplayImpl)this.RemoteMDisplay);
                rs.addDisplay((RemoteDisplayImpl)this.RemoteVDisplay);
                Vector vector2 = this.CellData;
                synchronized (vector2) {
                    int len = this.CellData.size();
                    for (int i = 0; i < len; ++i) {
                        SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                        rs.addDataReference(cellData.getRemoteReference());
                    }
                }
                this.Servers.add(rs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromRemoteServer(RemoteServerImpl rs) throws RemoteException {
        if (rs == null) {
            return;
        }
        if (this.IsRemote) {
            throw new RemoteException("Cannot remove a cloned cell from a server");
        }
        Vector vector = this.Servers;
        synchronized (vector) {
            if (this.Servers.contains(rs)) {
                rs.removeDisplay((RemoteDisplayImpl)this.RemoteMDisplay);
                rs.removeDisplay((RemoteDisplayImpl)this.RemoteVDisplay);
                Vector vector2 = this.CellData;
                synchronized (vector2) {
                    int len = this.CellData.size();
                    for (int i = 0; i < len; ++i) {
                        SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                        rs.removeDataReference(cellData.getRemoteReference());
                    }
                }
                this.Servers.remove(rs);
            }
        }
    }

    void sendMessage(int id, String msg, Data data) throws RemoteException {
        RemoteData d = data instanceof RemoteData ? (RemoteData)data : new RemoteDataImpl((DataImpl)data);
        this.MDisplay.sendMessage(new MessageEvent(9 * this.CollabID + id, msg, d));
        if (DEBUG && DEBUG_LEVEL >= 2) {
            System.out.println(this.Name + "[" + this.CollabID + "]: sent " + messages[id] + ": msg=" + msg + ", data=" + (data == null ? "null" : data.getClass().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(MessageEvent msg) throws RemoteException {
        block60: {
            Cloneable ld;
            int id = msg.getId();
            int mid = id % 9;
            int oid = id / 9;
            if (oid == this.CollabID && mid != 7) {
                return;
            }
            String m = msg.getString();
            RemoteData data = msg.getData();
            if (DEBUG && DEBUG_LEVEL >= 2) {
                ld = DataUtility.makeLocal(data, DEBUG);
                System.out.println(this.Name + "[" + this.CollabID + "]: received " + messages[mid] + " from " + oid + ": msg=" + m + ", data=" + (ld == null ? "null" : ld.getClass().getName()));
            }
            try {
                SSCellData cellData;
                Cloneable tuple;
                if (mid == 0) {
                    ld = this.CellData;
                    synchronized (ld) {
                        SSCellData cellData2 = this.addReferenceImpl(0, null, null, m, m.equals("") ? 0 : 1, false, false);
                        cellData2.setData(data, false);
                        break block60;
                    }
                }
                if (mid == 1) {
                    ld = this.CellData;
                    synchronized (ld) {
                        int type = (int)((Real)DataUtility.makeLocal(data, DEBUG)).getValue();
                        this.addDataSource(0, m, type, false);
                        break block60;
                    }
                }
                if (mid == 2) {
                    ld = this.CellData;
                    synchronized (ld) {
                        SSCellData cellData3 = this.getCellDataByName(m);
                        this.removeDataImpl(cellData3, false, true);
                        break block60;
                    }
                }
                if (mid == 3) {
                    if (!this.IsRemote) {
                        if (m == null) {
                            this.clearMaps();
                        } else {
                            this.setMaps(DataUtility.convertStringToMaps(m, this.getData(), true));
                        }
                    }
                    break block60;
                }
                if (mid == 4) {
                    int dim = (int)((Real)DataUtility.makeLocal(data, DEBUG)).getValue();
                    if (m != null) {
                        if (this.IsRemote) {
                            this.beginWait(true);
                        } else {
                            this.setDimension(dim);
                        }
                    } else if (this.IsRemote) {
                        this.endWait(false);
                        this.setDimClone();
                    }
                    break block60;
                }
                if (mid == 5) {
                    SSCellData cellData4;
                    tuple = (Tuple)DataUtility.makeLocal(data, DEBUG);
                    String[] errors = DataUtility.tupleToStrings((Tuple)tuple, DEBUG);
                    Vector vector = this.CellData;
                    synchronized (vector) {
                        cellData4 = this.getCellDataByName(m);
                    }
                    if (cellData4 != null) {
                        cellData4.setErrors(errors, false);
                    }
                    break block60;
                }
                if (mid == 6) {
                    Vector errors = this.CellData;
                    synchronized (errors) {
                        cellData = this.getCellDataByName(m);
                    }
                    cellData.cell.skipNextErrors();
                    cellData.setData(data, false);
                    break block60;
                }
                if (mid == 7) {
                    Vector errors = this.CellData;
                    synchronized (errors) {
                        cellData = this.getCellDataByName(m);
                    }
                    if (cellData != null) {
                        cellData.setDependencies((Real)DataUtility.makeLocal(data, DEBUG));
                    }
                    break block60;
                }
                if (mid == 8) {
                    if (m == null) {
                        if (!this.IsRemote || !this.NewClient) break block60;
                        tuple = (Tuple)DataUtility.makeLocal(data, DEBUG);
                        if (tuple != null) {
                            Vector errors = this.CellData;
                            synchronized (errors) {
                                block61: {
                                    try {
                                        int len = ((Tuple)tuple).getDimension();
                                        for (int i = 0; i < len; ++i) {
                                            Tuple t = (Tuple)DataUtility.makeLocal(((Tuple)tuple).getComponent(i), DEBUG);
                                            Real rid = (Real)DataUtility.makeLocal(t.getComponent(0), DEBUG);
                                            Data d = t.getComponent(1);
                                            DataReferenceImpl ref = new DataReferenceImpl(this.Name);
                                            ref.setData(d);
                                            Text source = (Text)DataUtility.makeLocal(t.getComponent(2), DEBUG);
                                            Real type = (Real)DataUtility.makeLocal(t.getComponent(3), DEBUG);
                                            this.addReferenceImpl((int)rid.getValue(), ref, null, source.getValue(), (int)type.getValue(), false, false);
                                        }
                                    }
                                    catch (VisADException exc) {
                                        if (DEBUG) {
                                            exc.printStackTrace();
                                        }
                                    }
                                    catch (RemoteException exc) {
                                        if (!DEBUG) break block61;
                                        exc.printStackTrace();
                                    }
                                }
                            }
                        }
                        this.NewClient = false;
                        break block60;
                    }
                    if (this.IsRemote) break block60;
                    tuple = this.CellData;
                    synchronized (tuple) {
                        block62: {
                            try {
                                int len = this.CellData.size();
                                Data[] d = new Data[len];
                                for (int i = 0; i < len; ++i) {
                                    SSCellData cellData5 = (SSCellData)this.CellData.elementAt(i);
                                    Data[] status = new Data[]{new Real(cellData5.getId()), cellData5.getData(), new Text(cellData5.getSource()), new Real(cellData5.getSourceType())};
                                    d[i] = new Tuple(status);
                                }
                                this.sendMessage(8, null, len == 0 ? null : new Tuple(d));
                            }
                            catch (VisADException exc) {
                                if (DEBUG) {
                                    exc.printStackTrace();
                                }
                            }
                            catch (RemoteException exc) {
                                if (!DEBUG) break block62;
                                exc.printStackTrace();
                            }
                        }
                        break block60;
                    }
                }
                if (DEBUG) {
                    this.warn("unknown message id (" + mid + ") received.");
                }
            }
            catch (VisADException exc) {
                if (!DEBUG) break block60;
                exc.printStackTrace();
            }
        }
    }

    protected void setupServer() throws VisADException, RemoteException {
        this.MDisplay = new DisplayImplJ2D(this.Name + "_Messenger", null);
        this.RemoteMDisplay = new RemoteDisplayImpl(this.MDisplay);
        this.MDisplay.addMessageListener(this);
        this.CollabID = 0;
        this.setDimension(2);
    }

    protected void setupClient() throws VisADException, RemoteException {
        block2: {
            this.RemoteMDisplay = this.RemoteVServer.getDisplay(this.Name + "_Messenger");
            this.MDisplay = new DisplayImplJ2D(this.RemoteMDisplay, null);
            this.MDisplay.addMessageListener(this);
            try {
                this.CollabID = this.MDisplay.getConnectionID(this.RemoteMDisplay);
            }
            catch (RemoteException exc) {
                if (!DEBUG) break block2;
                exc.printStackTrace();
            }
        }
        this.setDimClone();
        this.addDisplayListener(this);
        this.NewClient = true;
        this.sendMessage(8, "", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateDependencies() {
        Vector vector = SSCellVector;
        synchronized (vector) {
            int len = SSCellVector.size();
            for (int i = 0; i < len; ++i) {
                BasicSSCell cell = (BasicSSCell)SSCellVector.elementAt(i);
                if (cell.isRemote()) continue;
                Vector vector2 = cell.CellData;
                synchronized (vector2) {
                    int len2 = cell.CellData.size();
                    for (int j = 0; j < len2; ++j) {
                        boolean canBeRemoved;
                        String varName;
                        SSCellData cellData;
                        block12: {
                            cellData = (SSCellData)cell.CellData.elementAt(j);
                            if (cellData.ssCell.isRemote()) continue;
                            varName = cellData.getVariableName();
                            canBeRemoved = true;
                            try {
                                canBeRemoved = cell.fm.canBeRemoved(varName);
                            }
                            catch (FormulaException exc) {
                                if (!DEBUG) break block12;
                                exc.printStackTrace();
                            }
                        }
                        if (canBeRemoved != cellData.othersDepend) continue;
                        try {
                            cellData.ssCell.sendMessage(7, varName, canBeRemoved ? SSCellImpl.FALSE : SSCellImpl.TRUE);
                            continue;
                        }
                        catch (RemoteException exc) {
                            if (!DEBUG) continue;
                            exc.printStackTrace();
                        }
                    }
                    continue;
                }
            }
        }
    }

    public String addData(Data data) throws VisADException, RemoteException {
        return this.addData(0, data, null, "", 0, true);
    }

    public String addData(Data data, ConstantMap[] cmaps) throws VisADException, RemoteException {
        return this.addData(0, data, cmaps, "", 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addData(int id, Data data, ConstantMap[] cmaps, String source, int type, boolean notify) throws VisADException, RemoteException {
        SSCellData cellData;
        DataReferenceImpl ref = new DataReferenceImpl(this.Name);
        ref.setData(data);
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.addReferenceImpl(id, ref, cmaps, source, type, notify, true);
        }
        return cellData.getVariableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addReference(DataReferenceImpl ref) throws VisADException, RemoteException {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.addReferenceImpl(0, ref, null, "", 0, true, true);
        }
        return cellData.getVariableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addReference(DataReferenceImpl ref, ConstantMap[] cmaps) throws VisADException, RemoteException {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.addReferenceImpl(0, ref, cmaps, "", 0, true, true);
        }
        return cellData.getVariableName();
    }

    public String addDataSource(String source) throws VisADException, RemoteException {
        return this.addDataSource(0, source, -1, true);
    }

    public String addDataSource(String source, int type) throws VisADException, RemoteException {
        return this.addDataSource(0, source, type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    String addDataSource(int id, String source, int type, boolean notify) throws VisADException, RemoteException {
        SSCellData cellData;
        Cloneable data;
        String varName = null;
        if (type == -1) {
            if (source.startsWith("rmi://")) {
                type = 3;
            } else if (source.startsWith("adde://")) {
                type = 1;
            } else {
                File f = new File(source);
                if (f.exists()) {
                    type = 1;
                } else {
                    URL url;
                    block48: {
                        url = null;
                        try {
                            url = new URL(source);
                        }
                        catch (MalformedURLException exc) {
                            if (!DEBUG || DEBUG_LEVEL < 3) break block48;
                            exc.printStackTrace();
                        }
                    }
                    type = url != null ? 1 : 2;
                }
            }
        }
        if (type == 0) throw new VisADException("Invalid source type");
        if (type == 4) {
            throw new VisADException("Invalid source type");
        }
        if (type == 1) {
            this.beginWait(true);
            data = null;
            boolean success = true;
            try {
                DefaultFamily loader = new DefaultFamily("loader", true);
                if (source.startsWith("file:") && (source = source.substring(5)).length() > 2 && source.charAt(2) == ':' && source.charAt(0) == '/') {
                    source = source.substring(1);
                }
                data = loader.open(source);
                File file = new File(source);
                if (file.exists()) {
                    String path = file.getAbsolutePath();
                    char[] p = path.toCharArray();
                    for (int i = 0; i < p.length; ++i) {
                        if (p[i] != '\\') continue;
                        p[i] = 47;
                    }
                    path = new String(p);
                    source = "file:" + (path.startsWith("/") ? "" : "/") + path;
                }
                this.endWait(!success);
            }
            catch (OutOfMemoryError err) {
                try {
                    if (DEBUG) {
                        err.printStackTrace();
                    }
                    success = false;
                    throw new VisADException("Not enough memory to import the data.");
                    catch (BadFormException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                        success = false;
                        throw new VisADException("The source could not be converted to VisAD data.");
                    }
                    catch (VisADException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                        success = false;
                        throw exc;
                    }
                }
                catch (Throwable throwable) {
                    this.endWait(!success);
                    throw throwable;
                }
            }
            if (data != null) return this.addData(id, (Data)((Object)data), null, source, 1, notify);
            throw new VisADException("Could not load data from source " + source);
        }
        if (type == 2) {
            data = this.CellData;
            // MONITORENTER : data
            cellData = this.addReferenceImpl(id, null, null, source, 2, false, false);
            varName = cellData.getVariableName();
            if (!this.IsRemote) {
                this.fm.assignFormula(varName, source);
            }
            // MONITOREXIT : data
            if (!notify) return varName;
            this.sendMessage(1, source, new Real(type));
            return varName;
        }
        if (type != 3) return varName;
        if (!source.startsWith("rmi://")) {
            throw new VisADException("RMI address must begin with rmi://");
        }
        final DataReferenceImpl lref = new DataReferenceImpl(this.Name);
        Vector exc = this.CellData;
        // MONITORENTER : exc
        cellData = this.addReferenceImpl(id, lref, null, source, 3, false, false);
        varName = cellData.getVariableName();
        // MONITOREXIT : exc
        if (!this.IsRemote) {
            this.beginWait(true);
            boolean success = true;
            try {
                int len = source.length();
                int end = source.lastIndexOf("/");
                if (end < 6) {
                    end = len;
                }
                String server = source.substring(4, end);
                String object = end < len - 1 ? source.substring(end + 1) : "";
                RemoteServer rs = null;
                rs = (RemoteServer)Naming.lookup(server);
                RemoteDataReference ref = rs.getDataReference(object);
                if (ref == null) {
                    throw new VisADException("The remote object called \"" + object + "\" does not exist");
                }
                final SSCellData fcd = cellData;
                final RemoteDataReference rref = ref;
                BasicSSCell cell = this;
                CellImpl lcell = new CellImpl(){

                    public void doAction() {
                        try {
                            lref.setData(DataUtility.makeLocal(rref.getData(), DEBUG));
                        }
                        catch (NullPointerException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            fcd.setError("Remote data is null");
                        }
                        catch (VisADException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            fcd.setError("Could not update remote data");
                        }
                        catch (RemoteException exc) {
                            if (DEBUG) {
                                exc.printStackTrace();
                            }
                            fcd.setError("Unable to import updated remote data");
                        }
                    }
                };
                RemoteCellImpl rcell = new RemoteCellImpl(lcell);
                rcell.addReference(ref);
                this.endWait(!success);
            }
            catch (ClassCastException exc2) {
                try {
                    if (DEBUG) {
                        exc2.printStackTrace();
                    }
                    success = false;
                    throw new VisADException("The name of the RMI server is not valid.");
                    catch (MalformedURLException exc3) {
                        if (DEBUG) {
                            exc3.printStackTrace();
                        }
                        success = false;
                        throw new VisADException("The name of the RMI server is not valid.");
                    }
                    catch (NotBoundException exc4) {
                        if (DEBUG) {
                            exc4.printStackTrace();
                        }
                        success = false;
                        throw new VisADException("The remote data specified does not exist.");
                    }
                    catch (AccessException exc5) {
                        if (DEBUG) {
                            exc5.printStackTrace();
                        }
                        success = false;
                        throw new VisADException("Could not gain access to the remote data.");
                    }
                    catch (RemoteException exc6) {
                        if (DEBUG) {
                            exc6.printStackTrace();
                        }
                        success = false;
                        throw new VisADException("Could not connect to the RMI server.");
                    }
                    catch (VisADException exc7) {
                        if (DEBUG) {
                            exc7.printStackTrace();
                        }
                        success = false;
                        throw exc7;
                    }
                }
                catch (Throwable throwable) {
                    this.endWait(!success);
                    throw throwable;
                }
            }
        }
        if (!notify) return varName;
        this.sendMessage(1, source, new Real(type));
        return varName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSCellData addReferenceImpl(int id, DataReferenceImpl ref, ConstantMap[] cmaps, String source, int type, boolean notify, boolean checkErrors) throws VisADException, RemoteException {
        if (id == 0) {
            id = this.getFirstFreeId();
        }
        if (ref == null) {
            ref = new DataReferenceImpl(this.Name);
        }
        if (notify) {
            this.sendMessage(0, source, ref.getData());
        }
        SSCellData cellData = new SSCellData(id, this, ref, cmaps, source, type, checkErrors);
        this.CellData.add(cellData);
        if (!this.IsRemote) {
            if (this.HasMappings) {
                this.VDisplay.addReference(ref, cmaps);
            }
            Vector vector = this.Servers;
            synchronized (vector) {
                RemoteDataReferenceImpl remoteRef = cellData.getRemoteReference();
                int len = this.Servers.size();
                for (int i = 0; i < len; ++i) {
                    RemoteServerImpl rs = (RemoteServerImpl)this.Servers.elementAt(i);
                    rs.addDataReference(remoteRef);
                }
            }
        }
        return cellData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(Data data) throws VisADException, RemoteException {
        boolean found = false;
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                if (cellData.getData() != data) continue;
                this.removeDataImpl(cellData, true, true);
                found = true;
                break;
            }
        }
        if (!found) {
            throw new VisADException("The given Data object does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String varName) throws VisADException, RemoteException {
        Vector vector = this.CellData;
        synchronized (vector) {
            SSCellData cellData = this.getCellDataByName(varName);
            if (cellData == null) {
                throw new VisADException("Data object called " + varName + " does not exist");
            }
            this.removeDataImpl(cellData, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(DataReferenceImpl ref) throws VisADException, RemoteException {
        boolean found = false;
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                if (cellData.getReference() != ref) continue;
                this.removeDataImpl(cellData, true, true);
                found = true;
                break;
            }
        }
        if (!found) {
            throw new VisADException("The given DataReference does not exist");
        }
    }

    public void removeAllReferences() throws VisADException, RemoteException {
        this.removeAllReferences(true, true);
    }

    protected void removeAllReferences(boolean notify) throws VisADException, RemoteException {
        this.removeAllReferences(notify, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllReferences(boolean notify, boolean display) throws VisADException, RemoteException {
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            for (int i = 0; i < len; ++i) {
                this.removeDataImpl((SSCellData)this.CellData.firstElement(), notify, display);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDataImpl(SSCellData cellData, boolean notify, boolean display) throws VisADException, RemoteException {
        String varName = cellData.getVariableName();
        if (notify) {
            this.sendMessage(2, varName, null);
        }
        if (!this.IsRemote) {
            if (this.HasMappings) {
                this.VDisplay.removeReference(cellData.getReference());
            }
            Vector vector = this.Servers;
            synchronized (vector) {
                RemoteDataReferenceImpl ref = cellData.getRemoteReference();
                int len = this.Servers.size();
                for (int i = 0; i < len; ++i) {
                    RemoteServerImpl rs = (RemoteServerImpl)this.Servers.elementAt(i);
                    rs.removeDataReference(ref);
                }
            }
        }
        this.CellData.remove(cellData);
        cellData.destroy();
        cellData = null;
        if (display) {
            if (this.hasData()) {
                this.updateDisplay();
            } else {
                this.clearDisplay();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForData(String varName) throws VisADException {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.getCellDataByName(varName);
        }
        this.fm.waitForFormula(varName);
        while (!cellData.isInited()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException exc) {
                if (!DEBUG || DEBUG_LEVEL < 3) continue;
                exc.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForData() throws VisADException {
        String[] varNames;
        int len;
        Vector vector = this.CellData;
        synchronized (vector) {
            len = this.CellData.size();
            varNames = new String[len];
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                varNames[i] = cellData.getVariableName();
            }
        }
        while (this.Loading > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException exc) {
                if (!DEBUG || DEBUG_LEVEL < 3) continue;
                exc.printStackTrace();
            }
        }
        for (int i = 0; i < len; ++i) {
            this.waitForData(varNames[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveData(String varName, String location, Form form) throws BadFormException, IOException, VisADException, RemoteException {
        if (this.IsSlave) {
            throw new VisADException("Cannot saveData on a slaved cell");
        }
        Data data = this.getData(varName);
        ++Saving;
        try {
            form.save(location, data, true);
        }
        finally {
            --Saving;
        }
    }

    protected SSCellData getCellDataByName(String varName) {
        int len = this.CellData.size();
        SSCellData cellData = null;
        for (int i = 0; i < len; ++i) {
            SSCellData cd = (SSCellData)this.CellData.elementAt(i);
            if (!cd.getVariableName().equals(varName)) continue;
            cellData = cd;
            break;
        }
        return cellData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFirstFreeId() {
        Vector vector = this.CellData;
        synchronized (vector) {
            if (this.CellData.size() == 0) {
                return 1;
            }
            SSCellData cellData = (SSCellData)this.CellData.lastElement();
            return cellData.getId() + 1;
        }
    }

    public synchronized boolean constructDisplay() {
        boolean success = true;
        DisplayImpl newDisplay = this.VDisplay;
        RemoteDisplay rmtDisplay = this.RemoteVDisplay;
        if (this.IsSlave) {
            try {
                newDisplay = new DisplayImplJ2D("DUMMY");
            }
            catch (VisADException exc) {
                if (DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
            catch (RemoteException exc) {
                if (DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
        } else if (!CanDo3D && this.Dim != 2) {
            success = false;
        } else {
            try {
                TwoDDisplayRendererJ3D tdr;
                if (this.IsRemote) {
                    if (this.Dim == 1) {
                        newDisplay = new DisplayImplJ3D(rmtDisplay);
                    } else if (this.Dim == 2) {
                        newDisplay = new DisplayImplJ2D(rmtDisplay);
                    } else {
                        tdr = new TwoDDisplayRendererJ3D();
                        newDisplay = new DisplayImplJ3D(rmtDisplay, (DisplayRendererJ3D)tdr);
                    }
                } else {
                    if (this.Dim == 1) {
                        newDisplay = new DisplayImplJ3D(this.Name);
                    } else if (this.Dim == 2) {
                        newDisplay = new DisplayImplJ2D(this.Name);
                    } else {
                        tdr = new TwoDDisplayRendererJ3D();
                        newDisplay = new DisplayImplJ3D(this.Name, (DisplayRendererJ3D)tdr);
                    }
                    rmtDisplay = new RemoteDisplayImpl(newDisplay);
                }
            }
            catch (NoClassDefFoundError err) {
                if (DEBUG) {
                    err.printStackTrace();
                }
                success = false;
            }
            catch (UnsatisfiedLinkError err) {
                if (DEBUG) {
                    err.printStackTrace();
                }
                success = false;
            }
            catch (Exception exc) {
                if (DEBUG) {
                    exc.printStackTrace();
                }
                success = false;
            }
        }
        if (success) {
            block32: {
                if (this.VDisplay != null) {
                    try {
                        this.VDisplay.destroy();
                    }
                    catch (VisADException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!DEBUG) break block32;
                        exc.printStackTrace();
                    }
                }
            }
            this.VDisplay = newDisplay;
            this.RemoteVDisplay = rmtDisplay;
        }
        return success;
    }

    public void displayChanged(DisplayEvent e) {
        int id = e.getId();
        if (id == 2 || id == 3 && this.IsSlave && !this.hasDisplay()) {
            if (!this.hasDisplay()) {
                this.initDisplayPanel();
                this.updateDisplay(true);
            }
            this.notifySSCellListeners(SSCellChangeEvent.DISPLAY_CHANGE);
        } else if (id == 12) {
            this.updateDisplay(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaps(ScalarMap[] maps) throws VisADException, RemoteException {
        if (maps == null) {
            return;
        }
        VisADException vexc = null;
        RemoteException rexc = null;
        if (this.IsRemote) {
            this.sendMessage(3, DataUtility.convertMapsToString(maps), null);
        } else {
            int i;
            ConstantMap[][] cmaps;
            DataReference[] dr;
            Vector vector = this.CellData;
            synchronized (vector) {
                int len = this.CellData.size();
                dr = new DataReference[len];
                cmaps = new ConstantMap[len][];
                for (int i2 = 0; i2 < len; ++i2) {
                    SSCellData cellData = (SSCellData)this.CellData.elementAt(i2);
                    dr[i2] = cellData.getReference();
                    cmaps[i2] = cellData.getConstantMaps();
                }
            }
            String save = this.getPartialSaveString();
            this.VDisplay.disableAction();
            this.clearMaps();
            for (i = 0; i < maps.length; ++i) {
                if (maps[i] == null) continue;
                try {
                    this.VDisplay.addMap(maps[i]);
                    continue;
                }
                catch (VisADException exc) {
                    vexc = exc;
                    continue;
                }
                catch (RemoteException exc) {
                    rexc = exc;
                }
            }
            for (i = 0; i < dr.length; ++i) {
                boolean ok;
                block22: {
                    Set set;
                    ok = false;
                    Data data = dr[i].getData();
                    if (data == null) {
                        if (DEBUG) {
                            this.warn("data #" + i + " is null; cannot analyze MathType");
                        }
                    } else if (Possible3D && data instanceof FieldImpl && (set = ((FieldImpl)data).getDomainSet()) instanceof GriddedSet && set.getManifoldDimension() == 2) {
                        MathType type = data.getType();
                        try {
                            ok = ImageRendererJ3D.isRendererUsable((MathType)type, (ScalarMap[])maps);
                        }
                        catch (VisADException exc) {
                            if (!DEBUG || DEBUG_LEVEL < 3) break block22;
                            exc.printStackTrace();
                        }
                    }
                }
                if (ok && this.Dim != 2) {
                    this.VDisplay.addReferences((DataRenderer)new ImageRendererJ3D(), dr[i], cmaps[i]);
                    continue;
                }
                if (DEBUG) {
                    this.warn("data #" + i + " cannot use ImageRendererJ3D");
                }
                this.VDisplay.addReference(dr[i], cmaps[i]);
            }
            this.setPartialSaveString(save, true);
            this.VDisplay.enableAction();
        }
        this.HasMappings = true;
        if (vexc != null) {
            throw vexc;
        }
        if (rexc != null) {
            throw rexc;
        }
    }

    public void clearMaps() throws VisADException, RemoteException {
        if (this.IsRemote) {
            this.clearMapsClone(true);
        } else if (this.hasMappings()) {
            this.VDisplay.removeAllReferences();
            this.VDisplay.clearMaps();
            this.HasMappings = false;
        }
    }

    private void clearMapsClone(boolean display) throws VisADException, RemoteException {
        if (this.hasMappings()) {
            this.RemoteVDisplay.removeAllReferences();
            this.RemoteVDisplay.clearMaps();
            if (display) {
                this.clearDisplay();
                this.constructDisplay();
                this.initDisplayPanel();
                this.updateDisplay(true);
            }
            this.HasMappings = false;
        }
    }

    public void clearDisplay() throws VisADException, RemoteException {
        if (!this.DisplayEnabled) {
            return;
        }
        this.HasDisplay = false;
        Util.invoke(false, DEBUG, new Runnable(){

            public void run() {
                BasicSSCell.this.removeAll();
                BasicSSCell.this.refresh();
            }
        });
    }

    public void clearCell() throws VisADException, RemoteException {
        this.removeAllReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCell() throws VisADException, RemoteException {
        RemoteException problem = null;
        this.setDisplayEnabled(false);
        this.removeAllReferences(false, !this.IsRemote);
        if (!this.IsRemote) {
            this.clearCell();
            int slen = this.Servers.size();
            for (int i = 0; i < slen; ++i) {
                RemoteServerImpl rs = (RemoteServerImpl)this.Servers.elementAt(i);
                try {
                    this.removeFromRemoteServer(rs);
                    continue;
                }
                catch (RemoteException exc) {
                    problem = exc;
                }
            }
        } else if (this.IsSlave && this.RemoteVSlave != null) {
            try {
                this.RemoteVSlave.unlink();
            }
            catch (RemoteException exc) {
                problem = exc;
            }
        }
        Vector vector = SSCellVector;
        synchronized (vector) {
            SSCellVector.remove(this);
        }
        if (problem != null) {
            throw problem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimension(int dim) throws VisADException, RemoteException {
        if (dim == this.Dim) {
            return;
        }
        if (dim != 1 && dim != 2 && dim != 3) {
            throw new VisADException("Invalid dimension");
        }
        if (!this.IsRemote) {
            this.Dim = dim;
            Vector vector = this.DListen;
            synchronized (vector) {
                block16: {
                    int i;
                    Vector mapVector;
                    int mvs;
                    this.detachListeners();
                    ScalarMap[] maps = null;
                    if (this.VDisplay != null && (mvs = (mapVector = this.VDisplay.getMapVector()).size()) > 0) {
                        maps = new ScalarMap[mvs];
                        for (i = 0; i < mvs; ++i) {
                            maps[i] = (ScalarMap)mapVector.elementAt(i);
                        }
                    }
                    mapVector = this.Servers;
                    synchronized (mapVector) {
                        RemoteServerImpl rsi;
                        int slen = this.Servers.size();
                        for (i = 0; i < slen; ++i) {
                            rsi = (RemoteServerImpl)this.Servers.elementAt(i);
                            rsi.removeDisplay((RemoteDisplayImpl)this.RemoteVDisplay);
                        }
                        this.constructDisplay();
                        for (i = 0; i < slen; ++i) {
                            rsi = (RemoteServerImpl)this.Servers.elementAt(i);
                            rsi.addDisplay((RemoteDisplayImpl)this.RemoteVDisplay);
                        }
                    }
                    if (maps != null) {
                        try {
                            this.setMaps(maps);
                        }
                        catch (VisADException exc) {
                            if (!DEBUG) break block16;
                            exc.printStackTrace();
                        }
                    }
                }
                this.initDisplayPanel();
                this.updateDisplay(this.hasData());
                this.attachListeners();
            }
            this.notifySSCellListeners(SSCellChangeEvent.DIMENSION_CHANGE);
        }
        this.sendMessage(4, this.IsRemote ? "" : null, new Real(dim));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDimClone() throws VisADException, RemoteException {
        Vector vector = this.DListen;
        synchronized (vector) {
            String s;
            this.detachListeners();
            this.clearDisplay();
            this.RemoteVDisplay = this.RemoteVServer.getDisplay(this.Name);
            if (this.IsSlave) {
                if (this.RemoteVSlave != null) {
                    this.RemoteVSlave.unlink();
                }
                this.RemoteVSlave = new RemoteSlaveDisplayImpl(this.RemoteVDisplay);
            }
            if ((s = this.RemoteVDisplay.getDisplayRendererClassName()).equals(j33) || s.equals(jir)) {
                this.Dim = 1;
            } else if (s.equals(j22)) {
                this.Dim = 2;
            } else if (s.equals(j32)) {
                this.Dim = 3;
            }
            boolean success = this.constructDisplay();
            if (!success) {
                JComponent errorCanvas = this.Dim == 2 ? new JComponent(){

                    public void paint(Graphics g) {
                        g.setColor(Color.white);
                        g.drawString("A serious error occurred while constructing this display.", 8, 20);
                    }
                } : new JComponent(){

                    public void paint(Graphics g) {
                        g.setColor(Color.white);
                        g.drawString("This machine does not support Java3D.", 8, 20);
                        g.drawString("Switch the dimension to 2-D (Java2D) to view this display.", 8, 35);
                    }
                };
                this.VDisplay = new DisplayImplJ2D("DUMMY");
                final JComponent ec = errorCanvas;
                Util.invoke(false, DEBUG, new Runnable(){

                    public void run() {
                        BasicSSCell.this.removeAll();
                        BasicSSCell.this.add(ec);
                        BasicSSCell.this.refresh();
                    }
                });
            }
            this.initDisplayPanel();
            if (success && this.hasData()) {
                this.updateDisplay(true);
            }
            this.attachListeners();
        }
        this.notifySSCellListeners(SSCellChangeEvent.DIMENSION_CHANGE);
    }

    public void captureImage(File f) throws VisADException, IOException {
        BufferedImage image = this.IsSlave ? this.RemoteVSlave.getImage() : this.VDisplay.getImage();
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
            FileOutputStream fout = new FileOutputStream(f);
            writer.setOutput(fout);
            IIOImage iio = new IIOImage(image, null, null);
            writer.write(null, iio, param);
            ImageIO.write((RenderedImage)image, "image/jpeg", fout);
            fout.close();
        }
        catch (NoClassDefFoundError err) {
            throw new VisADException("JPEG codec not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSaveString() {
        StringBuffer sb = new StringBuffer();
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            sb.append("# ");
            sb.append(this.Name);
            sb.append(": data information\n");
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                sb.append("id = ");
                sb.append(cellData.getId());
                sb.append('\n');
                sb.append("source = ");
                sb.append(cellData.getSource());
                sb.append('\n');
                sb.append("source type = ");
                sb.append(cellData.getSourceType());
                sb.append('\n');
            }
        }
        sb.append("\n# ");
        sb.append(this.Name);
        sb.append(": display information\n");
        sb.append("dim = ");
        sb.append(this.Dim);
        sb.append('\n');
        sb.append(this.getPartialSaveString());
        return sb.toString();
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        this.setPartialSaveString(save, false);
    }

    public String getPartialSaveString() {
        int mvs;
        StringBuffer sb = new StringBuffer();
        Vector mapVector = null;
        if (this.hasMappings() && (mvs = (mapVector = this.VDisplay.getMapVector()).size()) > 0) {
            sb.append("maps =");
            sb.append(DataUtility.convertMapsToString(mapVector));
            sb.append('\n');
            sb.append("map ranges =");
            for (int i = 0; i < mvs; ++i) {
                double[] range;
                ScalarMap m = (ScalarMap)mapVector.elementAt(i);
                boolean scale = m.getScale(new double[2], range = new double[2], new double[2]);
                if (!scale) continue;
                sb.append(' ');
                sb.append(range[0]);
                sb.append(' ');
                sb.append(range[1]);
            }
            sb.append('\n');
        }
        if (this.hasDisplay()) {
            Control cc;
            int i;
            Vector cv;
            GraphicsModeControl gmc;
            ProjectionControl pc = this.VDisplay.getProjectionControl();
            if (pc != null) {
                sb.append("projection = ");
                sb.append(pc.getSaveString());
            }
            if ((gmc = this.VDisplay.getGraphicsModeControl()) != null) {
                sb.append("graphics mode = ");
                sb.append(gmc.getSaveString());
                sb.append('\n');
            }
            if ((cv = this.VDisplay.getControls(ColorControl.class)) != null) {
                int cvlen = cv.size();
                for (i = 0; i < cvlen; ++i) {
                    cc = (ColorControl)cv.elementAt(i);
                    if (cc == null) continue;
                    sb.append("color = ");
                    sb.append(((BaseColorControl)cc).getSaveString());
                }
            }
            if ((cv = this.VDisplay.getControls(ContourControl.class)) != null) {
                int cvlen = cv.size();
                for (i = 0; i < cvlen; ++i) {
                    cc = (ContourControl)cv.elementAt(i);
                    if (cc == null) continue;
                    sb.append("contour = ");
                    sb.append(((ContourControl)cc).getSaveString());
                    sb.append('\n');
                }
            }
            if ((cv = this.VDisplay.getControls(RangeControl.class)) != null) {
                int cvlen = cv.size();
                for (i = 0; i < cvlen; ++i) {
                    RangeControl rc = (RangeControl)cv.elementAt(i);
                    if (rc == null) continue;
                    sb.append("range = ");
                    sb.append(rc.getSaveString());
                    sb.append('\n');
                }
            }
            if ((cv = this.VDisplay.getControls(AnimationControl.class)) != null) {
                int cvlen = cv.size();
                for (i = 0; i < cvlen; ++i) {
                    AnimationControl ac = (AnimationControl)cv.elementAt(i);
                    if (ac == null) continue;
                    sb.append("anim = ");
                    sb.append(ac.getSaveString());
                    sb.append('\n');
                }
            }
            if ((cv = this.VDisplay.getControls(ValueControl.class)) != null) {
                int cvlen = cv.size();
                for (i = 0; i < cvlen; ++i) {
                    ValueControl vc = (ValueControl)cv.elementAt(i);
                    if (vc == null) continue;
                    sb.append("value = ");
                    sb.append(vc.getSaveString());
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    public void setPartialSaveString(String save, boolean preserveMaps) throws VisADException, RemoteException {
        int len;
        if (this.IsRemote) {
            throw new VisADException("Cannot setSaveString on a remote cell");
        }
        Vector<Integer> ids = new Vector<Integer>();
        Vector<String> sources = new Vector<String>();
        Vector<Integer> types = new Vector<Integer>();
        int dim = -1;
        String mapString = null;
        ScalarMap[] maps = null;
        Vector<Double> mapMins = null;
        Vector<Double> mapMaxs = null;
        String proj = null;
        String mode = null;
        Vector<String> color = new Vector<String>();
        Vector<String> contour = new Vector<String>();
        Vector<String> range = new Vector<String>();
        Vector<String> anim = new Vector<String>();
        Vector<String> selectVal = new Vector<String>();
        SaveStringTokenizer sst = new SaveStringTokenizer(save);
        block12: for (int i = 0; i < sst.keywords.length; ++i) {
            String keyword = sst.keywords[i];
            String value = sst.values[i];
            if (keyword.equalsIgnoreCase("id") || keyword.equalsIgnoreCase("data id") || keyword.equalsIgnoreCase("data_id") || keyword.equalsIgnoreCase("dataid")) {
                try {
                    ids.add(new Integer(value));
                }
                catch (NumberFormatException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                    this.warn("data id value " + value + " is not valid and will be ignored");
                }
                continue;
            }
            if (keyword.equalsIgnoreCase("source") || keyword.equalsIgnoreCase("data source") || keyword.equalsIgnoreCase("data_source") || keyword.equalsIgnoreCase("datasource")) {
                sources.add(value);
                continue;
            }
            if (keyword.equalsIgnoreCase("source type") || keyword.equalsIgnoreCase("source_type") || keyword.equalsIgnoreCase("sourcetype") || keyword.equalsIgnoreCase("data source type") || keyword.equalsIgnoreCase("data_source_type") || keyword.equalsIgnoreCase("datasourcetype")) {
                try {
                    types.add(new Integer(value));
                }
                catch (NumberFormatException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                    this.warn("source type value " + value + " is not valid and will be ignored");
                }
                continue;
            }
            if (keyword.equalsIgnoreCase("filename") || keyword.equalsIgnoreCase("file name") || keyword.equalsIgnoreCase("file_name") || keyword.equalsIgnoreCase("file")) {
                ids.add(new Integer(0));
                sources.add(value);
                types.add(new Integer(1));
                continue;
            }
            if (keyword.equalsIgnoreCase("rmi") || keyword.equalsIgnoreCase("rmi address") || keyword.equalsIgnoreCase("rmi_address") || keyword.equalsIgnoreCase("rmiaddress")) {
                ids.add(new Integer(0));
                sources.add(value);
                types.add(new Integer(3));
                continue;
            }
            if (keyword.equalsIgnoreCase("formula") || keyword.equalsIgnoreCase("equation")) {
                ids.add(new Integer(0));
                sources.add(value);
                types.add(new Integer(2));
                continue;
            }
            if (keyword.equalsIgnoreCase("dim") || keyword.equalsIgnoreCase("dimension")) {
                int d;
                block69: {
                    d = -1;
                    try {
                        d = Integer.parseInt(value);
                    }
                    catch (NumberFormatException exc) {
                        if (!DEBUG) break block69;
                        exc.printStackTrace();
                    }
                }
                if (d > 0 && d < 4) {
                    dim = d;
                    continue;
                }
                this.warn("dimension value " + value + " is not valid and will be ignored");
                continue;
            }
            if (keyword.equalsIgnoreCase("maps") || keyword.equalsIgnoreCase("mappings")) {
                mapString = value;
                continue;
            }
            if (keyword.equalsIgnoreCase("map ranges") || keyword.equalsIgnoreCase("map_ranges") || keyword.equalsIgnoreCase("mapranges")) {
                StringTokenizer st = new StringTokenizer(value);
                mapMins = new Vector<Double>();
                mapMaxs = new Vector<Double>();
                while (st.hasMoreTokens()) {
                    Double d2;
                    Double d1;
                    String s2;
                    String s1;
                    block70: {
                        s1 = st.nextToken();
                        if (!st.hasMoreTokens()) {
                            this.warn("trailing map range min value " + s1 + " has no corresponding max value and will be ignored");
                            continue block12;
                        }
                        s2 = st.nextToken();
                        d1 = null;
                        d2 = null;
                        try {
                            d1 = new Double(s1.equals("NaN") ? Double.NaN : Double.parseDouble(s1));
                            d2 = new Double(s2.equals("NaN") ? Double.NaN : Double.parseDouble(s2));
                        }
                        catch (NumberFormatException exc) {
                            if (!DEBUG) break block70;
                            exc.printStackTrace();
                        }
                    }
                    if (d1 == null || d2 == null) {
                        this.warn("map range min/max pair (" + s1 + ", " + s2 + ") is not valid and will be ignored");
                        continue;
                    }
                    mapMins.add(d1);
                    mapMaxs.add(d2);
                }
                continue;
            }
            if (keyword.equalsIgnoreCase("projection") || keyword.equalsIgnoreCase("proj")) {
                proj = value;
                continue;
            }
            if (keyword.equalsIgnoreCase("graphics mode") || keyword.equalsIgnoreCase("graphics_mode") || keyword.equalsIgnoreCase("graphicsmode") || keyword.equalsIgnoreCase("graphics") || keyword.equalsIgnoreCase("mode")) {
                mode = value;
                continue;
            }
            if (keyword.equalsIgnoreCase("color") || keyword.equalsIgnoreCase("color table") || keyword.equalsIgnoreCase("color_table") || keyword.equalsIgnoreCase("colortable")) {
                color.add(value);
                continue;
            }
            if (keyword.equalsIgnoreCase("contour") || keyword.equalsIgnoreCase("contours") || keyword.equalsIgnoreCase("iso contour") || keyword.equalsIgnoreCase("iso_contour") || keyword.equalsIgnoreCase("isocontour") || keyword.equalsIgnoreCase("iso contours") || keyword.equalsIgnoreCase("iso_contours") || keyword.equalsIgnoreCase("isocontours")) {
                contour.add(value);
                continue;
            }
            if (keyword.equalsIgnoreCase("range") || keyword.equalsIgnoreCase("select range") || keyword.equalsIgnoreCase("select_range") || keyword.equalsIgnoreCase("selectrange")) {
                range.add(value);
                continue;
            }
            if (keyword.equalsIgnoreCase("anim") || keyword.equalsIgnoreCase("animation")) {
                anim.add(value);
                continue;
            }
            if (keyword.equalsIgnoreCase("value") || keyword.equalsIgnoreCase("select value") || keyword.equalsIgnoreCase("select_value") || keyword.equalsIgnoreCase("selectvalue")) {
                selectVal.add(value);
                continue;
            }
            this.warn("keyword " + keyword + " is unknown and will be ignored");
        }
        if (preserveMaps) {
            maps = DataUtility.convertStringToMaps(mapString, this.getData(), true);
            if (maps != null) {
                int lmin = mapMins == null ? -1 : mapMins.size();
                int lmax = mapMaxs == null ? -1 : mapMaxs.size();
                int cmin = 0;
                int cmax = 0;
                Vector mapVector = this.VDisplay.getMapVector();
                for (int j = 0; j < maps.length; ++j) {
                    boolean scale;
                    if (maps[j] == null || !(scale = maps[j].getScale(new double[2], new double[2], new double[2])) || cmin >= lmin || cmax >= lmax) continue;
                    int mapIndex = mapVector.indexOf(maps[j]);
                    if (mapIndex >= 0) {
                        ScalarMap map = (ScalarMap)mapVector.elementAt(mapIndex);
                        map.setRange((Double)mapMins.elementAt(cmin++), (Double)mapMaxs.elementAt(cmax++));
                        continue;
                    }
                    ++cmin;
                    ++cmax;
                }
            }
        } else {
            this.clearCell();
            this.setDimension(dim);
            int ilen = ids.size();
            int slen = sources.size();
            int tlen = types.size();
            if (ilen != slen || ilen != tlen) {
                this.warn("some data object entries are corrupt and will be ignored");
            }
            int len2 = ilen < slen && ilen < tlen ? ilen : (slen < tlen ? slen : tlen);
            this.setDisplayEnabled(false);
            for (int i = 0; i < len2; ++i) {
                int id = (Integer)ids.elementAt(i);
                String source = (String)sources.elementAt(i);
                int type = (Integer)types.elementAt(i);
                this.addDataSource(id, source, type, true);
            }
            this.waitForData();
            maps = DataUtility.convertStringToMaps(mapString, this.getData(), true);
            if (maps != null) {
                int lmin = mapMins == null ? -1 : mapMins.size();
                int lmax = mapMaxs == null ? -1 : mapMaxs.size();
                int cmin = 0;
                int cmax = 0;
                for (int j = 0; j < maps.length; ++j) {
                    ScalarMap sm;
                    boolean scale;
                    if (maps[j] == null || !(scale = (sm = maps[j]).getScale(new double[2], new double[2], new double[2])) || cmin >= lmin || cmax >= lmax) continue;
                    sm.setRange((Double)mapMins.elementAt(cmin++), (Double)mapMaxs.elementAt(cmax++));
                }
                this.setMaps(maps);
            }
            this.setDisplayEnabled(true);
        }
        if (proj != null) {
            ProjectionControl pc = this.VDisplay.getProjectionControl();
            if (pc != null) {
                pc.setSaveString(proj);
            } else if (!preserveMaps) {
                this.warn("display has no ProjectionControl; the provided projection matrix will be ignored");
            }
        }
        if (mode != null) {
            GraphicsModeControl gmc = this.VDisplay.getGraphicsModeControl();
            if (gmc != null) {
                try {
                    gmc.setSaveString(mode);
                }
                catch (VisADException exc) {
                    if (DEBUG && DEBUG_LEVEL >= 3) {
                        exc.printStackTrace();
                    }
                }
            } else if (!preserveMaps) {
                this.warn("display has no GraphicsModeControl; the provided graphics mode settings will be ignored");
            }
        }
        if ((len = color.size()) > 0) {
            for (int i = 0; i < len; ++i) {
                String s = (String)color.elementAt(i);
                ColorControl cc = (ColorControl)this.VDisplay.getControl(ColorControl.class, i);
                if (cc != null) {
                    cc.setSaveString(s);
                    continue;
                }
                if (preserveMaps) continue;
                this.warn("display has no ColorControl #" + (i + 1) + "; " + "the provided color table will be ignored");
            }
        }
        if ((len = contour.size()) > 0) {
            for (int i = 0; i < len; ++i) {
                String s = (String)contour.elementAt(i);
                ContourControl cc = (ContourControl)this.VDisplay.getControl(ContourControl.class, i);
                if (cc != null) {
                    cc.setSaveString(s);
                    continue;
                }
                if (preserveMaps) continue;
                this.warn("display has no ContourControl #" + (i + 1) + "; " + "the provided contour settings will be ignored");
            }
        }
        if ((len = range.size()) > 0) {
            for (int i = 0; i < len; ++i) {
                String s = (String)range.elementAt(i);
                RangeControl rc = (RangeControl)this.VDisplay.getControl(RangeControl.class, i);
                if (rc != null) {
                    rc.setSaveString(s);
                    continue;
                }
                if (preserveMaps) continue;
                this.warn("display has no RangeControl #" + (i + 1) + "; " + "the provided range will be ignored");
            }
        }
        if ((len = anim.size()) > 0) {
            for (int i = 0; i < len; ++i) {
                String s = (String)anim.elementAt(i);
                AnimationControl ac = (AnimationControl)((Object)this.VDisplay.getControl(AnimationControl.class, i));
                if (ac != null) {
                    block71: {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException exc) {
                            if (!DEBUG || DEBUG_LEVEL < 3) break block71;
                            exc.printStackTrace();
                        }
                    }
                    ac.setSaveString(s);
                    continue;
                }
                if (preserveMaps) continue;
                this.warn("display has no AnimationControl #" + (i + 1) + "; " + "the provided animation settings will be ignored");
            }
        }
        if ((len = selectVal.size()) > 0) {
            for (int i = 0; i < len; ++i) {
                String s = (String)selectVal.elementAt(i);
                ValueControl vc = (ValueControl)((Object)this.VDisplay.getControl(ValueControl.class, i));
                if (vc != null) {
                    vc.setSaveString(s);
                    continue;
                }
                if (preserveMaps) continue;
                this.warn("display has no ValueControl #" + (i + 1) + "; " + "the provided value will be ignored");
            }
        }
    }

    public void addVar(String name, ThingReference tr) throws VisADException {
        this.fm.createVar(name, tr);
    }

    private void warn(String s) {
        System.err.println(this.Name + ": Warning: " + s);
    }

    void refresh() {
        this.validate();
        this.repaint();
    }

    protected void setErrors(String[] errors, boolean notify) {
        block4: {
            if (Util.arraysEqual(this.Errors, errors)) {
                return;
            }
            this.Errors = errors;
            this.updateDisplay();
            if (notify) {
                try {
                    this.sendMessage(5, null, BasicSSCell.stringsToTuple(errors));
                }
                catch (RemoteException exc) {
                    if (!DEBUG) break block4;
                    exc.printStackTrace();
                }
            }
        }
    }

    private void initDisplayPanel() {
        this.VDPanel = this.IsSlave ? this.RemoteVSlave.getComponent() : this.VDisplay.getComponent();
    }

    void updateDisplay(boolean hasDisplay) {
        this.HasDisplay = hasDisplay;
        this.updateDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDisplay() {
        int len;
        if (!this.DisplayEnabled) {
            return;
        }
        if (this.WaitPanel == null) {
            this.WaitPanel = new JPanel();
            this.WaitPanel.setBackground(Color.black);
            this.WaitPanel.setLayout(new BoxLayout(this.WaitPanel, 0));
            this.WaitPanel.add(Box.createHorizontalGlue());
            this.WaitPanel.add(new JLabel("Please wait..."));
            this.WaitPanel.add(Box.createHorizontalGlue());
        }
        final Vector<String> e = new Vector<String>();
        if (this.Errors == null) {
            Vector vector = this.CellData;
            synchronized (vector) {
                int len2 = this.CellData.size();
                for (int i = 0; i < len2; ++i) {
                    SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                    String varName = cellData.getVariableName();
                    String[] errors = cellData.getErrors();
                    if (errors == null) continue;
                    for (int j = 0; j < errors.length; ++j) {
                        e.add(varName + ": " + errors[j]);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.Errors.length; ++i) {
                e.add(this.Errors[i]);
            }
        }
        JComponent errorCanvas = (len = e.size()) == 0 ? null : new JComponent(){

            public void paint(Graphics g) {
                g.setColor(Color.white);
                String s = (len == 1 ? "An error" : "Errors") + " occurred while computing this cell:";
                g.drawString(s, 8, 20);
                for (int i = 0; i < len; ++i) {
                    s = (String)e.elementAt(i);
                    g.drawString(s, 8, 15 * i + 50);
                }
            }
        };
        final JComponent ec = errorCanvas;
        Util.invoke(true, DEBUG, new Runnable(){

            public void run() {
                boolean hasPanel;
                Component[] c = BasicSSCell.this.getComponents();
                boolean bl = hasPanel = c.length > 0 && c[0] == BasicSSCell.this.VDPanel;
                if (BasicSSCell.this.Loading > 0) {
                    BasicSSCell.this.removeAll();
                    BasicSSCell.this.add(BasicSSCell.this.WaitPanel);
                } else if (ec != null) {
                    BasicSSCell.this.removeAll();
                    BasicSSCell.this.add(ec);
                } else if (BasicSSCell.this.HasDisplay) {
                    if (!hasPanel) {
                        BasicSSCell.this.removeAll();
                        BasicSSCell.this.add(BasicSSCell.this.VDPanel);
                    }
                } else {
                    BasicSSCell.this.removeAll();
                }
                BasicSSCell.this.refresh();
            }
        });
    }

    private void setDisplayEnabled(boolean value) {
        if (value == this.DisplayEnabled) {
            return;
        }
        this.DisplayEnabled = value;
        if (this.DisplayEnabled) {
            this.updateDisplay();
        }
    }

    private void beginWait(boolean update) {
        ++this.Loading;
        if (update) {
            this.updateDisplay();
        }
    }

    private void endWait(boolean update) {
        --this.Loading;
        if (update) {
            this.updateDisplay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisplayListener(DisplayListener d) {
        Vector vector = this.DListen;
        synchronized (vector) {
            if (!this.DListen.contains(d)) {
                if (this.IsSlave) {
                    this.RemoteVSlave.addDisplayListener(d);
                } else {
                    this.VDisplay.addDisplayListener(d);
                }
                this.DListen.add(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisplayListener(DisplayListener d) {
        Vector vector = this.DListen;
        synchronized (vector) {
            if (this.DListen.contains(d)) {
                if (this.IsSlave) {
                    this.RemoteVSlave.removeDisplayListener(d);
                } else {
                    this.VDisplay.removeDisplayListener(d);
                }
                this.DListen.remove(d);
            }
        }
    }

    private void attachListeners() {
        int len = this.DListen.size();
        if (this.IsSlave) {
            for (int i = 0; i < len; ++i) {
                DisplayListener l = (DisplayListener)this.DListen.elementAt(i);
                this.RemoteVSlave.addDisplayListener(l);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                DisplayListener l = (DisplayListener)this.DListen.elementAt(i);
                this.VDisplay.addDisplayListener(l);
            }
        }
    }

    private void detachListeners() {
        int len = this.DListen.size();
        if (this.IsSlave) {
            for (int i = 0; i < len; ++i) {
                DisplayListener l = (DisplayListener)this.DListen.elementAt(i);
                this.RemoteVSlave.removeDisplayListener(l);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                DisplayListener l = (DisplayListener)this.DListen.elementAt(i);
                this.VDisplay.removeDisplayListener(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSSCellListener(SSCellListener l) {
        Vector vector = this.SListen;
        synchronized (vector) {
            if (!this.SListen.contains(l)) {
                this.SListen.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSSCellListener(SSCellListener l) {
        Vector vector = this.SListen;
        synchronized (vector) {
            this.SListen.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllSSCellListeners() {
        Vector vector = this.SListen;
        synchronized (vector) {
            this.SListen.removeAllElements();
        }
    }

    void notifySSCellListeners(int changeType) {
        this.notifySSCellListeners(changeType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySSCellListeners(int changeType, String varName) {
        SSCellListener[] l;
        int len;
        SSCellChangeEvent e = new SSCellChangeEvent(this, changeType, varName);
        Vector vector = this.SListen;
        synchronized (vector) {
            len = this.SListen.size();
            l = new SSCellListener[len];
            for (int i = 0; i < len; ++i) {
                l[i] = (SSCellListener)this.SListen.elementAt(i);
            }
        }
        for (int i = 0; i < len; ++i) {
            l[i].ssCellChanged(e);
        }
    }

    public String getName() {
        return this.Name;
    }

    public boolean isRemote() {
        return this.IsRemote;
    }

    public boolean isSlave() {
        return this.IsSlave;
    }

    public int getRemoteId() {
        return this.CollabID;
    }

    public FormulaManager getFormulaManager() {
        return this.fm;
    }

    public DisplayImpl getDisplay() {
        return this.VDisplay;
    }

    public RemoteDisplay getRemoteDisplay() {
        return this.RemoteVDisplay;
    }

    public ScalarMap[] getMaps() {
        Vector mapVector;
        block8: {
            mapVector = null;
            if (this.IsSlave) {
                try {
                    mapVector = this.RemoteVDisplay.getMapVector();
                }
                catch (VisADException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                    break block8;
                }
                catch (RemoteException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                    break block8;
                }
            }
            if (this.VDisplay != null) {
                mapVector = this.VDisplay.getMapVector();
            }
        }
        int len = mapVector == null ? 0 : mapVector.size();
        ScalarMap[] maps = len > 0 ? new ScalarMap[len] : null;
        for (int i = 0; i < len; ++i) {
            maps[i] = (ScalarMap)mapVector.elementAt(i);
        }
        return maps;
    }

    public int getDimension() {
        return this.Dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data getData(String varName) {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.getCellDataByName(varName);
        }
        return cellData == null ? null : cellData.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data[] getData() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            Data[] data = new Data[len];
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                data[i] = cellData.getData();
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataReference getReference(String varName) {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.getCellDataByName(varName);
        }
        return cellData == null ? null : cellData.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataReferenceImpl[] getReferences() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            DataReferenceImpl[] refs = new DataReferenceImpl[len];
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                refs[i] = cellData.getReference();
            }
            return refs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDataReference getRemoteReference(String varName) {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.getCellDataByName(varName);
        }
        return cellData == null ? null : cellData.getRemoteReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDataReference[] getRemoteReferences() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            RemoteDataReference[] remoteRefs = new RemoteDataReference[len];
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                remoteRefs[i] = cellData.getRemoteReference();
            }
            return remoteRefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataSourceType(String varName) {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.getCellDataByName(varName);
        }
        return cellData == null ? -1 : cellData.getSourceType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getDataSourceTypes() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            int[] types = new int[len];
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                types[i] = cellData.getSourceType();
            }
            return types;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataSource(String varName) {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.getCellDataByName(varName);
        }
        return cellData == null ? null : cellData.getSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDataSources() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            String[] sources = new String[len];
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                sources[i] = cellData.getSource();
            }
            return sources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstVariableName() {
        String varName = null;
        Vector vector = this.CellData;
        synchronized (vector) {
            if (this.CellData.size() > 0) {
                SSCellData cellData = (SSCellData)this.CellData.firstElement();
                varName = cellData.getVariableName();
            }
        }
        return varName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastVariableName() {
        String varName = null;
        Vector vector = this.CellData;
        synchronized (vector) {
            if (this.CellData.size() > 0) {
                SSCellData cellData = (SSCellData)this.CellData.lastElement();
                varName = cellData.getVariableName();
            }
        }
        return varName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVariableNames() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            String[] varNames = new String[len];
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                varNames[i] = cellData.getVariableName();
            }
            return varNames;
        }
    }

    public int getDataCount() {
        return this.CellData.size();
    }

    public boolean hasData() {
        return this.CellData.size() > 0;
    }

    public boolean hasDisplay() {
        return this.HasDisplay;
    }

    public boolean hasMappings() {
        if (this.IsRemote) {
            Vector v;
            block5: {
                v = null;
                try {
                    v = this.RemoteVDisplay.getMapVector();
                }
                catch (VisADException exc) {
                    if (DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!DEBUG) break block5;
                    exc.printStackTrace();
                }
            }
            return v != null && !v.isEmpty();
        }
        return this.HasMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean othersDepend(String varName) {
        SSCellData cellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            cellData = this.getCellDataByName(varName);
        }
        return cellData.othersDepend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean othersDepend() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int len = this.CellData.size();
            for (int i = 0; i < len; ++i) {
                SSCellData cellData = (SSCellData)this.CellData.elementAt(i);
                if (!cellData.othersDepend()) continue;
                return true;
            }
            return false;
        }
    }

    public static void createVar(String name, ThingReference tr) throws VisADException {
        defaultFM.createVar(name, tr);
    }

    public void addSSCellChangeListener(SSCellListener l) {
        this.addSSCellListener(l);
    }

    public void removeListener(SSCellListener l) {
        this.removeSSCellListener(l);
    }

    public void removeAllListeners() {
        this.removeAllSSCellListeners();
    }

    public void setSSCellString(String save) throws VisADException, RemoteException {
        this.setSaveString(save);
    }

    public String getSSCellString() {
        return this.getSaveString();
    }

    public void saveData(File f, boolean netcdf) throws BadFormException, IOException, VisADException, RemoteException {
        Form form = netcdf ? new Plain() : new VisADForm();
        this.saveData(this.getFirstVariableName(), f.getPath(), form);
    }

    public void saveData(File f, Form form) throws BadFormException, IOException, VisADException, RemoteException {
        this.saveData(this.getFirstVariableName(), f.getPath(), form);
    }

    public void setData(Data data) throws VisADException, RemoteException {
        this.removeAllReferences();
        this.addData(data);
    }

    public void setFormula(String f) throws VisADException, RemoteException {
        this.removeAllReferences();
        this.addDataSource(f, 2);
    }

    public void waitForFormula() throws VisADException, RemoteException {
        this.waitForData();
    }

    public DataReferenceImpl getDataRef() {
        return this.getDataCount() > 0 ? (DataReferenceImpl)this.getReference(this.getFirstVariableName()) : null;
    }

    public RemoteDataReferenceImpl getRemoteDataRef() {
        return this.getDataCount() > 0 ? (RemoteDataReferenceImpl)this.getRemoteReference(this.getFirstVariableName()) : null;
    }

    public URL getFileURL() {
        URL url;
        block3: {
            url = null;
            String varName = this.getFirstVariableName();
            if (this.getDataCount() > 0 && this.getDataSourceType(varName) == 1) {
                try {
                    url = new URL(this.getDataSource(varName));
                }
                catch (MalformedURLException exc) {
                    if (!DEBUG || DEBUG_LEVEL < 3) break block3;
                    exc.printStackTrace();
                }
            }
        }
        return url;
    }

    public String getFilename() {
        String filename = "";
        String varName = this.getFirstVariableName();
        if (this.getDataCount() > 0 && this.getDataSourceType(varName) == 1) {
            filename = this.getDataSource(varName);
        }
        return filename;
    }

    public String getRMIAddress() {
        String rmi = null;
        String varName = this.getFirstVariableName();
        if (this.getDataCount() > 0 && this.getDataSourceType(varName) == 3) {
            rmi = this.getDataSource(varName);
        }
        return rmi;
    }

    public String getFormula() {
        String formula = "";
        String varName = this.getFirstVariableName();
        if (this.getDataCount() > 0 && this.getDataSourceType(varName) == 2) {
            formula = this.getDataSource(varName);
        }
        return formula;
    }

    public void loadData(URL u) throws VisADException, RemoteException {
        this.addDataSource(u.toString(), 1);
    }

    public void loadData(String s) throws VisADException, RemoteException {
        this.addDataSource(s, 1);
    }

    public void loadRMI(String s) throws VisADException, RemoteException {
        this.addDataSource(s, 3);
    }

    public void setDimension(boolean twoD, boolean java2d) throws VisADException, RemoteException {
        if (!twoD && java2d) {
            return;
        }
        int dim = !twoD && !java2d ? 1 : (twoD && java2d ? 2 : 3);
        this.setDimension(dim);
    }

    public boolean hasFormula() {
        return this.getDataCount() > 0 && this.getDataSourceType(this.getFirstVariableName()) == 2;
    }

    public DataReference getReference() {
        return this.getDataCount() > 0 ? this.getReference(this.getFirstVariableName()) : null;
    }

    public static Tuple stringsToTuple(String[] s) {
        return DataUtility.stringsToTuple(s, DEBUG);
    }

    public static String[] tupleToStrings(Tuple t) {
        return DataUtility.tupleToStrings(t, DEBUG);
    }

    public static DataImpl makeLocal(Data data) {
        return DataUtility.makeLocal(data, DEBUG && DEBUG_LEVEL >= 3);
    }

    public static boolean arraysEqual(Object[] o1, Object[] o2) {
        return Util.arraysEqual(o1, o2);
    }

    public static void invoke(boolean wait, Runnable r) {
        Util.invoke(wait, DEBUG, r);
    }

    static {
        CanDo3D = BasicSSCell.enable3D();
        defaultFM = FormulaUtil.createStandardManager();
        messages = new String[]{"ADD_DATA", "ADD_SOURCE", "REMOVE_DATA", "SET_MAPS", "SET_DIM", "SET_ERRORS", "UPDATE_DATA", "UPDATE_DEPENDENCIES", "STATUS"};
    }
}

