/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.util.Date;
import net.jcip.annotations.ThreadSafe;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;

@ThreadSafe
public enum CollectionUpdater {
    INSTANCE;

    private static final Logger logger;
    private static final String DCM_NAME = "dcm";
    private static final long startupWait = 10000L;
    private static boolean disabled;
    private Scheduler scheduler = null;
    private boolean failed = false;
    private boolean isTdm = false;

    public void setTdm(boolean tdm) {
        this.isTdm = tdm;
    }

    public boolean isTdm() {
        return this.isTdm;
    }

    private CollectionUpdater() {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
            this.scheduler.getListenerManager().addSchedulerListener(new MySchedListener());
        }
        catch (SchedulerException e) {
            this.failed = true;
            throw new RuntimeException("quartz scheduler failed to initialize", e);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void scheduleTasks(FeatureCollectionConfig config, CollectionManager manager) {
        FeatureCollectionConfig.UpdateConfig updateConfig;
        if (disabled || this.failed) {
            return;
        }
        FeatureCollectionConfig.UpdateConfig updateConfig2 = updateConfig = this.isTdm ? config.tdmConfig : config.updateConfig;
        if (updateConfig == null) {
            return;
        }
        String jobName = manager.getCollectionName();
        JobDataMap map = new JobDataMap();
        map.put(DCM_NAME, (Object)manager);
        JobDetail updateJob = JobBuilder.newJob(UpdateCollectionJob.class).withIdentity(jobName, "UpdateCollection").storeDurably().usingJobData(map).build();
        try {
            this.scheduler.addJob(updateJob, false);
        }
        catch (SchedulerException e) {
            logger.error("cronExecutor failed to schedule startup Job for " + config, e);
            return;
        }
        if (updateConfig.startup) {
            Date runTime = new Date(new Date().getTime() + 10000L);
            SimpleTrigger startupTrigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, "startup").startAt(runTime).forJob(updateJob).build();
            try {
                this.scheduler.scheduleJob(startupTrigger);
                logger.info("Schedule startup scan for {} at {}", (Object)config.spec, (Object)runTime);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule startup Job for " + config, e);
                return;
            }
        }
        if (updateConfig.rescan != null) {
            CronTrigger rescanTrigger = TriggerBuilder.newTrigger().withIdentity(jobName, "rescan").withSchedule(CronScheduleBuilder.cronSchedule(updateConfig.rescan)).forJob(updateJob).build();
            try {
                this.scheduler.scheduleJob(rescanTrigger);
                logger.info("Schedule recurring scan for {} cronExpr={}", (Object)config.spec, (Object)updateConfig.rescan);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule cron Job", e);
            }
        }
        FeatureCollectionConfig.ProtoConfig pconfig = config.protoConfig;
        if (pconfig.change != null) {
            JobDataMap pmap = new JobDataMap();
            pmap.put(DCM_NAME, (Object)manager);
            JobDetail protoJob = JobBuilder.newJob(ChangeProtoJob.class).withIdentity(jobName, "UpdateProto").usingJobData(pmap).storeDurably().build();
            try {
                CronTrigger protoTrigger = TriggerBuilder.newTrigger().withIdentity(jobName, "rereadProto").withSchedule(CronScheduleBuilder.cronSchedule(pconfig.change)).build();
                this.scheduler.scheduleJob(protoJob, protoTrigger);
                logger.info("Schedule Reread Proto for {}", (Object)jobName);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule RereadProtoJob", e);
            }
        }
    }

    public void shutdown() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown(true);
            Logger logServerStartup = LoggerFactory.getLogger("serverStartup");
            logServerStartup.info("Scheduler shutdown");
        }
        catch (SchedulerException e) {
            logger.error("Scheduler failed to shutdown", e);
            this.scheduler = null;
        }
    }

    public void triggerUpdate(String collectionName, String triggerType) {
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(collectionName, triggerType).forJob(collectionName, "UpdateCollection").startNow().build();
        try {
            logger.debug("Trigger Update for {} type= {}", (Object)collectionName, (Object)triggerType);
            this.scheduler.scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            logger.error("triggerUpdate failed", e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(CollectionUpdater.class);
        disabled = false;
    }

    public static class ChangeProtoJob
    implements Job {
        @Override
        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                CollectionManager manager = (CollectionManager)context.getJobDetail().getJobDataMap().get(CollectionUpdater.DCM_NAME);
                if (manager == null) {
                    logger.error("Update resetProto failed: no manager object on {}", context);
                    return;
                }
                logger.debug("Update resetProto for {}", (Object)manager.getCollectionName());
                manager.resetProto();
            }
            catch (Throwable e) {
                logger.error("ChangeProtoJob.execute failed", e);
            }
        }
    }

    public static class UpdateCollectionJob
    implements Job {
        @Override
        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                CollectionManager manager = (CollectionManager)context.getJobDetail().getJobDataMap().get(CollectionUpdater.DCM_NAME);
                logger.debug("Update for {} trigger = {}", (Object)manager.getCollectionName(), (Object)context.getTrigger().getKey());
                String groupName = context.getTrigger().getKey().getGroup();
                if (groupName.equals("nocheck")) {
                    manager.updateNocheck();
                } else {
                    manager.scan(true);
                }
            }
            catch (Throwable e) {
                logger.error("UpdateCollectionJob.execute failed", e);
            }
        }
    }

    private class MySchedListener
    implements SchedulerListener {
        private MySchedListener() {
        }

        @Override
        public void jobScheduled(Trigger trigger) {
            logger.debug("jobScheduled {}", trigger);
        }

        @Override
        public void jobUnscheduled(TriggerKey triggerKey) {
            logger.debug("jobUnscheduled {}", triggerKey);
        }

        @Override
        public void triggerFinalized(Trigger trigger) {
            logger.debug("triggerFinalized {}", trigger);
        }

        @Override
        public void triggerPaused(TriggerKey triggerKey) {
            logger.debug("triggerPaused {}", triggerKey);
        }

        @Override
        public void triggersPaused(String s) {
            logger.debug("triggersPaused {}", (Object)s);
        }

        @Override
        public void triggerResumed(TriggerKey triggerKey) {
            logger.debug("triggerResumed {}", triggerKey);
        }

        @Override
        public void triggersResumed(String s) {
            logger.debug("triggersResumed {}", (Object)s);
        }

        @Override
        public void jobAdded(JobDetail jobDetail) {
            logger.debug("jobAdded {}", jobDetail);
        }

        @Override
        public void jobDeleted(JobKey jobKey) {
            logger.debug("jobDeleted {}", jobKey);
        }

        @Override
        public void jobPaused(JobKey jobKey) {
            logger.debug("jobPaused {}", jobKey);
        }

        @Override
        public void jobsPaused(String s) {
            logger.debug("jobPaused {}", (Object)s);
        }

        @Override
        public void jobResumed(JobKey jobKey) {
            logger.debug("jobsResumed {}", jobKey);
        }

        @Override
        public void jobsResumed(String s) {
            logger.debug("jobsResumed {}", (Object)s);
        }

        @Override
        public void schedulerError(String s, SchedulerException e) {
            logger.debug("schedulerError {} {}", (Object)s, (Object)e);
        }

        @Override
        public void schedulerInStandbyMode() {
        }

        @Override
        public void schedulerStarted() {
        }

        @Override
        public void schedulerShutdown() {
        }

        @Override
        public void schedulerShuttingdown() {
        }

        @Override
        public void schedulingDataCleared() {
        }
    }
}

