/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5;

import java.net.URL;
import java.rmi.RemoteException;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.Data;
import visad.DataImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.Set;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.hdf5.HDF5AdapterException;
import visad.data.hdf5.HDF5DataAdaptable;
import visad.data.hdf5.HDF5DatasetAdapted;
import visad.data.hdf5.HDF5FileAdapted;
import visad.data.hdf5.HDF5GroupAdapted;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Form
extends Form
implements FormFileInformer {
    public HDF5Form() {
        this("HDF5 Data");
    }

    public HDF5Form(String name) {
        super(name);
    }

    public boolean isThisType(String name) {
        boolean retVal = false;
        try {
            retVal = H5.H5Fis_hdf5((String)name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public boolean isThisType(byte[] block) {
        int firstByte = new Byte(block[0]).intValue();
        if (firstByte != 137) {
            return false;
        }
        String bytes2to4 = new String(block, 1, 4);
        return bytes2to4.startsWith("HDF");
    }

    public String[] getDefaultSuffixes() {
        String[] suffs = new String[]{"hdf", "h5"};
        return suffs;
    }

    public FormNode getForms(Data data) {
        return this;
    }

    public DataImpl open(String file_path) throws VisADException, RemoteException {
        HDF5FileAdapted file = null;
        try {
            file = new HDF5FileAdapted(file_path, 0, -2);
        }
        catch (HDF5Exception e) {
            System.err.println((Object)e);
        }
        return this.getFileData(file);
    }

    public DataImpl open(URL url) throws VisADException {
        throw new UnimplementedException("HDF5Form.open( URL )");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("HDF5Form.add( String, Data, boolean )");
    }

    public void save(String filename, Data data, boolean replace) throws BadFormException, RemoteException, VisADException {
        int fid = 0;
        boolean did = false;
        boolean gid = false;
        try {
            fid = H5.H5Fcreate((String)filename, (int)2, (int)-2, (int)-2);
        }
        catch (HDF5Exception e) {
            throw new HDF5AdapterException("HDF5Form.save() failed: cannot create file " + filename);
        }
        catch (NoClassDefFoundError e) {
            throw new HDF5AdapterException("HDF5Form.save() failed: cannot create file " + filename);
        }
        try {
            this.save(fid, data, 0, 0);
        }
        catch (BadFormException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (VisADException e) {
            throw e;
        }
        catch (HDF5Exception e) {
            throw new HDF5AdapterException(e.toString());
        }
        finally {
            try {
                H5.H5Fclose((int)fid);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(int pid, Data data, int level, int index) throws BadFormException, RemoteException, VisADException, HDF5Exception {
        if (data instanceof Tuple) {
            int g_idx = 0;
            int new_pid = 0;
            Data d = null;
            Tuple tuple = (Tuple)data;
            String gname = "Group" + index + "at" + level;
            if (level == 0) {
                new_pid = pid;
                g_idx = -1;
            } else {
                new_pid = H5.H5Gcreate((int)pid, (String)gname, (int)-1);
            }
            int n = tuple.getDimension();
            for (int i = 0; i < n; ++i) {
                d = tuple.getComponent(i);
                this.save(new_pid, d, level + 1, g_idx++);
            }
        } else if (data instanceof Field) {
            Field field = (Field)data;
            RealType[] rTypes = ((FunctionType)field.getType()).getRealComponents();
            Set dset = field.getDomainSet();
            if (!(dset instanceof GriddedSet) || rTypes == null) {
                return;
            }
            GriddedSet domain = (GriddedSet)dset;
            RealType rangeType = rTypes[0];
            int sid = 0;
            int did = 0;
            int tid = 0;
            int l = domain.getLength();
            int[] ddims = domain.getLengths();
            int rank = ddims.length;
            long[] dims = new long[rank];
            for (int i = 0; i < rank; ++i) {
                dims[i] = ddims[i];
            }
            sid = H5.H5Screate_simple((int)rank, (long[])dims, null);
            int number_of_range_components = 1;
            number_of_range_components = field.isFlatField() ? ((FlatField)field).getRangeDimension() : field.getDefaultRangeUnits().length;
            float[] rangeValues = new float[l];
            float[][] rValue = field.getFloats(false);
            if (number_of_range_components == 1) {
                for (int i = 0; i < l; ++i) {
                    rangeValues[i] = rValue[0][i];
                }
                try {
                    did = H5.H5Dcreate((int)pid, (String)rangeType.getName(), (int)H5.J2C((int)55), (int)sid, (int)-2);
                    H5.H5Dwrite((int)did, (int)H5.J2C((int)55), (int)-2, (int)-2, (int)-2, (Object)rangeValues);
                }
                finally {
                    H5.H5Dclose((int)did);
                    H5.H5Sclose((int)sid);
                }
            } else {
                float[][] fValue = new float[l][number_of_range_components];
                for (int i = 0; i < l; ++i) {
                    for (int j = 0; j < number_of_range_components; ++j) {
                        fValue[i][j] = rValue[j][i];
                    }
                }
                try {
                    tid = H5.H5Tcreate((int)6, (int)(number_of_range_components * 4));
                    for (int j = 0; j < number_of_range_components; ++j) {
                        rangeType = rTypes[j];
                        H5.H5Tinsert((int)tid, (String)rangeType.getName(), (long)(j * 4), (int)H5.J2C((int)55));
                    }
                    String dname = "Compound" + index + "at" + level;
                    did = H5.H5Dcreate((int)pid, (String)dname, (int)tid, (int)sid, (int)-2);
                    H5.H5Dwrite((int)did, (int)tid, (int)sid, (int)-2, (int)-2, (Object)fValue);
                }
                finally {
                    H5.H5Tclose((int)tid);
                    H5.H5Dclose((int)did);
                    H5.H5Sclose((int)sid);
                }
            }
        } else if (data instanceof Text) {
            Text text = (Text)data;
            String text_value = text.getValue();
            TextType tt = (TextType)text.getType();
            String text_name = tt.getName();
            int max_length = text_value.length();
            long[] dims_str = new long[]{1L};
            int dataspace = H5.H5Screate_simple((int)1, (long[])dims_str, null);
            int datatype = H5.H5Tcopy((int)H5.J2C((int)15));
            H5.H5Tset_size((int)datatype, (int)max_length);
            H5.H5Tset_strpad((int)datatype, (int)1);
            int dataset = H5.H5Dcreate((int)pid, (String)text_name, (int)datatype, (int)dataspace, (int)-2);
            byte[][] bnotes = new byte[1][max_length];
            bnotes[0] = text_value.getBytes();
            H5.H5Dwrite((int)dataset, (int)datatype, (int)-2, (int)-2, (int)-2, (Object)bnotes);
            H5.H5Dclose((int)dataset);
            bnotes = null;
        }
    }

    public MathType getMathType(HDF5FileAdapted file) throws VisADException, RemoteException {
        MathType mathType = null;
        HDF5Object data = null;
        int n_structs = file.getObjectCount();
        if (n_structs <= 0) {
            throw new HDF5AdapterException("no data object in file: " + file.getName());
        }
        MathType[] types = new MathType[n_structs];
        for (int i = 0; i < n_structs; ++i) {
            Object obj = file.getDataObject(i);
            if (obj instanceof HDF5GroupAdapted) {
                data = (HDF5GroupAdapted)obj;
            } else if (obj instanceof HDF5DatasetAdapted) {
                data = (HDF5DatasetAdapted)obj;
            }
            types[i] = mathType = data.getMathType();
        }
        TupleType t_type = new TupleType(types);
        return t_type;
    }

    public DataImpl getFileData(HDF5FileAdapted file) throws VisADException, RemoteException {
        Object data = null;
        Object h5Data = null;
        int n_structs = file.getObjectCount();
        if (n_structs <= 0) {
            throw new HDF5AdapterException("no data object in file: " + file.getName());
        }
        HDF5DataAdaptable[] datas = new HDF5DataAdaptable[n_structs];
        int ndatas = 0;
        for (int i = 0; i < n_structs; ++i) {
            Object obj = file.getDataObject(i);
            if (obj instanceof HDF5GroupAdapted) {
                datas[ndatas++] = (HDF5GroupAdapted)obj;
                continue;
            }
            if (!(obj instanceof HDF5DatasetAdapted)) continue;
            datas[ndatas++] = (HDF5DatasetAdapted)obj;
        }
        return this.assembleStructs(datas);
    }

    private DataImpl assembleStructs(HDF5DataAdaptable[] h_datas) throws VisADException, RemoteException {
        DataImpl fileData = null;
        int n_structs = h_datas.length;
        if (n_structs == 1) {
            return this.getVisADDataObject(h_datas[0]);
        }
        boolean types_equal = true;
        MathType first_type = null;
        MathType[] types = new MathType[n_structs];
        Data[] datas = new DataImpl[n_structs];
        datas[0] = this.getVisADDataObject(h_datas[0]);
        types[0] = datas[0].getType();
        first_type = types[0];
        for (int i = 1; i < n_structs; ++i) {
            datas[i] = this.getVisADDataObject(h_datas[i]);
            types[i] = datas[i].getType();
            types_equal = types[i].equals(first_type);
        }
        if (types_equal) {
            RealType struct_id = RealType.getRealType("struct_id");
            Integer1DSet domain = new Integer1DSet((MathType)struct_id, n_structs);
            FunctionType fType = new FunctionType(struct_id, first_type);
            FieldImpl field = new FieldImpl(fType, domain);
            for (int i = 0; i < n_structs; ++i) {
                field.setSample(i, datas[i]);
            }
            fileData = field;
        } else {
            TupleType t_type = new TupleType(types);
            fileData = new Tuple(t_type, datas, false);
        }
        return fileData;
    }

    public DataImpl getVisADDataObject(HDF5DataAdaptable h_data) throws VisADException, RemoteException {
        return h_data.getAdaptedData();
    }
}

