/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeException;
import edu.wisc.ssec.mcidas.adde.AddePointDataReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.DoubleStringTuple;
import visad.DoubleTuple;
import visad.Field;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarType;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.jmet.MetUnits;
import visad.python.JPythonMethods;
import visad.util.DataUtility;

public class PointDataAdapter {
    AddePointDataReader reader;
    FieldImpl field = null;
    private boolean debug = false;
    private boolean useAliases = true;
    private boolean makeUniqueNames = false;
    private static final String TEXT_EXT = "[Text]";

    public PointDataAdapter(String addePointRequest) throws VisADException {
        this(addePointRequest, true);
    }

    public PointDataAdapter(String addePointRequest, boolean useAliases) throws VisADException {
        this(addePointRequest, useAliases, false);
    }

    public PointDataAdapter(String addePointRequest, boolean useAliases, boolean makeUniqueNames) throws VisADException {
        try {
            this.reader = new AddePointDataReader(addePointRequest);
            this.debug = addePointRequest.indexOf("debug=true") > 0;
            this.useAliases = useAliases;
            this.makeUniqueNames = makeUniqueNames;
        }
        catch (AddeException excp) {
            throw new VisADException("Problem accessing data");
        }
        this.makeField();
    }

    private void makeField() throws VisADException {
        TupleType rangeType;
        int[] scalingFactors;
        String[] params;
        String[] units;
        int[][] data;
        try {
            data = this.reader.getData(1);
            units = this.reader.getUnits();
            params = this.reader.getParams();
            scalingFactors = this.reader.getScales();
        }
        catch (AddeException ae) {
            throw new VisADException("Error retrieving data info");
        }
        int numObs = data.length;
        if (numObs == 0) {
            throw new VisADException("No data available");
        }
        if (this.debug) {
            System.out.println("Number of observations = " + numObs);
        }
        RealType domainType = RealType.getRealType("index");
        Integer1DSet domain = new Integer1DSet((MathType)domainType, numObs);
        MetUnits unitTranslator = new MetUnits();
        int numParams = params.length;
        if (this.debug) {
            System.out.println("Number of parameters = " + numParams);
        }
        ScalarType[] types = new ScalarType[numParams];
        Unit[] defaultUnits = new Unit[numParams];
        Vector<Unit> usedUnits = new Vector<Unit>();
        boolean noText = true;
        int numDouble = 0;
        int numString = 0;
        ArrayList<RealType> realTypes = new ArrayList<RealType>();
        ArrayList<TextType> textTypes = new ArrayList<TextType>();
        for (int i = 0; i < numParams; ++i) {
            String name = params[i];
            if (units[i].equalsIgnoreCase("CHAR")) {
                TextType textType;
                noText = false;
                ++numString;
                if (this.debug) {
                    System.out.println(params[i] + " has units of CHAR");
                }
                if ((textType = TextType.getTextType(params[i])) == null && this.makeUniqueNames) {
                    textType = TextType.getTextType(params[i] + TEXT_EXT);
                }
                if (textType == null) {
                    throw new VisADException("can't create TextType for " + params[i]);
                }
                textTypes.add(textType);
                types[i] = textType;
                defaultUnits[i] = null;
                continue;
            }
            Unit unit = null;
            try {
                unit = !name.equalsIgnoreCase("LON") ? Parser.parse(MetUnits.makeSymbol(units[i])) : Parser.parse("degrees_west");
            }
            catch (NoSuchUnitException ne) {
                if (this.debug) {
                    System.out.println("Unknown unit: " + units[i] + " for " + name);
                }
                unit = null;
            }
            catch (ParseException pe) {
                unit = null;
            }
            defaultUnits[i] = unit;
            if (this.debug) {
                System.out.println(params[i] + " has units " + unit);
                System.out.println("scaling factor = " + scalingFactors[i]);
            }
            ++numDouble;
            types[i] = this.getQuantity(params[i], unit);
            realTypes.add((RealType)types[i]);
        }
        if (noText) {
            RealType[] newTypes = new RealType[types.length];
            for (int i = 0; i < types.length; ++i) {
                newTypes[i] = (RealType)types[i];
            }
            rangeType = new RealTupleType(newTypes);
        } else {
            rangeType = DoubleStringTuple.makeTupleType(realTypes, textTypes);
        }
        FunctionType functionType = new FunctionType(domainType, rangeType);
        this.field = new FieldImpl(functionType, domain);
        if (this.debug) {
            System.out.println("filling in data");
        }
        long millis = System.currentTimeMillis();
        Data[] firstTuple = null;
        Unit[] actualUnits = null;
        Data[] protos = numDouble > 0 ? new Real[numDouble] : null;
        for (int i = 0; i < numObs; ++i) {
            double[] values = new double[numDouble];
            String[] strings = new String[numString];
            int stringIdx = 0;
            int doubleIdx = 0;
            for (int j = 0; j < numParams; ++j) {
                double value;
                if (types[j] instanceof TextType) {
                    String text = McIDASUtil.intBitsToString(data[i][j]);
                    strings[stringIdx++] = text;
                    continue;
                }
                values[doubleIdx] = value = data[i][j] == -2139062144 ? Double.NaN : (double)data[i][j] / Math.pow(10.0, scalingFactors[j]);
                if (firstTuple == null) {
                    try {
                        protos[doubleIdx] = new Real((RealType)types[j], value, defaultUnits[j]);
                    }
                    catch (VisADException excp) {
                        protos[doubleIdx] = new Real((RealType)types[j], value);
                    }
                    usedUnits.add(((Real)protos[doubleIdx]).getUnit());
                }
                ++doubleIdx;
            }
            if (actualUnits == null && !usedUnits.isEmpty()) {
                actualUnits = new Unit[usedUnits.size()];
                for (int k = 0; k < usedUnits.size(); ++k) {
                    actualUnits[k] = (Unit)usedUnits.get(k);
                }
            }
            try {
                Tuple sample = noText ? new DoubleTuple((RealTupleType)rangeType, protos, values, actualUnits) : new DoubleStringTuple(rangeType, protos, values, strings, actualUnits);
                this.field.setSample(i, sample, false, i == 0);
            }
            catch (VisADException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                // empty catch block
            }
            if (firstTuple != null) continue;
            firstTuple = protos;
        }
        if (this.debug) {
            System.out.println("data fill took " + (System.currentTimeMillis() - millis) + " ms");
        }
    }

    public DataImpl getData() {
        return this.field;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("You must specify an ADDE Point Data URL");
            System.exit(-1);
        }
        try {
            PointDataAdapter pda = new PointDataAdapter(args[0]);
            Field data = (Field)((Object)pda.getData());
            JPythonMethods.dumpTypes((Data)data);
        }
        catch (VisADException ve) {
            System.out.println("Error reading data");
        }
    }

    private RealType getQuantity(String name, Unit unit) throws VisADException {
        RealType type = null;
        if (name.equalsIgnoreCase("lat")) {
            type = RealType.Latitude;
        } else if (name.equalsIgnoreCase("lon")) {
            type = RealType.Longitude;
        } else if (name.equalsIgnoreCase("zs")) {
            type = RealType.Altitude;
        } else if (name.equalsIgnoreCase("z") && this.useAliases) {
            type = RealType.Altitude;
        } else {
            type = RealType.getRealType(name, unit);
            if (type == null && (type = this.makeUniqueNames ? DataUtility.getUniqueRealType(name, unit) : RealType.getRealTypeByName(name)) == null) {
                throw new VisADException("getQuantity(): Couldn't create RealType for " + name);
            }
        }
        if (this.useAliases) {
            if (RealType.getRealTypeByName(name) == null) {
                type.alias(name);
            } else if (!RealType.getRealTypeByName(name).equals(type)) {
                throw new VisADException("getQuanity(): Two different variables can't have the same alias");
            }
        }
        return type;
    }
}

