/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.ArrayList;
import java.util.List;
import visad.ContourLabelGeometry;
import visad.ContourQuadSet;
import visad.ContourStrip;
import visad.Gridded3DSet;
import visad.VisADException;
import visad.VisADLineStripArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContourStripSet {
    static final int DEFAULT_DASH_VALUE = 2;
    static final int DISABLE_DASH_VALUE = -1;
    int mxsize;
    float[] levels;
    int[][] labelIndexes;
    int n_levs;
    int nr;
    int nc;
    Gridded3DSet spatial_set;
    List<ContourStrip>[] vecArray;
    List<ContourStrip> vec;
    boolean[] swap;
    ContourQuadSet[] qSet;
    private float[] gridX;
    private float[] gridY;
    private byte[][] gridColors;
    ArrayList<ContourLabelGeometry> labels = new ArrayList();
    ArrayList<VisADLineStripArray> fillLines = new ArrayList();
    ArrayList<VisADLineStripArray> fillLinesStyled = new ArrayList();
    ArrayList<VisADLineStripArray> cntrLines = new ArrayList();
    ArrayList<VisADLineStripArray> cntrLinesStyled = new ArrayList();
    double labelScale;

    ContourStripSet(int size, float[] levels, boolean[] swap, double scale_ratio, double label_size, int nr, int nc, Gridded3DSet spatial_set) throws VisADException {
        int kk;
        this.mxsize = 40 * size;
        this.levels = levels;
        this.n_levs = levels.length;
        this.labelIndexes = new int[this.n_levs][];
        this.vecArray = new List[this.n_levs];
        float fac = (float)(0.15 * (1.0 / scale_ratio) * label_size);
        this.labelScale = 0.062 * (1.0 / scale_ratio) * label_size;
        this.nr = nr;
        this.nc = nc;
        this.swap = swap;
        this.spatial_set = spatial_set;
        for (kk = 0; kk < this.n_levs; ++kk) {
            this.vecArray[kk] = new ArrayList<ContourStrip>();
        }
        this.qSet = new ContourQuadSet[this.n_levs];
        for (kk = 0; kk < this.n_levs; ++kk) {
            this.qSet[kk] = new ContourQuadSet(nr, nc, kk, this);
        }
    }

    void setGridValues(float[] gx, float[] gy) {
        this.gridX = gx;
        this.gridY = gy;
    }

    void setGridColors(byte[][] colors) {
        this.gridColors = colors;
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, int lev_idx, int ir, int ic) {
        this.qSet[lev_idx].add(idx0, ir, ic);
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, float level) {
        int lev_idx = 0;
        for (int kk = 0; kk < this.n_levs; ++kk) {
            if (level != this.levels[kk]) continue;
            lev_idx = kk;
        }
        this.add(vx, vy, idx0, idx1, lev_idx);
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, int lev_idx) {
        this.vec = this.vecArray[lev_idx];
        int n_strip = this.vec.size();
        if (n_strip == 0) {
            ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this);
            this.vec.add(c_strp);
        } else {
            int[] found_array = new int[3];
            int found = 0;
            for (int kk = 0; kk < n_strip; ++kk) {
                ContourStrip c_strp = this.vec.get(kk);
                if (!c_strp.addPair(vx, vy, idx0, idx1)) continue;
                found_array[found] = kk;
                ++found;
            }
            if (found == 3) {
                ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this);
                this.vec.add(c_strp);
            } else if (found == 2) {
                ContourStrip c_strpA = this.vec.get(found_array[0]);
                ContourStrip c_strpB = this.vec.get(found_array[1]);
                c_strpA.merge(c_strpB);
                this.vec.remove(found_array[1]);
            } else if (found == 0) {
                ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this);
                this.vec.add(c_strp);
            }
        }
    }

    void getLineColorArrays(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, Object labelFont, boolean labelAlign, boolean sphericalDisplayCS, int lev_idx, boolean[] dashed) throws VisADException {
        int n_strips = this.vecArray[lev_idx].size();
        for (int kk = 0; kk < n_strips; ++kk) {
            ContourStrip cs = this.vecArray[lev_idx].get(kk);
            cs.isDashed = dashed[lev_idx];
            cs.getLabeledLineColorArray(vx, vy, colors, labelColor, labelFont, labelAlign, sphericalDisplayCS);
        }
    }

    void getLineColorArrays(float[] vx, float[] vy, byte[][] colors, byte[] labelColor, Object labelFont, boolean labelAlign, boolean sphericalDisplayCS, boolean[] dashFlags) throws VisADException {
        this.makeContourStrips(vx, vy);
        for (int kk = 0; kk < this.n_levs; ++kk) {
            this.getLineColorArrays(vx, vy, colors, labelColor, labelFont, labelAlign, sphericalDisplayCS, kk, dashFlags);
        }
    }

    void makeContourStrips(float[] vx, float[] vy) {
        for (int kk = 0; kk < this.n_levs; ++kk) {
            int nx = this.qSet[kk].nx;
            int ny = this.qSet[kk].ny;
            for (int j = 0; j < ny; ++j) {
                for (int i = 0; i < nx; ++i) {
                    if (this.qSet[kk].qarray[j][i] == null) continue;
                    int[] vert_indices = this.qSet[kk].qarray[j][i].vert_indices;
                    int len = this.qSet[kk].qarray[j][i].numv;
                    for (int q = 0; q < len; ++q) {
                        int idx = vert_indices[q];
                        this.add(vx, vy, idx, idx + 1, kk);
                    }
                }
            }
        }
    }

    List<float[][][]> getLineStripCoordinates(int lvlIdx) {
        if (lvlIdx > this.vecArray.length - 1) {
            return new ArrayList<float[][][]>(0);
        }
        List<ContourStrip> strips = this.vecArray[lvlIdx];
        ArrayList<float[][][]> stripValues = new ArrayList<float[][][]>();
        for (ContourStrip strip : strips) {
            stripValues.add(strip.getLineStripArrays(this.gridX, this.gridY));
        }
        return stripValues;
    }

    List<byte[][][]> getLineStripColors(int lvlIdx) {
        if (lvlIdx > this.vecArray.length - 1) {
            return new ArrayList<byte[][][]>(0);
        }
        List<ContourStrip> strips = this.vecArray[lvlIdx];
        ArrayList<byte[][][]> stripColors = new ArrayList<byte[][][]>();
        for (ContourStrip strip : strips) {
            stripColors.add(strip.getColorStripArrays(this.gridColors));
        }
        return stripColors;
    }

    boolean isLevelStyled(int lvl) {
        if (this.vecArray.length > lvl + 1 && this.vecArray[lvl] != null && this.vecArray[lvl].size() > 0) {
            return this.vecArray[lvl].get((int)0).isDashed;
        }
        return false;
    }

    boolean isLabeled(int lvl) {
        return this.vecArray[lvl].get(0).isLabeled();
    }
}

