/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

import java.io.IOException;
import org.itadaki.bzip2.BitInputStream;

public class BZip2HuffmanStageDecoder {
    private final BitInputStream bitInputStream;
    private final byte[] selectors;
    private final int[] minimumLengths = new int[6];
    private final int[][] codeBases = new int[6][25];
    private final int[][] codeLimits = new int[6][24];
    private final int[][] codeSymbols = new int[6][258];
    private int currentTable;
    private int groupIndex = -1;
    private int groupPosition = -1;

    private void createHuffmanDecodingTables(int alphabetSize, byte[][] tableCodeLengths) {
        int table = 0;
        while (table < tableCodeLengths.length) {
            int[] tableBases = this.codeBases[table];
            int[] tableLimits = this.codeLimits[table];
            int[] tableSymbols = this.codeSymbols[table];
            byte[] codeLengths = tableCodeLengths[table];
            int minimumLength = 23;
            int maximumLength = 0;
            int i = 0;
            while (i < alphabetSize) {
                maximumLength = Math.max(codeLengths[i], maximumLength);
                minimumLength = Math.min(codeLengths[i], minimumLength);
                ++i;
            }
            this.minimumLengths[table] = minimumLength;
            i = 0;
            while (i < alphabetSize) {
                int n = codeLengths[i] + 1;
                tableBases[n] = tableBases[n] + 1;
                ++i;
            }
            i = 1;
            while (i < 25) {
                int n = i;
                tableBases[n] = tableBases[n] + tableBases[i - 1];
                ++i;
            }
            int code = 0;
            int i2 = minimumLength;
            while (i2 <= maximumLength) {
                int base = code;
                tableBases[i2] = base - tableBases[i2];
                tableLimits[i2] = (code += tableBases[i2 + 1] - tableBases[i2]) - 1;
                code <<= 1;
                ++i2;
            }
            int codeIndex = 0;
            int bitLength = minimumLength;
            while (bitLength <= maximumLength) {
                int symbol = 0;
                while (symbol < alphabetSize) {
                    if (codeLengths[symbol] == bitLength) {
                        tableSymbols[codeIndex++] = symbol;
                    }
                    ++symbol;
                }
                ++bitLength;
            }
            ++table;
        }
    }

    public int nextSymbol() throws IOException {
        BitInputStream bitInputStream = this.bitInputStream;
        if (++this.groupPosition % 50 == 0) {
            this.currentTable = this.selectors[++this.groupIndex] & 0xFF;
        }
        int currentTable = this.currentTable;
        int[] tableLimits = this.codeLimits[currentTable];
        int codeLength = this.minimumLengths[currentTable];
        int codeBits = bitInputStream.readBits(codeLength);
        while (codeLength <= 23) {
            if (codeBits <= tableLimits[codeLength]) {
                return this.codeSymbols[currentTable][codeBits - this.codeBases[currentTable][codeLength]];
            }
            codeBits = codeBits << 1 | bitInputStream.readBits(1);
            ++codeLength;
        }
        throw new IOException("Error decoding BZip2 block");
    }

    public BZip2HuffmanStageDecoder(BitInputStream bitInputStream, int alphabetSize, byte[][] tableCodeLengths, byte[] selectors) {
        this.bitInputStream = bitInputStream;
        this.selectors = selectors;
        this.currentTable = this.selectors[0];
        this.createHuffmanDecodingTables(alphabetSize, tableCodeLengths);
    }
}

