/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTable;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.ui.Grib2CollectionPanel;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Misc;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribFilesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted grib1Table;
    private BeanTableSorted grib2Table;
    private BeanTableSorted collectionTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private IndependentWindow infoWindow;
    private static final KMPMatch matcher = new KMPMatch("GRIB".getBytes());
    private List<CollectionBean> collections = new ArrayList<CollectionBean>();

    public GribFilesPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.collectionTable = new BeanTableSorted(CollectionBean.class, (PreferencesExt)prefs.node("CollectionBean"), true);
        PopupMenu varPopup = new PopupMenu(this.collectionTable.getJTable(), "Options");
        varPopup.addAction("Show Files in Collection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionBean pb = (CollectionBean)GribFilesPanel.this.collectionTable.getSelectedBean();
                Formatter f = new Formatter();
                GribFilesPanel.this.showFilesInCollection(pb, f);
                GribFilesPanel.this.infoPopup.setText(f.toString());
                GribFilesPanel.this.infoPopup.gotoTop();
                GribFilesPanel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Read Files", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = GribFilesPanel.this.collectionTable.getSelectedBeans();
                GribFilesPanel.this.readFiles(list);
            }
        });
        this.grib1Table = new BeanTableSorted(Grib1Bean.class, (PreferencesExt)prefs.node("Grib1Bean"), false);
        varPopup = new PopupMenu(this.grib1Table.getJTable(), "Options");
        varPopup.addAction("Open in Grib-Raw", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1Bean pb = (Grib1Bean)GribFilesPanel.this.grib1Table.getSelectedBean();
                if (pb == null) {
                    return;
                }
                GribFilesPanel.this.firePropertyChange("openGrib1Raw", null, pb.m.getPath());
            }
        });
        this.grib2Table = new BeanTableSorted(Grib2Bean.class, (PreferencesExt)prefs.node("Grib2Bean"), false);
        varPopup = new PopupMenu(this.grib2Table.getJTable(), "Options");
        varPopup.addAction("Show complete GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2Bean bean = (Grib2Bean)GribFilesPanel.this.grib2Table.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.showComplete(f);
                    GribFilesPanel.this.infoPopup.setText(f.toString());
                    GribFilesPanel.this.infoPopup.gotoTop();
                    GribFilesPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Open in Grib2collecion", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2Bean pb = (Grib2Bean)GribFilesPanel.this.grib2Table.getSelectedBean();
                if (pb == null) {
                    return;
                }
                GribFilesPanel.this.firePropertyChange("openGrib2c", null, pb.m.getPath());
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, this.collectionTable, this.grib1Table);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.grib1Table.saveState(false);
        this.grib2Table.saveState(false);
        this.collectionTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void showCollection(Formatter f) {
    }

    private void showFilesInCollection(CollectionBean bean, Formatter f) {
        f.format("Collection= %s %n", bean.spec);
        int count = 0;
        for (MFile mfile : bean.fileList) {
            f.format("  %s%n", mfile.getPath());
            ++count;
        }
        f.format(" count = %d %n", count);
    }

    public void setCollection(String spec) throws IOException {
        this.collections.add(new CollectionBean(spec));
        this.collectionTable.setBeans(this.collections);
    }

    private void readFiles(List<CollectionBean> beans) {
        ArrayList<Object> files = new ArrayList<Object>();
        for (CollectionBean bean : beans) {
            for (MFile mfile : bean.fileList) {
                Object gbean;
                String path = mfile.getPath();
                if (path.endsWith(".gbx8") || path.endsWith(".gbx9") || path.endsWith(".ncx") || (gbean = this.getGribBean(mfile)) == null) continue;
                files.add(gbean);
            }
        }
        this.grib1Table.setBeans(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getGribBean(MFile ff) {
        block18: {
            Object object;
            String path = ff.getPath();
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(path, "r");
                raf.order(0);
                raf.seek(0L);
                if (!raf.searchForward(matcher, 8000)) {
                    Object var4_4 = null;
                    return var4_4;
                }
                raf.skipBytes(7);
                int edition = raf.read();
                if (edition != 1) break block18;
                object = this.getFirstGrib1Bean(ff, raf);
            }
            catch (Throwable ioe) {
                System.out.printf("Failed on %s%n", path);
                ioe.printStackTrace();
                break block18;
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {}
                }
            }
            return object;
        }
        return null;
    }

    Object getFirstGrib1Bean(MFile mf, RandomAccessFile raf) throws IOException {
        Grib1Record first = null;
        Grib1RecordScanner reader = new Grib1RecordScanner(raf);
        if (reader.hasNext()) {
            first = reader.next();
        }
        return new Grib1Bean(mf, first);
    }

    public class Grib2Bean {
        MFile m;
        Grib2Index index;
        int nRecords;
        int localCount = 0;
        int gdsCount = 0;
        Grib2Record first;
        Grib2Customizer tables;
        boolean bad = false;

        public Grib2Bean() {
        }

        public Grib2Bean(MFile m) {
            this.m = m;
            try {
                this.index = new Grib2Index();
                if (!this.index.readIndex(m.getPath(), m.getLastModified())) {
                    this.index.makeIndex(m.getPath(), null);
                }
                HashMap<Long, Grib2SectionGridDefinition> gdsSet = new HashMap<Long, Grib2SectionGridDefinition>();
                for (Grib2SectionGridDefinition gds : this.index.getGds()) {
                    if (gdsSet.get(gds.calcCRC()) != null) continue;
                    gdsSet.put(gds.calcCRC(), gds);
                }
                this.gdsCount = gdsSet.size();
                this.nRecords = this.index.getRecords().size();
                for (Grib2Record gr : this.index.getRecords()) {
                    Grib2Pds pds;
                    if (this.first == null) {
                        this.first = gr;
                    }
                    if (this.tables == null) {
                        Grib2SectionIdentification ids = gr.getId();
                        this.tables = Grib2Customizer.factory(ids.getCenter_id(), ids.getSubcenter_id(), ids.getMaster_table_version(), ids.getLocal_table_version());
                    }
                    if ((pds = gr.getPDSsection().getPDS()).getParameterCategory() <= 191 && pds.getParameterNumber() <= 191) continue;
                    ++this.localCount;
                }
            }
            catch (IOException e) {
                System.out.printf("%s%n", e.getMessage());
                this.bad = true;
            }
        }

        public final String getPath() {
            return this.bad ? "BAD " + this.m.getPath() : this.m.getPath();
        }

        public final String getRefDate() {
            return this.bad ? "" : this.first.getReferenceDate().toString();
        }

        public String getHeader() {
            return this.bad ? "" : StringUtil2.cleanup(this.first.getHeader());
        }

        public int getMasterTable() {
            return this.bad ? -1 : this.first.getId().getMaster_table_version();
        }

        public int getLocalTable() {
            return this.bad ? -1 : this.first.getId().getLocal_table_version();
        }

        public int getCenter() {
            return this.bad ? -1 : this.first.getId().getCenter_id();
        }

        public int getSubCenter() {
            return this.bad ? -1 : this.first.getId().getSubcenter_id();
        }

        public String getLocalCount() {
            return this.bad ? "" : this.localCount + "/" + this.nRecords;
        }

        public int getGdsCount() {
            return this.gdsCount;
        }

        void showComplete(Formatter f) {
            try {
                Grib2CollectionPanel.showCompleteGribRecord(f, this.m.getPath(), this.first, this.tables);
            }
            catch (IOException e) {
                e.printStackTrace();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                f.format("%s", bos.toString());
            }
        }
    }

    public class Grib1Bean {
        MFile m;
        Grib1Record first;
        Grib1ParamTable table;
        Grib1SectionProductDefinition pds;

        public Grib1Bean() {
        }

        public Grib1Bean(MFile m, Grib1Record first) {
            this.m = m;
            this.first = first;
            this.pds = first.getPDSsection();
            Grib1ParamTables tables = new Grib1ParamTables();
            this.table = tables.getParameterTable(this.getCenter(), this.getSubCenter(), this.getTableVersion());
        }

        public final String getPath() {
            return this.m.getPath();
        }

        public int getTableVersion() {
            return this.pds.getTableVersion();
        }

        public int getCenter() {
            return this.pds.getCenter();
        }

        public String getCenterName() {
            return CommonCodeTable.getCenterName(this.getCenter(), 1);
        }

        public int getSubCenter() {
            return this.pds.getSubCenter();
        }

        public String getSubCenterName() {
            return Grib1Customizer.getSubCenterName(this.getCenter(), this.getSubCenter());
        }

        public int getTimeUnit() {
            return this.pds.getTimeUnit();
        }

        public String getTable() {
            return this.table == null ? " missing" : this.table.getName();
        }

        public int getTableKey() {
            return this.table == null ? -1 : this.table.getKey();
        }
    }

    public class CollectionBean {
        String spec;
        MFileCollectionManager dcm;
        Iterable<MFile> fileList;

        public CollectionBean() {
        }

        public CollectionBean(String spec) throws IOException {
            this.spec = spec;
            Formatter f = new Formatter();
            MFileCollectionManager dc = null;
            try {
                dc = MFileCollectionManager.open(spec, null, f);
                dc.scan(false);
                this.fileList = dc.getFiles();
            }
            catch (Exception e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                f.format("%s", bos.toString());
                JOptionPane.showMessageDialog(null, "Collection is null");
            }
        }

        public int getN() {
            return Misc.getSize(this.fileList);
        }

        public String getSpec() {
            return this.spec;
        }
    }
}

