/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.EventObject;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.IO;
import ucar.nc2.util.ListenerManager;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;

public class SocketMessage {
    private static final boolean debug = false;
    private static final boolean throwAway = false;
    private static boolean raw = false;
    private ServerSocket server;
    private boolean isAlreadyRunning = false;
    private ListenerManager lm;

    public SocketMessage(int port, String message) {
        try {
            this.server = new ServerSocket(port, 1);
            ListenThread listen = new ListenThread();
            listen.start();
            this.lm = new ListenerManager("ucar.nc2.ui.util.SocketMessage$EventListener", "ucar.nc2.ui.util.SocketMessage$Event", "setMessage");
        }
        catch (BindException e) {
            if (message != null) {
                this.sendMessage(port, message);
            }
            this.isAlreadyRunning = true;
        }
        catch (SocketException e) {
            if (message != null) {
                this.sendMessage(port, message);
            }
            this.isAlreadyRunning = true;
        }
        catch (IOException e) {
            System.out.println("SocketMessage IOException= " + e);
            e.printStackTrace();
        }
    }

    public boolean isAlreadyRunning() {
        return this.isAlreadyRunning;
    }

    public void addEventListener(EventListener l) {
        this.lm.addListener(l);
    }

    public void removeEventListener(EventListener l) {
        this.lm.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(int port, String message) {
        Socket connection = null;
        try {
            connection = new Socket("localhost", port);
            IO.writeContents(message, connection.getOutputStream());
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void main(String[] args) throws IOException {
        String url = "http://localhost:8080/thredds/test/it?" + EscapeStrings.escapeOGC("quuery[1]");
        System.out.printf("send '%s'%n", url);
        HTTPSession session = new HTTPSession(url);
        HTTPMethod method = HTTPMethod.Head(session);
        method.execute();
        int status = method.getStatusCode();
        System.out.printf("%d%n", status);
        session.close();
    }

    public static interface EventListener {
        public void setMessage(Event var1);
    }

    public class Event
    extends EventObject {
        private String message;

        Event(String message) {
            super(SocketMessage.this);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private class ListenThread
    extends Thread {
        String message;

        private ListenThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Socket connection;
                try {
                    connection = SocketMessage.this.server.accept();
                }
                catch (IOException e) {
                    System.out.println("SocketMessage accept= " + e);
                    e.printStackTrace();
                    return;
                }
                try {
                    if (raw) {
                        InputStream in = connection.getInputStream();
                        byte[] buffer = new byte[8000];
                        int bytesRead = in.read(buffer);
                        System.out.printf("%s == %s%n", bytesRead, new String(buffer, 0, bytesRead));
                        continue;
                    }
                    this.message = IO.readContents(connection.getInputStream());
                    SocketMessage.this.lm.sendEvent(new Event(this.message));
                    continue;
                }
                catch (IOException e) {
                    System.out.println("SocketMessage IOException reading= " + e);
                    e.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        if (connection == null) continue;
                        connection.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                break;
            }
        }
    }
}

