/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import ucar.nc2.iosp.bufr.Message;

public class MessageWriter {
    private final WritableByteChannel wbc;
    private final FileOutputStream fos;
    private final String name;
    private final short fileno;
    private final AtomicBoolean isScheduled = new AtomicBoolean(false);
    private long lastModified;

    MessageWriter(File file, short fileno, List<Message> bufrTableMessages) throws IOException {
        this.fileno = fileno;
        this.fos = new FileOutputStream(file, true);
        this.wbc = this.fos.getChannel();
        this.name = file.getPath();
        for (Message m : bufrTableMessages) {
            this.write(m);
        }
        System.out.printf("Start %s ntables=%d%n", file, bufrTableMessages.size());
    }

    public void write(Message m) throws IOException {
        this.wbc.write(ByteBuffer.wrap(m.getHeader().getBytes()));
        this.wbc.write(ByteBuffer.wrap(m.getRawBytes()));
        this.lastModified = System.currentTimeMillis();
        this.isScheduled.getAndSet(false);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void close() throws IOException {
        if (this.wbc != null) {
            this.wbc.close();
        }
        if (this.fos != null) {
            this.fos.close();
        }
        System.out.printf("%s closed%n", this.name);
    }
}

