/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CompareNetcdf2;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class AggTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted messageTable;
    private BeanTableSorted obsTable;
    private BeanTableSorted ddsTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private TextHistoryPane aggTA;
    private IndependentWindow infoWindow;
    private StructureTable dataTable;
    private IndependentWindow dataWindow;
    private NetcdfDataset current;

    public AggTable(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.messageTable = new BeanTableSorted(DatasetBean.class, (PreferencesExt)prefs.node("DatasetBean"), false);
        this.messageTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AggTable.this.ddsTable.setBeans(new ArrayList());
                AggTable.this.obsTable.setBeans(new ArrayList());
                DatasetBean mb = (DatasetBean)AggTable.this.messageTable.getSelectedBean();
            }
        });
        this.obsTable = new BeanTableSorted(ObsBean.class, (PreferencesExt)prefs.node("ObsBean"), false);
        this.obsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ObsBean csb = (ObsBean)AggTable.this.obsTable.getSelectedBean();
            }
        });
        this.ddsTable = new BeanTableSorted(DdsBean.class, (PreferencesExt)prefs.node("DdsBean"), false);
        this.ddsTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DdsBean csb = (DdsBean)AggTable.this.ddsTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.messageTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openNetcdfFile", null, dsb.acquireFile());
            }
        });
        varPopup.addAction("Check CoordSystems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openCoordSystems", null, dsb.acquireFile());
            }
        });
        varPopup.addAction("Open as GridDataset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.messageTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openGridDataset", null, dsb.acquireFile());
            }
        });
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Check files", false);
        compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                AggTable.this.compare(f);
                AggTable.this.checkAggCoordinate(f);
                AggTable.this.infoTA.setText(f.toString());
                AggTable.this.infoTA.gotoTop();
                AggTable.this.infoWindow.show();
            }
        });
        buttPanel.add(compareButton);
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.split2 = new JSplitPane(0, false, this.ddsTable, this.obsTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.aggTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, this.messageTable, this.aggTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    private void makeDataTable() {
        this.dataTable = new StructureTable((PreferencesExt)this.prefs.node("structTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)this.prefs.getBean("dataWindow", new Rectangle(50, 300, 1000, 600)));
    }

    public void save() {
        this.messageTable.saveState(false);
        this.ddsTable.saveState(false);
        this.obsTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
    }

    public void setAggDataset(NetcdfDataset ncd) throws IOException {
        this.current = ncd;
        Aggregation agg = ncd.getAggregation();
        ArrayList<DatasetBean> beanList = new ArrayList<DatasetBean>();
        for (Aggregation.Dataset dataset : agg.getDatasets()) {
            beanList.add(new DatasetBean(dataset));
        }
        this.messageTable.setBeans(beanList);
        Formatter f = new Formatter();
        agg.getDetailInfo(f);
        this.aggTA.setText(f.toString());
    }

    private void checkAggCoordinate(Formatter f) {
        if (null == this.current) {
            return;
        }
        try {
            Aggregation agg = this.current.getAggregation();
            String aggDimName = agg.getDimensionName();
            Variable aggCoord = this.current.findVariable(aggDimName);
            Array data = aggCoord.read();
            f.format("   Aggregated coordinate variable %s%n", aggCoord);
            f.format(NCdumpW.printArray(data, aggDimName, null), new Object[0]);
            for (Object bean : this.messageTable.getBeans()) {
                DatasetBean dbean = (DatasetBean)bean;
                Aggregation.Dataset ads = dbean.ds;
                NetcdfFile aggFile = ads.acquireFile(null);
                f.format("   Component file %s%n", aggFile.getLocation());
                Variable aggCoordp = aggFile.findVariable(aggDimName);
                if (aggCoordp == null) {
                    f.format("   doesnt have coordinate variable%n", new Object[0]);
                    continue;
                }
                data = aggCoordp.read();
                f.format(NCdumpW.printArray(data, aggCoordp.getNameAndDimensions() + " (" + aggCoordp.getUnitsString() + ")", null), new Object[0]);
            }
        }
        catch (Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            t.printStackTrace(new PrintStream(bos));
            f.format(bos.toString(), new Object[0]);
        }
    }

    private void compare(Formatter f) {
        try {
            NetcdfFile org = null;
            for (Object bean : this.messageTable.getBeans()) {
                DatasetBean dbean = (DatasetBean)bean;
                Aggregation.Dataset ads = dbean.ds;
                NetcdfFile ncd = ads.acquireFile(null);
                if (org == null) {
                    org = ncd;
                    continue;
                }
                CompareNetcdf2 cn = new CompareNetcdf2(f, false, false, false);
                cn.compareVariables(org, ncd);
                ncd.close();
                f.format("--------------------------------%n", new Object[0]);
            }
            if (org != null) {
                org.close();
            }
        }
        catch (Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            t.printStackTrace(new PrintStream(bos));
            f.format(bos.toString(), new Object[0]);
        }
    }

    public class ObsBean {
        double lat = Double.NaN;
        double lon = Double.NaN;
        double alt = Double.NaN;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int sec = -1;
        Date time;
        int wmo_block = -1;
        int wmo_id = -1;
        String stn = null;

        public ObsBean() {
        }

        public ObsBean(Structure obs, StructureData sdata) {
            String val;
            Attribute att;
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-5-1") && Double.isNaN(this.lat)) {
                    this.lat = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-6-1") && Double.isNaN(this.lon)) {
                    this.lon = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-30") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-1") && this.year < 0) {
                    this.year = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-2") && this.month < 0) {
                    this.month = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-3") && this.day < 0) {
                    this.day = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-4") && this.hour < 0) {
                    this.hour = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-5") && this.minute < 0) {
                    this.minute = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-4-6") && this.sec < 0) {
                    this.sec = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-1-1") && this.wmo_block < 0) {
                    this.wmo_block = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (val.equals("0-1-2") && this.wmo_id < 0) {
                    this.wmo_id = sdata.convertScalarInt(v.getShortName());
                    continue;
                }
                if (this.stn != null || !val.equals("0-1-7") && !val.equals("0-1-194") && !val.equals("0-1-11") && !val.equals("0-1-18")) continue;
                if (v.getDataType().isString()) {
                    this.stn = sdata.getScalarString(v.getShortName());
                    continue;
                }
                this.stn = Integer.toString(sdata.convertScalarInt(v.getShortName()));
            }
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-5-2") && Double.isNaN(this.lat)) {
                    this.lat = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-6-2") && Double.isNaN(this.lon)) {
                    this.lon = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (val.equals("0-7-1") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (!val.equals("0-4-7") || this.sec >= 0) continue;
                this.sec = sdata.convertScalarInt(v.getShortName());
            }
            for (Variable v : obs.getVariables()) {
                att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null) continue;
                val = att.getStringValue();
                if (val.equals("0-7-10") && Double.isNaN(this.alt)) {
                    this.alt = sdata.convertScalarDouble(v.getShortName());
                    continue;
                }
                if (!val.equals("0-7-2") || !Double.isNaN(this.alt)) continue;
                this.alt = sdata.convertScalarDouble(v.getShortName());
            }
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }

        public double getHeight() {
            return this.alt;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSec() {
            return this.sec;
        }

        public String getWmoId() {
            return this.wmo_block + "/" + this.wmo_id;
        }

        public String getStation() {
            return this.stn;
        }
    }

    public class DdsBean {
        DataDescriptor dds;
        int seq;

        public DdsBean() {
        }

        public DdsBean(DataDescriptor dds, int seq) {
            this.dds = dds;
            this.seq = seq;
        }

        public String getFxy() {
            return this.dds.getFxyName();
        }

        public String getName() {
            return this.dds.getName();
        }

        public String getUnits() {
            return this.dds.getUnits();
        }

        public int getBitWidth() {
            return this.dds.getBitWidth();
        }

        public int getScale() {
            return this.dds.getScale();
        }

        public int getReference() {
            return this.dds.getRefVal();
        }

        public int getSeq() {
            return this.seq;
        }

        public String getLocal() {
            return this.dds.isLocal() ? "true" : "false";
        }
    }

    public class DatasetBean {
        Aggregation.Dataset ds;

        protected NetcdfFile acquireFile() {
            try {
                return this.ds.acquireFile(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public DatasetBean() {
        }

        public DatasetBean(Aggregation.Dataset ds) {
            this.ds = ds;
        }

        public String getLocation() throws IOException {
            return this.ds.getLocation();
        }

        public String getCacheLocation() {
            return this.ds.getCacheLocation();
        }

        public String getId() {
            return this.ds.getId();
        }
    }
}

