/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategyFromAttribute;
import ucar.nc2.write.Nc4ChunkingStrategyGrib;

@Immutable
public class Nc4ChunkingStrategyImpl
implements Nc4Chunking {
    private static final boolean debug = true;
    private static final int DEFAULT_CHUNKSIZE = (int)Math.pow(2.0, 22.0);
    private final int deflateLevel;
    private final boolean shuffle;

    public static Nc4Chunking factory(Nc4Chunking.Strategy type, int deflateLevel, boolean shuffle) {
        switch (type) {
            case standard: {
                return new Nc4ChunkingStrategyImpl(deflateLevel, shuffle);
            }
            case grib: {
                return new Nc4ChunkingStrategyGrib(deflateLevel, shuffle);
            }
            case fromAttribute: {
                return new Nc4ChunkingStrategyFromAttribute(deflateLevel, shuffle);
            }
        }
        throw new IllegalArgumentException("Illegal Nc4Chunking.Standard " + (Object)((Object)type));
    }

    public Nc4ChunkingStrategyImpl() {
        this.deflateLevel = 5;
        this.shuffle = true;
    }

    public Nc4ChunkingStrategyImpl(int deflateLevel, boolean shuffle) {
        this.deflateLevel = deflateLevel;
        this.shuffle = shuffle;
    }

    @Override
    public boolean isChunked(Variable v) {
        if (v.isUnlimited()) {
            return true;
        }
        long size = v.getSize() * (long)v.getElementSize();
        return size >= (long)DEFAULT_CHUNKSIZE;
    }

    @Override
    public int getDeflateLevel(Variable v) {
        return this.deflateLevel;
    }

    @Override
    public boolean isShuffle(Variable v) {
        return this.shuffle;
    }

    @Override
    public long[] computeChunking(Variable v) {
        long size = v.getSize() * (long)v.getElementSize();
        if (size < (long)DEFAULT_CHUNKSIZE) {
            return this.convert(v.getShape());
        }
        if (v.isUnlimited()) {
            return this._computeChunkingUnlimited(v);
        }
        return this._computeChunking(v);
    }

    private long[] _computeChunkingUnlimited(Variable v) {
        List<Dimension> dims = v.getDimensions();
        long[] result = new long[dims.size()];
        int count = 0;
        for (Dimension d : dims) {
            if (d.isUnlimited()) {
                result[count++] = 1L;
                continue;
            }
            result[count++] = d.getLength();
        }
        return result;
    }

    private long[] _computeChunking(Variable v) {
        List<Dimension> dims = v.getDimensions();
        long[] result = new long[dims.size()];
        int count = 0;
        for (Dimension d : dims) {
            if (d.isUnlimited()) {
                result[count++] = 1L;
                continue;
            }
            result[count++] = d.getLength();
        }
        return result;
    }

    private long[] convert(int[] shape) {
        if (shape.length == 0) {
            shape = new int[1];
        }
        long[] result = new long[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            result[i] = shape[i] > 0 ? (long)shape[i] : 1L;
        }
        return result;
    }

    protected Attribute getChunkAttribute(Variable v) {
        return v.findAttribute("_ChunkSize");
    }
}

