/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli.validation;

import com.lexicalscope.jewel.cli.ValidationErrorBuilder;
import com.lexicalscope.jewel.cli.specification.OptionSpecificationMatchers;
import com.lexicalscope.jewel.cli.specification.OptionsSpecification;
import com.lexicalscope.jewel.cli.specification.ParsedOptionSpecification;
import com.lexicalscope.jewel.cli.specification.UnparsedOptionSpecification;
import com.lexicalscope.jewel.cli.validation.ArgumentValidator;
import com.lexicalscope.jewel.cli.validation.OptionCollection;
import com.lexicalscope.jewel.cli.validation.OptionCollectionImpl;
import com.lexicalscope.jewel.cli.validation.RawOption;
import com.lexicalscope.jewel.cli.validation.ValidationPipeline;
import com.lexicalscope.jewelcli.internal.fluentcollections.$FluentDollar;
import com.lexicalscope.jewelcli.internal.fluentcollectionsmap.$FluentMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class ArgumentValidatorImpl<O>
implements ArgumentValidator {
    private final ValidationErrorBuilder validationErrorBuilder;
    private final Map<RawOption, List<String>> rawArguments;
    private final $FluentMap<ParsedOptionSpecification, List<String>> arguments = $FluentDollar.$.map();
    private final $FluentMap<ParsedOptionSpecification, List<String>> mandatoryArguments = $FluentDollar.$(this.arguments).$retainKeys(OptionSpecificationMatchers.mandatory());
    private final List<String> validatedUnparsedArguments = new ArrayList<String>();
    private final OptionsSpecification<O> specification;

    public ArgumentValidatorImpl(OptionsSpecification<O> specification, ValidationErrorBuilder validationErrorBuilder) {
        this.specification = specification;
        this.validationErrorBuilder = validationErrorBuilder;
        this.rawArguments = new ValidationPipeline(specification, validationErrorBuilder).buildValidationPipeline(this.validatedUnparsedArguments).outputTo(this.arguments);
    }

    @Override
    public void processOption(String optionName, List<String> values) {
        this.rawArguments.put(new RawOption(optionName), values);
    }

    @Override
    public void processLastOption(String optionName, List<String> values) {
        this.rawArguments.put(new RawOption(optionName, true), values);
    }

    @Override
    public void processUnparsed(List<String> values) {
        this.validatedUnparsedArguments.addAll(values);
    }

    @Override
    public OptionCollection finishedProcessing() {
        this.validateUnparsedOptions();
        this.validationErrorBuilder.validate();
        this.specification.getMandatoryOptions()._withoutKeys(this.mandatoryArguments)._forEach(ParsedOptionSpecification.class).reportMissingTo(this.validationErrorBuilder);
        this.validationErrorBuilder.validate();
        return new OptionCollectionImpl(this.specification, this.arguments, this.validatedUnparsedArguments);
    }

    private void validateUnparsedOptions() {
        if (this.specification.hasUnparsedSpecification()) {
            UnparsedOptionSpecification unparsedSpecification = this.specification.getUnparsedSpecification();
            if (!(unparsedSpecification.isOptional() && this.validatedUnparsedArguments.isEmpty() || unparsedSpecification.allowedThisManyValues(this.validatedUnparsedArguments.size()))) {
                this.validationErrorBuilder.wrongNumberOfValues(unparsedSpecification, this.validatedUnparsedArguments);
            }
        } else if (!this.validatedUnparsedArguments.isEmpty()) {
            this.validationErrorBuilder.unexpectedTrailingValue(this.validatedUnparsedArguments);
        }
    }
}

