/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.iosp.netcdf3.N3outputStreamWriter;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFPointDataset {
    private static final String recordDimName = "record";
    private static final String latName = "latitude";
    private static final String lonName = "longitude";
    private static final String altName = "altitude";
    private static final String timeName = "time";
    private NetcdfFileStream ncfileOut;
    private List<Attribute> globalAtts;
    private String altUnits;
    private Set<Dimension> dimSet = new HashSet<Dimension>();
    private List<Variable> recordVars = new ArrayList<Variable>();
    private boolean useAlt = false;
    private boolean debug = false;

    public WriterCFPointDataset(DataOutputStream stream, List<Attribute> globalAtts, String altUnits) {
        this.ncfileOut = new NetcdfFileStream(stream);
        this.globalAtts = globalAtts;
        this.altUnits = altUnits;
        this.useAlt = altUnits != null;
    }

    public void writeHeader(List<? extends VariableSimpleIF> vars, int numrec) throws IOException {
        this.createGlobalAttributes();
        this.createRecordVariables(vars);
        this.ncfileOut.finish();
        this.ncfileOut.writeHeader(numrec);
    }

    private void createGlobalAttributes() {
        if (this.globalAtts != null) {
            for (Attribute att : this.globalAtts) {
                if (att.getShortName().equalsIgnoreCase("cdm_data_type") || att.getShortName().equalsIgnoreCase("cdm_datatype") || att.getShortName().equalsIgnoreCase("thredds_data_type")) continue;
                this.ncfileOut.addAttribute(null, att);
            }
        }
        this.ncfileOut.addAttribute(null, new Attribute("Conventions", "CF-1"));
        this.ncfileOut.addAttribute(null, new Attribute("featureType", CF.FeatureType.point.name()));
    }

    private void createRecordVariables(List<? extends VariableSimpleIF> dataVars) {
        List<Dimension> dims;
        this.ncfileOut.addDimension(null, new Dimension(recordDimName, 0, true, true, false));
        Variable timeVar = this.ncfileOut.addVariable(null, timeName, DataType.DOUBLE, recordDimName);
        timeVar.addAttribute(new Attribute("units", "secs since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", "date/time of observation"));
        this.recordVars.add(timeVar);
        Variable latVar = this.ncfileOut.addVariable(null, latName, DataType.DOUBLE, recordDimName);
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude of observation"));
        latVar.addAttribute(new Attribute("standard_name", latName));
        this.recordVars.add(latVar);
        Variable lonVar = this.ncfileOut.addVariable(null, lonName, DataType.DOUBLE, recordDimName);
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude of observation"));
        lonVar.addAttribute(new Attribute("standard_name", lonName));
        this.recordVars.add(lonVar);
        if (this.useAlt) {
            Variable altVar = this.ncfileOut.addVariable(null, altName, DataType.DOUBLE, recordDimName);
            altVar.addAttribute(new Attribute("units", this.altUnits));
            altVar.addAttribute(new Attribute("long_name", "altitude of observation"));
            altVar.addAttribute(new Attribute("standard_name", lonName));
            altVar.addAttribute(new Attribute("positive", CF1Convention.getZisPositive(altName, this.altUnits)));
            this.recordVars.add(altVar);
        }
        String coordinates = "time latitude longitude";
        if (this.useAlt) {
            coordinates = coordinates + " " + altName;
        }
        Attribute coordAtt = new Attribute("coordinates", coordinates);
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            dims = variableSimpleIF.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension dimension : this.dimSet) {
            if (!this.isExtraDimension(dimension)) continue;
            this.ncfileOut.addDimension(null, new Dimension(dimension.getShortName(), dimension.getLength(), true, false, dimension.isVariableLength()));
        }
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            if (this.ncfileOut.findVariable(variableSimpleIF.getShortName()) != null) continue;
            dims = variableSimpleIF.getDimensions();
            StringBuilder dimNames = new StringBuilder(recordDimName);
            for (Dimension d : dims) {
                if (!this.isExtraDimension(d)) continue;
                dimNames.append(" ").append(d.getShortName());
            }
            Variable newVar = this.ncfileOut.addVariable(null, variableSimpleIF.getShortName(), variableSimpleIF.getDataType(), dimNames.toString());
            this.recordVars.add(newVar);
            List<Attribute> atts = variableSimpleIF.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(coordAtt);
        }
    }

    private boolean isExtraDimension(Dimension d) {
        return !d.isUnlimited() && !d.getShortName().equalsIgnoreCase(timeName);
    }

    public void writeRecord(double lat, double lon, double alt, Date time, double[] vals, String[] svals) throws IOException {
        Variable v;
        Array data;
        int count = this.writeCoordinates(lat, lon, alt, time);
        for (double val : vals) {
            data = new ArrayDouble.D0();
            data.set(val);
            v = this.recordVars.get(count++);
            v.setCachedData(data, false);
        }
        for (String sval : svals) {
            v = this.recordVars.get(count++);
            int strlen = v.getShape(1);
            data = ArrayChar.makeFromString(sval, strlen);
            v.setCachedData(data, false);
        }
        this.ncfileOut.writeRecordData(this.recordVars);
    }

    private int writeCoordinates(double lat, double lon, double alt, Date time) {
        int count = 0;
        ArrayDouble.D0 tdata = new ArrayDouble.D0();
        double secs = (double)time.getTime() / 1000.0;
        tdata.set(secs);
        Variable v = this.recordVars.get(count++);
        v.setCachedData(tdata, false);
        ArrayDouble.D0 latData = new ArrayDouble.D0();
        latData.set(lat);
        v = this.recordVars.get(count++);
        v.setCachedData(latData, false);
        ArrayDouble.D0 lonData = new ArrayDouble.D0();
        lonData.set(lon);
        v = this.recordVars.get(count++);
        v.setCachedData(lonData, false);
        if (this.useAlt) {
            ArrayDouble.D0 altData = new ArrayDouble.D0();
            altData.set(alt);
            v = this.recordVars.get(count++);
            v.setCachedData(altData, false);
        }
        return count;
    }

    public void writeRecord(PointFeature pf, StructureData sdata) throws IOException {
        int count;
        if (this.debug) {
            System.out.println("PointFeature= " + pf);
        }
        EarthLocation loc = pf.getLocation();
        for (int i = count = this.writeCoordinates(loc.getLatitude(), loc.getLongitude(), loc.getAltitude(), pf.getObservationTimeAsDate()); i < this.recordVars.size(); ++i) {
            Variable v = this.recordVars.get(i);
            v.setCachedData(sdata.getArray(v.getShortName()), false);
        }
        this.ncfileOut.writeRecordData(this.recordVars);
    }

    public void writeRecord(PointObsDatatype pobs, StructureData sdata) throws IOException {
        int count;
        if (this.debug) {
            System.out.println("pobs= " + pobs);
        }
        EarthLocation loc = pobs.getLocation();
        for (int i = count = this.writeCoordinates(loc.getLatitude(), loc.getLongitude(), loc.getAltitude(), pobs.getObservationTimeAsDate()); i < this.recordVars.size(); ++i) {
            Variable v = this.recordVars.get(i);
            if (this.debug) {
                System.out.println(" var= " + v.getShortName());
            }
            v.setCachedData(sdata.getArray(v.getShortName()), false);
        }
        this.ncfileOut.writeRecordData(this.recordVars);
    }

    public void finish() throws IOException {
        this.ncfileOut.close();
        this.ncfileOut.stream.flush();
        this.ncfileOut.stream.close();
    }

    public static int writePointFeatureCollection(FeatureDatasetPoint pfDataset, String fileOut) throws IOException {
        PointFeatureCollection pointFeatureCollection = null;
        List<FeatureCollection> featureCollectionList = pfDataset.getPointFeatureCollectionList();
        for (FeatureCollection featureCollection : featureCollectionList) {
            if (!(featureCollection instanceof PointFeatureCollection)) continue;
            pointFeatureCollection = (PointFeatureCollection)featureCollection;
        }
        if (null == pointFeatureCollection) {
            throw new IOException("There is no PointFeatureCollection in  " + pfDataset.getLocation());
        }
        long start = System.currentTimeMillis();
        FileOutputStream fos = new FileOutputStream(fileOut);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos, 10000));
        WriterCFPointDataset writer = null;
        ArrayList<VariableSimpleIF> dataVars = new ArrayList<VariableSimpleIF>();
        NetcdfFile ncfile = pfDataset.getNetcdfFile();
        if (ncfile == null || !(ncfile instanceof NetcdfDataset)) {
            dataVars.addAll(pfDataset.getDataVariables());
        } else {
            NetcdfDataset ncd = (NetcdfDataset)ncfile;
            for (VariableSimpleIF vs : pfDataset.getDataVariables()) {
                if (ncd.findCoordinateAxis(vs.getShortName()) != null) continue;
                dataVars.add(vs);
            }
        }
        int count = 0;
        pointFeatureCollection.resetIteration();
        while (pointFeatureCollection.hasNext()) {
            PointFeature pointFeature = pointFeatureCollection.next();
            StructureData data = pointFeature.getData();
            if (count == 0) {
                EarthLocation loc = pointFeature.getLocation();
                String altUnits = Double.isNaN(loc.getAltitude()) ? null : "meters";
                writer = new WriterCFPointDataset(out, pfDataset.getGlobalAttributes(), altUnits);
                writer.writeHeader(dataVars, -1);
            }
            writer.writeRecord(pointFeature, data);
            ++count;
        }
        writer.finish();
        out.flush();
        out.close();
        long took = System.currentTimeMillis() - start;
        System.out.printf("Write %d records from %s to %s took %d msecs %n", count, pfDataset.getLocation(), fileOut, took);
        return count;
    }

    public static void rewritePointObsDataset(String fileIn, String fileOut, boolean inMemory) throws IOException {
        System.out.println("Rewrite .nc files from " + fileIn + " to " + fileOut + "inMem= " + inMemory);
        long start = System.currentTimeMillis();
        NetcdfFile ncfile = inMemory ? NetcdfFile.openInMemory(fileIn) : NetcdfFile.open(fileIn);
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        StringBuilder errlog = new StringBuilder();
        PointObsDataset pobsDataset = (PointObsDataset)TypedDatasetFactory.open(FeatureType.POINT, ncd, null, errlog);
        FileOutputStream fos = new FileOutputStream(fileOut);
        DataOutputStream out = new DataOutputStream(fos);
        WriterCFPointDataset writer = null;
        DataIterator iter = pobsDataset.getDataIterator(1000000);
        while (iter.hasNext()) {
            PointObsDatatype pobsData = (PointObsDatatype)iter.nextData();
            StructureData sdata = pobsData.getData();
            if (writer == null) {
                EarthLocation loc = pobsData.getLocation();
                String altUnits = Double.isNaN(loc.getAltitude()) ? null : "meters";
                writer = new WriterCFPointDataset(out, ncfile.getGlobalAttributes(), altUnits);
                writer.writeHeader(pobsDataset.getDataVariables(), -1);
            }
            writer.writeRecord(pobsData, sdata);
        }
        writer.finish();
        long took = System.currentTimeMillis() - start;
        System.out.println("Rewrite " + fileIn + " to " + fileOut + " took = " + took);
    }

    public static void main(String[] args) throws IOException {
        String location = "R:/testdata/point/netcdf/02092412_metar.nc";
        File file = new File(location);
        WriterCFPointDataset.rewritePointObsDataset(location, "C:/TEMP/" + file.getName(), true);
    }

    private class NetcdfFileStream
    extends NetcdfFile {
        N3outputStreamWriter swriter;
        DataOutputStream stream;

        NetcdfFileStream(DataOutputStream stream) {
            this.stream = stream;
            this.swriter = new N3outputStreamWriter(this);
        }

        void writeHeader(int numrec) throws IOException {
            this.swriter.writeHeader(this.stream, numrec);
        }

        void writeNonRecordData(String varName, Array data) throws IOException {
            this.swriter.writeNonRecordData(this.findVariable(varName), this.stream, data);
        }

        void writeRecordData(List<Variable> varList) throws IOException {
            this.swriter.writeRecordData(this.stream, varList);
        }
    }
}

