/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.InputStream;

final class SegmentTermEnum
extends TermEnum
implements Cloneable {
    private InputStream input;
    FieldInfos fieldInfos;
    long size;
    long position = -1L;
    private Term term = new Term("", "");
    private TermInfo termInfo = new TermInfo();
    private int format;
    private boolean isIndex = false;
    long indexPointer = 0L;
    int indexInterval;
    int skipInterval;
    private int formatM1SkipInterval;
    Term prev;
    private char[] buffer = new char[0];

    SegmentTermEnum(InputStream i, FieldInfos fis, boolean isi) throws IOException {
        this.input = i;
        this.fieldInfos = fis;
        this.isIndex = isi;
        int firstInt = this.input.readInt();
        if (firstInt >= 0) {
            this.format = 0;
            this.size = firstInt;
            this.indexInterval = 128;
            this.skipInterval = Integer.MAX_VALUE;
        } else {
            this.format = firstInt;
            if (this.format < -2) {
                throw new IOException("Unknown format version:" + this.format);
            }
            this.size = this.input.readLong();
            if (this.format == -1) {
                if (!this.isIndex) {
                    this.indexInterval = this.input.readInt();
                    this.formatM1SkipInterval = this.input.readInt();
                }
                this.skipInterval = Integer.MAX_VALUE;
            } else {
                this.indexInterval = this.input.readInt();
                this.skipInterval = this.input.readInt();
            }
        }
    }

    protected Object clone() {
        SegmentTermEnum clone = null;
        try {
            clone = (SegmentTermEnum)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.input = (InputStream)this.input.clone();
        clone.termInfo = new TermInfo(this.termInfo);
        if (this.term != null) {
            clone.growBuffer(this.term.text.length());
        }
        return clone;
    }

    final void seek(long pointer, int p, Term t, TermInfo ti) throws IOException {
        this.input.seek(pointer);
        this.position = p;
        this.term = t;
        this.prev = null;
        this.termInfo.set(ti);
        this.growBuffer(this.term.text.length());
    }

    public final boolean next() throws IOException {
        if (this.position++ >= this.size - 1L) {
            this.term = null;
            return false;
        }
        this.prev = this.term;
        this.term = this.readTerm();
        this.termInfo.docFreq = this.input.readVInt();
        this.termInfo.freqPointer += this.input.readVLong();
        this.termInfo.proxPointer += this.input.readVLong();
        if (this.format == -1) {
            if (!this.isIndex && this.termInfo.docFreq > this.formatM1SkipInterval) {
                this.termInfo.skipOffset = this.input.readVInt();
            }
        } else if (this.termInfo.docFreq >= this.skipInterval) {
            this.termInfo.skipOffset = this.input.readVInt();
        }
        if (this.isIndex) {
            this.indexPointer += this.input.readVLong();
        }
        return true;
    }

    private final Term readTerm() throws IOException {
        int length;
        int start = this.input.readVInt();
        int totalLength = start + (length = this.input.readVInt());
        if (this.buffer.length < totalLength) {
            this.growBuffer(totalLength);
        }
        this.input.readChars(this.buffer, start, length);
        return new Term(this.fieldInfos.fieldName(this.input.readVInt()), new String(this.buffer, 0, totalLength), false);
    }

    private final void growBuffer(int length) {
        this.buffer = new char[length];
        for (int i = 0; i < this.term.text.length(); ++i) {
            this.buffer[i] = this.term.text.charAt(i);
        }
    }

    public final Term term() {
        return this.term;
    }

    final TermInfo termInfo() {
        return new TermInfo(this.termInfo);
    }

    final void termInfo(TermInfo ti) {
        ti.set(this.termInfo);
    }

    public final int docFreq() {
        return this.termInfo.docFreq;
    }

    final long freqPointer() {
        return this.termInfo.freqPointer;
    }

    final long proxPointer() {
        return this.termInfo.proxPointer;
    }

    public final void close() throws IOException {
        this.input.close();
    }
}

