/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1Rectilyser;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class Grib1CollectionPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(Grib1CollectionPanel.class);
    private PreferencesExt prefs;
    private BeanTableSorted gds1Table;
    private BeanTableSorted param1BeanTable;
    private BeanTableSorted record1BeanTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane infoPopup3;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private IndependentWindow infoWindow3;
    private FileManager fileChooser;
    private Grib1Customizer cust = null;
    private Grib1Rectilyser rect = null;
    private String spec;
    private MFileCollectionManager dcm;
    private List<MFile> fileList;

    public Grib1CollectionPanel(JPanel buttPanel, PreferencesExt prefs) {
        this.prefs = prefs;
        AbstractButton xmlButt = BAMutil.makeButtcon("Information", "generate gds xml", false);
        xmlButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                Grib1CollectionPanel.this.generateGdsXml(f);
                Grib1CollectionPanel.this.infoPopup2.setText(f.toString());
                Grib1CollectionPanel.this.infoPopup2.gotoTop();
                Grib1CollectionPanel.this.infoWindow2.show();
            }
        });
        buttPanel.add(xmlButt);
        this.param1BeanTable = new BeanTableSorted(ParameterBean.class, (PreferencesExt)prefs.node("Param1Bean"), false, "Grib1PDSVariables", "from Grib1Input.getRecords()");
        this.param1BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ParameterBean pb = (ParameterBean)Grib1CollectionPanel.this.param1BeanTable.getSelectedBean();
                if (pb != null) {
                    Grib1CollectionPanel.this.record1BeanTable.setBeans(pb.getRecordBeans());
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.param1BeanTable.getJTable(), "Options");
        varPopup.addAction("Show raw PDS bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterBean pb = (ParameterBean)Grib1CollectionPanel.this.param1BeanTable.getSelectedBean();
                if (pb != null) {
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.showRawPds(pb.pds, f);
                    Grib1CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib1CollectionPanel.this.infoPopup2.gotoTop();
                    Grib1CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show processed PDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterBean pb = (ParameterBean)Grib1CollectionPanel.this.param1BeanTable.getSelectedBean();
                if (pb != null) {
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.showProcessedPds(pb, f);
                    Grib1CollectionPanel.this.infoPopup3.setText(f.toString());
                    Grib1CollectionPanel.this.infoPopup3.gotoTop();
                    Grib1CollectionPanel.this.infoWindow3.show();
                }
            }
        });
        this.record1BeanTable = new BeanTableSorted(RecordBean.class, (PreferencesExt)prefs.node("Record1Bean"), false, "Grib1Record", "from Grib1Input.getRecords()");
        varPopup = new PopupMenu(this.record1BeanTable.getJTable(), "Options");
        varPopup.addAction("Show raw PDS bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordBean bean = (RecordBean)Grib1CollectionPanel.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.showRawPds(bean.pds, f);
                    Grib1CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib1CollectionPanel.this.infoPopup2.gotoTop();
                    Grib1CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Complete Grib1 Record", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordBean bean = (RecordBean)Grib1CollectionPanel.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.showCompleteRecord(bean, f);
                    Grib1CollectionPanel.this.infoPopup3.setText(f.toString());
                    Grib1CollectionPanel.this.infoPopup3.gotoTop();
                    Grib1CollectionPanel.this.infoWindow3.show();
                }
            }
        });
        varPopup.addAction("Compare Grib1 Records", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib1CollectionPanel.this.record1BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    RecordBean bean1 = (RecordBean)list.get(0);
                    RecordBean bean2 = (RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.compare(bean1, bean2, f);
                    Grib1CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib1CollectionPanel.this.infoPopup2.gotoTop();
                    Grib1CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Compare Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib1CollectionPanel.this.record1BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    RecordBean bean1 = (RecordBean)list.get(0);
                    RecordBean bean2 = (RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.compareData(bean1, bean2, f);
                    Grib1CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib1CollectionPanel.this.infoPopup2.gotoTop();
                    Grib1CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordBean bean = (RecordBean)Grib1CollectionPanel.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.showData(bean, f);
                    Grib1CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib1CollectionPanel.this.infoPopup2.gotoTop();
                    Grib1CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        this.gds1Table = new BeanTableSorted(Gds1Bean.class, (PreferencesExt)prefs.node("Gds1Bean"), false, "Grib1GridDefinitionSection", "unique from Grib1Records");
        varPopup = new PopupMenu(this.gds1Table.getJTable(), "Options");
        varPopup.addAction("Show raw GDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib1CollectionPanel.this.gds1Table.getSelectedBeans();
                Formatter f = new Formatter();
                for (Object bo : list) {
                    Gds1Bean bean = (Gds1Bean)bo;
                    Grib1CollectionPanel.this.showRawGds(bean.gdss, f);
                }
                Grib1CollectionPanel.this.infoPopup.setText(f.toString());
                Grib1CollectionPanel.this.infoWindow.setVisible(true);
            }
        });
        varPopup.addAction("Compare GDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib1CollectionPanel.this.gds1Table.getSelectedBeans();
                if (list.size() == 2) {
                    Gds1Bean bean1 = (Gds1Bean)list.get(0);
                    Gds1Bean bean2 = (Gds1Bean)list.get(1);
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.this.compare(bean1.gdss, bean2.gdss, f);
                    Grib1CollectionPanel.this.infoPopup2.setText(f.toString());
                    Grib1CollectionPanel.this.infoPopup2.gotoTop();
                    Grib1CollectionPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show GDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                List list = Grib1CollectionPanel.this.gds1Table.getSelectedBeans();
                Formatter f = new Formatter();
                for (Object bo : list) {
                    Gds1Bean bean = (Gds1Bean)bo;
                    Grib1CollectionPanel.this.showGds(bean.gdss, bean.gds, f);
                }
                Grib1CollectionPanel.this.infoPopup.setText(f.toString());
                Grib1CollectionPanel.this.infoWindow.setVisible(true);
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", new Rectangle(300, 300, 500, 300)));
        this.infoPopup3 = new TextHistoryPane();
        this.infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup3);
        this.infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, this.param1BeanTable, this.record1BeanTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, this.gds1Table);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.gds1Table.saveState(false);
        this.param1BeanTable.saveState(false);
        this.record1BeanTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", this.infoWindow2.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds3", this.infoWindow3.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void showCollection(Formatter f) {
        Set<Integer> group;
        if (this.dcm == null) {
            if (this.spec == null) {
                return;
            }
            this.dcm = this.scanCollection(this.spec, f);
            if (this.dcm == null) {
                return;
            }
        }
        f.format("dcm = %s%n", this.dcm);
        for (MFile mfile : this.dcm.getFiles()) {
            f.format("  %s%n", mfile.getPath());
        }
        HashMap groups = new HashMap();
        for (Object o : this.param1BeanTable.getBeans()) {
            ParameterBean p = (ParameterBean)o;
            group = (TreeSet)groups.get(p.getGds());
            if (group == null) {
                group = new TreeSet();
                groups.put(p.getGds(), group);
            }
            for (RecordBean r : p.getRecordBeans()) {
                group.add(r.gr.getFile());
            }
        }
        for (Object o : this.gds1Table.getBeans()) {
            Gds1Bean gds = (Gds1Bean)o;
            group = (Set)groups.get(gds.getHash());
            f.format("%nGroup %s %n", gds.getGridName());
            if (group == null) continue;
            Iterator iter = group.iterator();
            while (iter.hasNext()) {
                int fileno = (Integer)iter.next();
                f.format(" %d = %s%n", fileno, this.fileList.get(fileno).getPath());
            }
            f.format("%n", new Object[0]);
        }
    }

    public void generateGdsXml(Formatter f) {
        f.format("<gribConfig>%n", new Object[0]);
        ArrayList gdss = new ArrayList(this.gds1Table.getBeans());
        Collections.sort(gdss, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int h2;
                int h1 = ((Gds1Bean)o1).gds.hashCode();
                if (h1 < (h2 = ((Gds1Bean)o2).gds.hashCode())) {
                    return -1;
                }
                if (h1 == h2) {
                    return 0;
                }
                return 1;
            }
        });
        for (Object bean : gdss) {
            Gds1Bean gbean = (Gds1Bean)bean;
            gbean.gds.hashCode();
            f.format("  <gdsName hash='%d' groupName='%s'/>%n", gbean.gds.hashCode(), gbean.getGridName());
        }
        f.format("</gribConfig>%n", new Object[0]);
    }

    public boolean writeIndex(Formatter f) throws IOException {
        File def;
        String filename;
        String name;
        int pos;
        MFileCollectionManager dcm = this.scanCollection(this.spec, f);
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
        if ((pos = (name = dcm.getCollectionName()).lastIndexOf(47)) < 0) {
            pos = name.lastIndexOf(92);
        }
        if (pos > 0) {
            name = name.substring(pos + 1);
        }
        if ((filename = this.fileChooser.chooseFilename(def = new File(dcm.getRoot(), name + ".ncx"))) == null) {
            return false;
        }
        if (!filename.endsWith(".ncx")) {
            filename = filename + ".ncx";
        }
        File idxFile = new File(filename);
        Grib1CollectionBuilder.writeIndexFile(idxFile, dcm, logger);
        return true;
    }

    private void compare(RecordBean bean1, RecordBean bean2, Formatter f) {
        String h2;
        String h1 = bean1.getHeader();
        if (!h1.equals(h2 = bean2.getHeader())) {
            f.format("WMO headers differ %s != %s %n", h1, h2);
        }
        this.compare(bean1.gr.getPDSsection(), bean2.gr.getPDSsection(), f);
        this.compare(bean1.gr.getGDSsection(), bean2.gr.getGDSsection(), f);
    }

    private void compare(Grib1SectionGridDefinition gdss1, Grib1SectionGridDefinition gdss2, Formatter f) {
        f.format("1 GribGDS hash = %s%n", gdss1.getGDS().hashCode());
        f.format("2 GribGDS hash = %s%n", gdss2.getGDS().hashCode());
        f.format("%nCompare Gds%n", new Object[0]);
        byte[] raw1 = gdss1.getRawBytes();
        byte[] raw2 = gdss2.getRawBytes();
        Misc.compare(raw1, raw2, f);
        Grib1Gds gds1 = gdss1.getGDS();
        Grib1Gds gds2 = gdss2.getGDS();
        GdsHorizCoordSys gdsh1 = gds1.makeHorizCoordSys();
        GdsHorizCoordSys gdsh2 = gds2.makeHorizCoordSys();
        f.format("%ncompare gds1 - gds22%n", new Object[0]);
        f.format(" Start x diff : %f%n", gdsh1.getStartX() - gdsh2.getStartX());
        f.format(" Start y diff : %f%n", gdsh1.getStartY() - gdsh2.getStartY());
        f.format(" End x diff : %f%n", gdsh1.getEndX() - gdsh2.getEndX());
        f.format(" End y diff : %f%n", gdsh1.getEndY() - gdsh2.getEndY());
        LatLonPoint pt1 = gdsh1.getCenterLatLon();
        LatLonPoint pt2 = gdsh2.getCenterLatLon();
        f.format(" Center lon diff : %f%n", pt1.getLongitude() - pt2.getLongitude());
        f.format(" Center lat diff : %f%n", pt1.getLatitude() - pt2.getLatitude());
    }

    private void compare(Grib1SectionProductDefinition pds1, Grib1SectionProductDefinition pds2, Formatter f) {
        f.format("%nCompare Pds%n", new Object[0]);
        byte[] raw1 = pds1.getRawBytes();
        byte[] raw2 = pds2.getRawBytes();
        Misc.compare(raw1, raw2, f);
    }

    void compareData(RecordBean bean1, RecordBean bean2, Formatter f) {
        float[] data1 = null;
        float[] data2 = null;
        try {
            data1 = bean1.readData();
            data2 = bean2.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        Misc.compare(data1, data2, f);
    }

    void showData(RecordBean bean1, Formatter f) {
        float[] data;
        try {
            data = bean1.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        for (float fd : data) {
            f.format("%f%n", Float.valueOf(fd));
        }
    }

    public void setCollection(String spec) throws IOException {
        this.spec = spec;
        Formatter f = new Formatter();
        this.dcm = this.scanCollection(spec, f);
        if (this.dcm == null) {
            JOptionPane.showMessageDialog(this, "Collection is null\n" + f.toString());
            return;
        }
        HashMap<Integer, ParameterBean> pdsSet = new HashMap<Integer, ParameterBean>();
        HashMap<Integer, Grib1SectionGridDefinition> gdsSet = new HashMap<Integer, Grib1SectionGridDefinition>();
        ArrayList<ParameterBean> params = new ArrayList<ParameterBean>();
        ArrayList<Gds1Bean> gdsList = new ArrayList<Gds1Bean>();
        this.cust = null;
        int fileno = 0;
        for (MFile mfile : this.fileList) {
            f.format("%n %s%n", mfile.getPath());
            this.processGribFile(mfile, fileno++, pdsSet, gdsSet, params, f);
        }
        this.param1BeanTable.setBeans(params);
        for (Grib1SectionGridDefinition gds : gdsSet.values()) {
            gdsList.add(new Gds1Bean(gds));
        }
        Collections.sort(gdsList);
        this.gds1Table.setBeans(gdsList);
    }

    private MFileCollectionManager scanCollection(String spec, Formatter f) {
        MFileCollectionManager dc = null;
        try {
            dc = MFileCollectionManager.open(spec, null, f);
            dc.scan(false);
            this.fileList = Misc.getList(dc.getFiles());
            return dc;
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            e.printStackTrace(new PrintStream(bos));
            f.format("%s", bos.toString());
            return null;
        }
    }

    private void processGribFile(MFile mfile, int fileno, Map<Integer, ParameterBean> pdsSet, Map<Integer, Grib1SectionGridDefinition> gdsSet, List<ParameterBean> params, Formatter f) throws IOException {
        Grib1Index index = new Grib1Index();
        if (!index.readIndex(mfile.getPath(), mfile.getLastModified())) {
            index.makeIndex(mfile.getPath(), null);
        }
        for (Grib1SectionGridDefinition gds : index.getGds()) {
            int hash = gds.getGDS().hashCode();
            if (gdsSet.get(hash) != null) continue;
            gdsSet.put(hash, gds);
        }
        for (Grib1Record gr : index.getRecords()) {
            int id;
            ParameterBean bean;
            gr.setFile(fileno);
            if (this.cust == null) {
                this.cust = Grib1Customizer.factory(gr, null);
                this.rect = new Grib1Rectilyser(this.cust, null, 0, null);
            }
            if ((bean = pdsSet.get(id = this.rect.cdmVariableHash(gr, 0))) == null) {
                bean = new ParameterBean(gr);
                pdsSet.put(id, bean);
                params.add(bean);
            }
            bean.addRecord(gr);
        }
    }

    public void setGribFile(RandomAccessFile raf) throws IOException {
        this.split2 = new JSplitPane(0, false, this.param1BeanTable, this.record1BeanTable);
        this.split2.setDividerLocation(this.prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, this.gds1Table);
        this.split.setDividerLocation(this.prefs.getInt("splitPos", 500));
        this.removeAll();
        this.add((Component)this.split, "Center");
        this.revalidate();
        HashMap<Long, Grib1SectionGridDefinition> gdsSet = new HashMap<Long, Grib1SectionGridDefinition>();
        HashMap<Integer, ParameterBean> pdsSet = new HashMap<Integer, ParameterBean>();
        ArrayList<ParameterBean> products = new ArrayList<ParameterBean>();
        raf.order(0);
        raf.seek(0L);
        this.cust = null;
        int count = 0;
        Grib1RecordScanner reader = new Grib1RecordScanner(raf);
        while (reader.hasNext()) {
            Grib1SectionProductDefinition pds;
            ParameterBean bean;
            Grib1Record gr = reader.next();
            if (this.cust == null) {
                this.cust = Grib1Customizer.factory(gr, null);
            }
            if ((bean = (ParameterBean)pdsSet.get(this.makeUniqueId(pds = gr.getPDSsection()))) == null) {
                bean = new ParameterBean(gr);
                pdsSet.put(this.makeUniqueId(pds), bean);
                products.add(bean);
            }
            bean.addRecord(gr);
            Grib1SectionGridDefinition gds = gr.getGDSsection();
            gdsSet.put(gds.calcCRC(), gds);
            ++count;
        }
        this.param1BeanTable.setBeans(products);
        this.record1BeanTable.setBeans(new ArrayList());
        System.out.printf("GribRawPanel products = %d records = %d%n", products.size(), count);
        ArrayList<Gds1Bean> gdsList = new ArrayList<Gds1Bean>();
        for (Grib1SectionGridDefinition gds : gdsSet.values()) {
            gdsList.add(new Gds1Bean(gds));
        }
        this.gds1Table.setBeans(gdsList);
    }

    public int makeUniqueId(Grib1SectionProductDefinition pds) {
        int result = 17;
        result += result * 37 + pds.getParameterNumber();
        result *= result * 37 + pds.getLevelType();
        return result;
    }

    private void showRawPds(Grib1SectionProductDefinition pds, Formatter f) {
        byte[] raw = pds.getRawBytes();
        f.format("%n", new Object[0]);
        for (int i = 0; i < raw.length; ++i) {
            f.format(" %3d : %3d%n", i + 1, raw[i]);
        }
    }

    public void showRawGds(Grib1SectionGridDefinition gds, Formatter f) {
        byte[] raw = gds.getRawBytes();
        f.format("%n", new Object[0]);
        for (int i = 0; i < raw.length; ++i) {
            f.format(" %3d : %3d%n", i + 1, raw[i]);
        }
    }

    public void showGds(Grib1SectionGridDefinition gdss, Grib1Gds gds, Formatter f) {
        f.format("Grib1SectionGridDefinition = %s", gdss);
        f.format("Grib1GDS hash = %s%n", gds.hashCode());
        f.format("Grib1GDS = %s", gds);
        GdsHorizCoordSys gdsHc = gds.makeHorizCoordSys();
        f.format("%n%n%s", gdsHc);
        ProjectionImpl proj = gdsHc.proj;
        f.format("%n%nProjection %s%n", proj.getName());
        for (Parameter p : proj.getProjectionParameters()) {
            f.format("  %s == %s%n", p.getName(), p.getStringValue());
        }
    }

    public void showCompleteRecord(RecordBean rbean, Formatter f) {
        f.format("Header = %s%n", new String(rbean.gr.getHeader()));
        f.format("file = %d %s%n", rbean.gr.getFile(), this.fileList.get(rbean.gr.getFile()).getPath());
        rbean.pds.showPds(this.cust, f);
        this.showGds(rbean.gds, rbean.gds.getGDS(), f);
    }

    public void showProcessedPds(ParameterBean pbean, Formatter f) {
        pbean.pds.showPds(this.cust, f);
    }

    public class Gds1Bean
    implements Comparable<Gds1Bean> {
        Grib1SectionGridDefinition gdss;
        Grib1Gds gds;

        public Gds1Bean() {
        }

        public Gds1Bean(Grib1SectionGridDefinition m) {
            this.gdss = m;
            this.gds = this.gdss.getGDS();
        }

        public long getHash() {
            return this.gds.hashCode();
        }

        public int getGridNo() {
            return this.gdss.getGridTemplate();
        }

        public boolean isVertCoords() {
            return this.gdss.hasVerticalCoordinateParameters();
        }

        public String getGridName() {
            return this.gds.getNameShort();
        }

        public String getScanMode() {
            return Long.toBinaryString(this.gds.getScanMode());
        }

        public String getResolution() {
            return Long.toBinaryString(this.gds.getResolution());
        }

        public double getDx() {
            return this.gds.getDx();
        }

        public double getDy() {
            return this.gds.getDy();
        }

        public double getDxRaw() {
            return this.gds.getDxRaw();
        }

        public double getDyRaw() {
            return this.gds.getDyRaw();
        }

        public int getNx() {
            return this.gds.getNx();
        }

        public int getNy() {
            return this.gds.getNy();
        }

        public int getNxRaw() {
            return this.gds.getNxRaw();
        }

        public int getNyRaw() {
            return this.gds.getNyRaw();
        }

        @Override
        public int compareTo(Gds1Bean o) {
            return this.getGridName().compareTo(o.getGridName());
        }
    }

    public class RecordBean {
        Grib1Record gr;
        Grib1SectionGridDefinition gds;
        Grib1SectionProductDefinition pds;
        Grib1ParamLevel plevel;
        Grib1ParamTime ptime;

        public RecordBean() {
        }

        public RecordBean(Grib1Record m) {
            this.gr = m;
            this.gds = this.gr.getGDSsection();
            this.pds = this.gr.getPDSsection();
            this.plevel = Grib1CollectionPanel.this.cust.getParamLevel(this.pds);
            this.ptime = this.pds.getParamTime(Grib1CollectionPanel.this.cust);
        }

        public String getHeader() {
            return new String(this.gr.getHeader()).trim();
        }

        public String getPeriod() {
            return GribUtils.getCalendarPeriod(this.pds.getTimeUnit()).toString();
        }

        public String getTimeTypeName() {
            return this.ptime.getTimeTypeName();
        }

        public CalendarDate getReferenceDate() {
            return this.pds.getReferenceDate();
        }

        public int getTimeValue1() {
            return this.pds.getTimeValue1();
        }

        public int getTimeValue2() {
            return this.pds.getTimeValue2();
        }

        public int getTimeType() {
            return this.pds.getTimeRangeIndicator();
        }

        public String getTimeCoord() {
            if (this.ptime.isInterval()) {
                int[] intv = this.ptime.getInterval();
                return intv[0] + "-" + intv[1] + "(" + this.ptime.getIntervalSize() + ")";
            }
            return Integer.toString(this.ptime.getForecastTime());
        }

        public String getNIncludeMiss() {
            return this.pds.getNincluded() + "/" + this.pds.getNmissing();
        }

        public int getPertNum() {
            return this.pds.getPerturbationNumber();
        }

        public int getLevelType() {
            return this.plevel.getLevelType();
        }

        public String getLevel() {
            if (Grib1CollectionPanel.this.cust.isLayer(this.pds.getLevelType())) {
                return this.plevel.getValue1() + "-" + this.plevel.getValue2();
            }
            return Float.toString(this.plevel.getValue1());
        }

        public long getPos() {
            return this.gr.getDataSection().getStartingPosition();
        }

        public final int getFile() {
            return this.gr.getFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        float[] readData() throws IOException {
            int fileno = this.gr.getFile();
            MFile mfile = (MFile)Grib1CollectionPanel.this.fileList.get(fileno);
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(mfile.getPath(), "r");
                raf.order(0);
                float[] fArray = this.gr.readData(raf);
                return fArray;
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }
    }

    public class ParameterBean {
        Grib1SectionProductDefinition pds;
        List<RecordBean> records;
        String header;
        Grib1Parameter param;
        int gdsHash;

        public ParameterBean() {
        }

        public ParameterBean(Grib1Record r) {
            this.pds = r.getPDSsection();
            this.header = new String(r.getHeader());
            this.records = new ArrayList<RecordBean>();
            this.param = Grib1CollectionPanel.this.cust.getParameter(this.pds.getCenter(), this.pds.getSubCenter(), this.pds.getTableVersion(), this.pds.getParameterNumber());
            this.gdsHash = r.getGDSsection().getGDS().hashCode();
        }

        void addRecord(Grib1Record r) {
            this.records.add(new RecordBean(r));
        }

        List<RecordBean> getRecordBeans() {
            return this.records;
        }

        public String getTableVersion() {
            return this.pds.getCenter() + "-" + this.pds.getSubCenter() + "-" + this.pds.getTableVersion();
        }

        public final CalendarDate getReferenceDate() {
            return this.pds.getReferenceDate();
        }

        public int getParamNo() {
            return this.pds.getParameterNumber();
        }

        public final int getLevelType() {
            return this.pds.getLevelType();
        }

        public String getParamDesc() {
            return this.param == null ? null : this.param.getDescription();
        }

        public String getName() {
            if (this.param == null) {
                return null;
            }
            return Grib1CollectionPanel.this.cust.makeVariableName(this.pds);
        }

        public String getUnit() {
            return this.param == null ? null : this.param.getUnit();
        }

        public int getGds() {
            return this.gdsHash;
        }

        public int getGen() {
            return this.pds.getGenProcess();
        }

        public final String getLevelName() {
            Grib1ParamLevel plevel = Grib1CollectionPanel.this.cust.getParamLevel(this.pds);
            return plevel.getNameShort();
        }

        public int getN() {
            return this.records.size();
        }

        public final String getStatType() {
            Grib1ParamTime ptime = this.pds.getParamTime(Grib1CollectionPanel.this.cust);
            GribStatType stype = ptime.getStatType();
            return stype == null ? null : stype.name();
        }
    }
}

