/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft.point.bufr.BufrCdmIndexProto;
import ucar.nc2.ft.point.bufr.StandardFields;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.tables.CodeFlagTables;

class Construct2 {
    private static Logger log = LoggerFactory.getLogger(Construct2.class);
    private static final boolean warnUnits = false;
    private NetcdfFile ncfile;
    private Sequence recordStructure;
    private int centerId;
    private Formatter coordinates = new Formatter();
    private int seqNum = 1;
    private int tempNo = 1;
    private Map<String, Integer> names = new HashMap<String, Integer>(100);

    Construct2(Message proto, BufrConfig bufrConfig, NetcdfFile nc) throws IOException {
        this.ncfile = nc;
        this.ncfile.addAttribute(null, new Attribute("history", "Read using CDM BufrIosp2"));
        if (bufrConfig.getFeatureType() != null) {
            this.ncfile.addAttribute(null, "featureType", bufrConfig.getFeatureType().toString());
        }
        this.ncfile.addAttribute(null, "location", nc.getLocation());
        this.ncfile.addAttribute(null, "BUFR:categoryName", proto.getLookup().getCategoryName());
        this.ncfile.addAttribute(null, "BUFR:subCategoryName", proto.getLookup().getSubCategoryName());
        this.ncfile.addAttribute(null, "BUFR:centerName", proto.getLookup().getCenterName());
        this.ncfile.addAttribute(null, new Attribute("BUFR:category", proto.ids.getCategory()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:subCategory", proto.ids.getSubCategory()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:localSubCategory", proto.ids.getLocalSubCategory()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:centerId", proto.ids.getCenterId()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:subCenter", proto.ids.getSubCenterId()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:table", proto.ids.getMasterTableId()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:tableVersion", proto.ids.getMasterTableVersion()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:localTableVersion", proto.ids.getLocalTableVersion()));
        this.ncfile.addAttribute(null, "Conventions", "BUFR/CDM");
        this.ncfile.addAttribute(null, new Attribute("BUFR:edition", proto.is.getBufrEdition()));
        this.centerId = proto.ids.getCenterId();
        String header = proto.getHeader();
        if (header != null && header.length() > 0) {
            this.ncfile.addAttribute(null, new Attribute("WMO Header", header));
        }
        this.makeObsRecord(bufrConfig);
        String coordS = this.coordinates.toString();
        if (!coordS.isEmpty()) {
            this.recordStructure.addAttribute(new Attribute("coordinates", coordS));
        }
        this.ncfile.finish();
    }

    Sequence getObsStructure() {
        return this.recordStructure;
    }

    private void makeObsRecord(BufrConfig bufrConfig) throws IOException {
        this.recordStructure = new Sequence(this.ncfile, null, null, "obs");
        this.ncfile.addVariable(null, this.recordStructure);
        BufrConfig.FieldConverter root = bufrConfig.getRootConverter();
        for (BufrConfig.FieldConverter fld : root.flds) {
            DataDescriptor dkey = fld.dds;
            if (!dkey.isOkForVariable()) continue;
            if (dkey.replication == 0) {
                this.addSequence(this.recordStructure, fld);
                continue;
            }
            if (dkey.replication > 1) {
                List<BufrConfig.FieldConverter> subFlds = fld.flds;
                List<DataDescriptor> subKeys = dkey.subKeys;
                if (subKeys.size() == 1) {
                    DataDescriptor subDds = dkey.subKeys.get(0);
                    BufrConfig.FieldConverter subFld = subFlds.get(0);
                    if (subDds.dpi != null) {
                        this.addDpiStructure(this.recordStructure, fld, subFld);
                        continue;
                    }
                    if (subDds.replication == 1) {
                        Variable v = this.addVariable(this.recordStructure, subFld, dkey.replication);
                        v.setSPobject(fld);
                        continue;
                    }
                    this.addStructure(this.recordStructure, fld, dkey.replication);
                    continue;
                }
                if (subKeys.size() <= 1) continue;
                this.addStructure(this.recordStructure, fld, dkey.replication);
                continue;
            }
            this.addVariable(this.recordStructure, fld, dkey.replication);
        }
    }

    private void addStructure(Structure parent, BufrConfig.FieldConverter fld, int count) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findUniqueName(parent, fld.getName(), "struct");
        Structure struct = new Structure(this.ncfile, null, parent, uname);
        try {
            struct.setDimensionsAnonymous(new int[]{count});
        }
        catch (InvalidRangeException e) {
            log.error("illegal count= " + count + " for " + fld);
        }
        for (BufrConfig.FieldConverter subKey : fld.flds) {
            this.addMember(struct, subKey);
        }
        parent.addMemberVariable(struct);
        struct.setSPobject(fld);
        dkey.refersTo = struct;
    }

    private void addSequence(Structure parent, BufrConfig.FieldConverter fld) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findUniqueName(parent, fld.getName(), "seq");
        Sequence seq = new Sequence(this.ncfile, null, parent, uname);
        seq.setDimensions("");
        for (BufrConfig.FieldConverter subKey : fld.flds) {
            this.addMember(seq, subKey);
        }
        parent.addMemberVariable(seq);
        seq.setSPobject(fld);
        dkey.refersTo = seq;
    }

    private void addMember(Structure parent, BufrConfig.FieldConverter fld) {
        DataDescriptor dkey = fld.dds;
        if (dkey.replication == 0) {
            this.addSequence(parent, fld);
        } else if (dkey.replication > 1) {
            List<DataDescriptor> subKeys = dkey.subKeys;
            if (subKeys.size() == 1) {
                DataDescriptor sub = dkey.subKeys.get(0);
                BufrConfig.FieldConverter subFld = fld.flds.get(0);
                Variable v = this.addVariable(parent, subFld, dkey.replication);
                v.setSPobject(fld);
            } else {
                this.addStructure(parent, fld, dkey.replication);
            }
        } else {
            this.addVariable(parent, fld, dkey.replication);
        }
    }

    private void addDpiStructure(Structure parent, BufrConfig.FieldConverter parentFld, BufrConfig.FieldConverter dpiField) {
        String uname;
        DataDescriptor dpiKey = dpiField.dds;
        dpiKey.name = uname = this.findUniqueName(parent, dpiField.getName(), "struct");
        Structure struct = new Structure(this.ncfile, null, parent, uname);
        int n = parentFld.dds.replication;
        try {
            struct.setDimensionsAnonymous(new int[]{n});
        }
        catch (InvalidRangeException e) {
            log.error("illegal count= 1 for " + dpiField);
        }
        Variable v = new Variable(this.ncfile, null, struct, "name");
        v.setDataType(DataType.STRING);
        v.setDimensions("");
        struct.addMemberVariable(v);
        v = new Variable(this.ncfile, null, struct, "data");
        v.setDataType(DataType.FLOAT);
        v.setDimensions("");
        struct.addMemberVariable(v);
        parent.addMemberVariable(struct);
        struct.setSPobject(dpiField);
        dpiKey.refersTo = struct;
    }

    private void addDpiSequence(Structure parent, BufrConfig.FieldConverter fld) {
        Structure struct = new Structure(this.ncfile, null, parent, "statistics");
        try {
            struct.setDimensionsAnonymous(new int[]{fld.dds.replication});
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        Variable v = new Variable(this.ncfile, null, struct, "name");
        v.setDataType(DataType.STRING);
        v.setDimensions("");
        struct.addMemberVariable(v);
        v = new Variable(this.ncfile, null, struct, "data");
        v.setDataType(DataType.FLOAT);
        v.setDimensions("");
        struct.addMemberVariable(v);
        parent.addMemberVariable(struct);
    }

    private Variable addVariable(Structure struct, BufrConfig.FieldConverter fld, int count) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findGloballyUniqueName(fld.getName(), "unknown");
        Variable v = new Variable(this.ncfile, null, struct, uname);
        try {
            if (count > 1) {
                v.setDimensionsAnonymous(new int[]{count});
            } else {
                v.setDimensions("");
            }
        }
        catch (InvalidRangeException e) {
            log.error("illegal count= " + count + " for " + fld);
        }
        if (fld.getDesc() != null) {
            v.addAttribute(new Attribute("long_name", fld.getDesc()));
        }
        if (fld.getUnits() != null) {
            String units = fld.getUnits();
            if (units.equalsIgnoreCase("Code_Table") || units.equalsIgnoreCase("Code Table")) {
                v.addAttribute(new Attribute("units", "CodeTable " + fld.dds.getFxyName()));
            } else if (units.equalsIgnoreCase("Flag_Table") || units.equalsIgnoreCase("Flag Table")) {
                v.addAttribute(new Attribute("units", "FlagTable " + fld.dds.getFxyName()));
            } else if (!units.startsWith("CCITT") && !units.startsWith("Numeric")) {
                v.addAttribute(new Attribute("units", units));
            }
        }
        DataDescriptor dataDesc = fld.dds;
        if (dataDesc.type == 1) {
            v.setDataType(DataType.CHAR);
            int size = dataDesc.bitWidth / 8;
            try {
                v.setDimensionsAnonymous(new int[]{size});
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        } else if (dataDesc.type == 2 && CodeFlagTables.hasTable(dataDesc.fxy)) {
            int nbits = dataDesc.bitWidth;
            int nbytes = nbits % 8 == 0 ? nbits / 8 : nbits / 8 + 1;
            CodeFlagTables ct = CodeFlagTables.getTable(dataDesc.fxy);
            if (nbytes == 1) {
                v.setDataType(DataType.ENUM1);
            } else if (nbytes == 2) {
                v.setDataType(DataType.ENUM2);
            } else if (nbytes == 4) {
                v.setDataType(DataType.ENUM4);
            }
            v.addAttribute(new Attribute("BUFR:CodeTable", ct.getName() + " (" + dataDesc.getFxyName() + ")"));
            Group g = struct.getParentGroup();
            EnumTypedef enumTypedef = g.findEnumeration(ct.getName());
            if (enumTypedef == null) {
                enumTypedef = new EnumTypedef(ct.getName(), ct.getMap());
                g.addEnumeration(enumTypedef);
            }
            v.setEnumTypedef(enumTypedef);
        } else {
            double scale;
            int nbits = dataDesc.bitWidth;
            if (nbits < 9) {
                v.setDataType(DataType.BYTE);
                if (nbits == 8) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (short)BufrNumbers.missingValue(nbits)));
                } else {
                    v.addAttribute(new Attribute("missing_value", (byte)BufrNumbers.missingValue(nbits)));
                }
            } else if (nbits < 17) {
                v.setDataType(DataType.SHORT);
                if (nbits == 16) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (int)BufrNumbers.missingValue(nbits)));
                } else {
                    v.addAttribute(new Attribute("missing_value", (short)BufrNumbers.missingValue(nbits)));
                }
            } else if (nbits < 33) {
                v.setDataType(DataType.INT);
                if (nbits == 32) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (int)BufrNumbers.missingValue(nbits)));
                } else {
                    v.addAttribute(new Attribute("missing_value", (int)BufrNumbers.missingValue(nbits)));
                }
            } else {
                v.setDataType(DataType.LONG);
                v.addAttribute(new Attribute("missing_value", BufrNumbers.missingValue(nbits)));
            }
            int scale10 = dataDesc.scale;
            double d = scale = scale10 == 0 ? 1.0 : Math.pow(10.0, -scale10);
            if (scale10 != 0) {
                v.addAttribute(new Attribute("scale_factor", Float.valueOf((float)scale)));
            }
            if (dataDesc.refVal != 0) {
                v.addAttribute(new Attribute("add_offset", Float.valueOf((float)scale * (float)dataDesc.refVal)));
            }
        }
        this.annotate(v, fld);
        v.addAttribute(new Attribute("BUFR:TableB_descriptor", dataDesc.getFxyName()));
        v.addAttribute(new Attribute("BUFR:bitWidth", dataDesc.bitWidth));
        struct.addMemberVariable(v);
        v.setSPobject(fld);
        return v;
    }

    private String findUniqueName(Structure struct, String want, String def) {
        if (want == null) {
            return def + this.tempNo++;
        }
        String vwant = NetcdfFile.makeValidCdmObjectName(want);
        Variable oldV = struct.findVariable(vwant);
        if (oldV == null) {
            return vwant;
        }
        int seq = 2;
        String wantSeq;
        while ((oldV = struct.findVariable(wantSeq = vwant + "-" + seq)) != null) {
            ++seq;
        }
        return wantSeq;
    }

    private String findGloballyUniqueName(String want, String def) {
        if (want == null) {
            return def + this.tempNo++;
        }
        String vwant = NetcdfFile.makeValidCdmObjectName(want);
        Integer have = this.names.get(vwant);
        if (have == null) {
            this.names.put(vwant, 1);
            return vwant;
        }
        have = have + 1;
        String wantSeq = vwant + "-" + have;
        this.names.put(vwant, have);
        return wantSeq;
    }

    private void annotate(Variable v, BufrConfig.FieldConverter fld) {
        if (fld.type == null) {
            return;
        }
        switch (fld.type) {
            case lat: {
                v.addAttribute(new Attribute("units", "degrees_north"));
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                this.coordinates.format("%s ", v.getShortName());
                break;
            }
            case lon: {
                v.addAttribute(new Attribute("units", "degrees_east"));
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                this.coordinates.format("%s ", v.getShortName());
                break;
            }
            case height: {
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
                this.coordinates.format("%s ", v.getShortName());
                break;
            }
            case heightOfStation: {
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
                this.coordinates.format("%s ", v.getShortName());
                break;
            }
            case heightAboveStation: {
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
                this.coordinates.format("%s ", v.getShortName());
                break;
            }
            case stationId: {
                v.addAttribute(new Attribute("standard_name", "station_id"));
                break;
            }
            case wmoId: {
                v.addAttribute(new Attribute("standard_name", "station_WMO_id"));
            }
        }
    }

    private void annotateObs(Sequence recordStructure) {
        StandardFields.StandardFieldsFromStructure extract = new StandardFields.StandardFieldsFromStructure(this.centerId, recordStructure);
        Formatter f = new Formatter();
        String name = extract.getFieldName(BufrCdmIndexProto.FldType.lat);
        if (name != null) {
            f.format("%s ", name);
        }
        if ((name = extract.getFieldName(BufrCdmIndexProto.FldType.lon)) != null) {
            f.format("%s ", name);
        }
        if ((name = extract.getFieldName(BufrCdmIndexProto.FldType.height)) != null) {
            f.format("%s ", name);
        }
        if ((name = extract.getFieldName(BufrCdmIndexProto.FldType.heightAboveStation)) != null) {
            f.format("%s ", name);
        }
        recordStructure.addAttribute(new Attribute("coordinates", f.toString()));
    }
}

