/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.point.StationRegionDateChooser;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentDialog;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class StationObsViewer
extends JPanel {
    private PreferencesExt prefs;
    private StationObsDataset sds;
    private StationRegionDateChooser chooser;
    private BeanTableSorted stnTable;
    private StructureTable obsTable;
    private JSplitPane splitH = null;
    private JSplitPane splitV = null;
    private IndependentDialog infoWindow;
    private boolean eventsOK = true;
    private boolean debugStationRegionSelect = false;
    private boolean debugStationDatsets = false;
    private boolean debugQuery = false;

    public StationObsViewer(PreferencesExt prefs) {
        this.prefs = prefs;
        this.chooser = new StationRegionDateChooser();
        this.chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Station")) {
                    Station selectedStation = (Station)e.getNewValue();
                    if (StationObsViewer.this.debugStationRegionSelect) {
                        System.out.println("selectedStation= " + selectedStation.getName());
                    }
                    StationObsViewer.this.eventsOK = false;
                    StationObsViewer.this.stnTable.setSelectedBean(selectedStation);
                    StationObsViewer.this.eventsOK = true;
                }
            }
        });
        AbstractAction queryAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean useDate;
                if (StationObsViewer.this.sds == null) {
                    return;
                }
                DateRange dateRange = StationObsViewer.this.chooser.getDateRange();
                boolean bl = useDate = null != dateRange;
                if (!useDate) {
                    return;
                }
                Date startDate = dateRange.getStart().getDate();
                Date endDate = dateRange.getEnd().getDate();
                if (StationObsViewer.this.debugQuery) {
                    System.out.println("date range=" + dateRange);
                }
                LatLonRect geoRegion = null;
                Station selectedStation = null;
                boolean useRegion = StationObsViewer.this.chooser.getGeoSelectionMode();
                if (useRegion) {
                    geoRegion = StationObsViewer.this.chooser.getGeoSelectionLL();
                    if (StationObsViewer.this.debugQuery) {
                        System.out.println("geoRegion=" + geoRegion);
                    }
                } else {
                    selectedStation = StationObsViewer.this.chooser.getSelectedStation();
                }
                if (selectedStation == null && !useRegion) {
                    return;
                }
                try {
                    List obsList;
                    if (useRegion) {
                        obsList = useDate ? StationObsViewer.this.sds.getData(geoRegion, startDate, endDate) : StationObsViewer.this.sds.getData(geoRegion);
                    } else {
                        List list = obsList = useDate ? StationObsViewer.this.sds.getData(selectedStation, startDate, endDate) : StationObsViewer.this.sds.getData(selectedStation);
                    }
                    if (StationObsViewer.this.debugQuery) {
                        System.out.println("obsList=" + obsList.size());
                    }
                    StationObsViewer.this.setObservations(obsList);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(queryAction, "query", "query for data", false, 81, -1);
        this.chooser.addToolbarAction(queryAction);
        AbstractAction getallAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StationObsViewer.this.sds == null) {
                    return;
                }
                try {
                    List obsList = StationObsViewer.this.sds.getData();
                    if (obsList != null) {
                        StationObsViewer.this.setObservations(obsList);
                    } else {
                        JOptionPane.showMessageDialog(StationObsViewer.this, "GetAllData not implemented");
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        BAMutil.setActionProperties(getallAction, "GetAll", "get ALL data", false, 65, -1);
        this.chooser.addToolbarAction(getallAction);
        this.stnTable = new BeanTableSorted(StationBean.class, (PreferencesExt)prefs.node("StationBeans"), false);
        this.stnTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StationBean sb = (StationBean)StationObsViewer.this.stnTable.getSelectedBean();
                StationObsViewer.this.setStation(sb);
                if (StationObsViewer.this.debugStationRegionSelect) {
                    System.out.println("stnTable selected= " + sb.getName());
                }
                if (StationObsViewer.this.eventsOK) {
                    StationObsViewer.this.chooser.setSelectedStation(sb.getName());
                }
            }
        });
        this.obsTable = new StructureTable((PreferencesExt)prefs.node("ObsBean"));
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentDialog(null, true, "Station Information", infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.splitH = new JSplitPane(1, false, this.stnTable, this.chooser);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 400));
        this.splitV = new JSplitPane(0, false, this.splitH, this.obsTable);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
    }

    public void setDataset(StationObsDataset dataset) {
        this.sds = dataset;
        if (this.debugStationDatsets) {
            System.out.println("PointObsViewer open type " + dataset.getClass().getName());
        }
        Date startDate = dataset.getStartDate();
        Date endDate = dataset.getEndDate();
        if (startDate != null && endDate != null) {
            this.chooser.setDateRange(new DateRange(startDate, endDate));
        }
        ArrayList<StationBean> stationBeans = new ArrayList<StationBean>();
        try {
            List<Station> stations = this.sds.getStations();
            if (stations == null) {
                return;
            }
            for (Station station : stations) {
                stationBeans.add(new StationBean((StationImpl)station));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        this.stnTable.setBeans(stationBeans);
        this.chooser.setStations(stationBeans);
        this.obsTable.clear();
    }

    public void setStation(StationBean sb) {
        try {
            List obsList = this.sds.getData(sb.s);
            this.stnTable.getJTable().repaint();
            this.setObservations(obsList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setObservations(List obsList) throws IOException {
        if (obsList.size() == 0) {
            this.obsTable.clear();
            return;
        }
        this.obsTable.setPointObsData(obsList);
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.stnTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
        this.obsTable.saveState();
    }

    public class StationBean
    implements Station {
        private StationImpl s;

        public StationBean(StationImpl s) {
            this.s = s;
        }

        @Override
        public String getName() {
            return this.s.getName();
        }

        @Override
        public String getDescription() {
            return this.s.getDescription();
        }

        @Override
        public int getNobs() {
            return this.s.getNumObservations();
        }

        @Override
        public String getWmoId() {
            return this.s.getWmoId();
        }

        @Override
        public double getLatitude() {
            return this.s.getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.s.getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.s.getAltitude();
        }

        @Override
        public LatLonPoint getLatLon() {
            return new LatLonPointImpl(this.getLatitude(), this.getLongitude());
        }

        @Override
        public boolean isMissing() {
            return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }
}

