/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.in.TiffReader;

public class PerkinElmerReader
extends FormatReader {
    protected TiffReader[] tiff;
    protected String[] files;
    private boolean isTiff = true;
    private Vector allFiles;
    private String details;
    private String sliceSpace;

    public PerkinElmerReader() {
        super("PerkinElmer", new String[]{"ano", "cfg", "csv", "htm", "rec", "tim", "zpo"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        if (this.isTiff) {
            this.tiff[no / this.core.sizeC[0]].setId(this.files[no / this.core.sizeC[0]]);
            return this.tiff[no / this.core.sizeC[0]].openBytes(0, buf);
        }
        FormatTools.checkBufferSize(this, buf.length);
        String file = this.files[no];
        RandomAccessStream ras = new RandomAccessStream(file);
        ras.skipBytes(6);
        ras.read(buf);
        ras.close();
        return buf;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.allFiles.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.tiff != null) {
                for (int i = 0; i < this.tiff.length; ++i) {
                    if (this.tiff[i] == null) continue;
                    this.tiff[i].close(fileOnly);
                }
            }
        } else {
            this.close();
        }
    }

    public void close() throws IOException {
        this.currentId = null;
        this.files = null;
        if (this.tiff != null) {
            for (int i = 0; i < this.tiff.length; ++i) {
                if (this.tiff[i] == null) continue;
                this.tiff[i].close();
            }
        }
    }

    public boolean isThisType(String name, boolean open) {
        if (name.toLowerCase().endsWith(".cfg")) {
            try {
                RandomAccessStream s = new RandomAccessStream(name);
                String ss = s.readString(512);
                return ss.indexOf("Series") != -1;
            }
            catch (IOException e) {
                if (debug) {
                    this.trace(e);
                }
                return false;
            }
        }
        return super.isThisType(name, open);
    }

    protected void initFile(String id) throws FormatException, IOException {
        MetadataStore store;
        block100: {
            RandomAccessStream read;
            int tNum;
            byte[] data;
            int i;
            String ext;
            if (this.currentId != null && (id.equals(this.currentId) || this.isUsedFile(id))) {
                return;
            }
            this.status("Finding HTML companion file");
            if (debug) {
                this.debug("PerkinElmerReader.initFile(" + id + ")");
            }
            if (!id.toLowerCase().endsWith(".htm")) {
                Location parent = new Location(id).getAbsoluteFile().getParentFile();
                String[] ls = parent.list();
                for (int i2 = 0; i2 < ls.length; ++i2) {
                    if (!ls[i2].toLowerCase().endsWith(".htm")) continue;
                    id = new Location(parent.getAbsolutePath(), ls[i2]).getAbsolutePath();
                    break;
                }
            }
            super.initFile(id);
            this.allFiles = new Vector();
            Location tempFile = new Location(id).getAbsoluteFile();
            Location workingDir = tempFile.getParentFile();
            if (workingDir == null) {
                workingDir = new Location(".");
            }
            String workingDirPath = workingDir.getPath() + File.separator;
            String[] ls = workingDir.list();
            this.allFiles.add(id);
            this.status("Searching for all metadata companion files");
            int cfgPos = -1;
            int anoPos = -1;
            int recPos = -1;
            int timPos = -1;
            int csvPos = -1;
            int zpoPos = -1;
            int htmPos = -1;
            int filesPt = 0;
            this.files = new String[ls.length];
            String tempFileName = tempFile.getName();
            int dot = tempFileName.lastIndexOf(".");
            String check = dot < 0 ? tempFileName : tempFileName.substring(0, dot);
            String prefix = null;
            for (int i3 = 0; i3 < ls.length; ++i3) {
                int d = ls[i3].lastIndexOf(".");
                while (d == -1 && i3 < ls.length - 1) {
                    d = ls[++i3].lastIndexOf(".");
                }
                String s = dot < 0 ? ls[i3] : ls[i3].substring(0, d);
                String filename = ls[i3].toLowerCase();
                if (!s.startsWith(check) && !check.startsWith(s) && (prefix == null || !s.startsWith(prefix))) continue;
                if (cfgPos == -1 && filename.endsWith(".cfg")) {
                    cfgPos = i3;
                    prefix = ls[i3].substring(0, d);
                }
                if (anoPos == -1 && filename.endsWith(".ano")) {
                    anoPos = i3;
                    prefix = ls[i3].substring(0, d);
                }
                if (recPos == -1 && filename.endsWith(".rec")) {
                    recPos = i3;
                    prefix = ls[i3].substring(0, d);
                }
                if (timPos == -1 && filename.endsWith(".tim")) {
                    timPos = i3;
                    prefix = ls[i3].substring(0, d);
                }
                if (csvPos == -1 && filename.endsWith(".csv")) {
                    csvPos = i3;
                    prefix = ls[i3].substring(0, d);
                }
                if (zpoPos == -1 && filename.endsWith(".zpo")) {
                    zpoPos = i3;
                    prefix = ls[i3].substring(0, d);
                }
                if (htmPos == -1 && filename.endsWith(".htm")) {
                    htmPos = i3;
                    prefix = ls[i3].substring(0, d);
                }
                if (filename.endsWith(".tif") || filename.endsWith(".tiff")) {
                    this.files[filesPt] = workingDirPath + ls[i3];
                    ++filesPt;
                }
                try {
                    ext = filename.substring(filename.lastIndexOf(".") + 1);
                    Integer.parseInt(ext);
                    this.isTiff = false;
                    this.files[filesPt] = workingDirPath + ls[i3];
                    ++filesPt;
                    continue;
                }
                catch (NumberFormatException e) {
                    try {
                        String ext2 = filename.substring(filename.lastIndexOf(".") + 1);
                        Integer.parseInt(ext2, 16);
                        this.isTiff = false;
                        this.files[filesPt] = workingDirPath + ls[i3];
                        ++filesPt;
                        continue;
                    }
                    catch (NumberFormatException exc) {
                        if (!debug) continue;
                        this.trace(exc);
                    }
                }
            }
            String[] tempFiles = this.files;
            this.files = new String[filesPt];
            this.status("Finding image files");
            int extCount = 0;
            Vector<String> foundExts = new Vector<String>();
            for (i = 0; i < filesPt; ++i) {
                ext = tempFiles[i].substring(tempFiles[i].lastIndexOf(".") + 1);
                if (foundExts.contains(ext)) continue;
                ++extCount;
                foundExts.add(ext);
            }
            for (i = 0; i < filesPt; i += extCount) {
                int j;
                Vector<String> extSet = new Vector<String>();
                for (j = 0; j < extCount; ++j) {
                    if (extSet.size() == 0) {
                        extSet.add(tempFiles[i + j]);
                        continue;
                    }
                    String ext3 = tempFiles[i + j].substring(tempFiles[i + j].lastIndexOf(".") + 1);
                    int extNum = Integer.parseInt(ext3, 16);
                    int insert = -1;
                    for (int pos = 0; insert == -1 && pos < extSet.size(); ++pos) {
                        String posString = (String)extSet.get(pos);
                        int posNum = Integer.parseInt(posString = posString.substring(posString.lastIndexOf(".") + 1), 16);
                        if (extNum >= posNum) continue;
                        insert = pos;
                    }
                    if (insert == -1) {
                        extSet.add(tempFiles[i + j]);
                        continue;
                    }
                    extSet.add(insert, tempFiles[i + j]);
                }
                for (j = 0; j < extCount; ++j) {
                    this.files[i + j] = (String)extSet.get(j);
                }
            }
            for (i = 0; i < this.files.length; ++i) {
                this.allFiles.add(this.files[i]);
            }
            this.core.imageCount[0] = this.files.length;
            this.tiff = new TiffReader[this.core.imageCount[0]];
            for (int i4 = 0; i4 < this.tiff.length; ++i4) {
                this.tiff[i4] = new TiffReader();
                if (i4 <= 0) continue;
                this.tiff[i4].setMetadataCollected(false);
            }
            this.status("Parsing metadata values");
            if (timPos != -1) {
                tempFile = new Location(workingDir, ls[timPos]);
                this.allFiles.add(tempFile.getAbsolutePath());
                RandomAccessStream read2 = new RandomAccessStream(tempFile.getAbsolutePath());
                data = new byte[(int)tempFile.length()];
                read2.read(data);
                StringTokenizer t = new StringTokenizer(new String(data));
                String[] hashKeys = new String[]{"Number of Wavelengths/Timepoints", "Zero 1", "Zero 2", "Number of slices", "Extra int", "Calibration Unit", "Pixel Size Y", "Pixel Size X", "Image Width", "Image Length", "Origin X", "SubfileType X", "Dimension Label X", "Origin Y", "SubfileType Y", "Dimension Label Y", "Origin Z", "SubfileType Z", "Dimension Label Z"};
                for (tNum = 0; t.hasMoreTokens() && tNum < hashKeys.length; ++tNum) {
                    String token = t.nextToken();
                    while (!(tNum != 1 && tNum != 2 || token.trim().equals("0"))) {
                        ++tNum;
                    }
                    if (tNum == 4) {
                        try {
                            Integer.parseInt(token);
                        }
                        catch (NumberFormatException e) {
                            ++tNum;
                        }
                    }
                    this.addMeta(hashKeys[tNum], token);
                    if (hashKeys[tNum].equals("Image Width")) {
                        this.core.sizeX[0] = Integer.parseInt(token);
                        continue;
                    }
                    if (hashKeys[tNum].equals("Image Length")) {
                        this.core.sizeY[0] = Integer.parseInt(token);
                        continue;
                    }
                    if (hashKeys[tNum].equals("Number of slices")) {
                        this.core.sizeZ[0] = Integer.parseInt(token);
                        continue;
                    }
                    if (hashKeys[tNum].equals("Experiment details:")) {
                        this.details = token;
                        continue;
                    }
                    if (!hashKeys[tNum].equals("Z slice space")) continue;
                    this.sliceSpace = token;
                }
                read2.close();
            }
            if (csvPos != -1) {
                tempFile = new Location(workingDir, ls[csvPos]);
                this.allFiles.add(tempFile.getAbsolutePath());
                RandomAccessStream read3 = new RandomAccessStream(tempFile.getAbsolutePath());
                data = new byte[(int)tempFile.length()];
                read3.read(data);
                StringTokenizer t = new StringTokenizer(new String(data));
                tNum = 0;
                String[] hashKeys = new String[]{"Calibration Unit", "Pixel Size X", "Pixel Size Y", "Z slice space"};
                int pt = 0;
                while (t.hasMoreTokens()) {
                    if (tNum < 7) {
                        t.nextToken();
                    } else if (tNum > 7 && tNum < 12 || tNum > 12 && tNum < 18 || tNum > 18 && tNum < 22) {
                        t.nextToken();
                    } else if (pt < hashKeys.length) {
                        String token = t.nextToken();
                        this.addMeta(hashKeys[pt], token);
                        if (hashKeys[pt].equals("Image Width")) {
                            this.core.sizeX[0] = Integer.parseInt(token);
                        } else if (hashKeys[pt].equals("Image Length")) {
                            this.core.sizeY[0] = Integer.parseInt(token);
                        } else if (hashKeys[pt].equals("Number of slices")) {
                            this.core.sizeZ[0] = Integer.parseInt(token);
                        } else if (hashKeys[pt].equals("Experiment details:")) {
                            this.details = token;
                        } else if (hashKeys[pt].equals("Z slice space")) {
                            this.sliceSpace = token;
                        }
                        ++pt;
                    } else {
                        String key = t.nextToken() + t.nextToken();
                        String value = t.nextToken();
                        this.addMeta(key, value);
                        if (key.equals("Image Width")) {
                            this.core.sizeX[0] = Integer.parseInt(value);
                        } else if (key.equals("Image Length")) {
                            this.core.sizeY[0] = Integer.parseInt(value);
                        } else if (key.equals("Number of slices")) {
                            this.core.sizeZ[0] = Integer.parseInt(value);
                        } else if (key.equals("Experiment details:")) {
                            this.details = value;
                        } else if (key.equals("Z slice space")) {
                            this.sliceSpace = value;
                        }
                    }
                    ++tNum;
                }
                read3.close();
            } else if (zpoPos != -1) {
                tempFile = new Location(workingDir, ls[zpoPos]);
                this.allFiles.add(tempFile.getAbsolutePath());
                RandomAccessStream read4 = new RandomAccessStream(tempFile.getAbsolutePath());
                data = new byte[(int)tempFile.length()];
                read4.read(data);
                StringTokenizer t = new StringTokenizer(new String(data));
                tNum = 0;
                while (t.hasMoreTokens()) {
                    this.addMeta("Z slice #" + tNum + " position", t.nextToken());
                    ++tNum;
                }
                read4.close();
            }
            if (htmPos != -1) {
                int j;
                String[] tokens;
                block99: {
                    tempFile = new Location(workingDir, ls[htmPos]);
                    this.allFiles.add(tempFile.getAbsolutePath());
                    read = new RandomAccessStream(tempFile.getAbsolutePath());
                    data = new byte[(int)tempFile.length()];
                    read.read(data);
                    String regex = "<p>|</p>|<br>|<hr>|<b>|</b>|<HTML>|<HEAD>|</HTML>|</HEAD>|<h1>|</h1>|<HR>|</body>";
                    Class<String> c = String.class;
                    tokens = new String[]{};
                    Object th = null;
                    try {
                        Method split = c.getMethod("split", c);
                        tokens = (String[])split.invoke((Object)new String(data), regex);
                    }
                    catch (NoSuchMethodException exc) {
                        if (debug) {
                            this.trace(exc);
                        }
                    }
                    catch (IllegalAccessException exc) {
                        if (debug) {
                            this.trace(exc);
                        }
                    }
                    catch (InvocationTargetException exc) {
                        if (!debug) break block99;
                        this.trace(exc);
                    }
                }
                for (j = 0; j < tokens.length; ++j) {
                    if (tokens[j].indexOf("<") == -1) continue;
                    tokens[j] = "";
                }
                for (j = 0; j < tokens.length - 1; j += 2) {
                    if (tokens[j].indexOf("Wavelength") != -1) {
                        this.addMeta("Camera Data " + tokens[j].charAt(13), tokens[j]);
                        --j;
                        continue;
                    }
                    if (tokens[j].trim().equals("")) continue;
                    this.addMeta(tokens[j].trim(), tokens[j + 1].trim());
                    if (tokens[j].trim().equals("Image Width")) {
                        this.core.sizeX[0] = Integer.parseInt(tokens[j + 1].trim());
                        continue;
                    }
                    if (tokens[j].trim().equals("Image Length")) {
                        this.core.sizeY[0] = Integer.parseInt(tokens[j + 1].trim());
                        continue;
                    }
                    if (tokens[j].trim().equals("Number of slices")) {
                        this.core.sizeZ[0] = Integer.parseInt(tokens[j + 1].trim());
                        continue;
                    }
                    if (tokens[j].trim().equals("Experiment details:")) {
                        this.details = tokens[j + 1].trim();
                        continue;
                    }
                    if (!tokens[j].trim().equals("Z slice space")) continue;
                    this.sliceSpace = tokens[j + 1].trim();
                }
            } else {
                throw new FormatException("Valid header files not found.");
            }
            read.close();
            String wavelengths = "1";
            if (this.details != null) {
                StringTokenizer t = new StringTokenizer(this.details);
                int tokenNum = 0;
                boolean foundId = false;
                String prevToken = "";
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    foundId = token.equals("Wavelengths");
                    if (foundId) {
                        wavelengths = prevToken;
                    }
                    ++tokenNum;
                    prevToken = token;
                }
            }
            this.status("Populating metadata");
            this.core.sizeC[0] = Integer.parseInt(wavelengths);
            this.core.sizeT[0] = this.getImageCount() / (this.core.sizeZ[0] * this.core.sizeC[0]);
            if (this.isTiff) {
                this.tiff[0].setId(this.files[0]);
                this.core.pixelType[0] = this.tiff[0].getPixelType();
            } else {
                RandomAccessStream tmp = new RandomAccessStream(this.files[0]);
                int bpp = (int)(tmp.length() - 6L) / (this.core.sizeX[0] * this.core.sizeY[0]);
                tmp.close();
                switch (bpp) {
                    case 1: 
                    case 3: {
                        this.core.pixelType[0] = 1;
                        break;
                    }
                    case 2: {
                        this.core.pixelType[0] = 3;
                        break;
                    }
                    case 4: {
                        this.core.pixelType[0] = 5;
                    }
                }
            }
            this.core.currentOrder[0] = "XYC";
            if (this.core.sizeZ[0] <= 0) {
                this.core.sizeZ[0] = 1;
                this.core.sizeT[0] = this.getImageCount() / (this.core.sizeZ[0] * this.core.sizeC[0]);
            }
            if (this.core.sizeC[0] <= 0) {
                this.core.sizeC[0] = 1;
                this.core.sizeT[0] = this.getImageCount() / (this.core.sizeZ[0] * this.core.sizeC[0]);
            }
            if (this.core.sizeT[0] <= 0) {
                this.core.sizeT[0] = 1;
            }
            this.core.currentOrder[0] = this.sliceSpace != null ? this.core.currentOrder[0] + "TZ" : this.core.currentOrder[0] + "ZT";
            this.core.rgb[0] = this.isTiff ? this.tiff[0].isRGB() : false;
            this.core.interleaved[0] = false;
            this.core.littleEndian[0] = this.isTiff ? this.tiff[0].isLittleEndian() : true;
            this.core.metadataComplete[0] = true;
            this.core.indexed[0] = this.isTiff ? this.tiff[0].isIndexed() : false;
            this.core.falseColor[0] = false;
            store = this.getMetadataStore();
            String pixelSizeX = (String)this.getMeta("Pixel Size X");
            String pixelSizeY = (String)this.getMeta("Pixel Size Y");
            store.setDimensions(pixelSizeX == null ? null : new Float(pixelSizeX), pixelSizeY == null ? null : new Float(pixelSizeY), null, null, null, null);
            String time = (String)this.getMeta("Finish Time:");
            if (time != null) {
                SimpleDateFormat parse = new SimpleDateFormat("HH:mm:ss (MM/dd/yyyy)");
                Date date = parse.parse(time, new ParsePosition(0));
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                time = fmt.format(date);
            }
            store.setImage(this.currentId, time, null, null);
            FormatTools.populatePixels(store, this);
            String originX = (String)this.getMeta("Origin X");
            String originY = (String)this.getMeta("Origin Y");
            String originZ = (String)this.getMeta("Origin Z");
            try {
                store.setStageLabel(null, originX == null ? null : new Float(originX), originY == null ? null : new Float(originY), originZ == null ? null : new Float(originZ), null);
            }
            catch (NumberFormatException exc) {
                if (!debug) break block100;
                this.trace(exc);
            }
        }
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

