/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Misc;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class FeatureCollectionTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable ftTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private TextHistoryPane dumpTA;
    private IndependentWindow infoWindow;
    private List<MFile> fileList;
    private MFileCollectionManager dcm;
    private final String SPEC = "spec='";
    private final String DFM = "dateFormatMark='";

    public FeatureCollectionTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.ftTable = new BeanTable(Bean.class, (PreferencesExt)prefs.node("FeatureDatasetBeans"), false);
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, this.ftTable, this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.ftTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
    }

    public boolean setCollection(String spec) throws Exception {
        spec = spec.trim();
        Formatter f = new Formatter();
        if (spec.startsWith("<collection ")) {
            this.dcm = this.setCollectionElement(spec, f);
        } else {
            CollectionSpecParser sp = new CollectionSpecParser(spec, f);
            f.format("spec='%s'%n", sp);
            this.dcm = this.scanCollection(spec, f);
        }
        this.showCollection(f);
        this.dumpTA.setText(f.toString());
        return this.dcm != null;
    }

    private MFileCollectionManager setCollectionElement(String elem, Formatter f) throws Exception {
        int pos2;
        int pos22;
        String spec = null;
        int pos1 = elem.indexOf("spec='");
        if (pos1 > 0 && (pos22 = elem.indexOf("'", pos1 + "spec='".length())) > 0) {
            spec = elem.substring(pos1 + "spec='".length(), pos22);
        }
        if (spec == null) {
            f.format("want <collection spec='spec' [dateFormatMark='dfm'] ... %n", new Object[0]);
            return null;
        }
        f.format("spec='%s' %n", spec);
        String dfm = null;
        pos1 = elem.indexOf("dateFormatMark='");
        if (pos1 > 0 && (pos2 = elem.indexOf("'", pos1 + "dateFormatMark='".length())) > 0) {
            dfm = elem.substring(pos1 + "dateFormatMark='".length(), pos2);
        }
        this.dcm = this.scanCollection(spec, f);
        if (dfm != null) {
            this.dcm.setDateExtractor(new DateExtractorFromName(dfm, false));
            f.format("dateFormatMark='%s' %n", dfm);
        }
        return this.dcm;
    }

    public void showCollection(Formatter f) throws Exception {
        if (this.dcm == null) {
            return;
        }
        f.format("dcm = %s%n", this.dcm);
        for (MFile mfile : this.dcm.getFiles()) {
            f.format("  %s%n", mfile.getPath());
        }
    }

    private MFileCollectionManager scanCollection(String spec, Formatter f) {
        MFileCollectionManager dc = null;
        try {
            dc = MFileCollectionManager.open(spec, null, f);
            dc.scan(false);
            this.fileList = Misc.getList(dc.getFiles());
            ArrayList<Bean> beans = new ArrayList<Bean>();
            for (MFile mfile : this.fileList) {
                beans.add(new Bean(mfile));
            }
            this.ftTable.setBeans(beans);
            return dc;
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            e.printStackTrace(new PrintStream(bos));
            f.format("Exception %s", bos.toString());
            return null;
        }
    }

    public class Bean {
        MFile mfile;

        Bean() {
        }

        Bean(MFile mfile) {
            this.mfile = mfile;
        }

        public String getName() {
            return this.mfile.getName();
        }

        public String getDate() {
            CalendarDate cd = FeatureCollectionTable.this.dcm.extractRunDate(this.mfile);
            return cd.toString();
        }
    }
}

