/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.SSLException;
import net.jcip.annotations.NotThreadSafe;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.net.CustomSSLProtocolSocketFactory;
import ucar.nc2.util.net.HTTPAuthScope;
import ucar.nc2.util.net.HTTPAuthStore;
import ucar.nc2.util.net.HTTPBasicProvider;
import ucar.nc2.util.net.HTTPCredentialsCache;
import ucar.nc2.util.net.HTTPCredsProvider;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPFactory;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSSLProvider;
import ucar.nc2.util.net.HTTPUtil;

@NotThreadSafe
public class HTTPSession {
    static final String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";
    static final String HANDLE_REDIRECTS = "http.protocol.handle-redirects";
    static final String HANDLE_AUTHENTICATION = "http.protocol.handle-authentication";
    static final String MAX_REDIRECTS = "http.protocol.max-redirects";
    static final String SO_TIMEOUT = "http.socket.timeout";
    static final String CONN_TIMEOUT = "http.connection.timeout";
    static final String USER_AGENT = "http.useragent";
    static final String PROXY = "http.route.default-proxy";
    static final String COMPRESSION = "COMPRESSION";
    public static final String HEADER_USERAGENT = "User-Agent";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String BASIC = "Basic";
    public static final String DIGEST = "Digest";
    public static final String NTLM = "NTLM";
    public static final String SSL = "SSL";
    static final int DFALTTHREADCOUNT = 50;
    static final int DFALTREDIRECTS = 25;
    static final int DFALTCONNTIMEOUT = 60000;
    static final int DFALTSOTIMEOUT = 300000;
    static final String DFALTUSERAGENT = "/NetcdfJava/HttpClient4.3";
    public static Logger log = LoggerFactory.getLogger(HTTPSession.class);
    static PoolingClientConnectionManager connmgr = new PoolingClientConnectionManager();
    static Settings globalsettings;
    protected AbstractHttpClient sessionClient = null;
    protected List<HTTPMethod> methodList = new Vector<HTTPMethod>();
    protected String identifier = "Session";
    protected String legalurl = null;
    protected boolean closed = false;
    protected HttpContext execcontext = null;
    protected Settings localsettings = new Settings();
    protected HTTPAuthStore authlocal = new HTTPAuthStore();
    static List<HTTPSession> sessionList;
    public static boolean TESTING;
    protected static HttpRequestInterceptor globaldebugrequest;
    protected static HttpResponseInterceptor globaldebugresponse;
    protected HttpRequestInterceptor localdebugrequest = null;
    protected HttpResponseInterceptor localdebugresponse = null;

    static void setDefaults(Settings props) {
        props.setParameter(ALLOW_CIRCULAR_REDIRECTS, Boolean.TRUE);
        props.setParameter(HANDLE_REDIRECTS, Boolean.TRUE);
        props.setParameter(HANDLE_AUTHENTICATION, Boolean.TRUE);
        props.setParameter(MAX_REDIRECTS, 25);
        props.setParameter(SO_TIMEOUT, 300000);
        props.setParameter(CONN_TIMEOUT, 60000);
        props.setParameter(USER_AGENT, DFALTUSERAGENT);
    }

    public Settings getGlobalSettings() {
        return globalsettings;
    }

    public static synchronized void setGlobalUserAgent(String userAgent) {
        globalsettings.setParameter(USER_AGENT, userAgent);
    }

    public static String getGlobalUserAgent() {
        return (String)globalsettings.getParameter(USER_AGENT);
    }

    public static synchronized void setGlobalThreadCount(int nthreads) {
        connmgr.setMaxTotal(nthreads);
        connmgr.setDefaultMaxPerRoute(nthreads);
    }

    public static void setGlobalMaxConnections(int nthreads) {
        HTTPSession.setGlobalThreadCount(nthreads);
    }

    public static int getGlobalThreadCount() {
        return connmgr.getMaxTotal();
    }

    public static List<Cookie> getGlobalCookies() {
        DefaultHttpClient client = new DefaultHttpClient(connmgr);
        List<Cookie> cookies = client.getCookieStore().getCookies();
        return cookies;
    }

    public static synchronized void setGlobalConnectionTimeout(int timeout) {
        if (timeout >= 0) {
            globalsettings.setParameter(CONN_TIMEOUT, timeout);
        }
    }

    public static synchronized void setGlobalSoTimeout(int timeout) {
        if (timeout >= 0) {
            globalsettings.setParameter(SO_TIMEOUT, timeout);
        }
    }

    public static synchronized void setGlobalProxy(String host, int port) {
        Proxy proxy = new Proxy();
        proxy.host = host;
        proxy.port = port;
        globalsettings.setParameter(PROXY, proxy);
    }

    public static synchronized void setGlobalCompression() {
        globalsettings.setParameter(COMPRESSION, "gzip,deflate");
    }

    protected static synchronized void defineCredentialsProvider(String principal, AuthScope scope, CredentialsProvider provider, HTTPAuthStore store) {
        try {
            if (provider == null) {
                store.remove(new HTTPAuthStore.Entry(principal, scope, provider));
            } else {
                store.insert(new HTTPAuthStore.Entry(principal, scope, provider));
            }
        }
        catch (HTTPException he) {
            log.error("HTTPSession.setCredentialsProvider failed");
        }
    }

    public static void setGlobalCredentialsProvider(AuthScope scope, CredentialsProvider provider) {
        HTTPSession.defineCredentialsProvider(HTTPAuthScope.ANY_PRINCIPAL, scope, provider, HTTPAuthStore.DEFAULTS);
    }

    public static void setGlobalCredentialsProvider(CredentialsProvider provider) {
        HTTPSession.defineCredentialsProvider(HTTPAuthScope.ANY_PRINCIPAL, HTTPAuthScope.ANY, provider, HTTPAuthStore.DEFAULTS);
    }

    public static void setGlobalCredentials(AuthScope scope, Credentials creds) {
        HTTPCredsProvider provider = new HTTPCredsProvider(creds);
        HTTPSession.setGlobalCredentialsProvider(scope, provider);
    }

    public static int getRetryCount() {
        return RetryHandler.getRetries();
    }

    public static void setRetryCount(int count) {
        RetryHandler.setRetries(count);
    }

    public static String getCanonicalURL(String legalurl) {
        if (legalurl == null) {
            return null;
        }
        int index = legalurl.indexOf(63);
        if (index >= 0) {
            legalurl = legalurl.substring(0, index);
        }
        return HTTPSession.canonicalpath(legalurl);
    }

    public static String canonicalpath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String removeprincipal(String u) {
        String newurl = null;
        try {
            URL url = new URL(u);
            String protocol = url.getProtocol() + "://";
            String host = url.getHost();
            int port = url.getPort();
            String path = url.getPath();
            String query = url.getQuery();
            String ref = url.getRef();
            String sport = port <= 0 ? "" : ":" + port;
            path = path == null ? "" : path;
            query = query == null ? "" : "?" + query;
            ref = ref == null ? "" : "#" + ref;
            newurl = protocol + host + sport + path + query + ref;
        }
        catch (MalformedURLException use) {
            newurl = u;
        }
        return newurl;
    }

    public static String getUrlAsString(String url) throws HTTPException {
        HTTPSession session = HTTPFactory.newSession(url);
        HTTPMethod m = HTTPFactory.Get(session);
        int status = m.execute();
        String content = null;
        if (status == 200) {
            content = m.getResponseAsString();
        }
        m.close();
        return content;
    }

    public static int putUrlAsString(String content, String url) throws HTTPException {
        HTTPMethod m = HTTPFactory.Put(url);
        try {
            m.setRequestContent(new StringEntity(content, "application/text", "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new HTTPException(uee);
        }
        int status = m.execute();
        m.close();
        return status;
    }

    static String getstorepath(String prefix) {
        String path = System.getProperty(prefix + "store");
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        return path;
    }

    static String getpassword(String prefix) {
        String password = System.getProperty(prefix + "storepassword");
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        return password;
    }

    static String cleanproperty(String property) {
        String value = System.getProperty(property);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    static synchronized void setGlobalKeyStore() {
        String keypassword = HTTPSession.cleanproperty("keystorepassword");
        String keypath = HTTPSession.cleanproperty("keystore");
        String trustpassword = HTTPSession.cleanproperty("truststorepassword");
        String trustpath = HTTPSession.cleanproperty("truststore");
        if (keypath != null || trustpath != null) {
            HTTPSSLProvider sslprovider = new HTTPSSLProvider(keypath, keypassword, trustpath, trustpassword);
            HTTPSession.setGlobalCredentialsProvider(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, SSL), sslprovider);
        }
    }

    static void getGlobalProxyD() {
        Proxy proxy = new Proxy();
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        int portno = -1;
        if (host != null && (host = host.trim()).length() == 0) {
            host = null;
        }
        if (port != null && (port = port.trim()).length() > 0) {
            try {
                portno = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                portno = -1;
            }
        }
        if (host != null) {
            HTTPSession.setGlobalProxy(host, portno);
        }
    }

    public HTTPSession() throws HTTPException {
        this(null);
    }

    public HTTPSession(String url) throws HTTPException {
        try {
            new URL(url);
        }
        catch (MalformedURLException mue) {
            throw new HTTPException("Malformed URL: " + url, mue);
        }
        this.legalurl = url;
        try {
            this.sessionClient = new DefaultHttpClient(connmgr);
            if (TESTING) {
                HTTPSession.track(this);
            }
            HTTPSession.setInterceptors(this);
        }
        catch (Exception e) {
            throw new HTTPException("url=" + url, e);
        }
        this.execcontext = new BasicHttpContext();
    }

    public Settings getSettings() {
        return this.localsettings;
    }

    public String getURL() {
        return this.legalurl;
    }

    public void setUserAgent(String agent) {
        if (agent != null) {
            this.localsettings.setParameter(USER_AGENT, agent);
        }
    }

    public void setSoTimeout(int timeout) {
        if (timeout >= 0) {
            this.localsettings.setParameter(SO_TIMEOUT, timeout);
        }
    }

    public void setConnectionTimeout(int timeout) {
        if (timeout >= 0) {
            this.localsettings.setParameter(CONN_TIMEOUT, timeout);
        }
    }

    public void setMaxRedirects(int n) {
        this.localsettings.setParameter(MAX_REDIRECTS, n);
    }

    public void setCompression() {
        this.localsettings.setParameter(COMPRESSION, "gzip,deflate");
    }

    HttpContext getContext() {
        return this.execcontext;
    }

    HttpClient getClient() {
        return this.sessionClient;
    }

    HTTPAuthStore getAuthStore() {
        return this.authlocal;
    }

    HttpContext getExecutionContext() {
        return this.execcontext;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        while (this.methodList.size() > 0) {
            HTTPMethod m = this.methodList.get(0);
            m.close();
        }
        this.closed = true;
    }

    public List<Cookie> getCookies() {
        if (this.sessionClient == null) {
            return null;
        }
        List<Cookie> cookies = this.sessionClient.getCookieStore().getCookies();
        return cookies;
    }

    synchronized void addMethod(HTTPMethod m) {
        if (!this.methodList.contains(m)) {
            this.methodList.add(m);
        }
    }

    synchronized void removeMethod(HTTPMethod m) {
        this.methodList.remove(m);
    }

    public void clearState() {
        this.sessionClient.getCredentialsProvider().clear();
        this.sessionClient.getCookieStore().clear();
        this.execcontext = new BasicHttpContext();
        this.localsettings.clear();
        this.authlocal.clear();
    }

    void setProxy(Proxy proxy) {
        if (this.sessionClient == null) {
            return;
        }
        if (proxy != null && proxy.host != null) {
            this.localsettings.setParameter(PROXY, proxy);
        }
    }

    public void setProxy(String host, int port) {
        Proxy proxy = new Proxy();
        proxy.host = host;
        proxy.port = port;
        this.setProxy(proxy);
    }

    public void setCredentialsProvider(AuthScope scope, CredentialsProvider provider) {
        HTTPSession.defineCredentialsProvider(HTTPAuthScope.ANY_PRINCIPAL, scope, provider, this.authlocal);
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.setCredentialsProvider(HTTPAuthScope.ANY, provider);
    }

    public void setCredentialsProvider(String scheme, CredentialsProvider provider) {
        AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, scheme);
        this.setCredentialsProvider(scope, provider);
    }

    public void setCredentials(String scheme, Credentials creds) {
        HTTPCredsProvider provider = new HTTPCredsProvider(creds);
        this.setCredentialsProvider(scheme, (CredentialsProvider)provider);
    }

    public void setCredentialsProvider(String surl) throws HTTPException {
        URI uri = HTTPAuthScope.decompose(surl);
        String userinfo = uri.getUserInfo();
        if (userinfo != null) {
            int index = userinfo.indexOf(58);
            String user = userinfo.substring(index);
            String pwd = userinfo.substring(index + 1, userinfo.length());
            if (user != null && pwd != null) {
                HTTPBasicProvider bp = new HTTPBasicProvider(user, pwd);
                this.setCredentialsProvider(BASIC, (CredentialsProvider)bp);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getMethodcount() {
        return this.methodList.size();
    }

    protected synchronized void setAuthentication(HTTPCredentialsCache hap) {
        this.sessionClient.setCredentialsProvider(hap);
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        return this.sessionClient.execute(request);
    }

    void invalidate(AuthScope scope) {
        HTTPCredentialsCache.invalidate(scope);
    }

    protected static synchronized void kill() {
        if (sessionList != null) {
            for (HTTPSession session : sessionList) {
                session.close();
            }
            sessionList.clear();
            connmgr.shutdown();
            connmgr = new PoolingClientConnectionManager();
            HTTPSession.setGlobalThreadCount(50);
        }
    }

    protected static synchronized void track(HTTPSession session) {
        if (sessionList == null) {
            sessionList = new ArrayList<HTTPSession>();
        }
        sessionList.add(session);
    }

    public static synchronized void setInterceptors(HTTPSession session) {
        HttpResponseInterceptor hi;
        HttpRequestInterceptor ireq = session.localdebugrequest;
        if (ireq == null) {
            ireq = globaldebugrequest;
        }
        if (ireq != null && session != null) {
            AbstractHttpClient client = (AbstractHttpClient)session.getClient();
            client.addRequestInterceptor(ireq);
        }
        if ((hi = session.localdebugresponse) == null) {
            hi = globaldebugresponse;
        }
        if (hi != null && session != null) {
            AbstractHttpClient client = (AbstractHttpClient)session.getClient();
            client.addResponseInterceptor(hi);
        }
    }

    public static void debugGlobal(HttpRequestInterceptor ireq, HttpResponseInterceptor iresp) {
        globaldebugrequest = ireq;
        globaldebugresponse = iresp;
    }

    public void debugSession(HttpRequestInterceptor ireq, HttpResponseInterceptor iresp) {
        this.localdebugrequest = ireq;
        this.localdebugresponse = iresp;
    }

    public static void debugHeaders() {
        HTTPSession.debugGlobal(new HTTPUtil.RequestHeaderDump(), new HTTPUtil.ResponseHeaderDump());
    }

    static {
        connmgr.getSchemeRegistry().register(new Scheme("https", 8443, new CustomSSLProtocolSocketFactory()));
        connmgr.getSchemeRegistry().register(new Scheme("https", 443, new CustomSSLProtocolSocketFactory()));
        globalsettings = new Settings();
        HTTPSession.setDefaults(globalsettings);
        HTTPSession.setGlobalUserAgent(DFALTUSERAGENT);
        HTTPSession.setGlobalThreadCount(50);
        HTTPSession.setGlobalConnectionTimeout(60000);
        HTTPSession.setGlobalSoTimeout(300000);
        HTTPSession.getGlobalProxyD();
        HTTPSession.setGlobalKeyStore();
        HTTPSession.setGlobalCompression();
        sessionList = null;
        TESTING = false;
        globaldebugrequest = null;
        globaldebugresponse = null;
    }

    public static class RetryHandler
    implements HttpRequestRetryHandler {
        static final int DFALTRETRIES = 5;
        static int retries = 5;
        static boolean verbose = false;

        @Override
        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            boolean idempotent;
            if (verbose) {
                log.debug(String.format("Retry: count=%d exception=%s\n", executionCount, exception.toString()));
            }
            if (executionCount >= retries) {
                return false;
            }
            if (exception instanceof InterruptedIOException || exception instanceof UnknownHostException || exception instanceof ConnectException || exception instanceof SSLException) {
                return false;
            }
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        }

        public static synchronized int getRetries() {
            return retries;
        }

        public static synchronized void setRetries(int retries) {
            if (retries > 0) {
                RetryHandler.retries = retries;
            }
        }

        public static synchronized boolean getVerbose() {
            return verbose;
        }

        public static synchronized void setVerbose(boolean tf) {
            verbose = tf;
        }
    }

    static enum Methods {
        Get("get"),
        Head("head"),
        Put("put"),
        Post("post"),
        Options("options");

        private final String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class Proxy {
        public String host = null;
        public int port = -1;

        Proxy() {
        }
    }

    static class Settings
    extends SyncBasicHttpParams {
        Settings() {
        }
    }
}

