/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.Deflater;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.itadaki.bzip2.BZip2OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.ma2.DataType;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Rectilyser;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.grib.grib2.table.WmoTemplateTable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.nc2.util.Misc;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class Grib2DataPanel
extends JPanel {
    private static Map<String, WmoTemplateTable> gribTemplates = null;
    private static final Logger logger = LoggerFactory.getLogger(Grib2DataPanel.class);
    private PreferencesExt prefs;
    private BeanTable param2BeanTable;
    private BeanTable record2BeanTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane drsInfo;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private FileManager fileChooser;
    private String spec;
    private MFileCollectionManager dcm;
    private List<MFile> fileList;
    private Grib2Customizer cust;
    private Grib2Rectilyser rect2;

    public Grib2DataPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.param2BeanTable = new BeanTable(Grib2ParameterBean.class, (PreferencesExt)prefs.node("Param2Bean"), false, "UniquePDSVariables", "from Grib2Input.getRecords()", null);
        this.param2BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)Grib2DataPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    Grib2DataPanel.this.record2BeanTable.setBeans(pb.getRecordBeans());
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.param2BeanTable.getJTable(), "Options");
        varPopup.addAction("Show PDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)Grib2DataPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    Formatter f = new Formatter();
                    Grib2DataPanel.showPdsTemplate(pb.gr.getPDSsection(), f, Grib2DataPanel.this.cust);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        this.record2BeanTable = new BeanTable(Grib2RecordBean.class, (PreferencesExt)prefs.node("Record2Bean"), false, "DataRepresentation", "from Grib2Input.getRecords()", null);
        this.record2BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Grib2RecordBean pb = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (pb != null) {
                    Grib2DataPanel.this.drsInfo.setText(pb.drs.toString());
                }
            }
        });
        varPopup = new PopupMenu(this.record2BeanTable.getJTable(), "Options");
        varPopup.addAction("Compare GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2RecordBean bean1 = (Grib2RecordBean)list.get(0);
                    Grib2RecordBean bean2 = (Grib2RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.compare(bean1, bean2, f);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show raw PDS bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                List list = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                for (int i = 0; i < list.size(); ++i) {
                    Grib2RecordBean bean = (Grib2RecordBean)list.get(i);
                    bean.toRawPdsString(f);
                }
                Grib2DataPanel.this.infoPopup.setText(f.toString());
                Grib2DataPanel.this.infoPopup.gotoTop();
                Grib2DataPanel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Show complete GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    try {
                        Grib2DataPanel.showCompleteGribRecord(f, ((MFile)Grib2DataPanel.this.fileList.get(bean.gr.getFile())).getPath(), bean.gr, Grib2DataPanel.this.cust);
                    }
                    catch (IOException ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        ioe.printStackTrace(new PrintStream(bos));
                        f.format("%s", bos.toString());
                    }
                    Grib2DataPanel.this.infoPopup.setText(f.toString());
                    Grib2DataPanel.this.infoPopup.gotoTop();
                    Grib2DataPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Show Processed GridRecord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                Formatter f = new Formatter();
                for (Object o : list) {
                    Grib2RecordBean bean = (Grib2RecordBean)o;
                    bean.showProcessedGridRecord(f);
                }
                Grib2DataPanel.this.infoPopup2.setText(f.toString());
                Grib2DataPanel.this.infoPopup2.gotoTop();
                Grib2DataPanel.this.infoWindow2.show();
            }
        });
        varPopup.addAction("Compare Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2RecordBean bean1 = (Grib2RecordBean)list.get(0);
                    Grib2RecordBean bean2 = (Grib2RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.compareData(bean1, bean2, f);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.showData(bean, f);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Extract GribRecord to File", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                if (beans.size() > 0) {
                    Grib2DataPanel.this.writeToFile(beans);
                }
            }
        });
        varPopup.addAction("Show Bitmap", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    try {
                        Grib2DataPanel.this.showBitmap(bean, f);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Compute Scale/offset of data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.calcData(bean, f);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", new Rectangle(300, 300, 500, 300)));
        this.drsInfo = new TextHistoryPane();
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, this.param2BeanTable, this.record2BeanTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, this.drsInfo);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.param2BeanTable.saveState(false);
        this.record2BeanTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", this.infoWindow2.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void setCollection(String spec) throws IOException {
        this.spec = spec;
        this.cust = null;
        this.rect2 = null;
        Formatter f = new Formatter();
        this.dcm = this.scanCollection(spec, f);
        if (this.dcm == null) {
            JOptionPane.showMessageDialog(this, "Collection is null\n" + f.toString());
            return;
        }
        HashMap<Integer, Grib2ParameterBean> pdsSet = new HashMap<Integer, Grib2ParameterBean>();
        HashMap<Integer, Grib2SectionGridDefinition> gdsSet = new HashMap<Integer, Grib2SectionGridDefinition>();
        ArrayList<Grib2ParameterBean> params = new ArrayList<Grib2ParameterBean>();
        int fileno = 0;
        for (MFile mfile : this.fileList) {
            f.format("%n %s%n", mfile.getPath());
            RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");
            this.processGribFile(mfile, fileno++, raf, pdsSet, gdsSet, params, f);
            raf.close();
        }
        this.param2BeanTable.setBeans(params);
    }

    private void processGribFile(MFile mfile, int fileno, RandomAccessFile raf, Map<Integer, Grib2ParameterBean> pdsSet, Map<Integer, Grib2SectionGridDefinition> gdsSet, List<Grib2ParameterBean> params, Formatter f) throws IOException {
        Grib2Index index = new Grib2Index();
        if (!index.readIndex(mfile.getPath(), mfile.getLastModified())) {
            index.makeIndex(mfile.getPath(), null);
        }
        for (Grib2SectionGridDefinition gds : index.getGds()) {
            int hash = gds.getGDS().hashCode();
            if (gdsSet.get(hash) != null) continue;
            gdsSet.put(hash, gds);
        }
        for (Grib2Record gr : index.getRecords()) {
            int id;
            Grib2ParameterBean bean;
            gr.setFile(fileno);
            if (this.rect2 == null) {
                this.cust = Grib2Customizer.factory(gr);
                this.rect2 = new Grib2Rectilyser(this.cust, null, 0, null);
            }
            if ((bean = pdsSet.get(id = this.rect2.cdmVariableHash(gr, 0))) == null) {
                bean = new Grib2ParameterBean(gr);
                pdsSet.put(id, bean);
                params.add(bean);
            }
            bean.addRecord(gr, raf);
        }
    }

    private MFileCollectionManager scanCollection(String spec, Formatter f) {
        MFileCollectionManager dc = null;
        try {
            dc = MFileCollectionManager.open(spec, null, f);
            dc.scan(false);
            this.fileList = Misc.getList(dc.getFiles());
            return dc;
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            e.printStackTrace(new PrintStream(bos));
            f.format("%s", bos.toString());
            return null;
        }
    }

    public void runAggregator(Formatter f) throws IOException {
        ArrayList<Grib2Record> records = new ArrayList<Grib2Record>();
        ArrayList<String> filenames = new ArrayList<String>();
        int fileno = 0;
        for (MFile mfile : this.dcm.getFiles()) {
            f.format("%3d: %s%n", fileno, mfile.getPath());
            filenames.add(mfile.getPath());
            Grib2Index index = new Grib2Index();
            if (!index.readIndex(mfile.getPath(), mfile.getLastModified())) {
                index.makeIndex(mfile.getPath(), null);
            }
            for (Grib2Record gr : index.getRecords()) {
                gr.setFile(fileno);
                records.add(gr);
            }
            ++fileno;
        }
        Grib2Rectilyser.Counter stats = new Grib2Rectilyser.Counter();
        Grib2Rectilyser agg = new Grib2Rectilyser(this.cust, records, 0, null);
        agg.make(stats, null);
        agg.dump(f, this.cust);
        stats.recordsTotal = records.size();
        f.format("%s", stats.show());
    }

    public boolean writeIndex(Formatter f) throws IOException {
        File def;
        String filename;
        String name;
        int pos;
        MFileCollectionManager dcm = this.scanCollection(this.spec, f);
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
        if ((pos = (name = dcm.getCollectionName()).lastIndexOf(47)) < 0) {
            pos = name.lastIndexOf(92);
        }
        if (pos > 0) {
            name = name.substring(pos + 1);
        }
        if ((filename = this.fileChooser.chooseFilename(def = new File(dcm.getRoot(), name + ".ncx"))) == null) {
            return false;
        }
        if (!filename.endsWith(".ncx")) {
            filename = filename + ".ncx";
        }
        File idxFile = new File(filename);
        Grib2CollectionBuilder.writeIndexFile(idxFile, dcm, logger);
        return true;
    }

    public void showCollection(Formatter f) {
        if (this.dcm == null) {
            if (this.spec == null) {
                return;
            }
            this.dcm = this.scanCollection(this.spec, f);
            if (this.dcm == null) {
                return;
            }
        }
        f.format("dcm = %s%n", this.dcm);
        for (MFile mfile : this.dcm.getFiles()) {
            f.format("  %s%n", mfile.getPath());
        }
        HashMap groups = new HashMap();
        for (Object o : this.param2BeanTable.getBeans()) {
            Grib2ParameterBean p = (Grib2ParameterBean)o;
            TreeSet<Integer> group = (TreeSet<Integer>)groups.get(p.getGDS());
            if (group == null) {
                group = new TreeSet<Integer>();
                groups.put(p.getGDS(), group);
            }
            for (Grib2RecordBean r : p.getRecordBeans()) {
                group.add(r.gr.getFile());
            }
        }
    }

    public void checkProblems(Formatter f) {
        this.checkDuplicates(f);
    }

    private void checkDuplicates(Formatter f) {
        HashSet<Long> pdsMap = new HashSet<Long>();
        int dups = 0;
        int count = 0;
        HashMap<CalendarDate, DateCount> dateMap = new HashMap<CalendarDate, DateCount>();
        List params = this.param2BeanTable.getBeans();
        for (Grib2ParameterBean param : params) {
            for (Grib2RecordBean record : param.getRecordBeans()) {
                CalendarDate d = record.gr.getReferenceDate();
                DateCount dc = (DateCount)dateMap.get(d);
                if (dc == null) {
                    dc = new DateCount(d);
                    dateMap.put(d, dc);
                }
                ++dc.count;
                Grib2SectionProductDefinition pdss = record.gr.getPDSsection();
                long crc = pdss.calcCRC();
                if (pdsMap.contains(crc)) {
                    ++dups;
                } else {
                    pdsMap.add(crc);
                }
                ++count;
            }
        }
        f.format("PDS duplicates = %d / %d%n%n", dups, count);
        ArrayList dcList = new ArrayList(dateMap.values());
        Collections.sort(dcList);
        f.format("Run Dates%n", new Object[0]);
        int total = 0;
        for (DateCount dc : dcList) {
            f.format(" %s == %d%n", dc.d, dc.count);
            total += dc.count;
        }
        f.format("total records = %d%n", total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(List beans) {
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
        FileOutputStream fos = null;
        java.io.RandomAccessFile raf = null;
        try {
            String filename = null;
            boolean append = false;
            int n = 0;
            MFile curr = null;
            for (Object o : beans) {
                Grib2RecordBean bean = (Grib2RecordBean)o;
                MFile mfile = this.fileList.get(bean.gr.getFile());
                if (curr == null || curr != mfile) {
                    if (raf != null) {
                        raf.close();
                    }
                    raf = new java.io.RandomAccessFile(mfile.getPath(), "r");
                    curr = mfile;
                }
                if (fos == null) {
                    String defloc = mfile.getPath();
                    filename = this.fileChooser.chooseFilenameToSave(defloc + ".grib2");
                    if (filename == null) {
                        return;
                    }
                    File f = new File(filename);
                    append = f.exists();
                    fos = new FileOutputStream(filename, append);
                }
                Grib2SectionIndicator is = bean.gr.getIs();
                int size = (int)is.getMessageLength();
                long startPos = is.getStartPos();
                if (startPos < 0L) {
                    JOptionPane.showMessageDialog(this, "Old index does not have message start - record not written");
                }
                byte[] rb = new byte[size];
                raf.seek(startPos);
                raf.readFully(rb);
                fos.write(rb);
                ++n;
            }
            JOptionPane.showMessageDialog(this, filename + ": " + n + " records successfully written, append=" + append);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void compare(Grib2RecordBean bean1, Grib2RecordBean bean2, Formatter f) {
        Grib2SectionIndicator is1 = bean1.gr.getIs();
        Grib2SectionIndicator is2 = bean2.gr.getIs();
        f.format("Indicator Section%n", new Object[0]);
        if (is1.getDiscipline() != is2.getDiscipline()) {
            f.format("getDiscipline differs %d != %d %n", is1.getDiscipline(), is2.getDiscipline());
        }
        if (is1.getMessageLength() != is2.getMessageLength()) {
            f.format("getGribLength differs %d != %d %n", is1.getMessageLength(), is2.getMessageLength());
        }
        f.format("%nId Section%n", new Object[0]);
        Grib2SectionIdentification id1 = bean1.gr.getId();
        Grib2SectionIdentification id2 = bean2.gr.getId();
        if (id1.getCenter_id() != id2.getCenter_id()) {
            f.format("Center_id differs %d != %d %n", id1.getCenter_id(), id2.getCenter_id());
        }
        if (id1.getSubcenter_id() != id2.getSubcenter_id()) {
            f.format("Subcenter_id differs %d != %d %n", id1.getSubcenter_id(), id2.getSubcenter_id());
        }
        if (id1.getMaster_table_version() != id2.getMaster_table_version()) {
            f.format("Master_table_version differs %d != %d %n", id1.getMaster_table_version(), id2.getMaster_table_version());
        }
        if (id1.getLocal_table_version() != id2.getLocal_table_version()) {
            f.format("Local_table_version differs %d != %d %n", id1.getLocal_table_version(), id2.getLocal_table_version());
        }
        if (id1.getProductionStatus() != id2.getProductionStatus()) {
            f.format("ProductionStatus differs %d != %d %n", id1.getProductionStatus(), id2.getProductionStatus());
        }
        if (id1.getTypeOfProcessedData() != id2.getTypeOfProcessedData()) {
            f.format("TypeOfProcessedData differs %d != %d %n", id1.getTypeOfProcessedData(), id2.getTypeOfProcessedData());
        }
        if (!id1.getReferenceDate().equals(id2.getReferenceDate())) {
            f.format("ReferenceDate differs %s != %s %n", id1.getReferenceDate(), id2.getReferenceDate());
        }
        if (id1.getSignificanceOfRT() != id2.getSignificanceOfRT()) {
            f.format("getSignificanceOfRT differs %d != %d %n", id1.getSignificanceOfRT(), id2.getSignificanceOfRT());
        }
        Grib2SectionLocalUse lus1 = bean1.gr.getLocalUseSection();
        Grib2SectionLocalUse lus2 = bean2.gr.getLocalUseSection();
        if (lus1 == null || lus2 == null) {
            if (lus1 == lus2) {
                f.format("%nLus are both null%n", new Object[0]);
            } else {
                f.format("%nLus are different %s != %s %n", lus1, lus2);
            }
        } else {
            f.format("%nCompare LocalUseSection%n", new Object[0]);
            Misc.compare(lus1.getRawBytes(), lus2.getRawBytes(), f);
        }
        this.compare(bean1.gr.getPDSsection(), bean2.gr.getPDSsection(), f);
        this.compare(bean1.gr.getGDSsection(), bean2.gr.getGDSsection(), f);
    }

    private void compare(Grib2SectionGridDefinition gdss1, Grib2SectionGridDefinition gdss2, Formatter f) {
        f.format("1 GribGDS hash = %s%n", gdss1.getGDS().hashCode());
        f.format("2 GribGDS hash = %s%n", gdss2.getGDS().hashCode());
        f.format("%nCompare Gds%n", new Object[0]);
        byte[] raw1 = gdss1.getRawBytes();
        byte[] raw2 = gdss2.getRawBytes();
        Misc.compare(raw1, raw2, f);
        Grib2Gds gds1 = gdss1.getGDS();
        Grib2Gds gds2 = gdss2.getGDS();
        GdsHorizCoordSys gdsh1 = gds1.makeHorizCoordSys();
        GdsHorizCoordSys gdsh2 = gds2.makeHorizCoordSys();
        f.format("%ncompare gds1 - gds22%n", new Object[0]);
        f.format(" Start x diff : %f%n", gdsh1.getStartX() - gdsh2.getStartX());
        f.format(" Start y diff : %f%n", gdsh1.getStartY() - gdsh2.getStartY());
        f.format(" End x diff : %f%n", gdsh1.getEndX() - gdsh2.getEndX());
        f.format(" End y diff : %f%n", gdsh1.getEndY() - gdsh2.getEndY());
        LatLonPoint pt1 = gdsh1.getCenterLatLon();
        LatLonPoint pt2 = gdsh2.getCenterLatLon();
        f.format(" Center lon diff : %f%n", pt1.getLongitude() - pt2.getLongitude());
        f.format(" Center lat diff : %f%n", pt1.getLatitude() - pt2.getLatitude());
    }

    private void compare(Grib2SectionProductDefinition pds1, Grib2SectionProductDefinition pds2, Formatter f) {
        f.format("%nCompare Pds%n", new Object[0]);
        byte[] raw1 = pds1.getRawBytes();
        byte[] raw2 = pds2.getRawBytes();
        Misc.compare(raw1, raw2, f);
    }

    void compareData(Grib2RecordBean bean1, Grib2RecordBean bean2, Formatter f) {
        float[] data1 = null;
        float[] data2 = null;
        try {
            data1 = bean1.readData();
            data2 = bean2.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        Misc.compare(data1, data2, f);
    }

    void showData(Grib2RecordBean bean1, Formatter f) {
        float[] data;
        try {
            data = bean1.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        for (float fd : data) {
            f.format("%f%n", Float.valueOf(fd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showBitmap(Grib2RecordBean bean1, Formatter f) throws IOException {
        byte[] bitmap;
        RandomAccessFile raf = null;
        try {
            raf = bean1.getRaf();
            Grib2SectionBitMap bms = bean1.gr.getBitmapSection();
            f.format("%s%n", bms);
            bitmap = bms.getBitmap(raf);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        if (bitmap == null) {
            f.format(" no bitmap%n", new Object[0]);
            return;
        }
        int count = 0;
        int bits = 0;
        for (byte b : bitmap) {
            short s = DataType.unsignedByteToShort(b);
            bits += Long.bitCount(s);
            f.format("%8s", Long.toBinaryString(s));
            if (++count % 10 != 0) continue;
            f.format("%n", new Object[0]);
        }
        f.format("%n%n#bits on = %d%n", bits);
    }

    void calcData(Grib2RecordBean bean1, Formatter f) {
        float[] data;
        try {
            data = bean1.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        int nbits = bean1.getNBits();
        int width2 = (2 << nbits - 1) - 1;
        f.format(" nbits = %d%n", nbits);
        f.format(" width = %d (0x%s) %n", width2, Long.toHexString(width2));
        float dataMin = Float.MAX_VALUE;
        float dataMax = -3.4028235E38f;
        for (float fd : data) {
            dataMin = Math.min(dataMin, fd);
            dataMax = Math.max(dataMax, fd);
        }
        f.format(" dataMin = %f%n", Float.valueOf(dataMin));
        f.format(" dataMax = %f%n", Float.valueOf(dataMax));
        f.format(" range = %f%n", Float.valueOf(dataMax - dataMin));
        float scale_factor = (dataMax - dataMin) / (float)width2;
        float add_offset = dataMin + (float)width2 * scale_factor / 2.0f;
        f.format(" scale_factor = %f%n", Float.valueOf(scale_factor));
        f.format(" add_offset = %f%n", Float.valueOf(add_offset));
        int n = data.length;
        ByteBuffer bb = ByteBuffer.allocate(2 * n);
        ShortBuffer sb = bb.asShortBuffer();
        float diffMax = -3.4028235E38f;
        float diffTotal = 0.0f;
        float diffTotal2 = 0.0f;
        for (float fd : data) {
            short packed_data = (short)Math.round((fd - add_offset) / scale_factor);
            float unpacked_data = (float)packed_data * scale_factor + add_offset;
            float diff = Math.abs(fd - unpacked_data);
            if (diff > 100.0f) {
                f.format("   org=%f, packed_data=%d unpacked=%f diff = %f%n", Float.valueOf(fd), packed_data, Float.valueOf(unpacked_data), Float.valueOf(diff));
            }
            diffMax = Math.max(diffMax, diff);
            diffTotal += diff;
            diffTotal2 += diff * diff;
            sb.put(packed_data);
        }
        f.format("%n max_diff = %f%n", Float.valueOf(diffMax));
        f.format(" avg_diff = %f%n", Float.valueOf(diffTotal / (float)data.length));
        float mean = diffTotal / (float)n;
        float var = diffTotal2 / (float)n - mean * mean;
        f.format(" std_diff = %f%n", Math.sqrt(var));
        f.format("%nCompression%n", new Object[0]);
        f.format(" number of values = %d%n", n);
        f.format(" uncompressed as floats = %d%n", n * 4);
        f.format(" uncompressed packed = %d%n", n * nbits / 8);
        f.format(" grib compressed = %d%n", bean1.getDataLength());
        f.format("%ndeflate%n", new Object[0]);
        Deflater deflater = new Deflater();
        deflater.setInput(bb.array());
        deflater.finish();
        int compressedSize = deflater.deflate(new byte[10 * n]);
        deflater.end();
        f.format(" compressedSize = %d%n", compressedSize);
        f.format(" compressedRatio = %f%n", Float.valueOf((float)compressedSize / (float)(n * nbits / 8)));
        f.format(" ratio with grib = %f%n", Float.valueOf((float)compressedSize / (float)bean1.getDataLength()));
        try {
            f.format("%nbzip2%n", new Object[0]);
            ByteArrayOutputStream out = new ByteArrayOutputStream(2 * compressedSize);
            BZip2OutputStream zipper = new BZip2OutputStream(out);
            ByteArrayInputStream fin = new ByteArrayInputStream(bb.array());
            IO.copy(fin, zipper);
            zipper.close();
            compressedSize = out.size();
            f.format(" compressedSize = %d%n", compressedSize);
            f.format(" compressedRatio = %f%n", Float.valueOf((float)compressedSize / (float)(n * nbits / 8)));
            f.format(" ratio with grib = %f%n", Float.valueOf((float)compressedSize / (float)bean1.getDataLength()));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static void showBytes(Formatter f, byte[] buff) {
        for (int n : buff) {
            int ub;
            int n2 = ub = n < 0 ? n + 256 : n;
            if (n >= 32 && n < 127) {
                f.format("%s", Character.valueOf((char)ub));
                continue;
            }
            f.format("(%d)", ub);
        }
    }

    public static void showCompleteGribRecord(Formatter f, String path, Grib2Record gr, Grib2Customizer cust) throws IOException {
        TimeCoord.TinvDate intv;
        f.format("File=%d %s %n", gr.getFile(), path);
        f.format("Header=\"", new Object[0]);
        Grib2DataPanel.showBytes(f, gr.getHeader());
        f.format("\"%n%n", new Object[0]);
        int d = gr.getDiscipline();
        f.format("Grib2IndicatorSection%n", new Object[0]);
        f.format(" Discipline = (%d) %s%n", d, cust.getTableValue("0.0", d));
        f.format(" Length     = %d%n", gr.getIs().getMessageLength());
        Grib2SectionIdentification id = gr.getId();
        f.format("%nGrib2IdentificationSection%n", new Object[0]);
        f.format(" Center        = (%d) %s%n", id.getCenter_id(), CommonCodeTable.getCenterName(id.getCenter_id(), 2));
        f.format(" SubCenter     = (%d) %s%n", id.getSubcenter_id(), cust.getSubCenterName(id.getCenter_id(), id.getSubcenter_id()));
        f.format(" Master Table  = %d%n", id.getMaster_table_version());
        f.format(" Local Table   = %d%n", id.getLocal_table_version());
        f.format(" RefTimeSignif = %d (%s)%n", id.getSignificanceOfRT(), cust.getTableValue("1.2", id.getSignificanceOfRT()));
        f.format(" RefTime       = %s%n", id.getReferenceDate());
        f.format(" RefTime Fields = %d-%d-%d %d:%d:%d%n", id.getYear(), id.getMonth(), id.getDay(), id.getHour(), id.getMinute(), id.getSecond());
        f.format(" ProductionStatus      = %d (%s)%n", id.getProductionStatus(), cust.getTableValue("1.3", id.getProductionStatus()));
        f.format(" TypeOfProcessedData   = %d (%s)%n", id.getTypeOfProcessedData(), cust.getTableValue("1.4", id.getTypeOfProcessedData()));
        if (gr.hasLocalUseSection()) {
            byte[] lus = gr.getLocalUseSection().getRawBytes();
            f.format("%nLocal Use Section (grib section 2)%n", new Object[0]);
            f.format("bytes (len=%d) =", lus.length);
            Misc.showBytes(lus, f);
            f.format("%n", new Object[0]);
        }
        Grib2SectionGridDefinition gds = gr.getGDSsection();
        Grib2Gds ggds = gds.getGDS();
        f.format("%nGrib2GridDefinitionSection hash=%d crc=%d%n", ggds.hashCode(), gds.calcCRC());
        f.format(" Length             = %d%n", gds.getLength());
        f.format(" Source  (3.0)      = %d (%s) %n", gds.getSource(), cust.getTableValue("3.0", gds.getSource()));
        f.format(" Npts               = %d%n", gds.getNumberPoints());
        f.format(" Template (3.1)     = %d%n", gds.getGDSTemplateNumber());
        Grib2DataPanel.showGdsTemplate(gds, f, cust);
        Grib2SectionProductDefinition pdss = gr.getPDSsection();
        f.format("%nGrib2ProductDefinitionSection%n", new Object[0]);
        Grib2Pds pds = pdss.getPDS();
        if (pds.isTimeInterval() && (intv = cust.getForecastTimeInterval(gr)) != null) {
            f.format(" Interval     = %s%n", intv);
        }
        Grib2DataPanel.showPdsTemplate(pdss, f, cust);
        if (pds.getExtraCoordinatesCount() > 0) {
            float[] coords = pds.getExtraCoordinates();
            f.format("Hybrid Coordinates (%d) %n  ", coords.length);
            for (float fc : coords) {
                f.format("%10.5f ", Float.valueOf(fc));
            }
            f.format("%n%n", new Object[0]);
        }
        Grib2SectionDataRepresentation drs = gr.getDataRepresentationSection();
        f.format("%nGrib2SectionDataRepresentation%n", new Object[0]);
        f.format("  Template           = %d (%s) %n", drs.getDataTemplate(), cust.getTableValue("5.0", drs.getDataTemplate()));
        f.format("  NPoints            = %d%n", drs.getDataPoints());
        Grib2SectionData ds = gr.getDataSection();
        f.format("%nGrib2SectionData%n", new Object[0]);
        f.format("  Starting Pos       = %d %n", ds.getStartingPosition());
        f.format("  Data Length        = %d%n", ds.getMsgLength());
    }

    private static void showGdsTemplate(Grib2SectionGridDefinition gds, Formatter f, Grib2Customizer cust) {
        int template = gds.getGDSTemplateNumber();
        byte[] raw = gds.getRawBytes();
        Grib2DataPanel.showRawWithTemplate("3." + template, raw, f, cust);
    }

    private static void showPdsTemplate(Grib2SectionProductDefinition pdss, Formatter f, Grib2Customizer cust) {
        int template = pdss.getPDSTemplateNumber();
        byte[] raw = pdss.getRawBytes();
        Grib2DataPanel.showRawWithTemplate("4." + template, raw, f, cust);
    }

    private static void showRawWithTemplate(String key, byte[] raw, Formatter f, Grib2Customizer cust) {
        WmoTemplateTable gt;
        if (gribTemplates == null) {
            try {
                gribTemplates = WmoTemplateTable.getWmoStandard().map;
            }
            catch (IOException e) {
                f.format("Read template failed = %s%n", e.getMessage());
                return;
            }
        }
        if ((gt = gribTemplates.get(key)) == null) {
            f.format("Cant find template %s%n", key);
        } else {
            gt.showInfo(cust, raw, f);
        }
    }

    private void showProcessedPds(Grib2Record gr, Grib2Pds pds, int discipline, Formatter f) {
        int template = pds.getTemplateNumber();
        f.format(" Product Template %3d = %s%n", template, this.cust.getTableValue("4.0", template));
        f.format(" Discipline %3d     = %s%n", discipline, this.cust.getTableValue("0.0", discipline));
        f.format(" Category %3d       = %s%n", pds.getParameterCategory(), this.cust.getCategory(discipline, pds.getParameterCategory()));
        GribTables.Parameter entry = this.cust.getParameter(discipline, pds.getParameterCategory(), pds.getParameterNumber());
        if (entry != null) {
            f.format(" Parameter Name     = %3d %s %n", pds.getParameterNumber(), entry.getName());
            f.format(" Parameter Units    = %s %n", entry.getUnit());
        } else {
            f.format(" Unknown Parameter  = %d-%d-%d %n", discipline, pds.getParameterCategory(), pds.getParameterNumber());
            this.cust.getParameter(discipline, pds.getParameterCategory(), pds.getParameterNumber());
        }
        f.format(" Parameter Table  = %s%n", this.cust.getTablePath(discipline, pds.getParameterCategory(), pds.getParameterNumber()));
        int tgp = pds.getGenProcessType();
        f.format(" Generating Process Type = %3d %s %n", tgp, this.cust.getTableValue("4.3", tgp));
        f.format(" Forecast Offset    = %3d %n", pds.getForecastTime());
        f.format(" First Surface Type = %3d %s %n", pds.getLevelType1(), this.cust.getLevelNameShort(pds.getLevelType1()));
        f.format(" First Surface value= %3f %n", pds.getLevelValue1());
        f.format(" Second Surface Type= %3d %s %n", pds.getLevelType2(), this.cust.getLevelNameShort(pds.getLevelType2()));
        f.format(" Second Surface val = %3f %n", pds.getLevelValue2());
        f.format("%n Level Name (from table 4.5) = %3s %n", this.cust.getTableValue("4.5", pds.getLevelType1()));
        f.format(" Gen Process Ttype (from table 4.3) = %3s %n", this.cust.getTableValue("4.3", pds.getGenProcessType()));
    }

    public class Gds2Bean
    implements Comparable<Gds2Bean> {
        Grib2SectionGridDefinition gdss;
        Grib2Gds gds;

        public Gds2Bean() {
        }

        public Gds2Bean(Grib2SectionGridDefinition m) {
            this.gdss = m;
            this.gds = this.gdss.getGDS();
        }

        public int getGDShash() {
            return this.gds.hashCode();
        }

        public int getTemplate() {
            return this.gdss.getGDSTemplateNumber();
        }

        public String getGridName() {
            return Grib2DataPanel.this.cust.getTableValue("3.1", this.gdss.getGDSTemplateNumber());
        }

        public String getGroupName() {
            return this.getGridName() + "-" + this.getNy() + "X" + this.getNx();
        }

        public int getNPoints() {
            return this.gdss.getNumberPoints();
        }

        public int getNx() {
            return this.gds.getNx();
        }

        public int getNy() {
            return this.gds.getNy();
        }

        public String getScanMode() {
            return Long.toBinaryString(this.gds.scanMode);
        }

        public String toString() {
            return this.getGridName() + " " + this.getTemplate() + " " + this.getNx() + " X " + this.getNy();
        }

        public void toRawGdsString(Formatter f) {
            byte[] bytes = this.gds.getRawBytes();
            int count = 1;
            for (byte b : bytes) {
                short s = DataType.unsignedByteToShort(b);
                f.format(" %d : %d%n", count++, s);
            }
        }

        @Override
        public int compareTo(Gds2Bean o) {
            return this.getGroupName().compareTo(o.getGroupName());
        }
    }

    public class Grib2RecordBean {
        Grib2Record gr;
        Grib2Pds pds;
        Grib2Drs drs;
        Grib2SectionData dataSection;
        long drsLength;

        public Grib2RecordBean() {
        }

        public Grib2RecordBean(Grib2Record m, RandomAccessFile raf) throws IOException {
            this.gr = m;
            this.pds = this.gr.getPDSsection().getPDS();
            Grib2SectionDataRepresentation drss = this.gr.getDataRepresentationSection();
            this.drs = drss.getDrs(raf);
            this.drsLength = drss.getLength(raf);
            this.dataSection = this.gr.getDataSection();
        }

        public String getHeader() {
            return Grib2Utils.cleanupHeader(this.gr.getHeader());
        }

        public int getDrsTemplate() {
            return this.gr.getDataRepresentationSection().getDataTemplate();
        }

        public int getNDataPoints() {
            return this.gr.getDataRepresentationSection().getDataPoints();
        }

        public long getDrsLength() {
            return this.drsLength;
        }

        public int getDataLength() {
            return this.dataSection.getMsgLength();
        }

        public long getDataStart() {
            return this.dataSection.getStartingPosition();
        }

        public int getNBits() {
            return this.drs.getNBits();
        }

        public int getNGroups() {
            return this.drs.getNGroups();
        }

        public float getAvgBits() {
            float len = this.getDataLength();
            int n = this.getNDataPoints();
            return len * 8.0f / (float)n;
        }

        public int getDrsHash() {
            return this.drs.hashCode();
        }

        public int getBitMap() {
            return this.gr.getBitmapSection().getBitMapIndicator();
        }

        public boolean getBitMapReplaced() {
            return this.gr.isBmsReplaced();
        }

        public final String getFile() {
            int fno = this.gr.getFile();
            return ((MFile)Grib2DataPanel.this.fileList.get(fno)).getName();
        }

        public final int getTime() {
            return this.pds.getForecastTime();
        }

        public String getLevel() {
            int v1 = this.pds.getLevelType1();
            int v2 = this.pds.getLevelType2();
            if (v1 == 255) {
                return "";
            }
            if (v2 == 255) {
                return "" + this.pds.getLevelValue1();
            }
            if (v1 != v2) {
                return this.pds.getLevelValue1() + "-" + this.pds.getLevelValue2() + " level2 type= " + v2;
            }
            return this.pds.getLevelValue1() + "-" + this.pds.getLevelValue2();
        }

        public void toRawPdsString(Formatter f) {
            byte[] bytes = this.gr.getPDSsection().getRawBytes();
            int count = 1;
            for (byte b : bytes) {
                short s = DataType.unsignedByteToShort(b);
                f.format(" %d : %d%n", count++, s);
            }
        }

        public String showProcessedGridRecord(Formatter f) {
            f.format("%nFile=%s (%d)%n", ((MFile)Grib2DataPanel.this.fileList.get(this.gr.getFile())).getPath(), this.gr.getFile());
            GribTables.Parameter param = Grib2DataPanel.this.cust.getParameter(this.gr.getDiscipline(), this.gr.getPDS().getParameterCategory(), this.gr.getPDS().getParameterNumber());
            f.format("  Parameter=%s (%s)%n", param.getName(), param.getAbbrev());
            VertCoord.VertUnit levelUnit = Grib2Utils.getLevelUnit(this.pds.getLevelType1());
            f.format("  Level=%f/%f %s; level name =  (%s)%n", this.pds.getLevelValue1(), this.pds.getLevelValue1(), levelUnit.getUnits(), Grib2DataPanel.this.cust.getLevelNameShort(this.pds.getLevelType1()));
            String intvName = "none";
            if (this.pds instanceof Grib2Pds.PdsInterval) {
                Grib2Pds.PdsInterval pdsi = (Grib2Pds.PdsInterval)((Object)this.pds);
                Grib2Pds.TimeInterval[] ti = pdsi.getTimeIntervals();
                int statType = ti[0].statProcessType;
                intvName = Grib2DataPanel.this.cust.getIntervalNameShort(statType);
            }
            f.format("  Time Unit=%s ;Stat=%s%n", Grib2Utils.getCalendarPeriod(this.pds.getTimeUnit()), intvName);
            f.format("  ReferenceDate=%s%n", this.gr.getReferenceDate());
            f.format("  ForecastDate=%s%n", Grib2DataPanel.this.cust.getForecastDate(this.gr));
            TimeCoord.TinvDate intv = Grib2DataPanel.this.cust.getForecastTimeInterval(this.gr);
            if (intv != null) {
                f.format("  TimeInterval=%s%n", intv);
            }
            f.format("%n", new Object[0]);
            this.pds.show(f);
            if (this.pds.getTemplateNumber() == 8 && Grib2DataPanel.this.cust instanceof NcepLocalTables) {
                NcepLocalTables ncepCust = (NcepLocalTables)Grib2DataPanel.this.cust;
                ncepCust.showCfsr(this.pds, f);
            }
            return f.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        float[] readData() throws IOException {
            RandomAccessFile raf = this.getRaf();
            try {
                raf.order(0);
                float[] fArray = this.gr.readData(raf);
                return fArray;
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }

        RandomAccessFile getRaf() throws IOException {
            int fileno = this.gr.getFile();
            MFile mfile = (MFile)Grib2DataPanel.this.fileList.get(fileno);
            return new RandomAccessFile(mfile.getPath(), "r");
        }
    }

    public class Grib2ParameterBean {
        Grib2Record gr;
        Grib2SectionIdentification id;
        Grib2Pds pds;
        List<Grib2RecordBean> records;
        int discipline;
        private float nbits = -1.0f;
        private float avgbits;
        private float compress;

        public Grib2ParameterBean() {
        }

        public Grib2ParameterBean(Grib2Record r) throws IOException {
            this.gr = r;
            this.pds = r.getPDSsection().getPDS();
            this.id = r.getId();
            this.discipline = r.getDiscipline();
            this.records = new ArrayList<Grib2RecordBean>();
        }

        void addRecord(Grib2Record r, RandomAccessFile raf) throws IOException {
            this.records.add(new Grib2RecordBean(r, raf));
        }

        List<Grib2RecordBean> getRecordBeans() {
            return this.records;
        }

        public String getParamNo() {
            return this.discipline + "-" + this.pds.getParameterCategory() + "-" + this.pds.getParameterNumber();
        }

        public int getPDS() {
            return this.gr.getPDSsection().getPDSTemplateNumber();
        }

        public int getN() {
            return this.records.size();
        }

        public int getLevelType() {
            return this.pds.getLevelType1();
        }

        public String getLevelName() {
            return Grib2DataPanel.this.cust.getLevelNameShort(this.pds.getLevelType1());
        }

        public int getGDS() {
            return this.gr.getGDSsection().getGDS().hashCode();
        }

        public String toString() {
            Formatter f = new Formatter();
            Grib2DataPanel.showPdsTemplate(this.gr.getPDSsection(), f, Grib2DataPanel.this.cust);
            return f.toString();
        }

        public String toProcessedString() {
            Formatter f = new Formatter();
            Grib2DataPanel.this.showProcessedPds(this.gr, this.pds, this.discipline, f);
            return f.toString();
        }

        public float getNBits() {
            this.calcBits();
            return this.nbits;
        }

        public float getAvgBits() {
            this.calcBits();
            return this.avgbits;
        }

        public float getCompress() {
            this.calcBits();
            return this.compress;
        }

        private void calcBits() {
            if (this.nbits >= 0.0f) {
                return;
            }
            this.nbits = 0.0f;
            int count = 0;
            for (Grib2RecordBean bean : this.records) {
                this.nbits += (float)bean.getNBits();
                this.avgbits += bean.getAvgBits();
                ++count;
            }
            this.compress = this.nbits / this.avgbits;
            this.nbits /= (float)count;
            this.avgbits /= (float)count;
        }

        public String getName() {
            return GribUtils.makeNameFromDescription(Grib2DataPanel.this.cust.getVariableName(this.gr));
        }

        public String getUnits() {
            GribTables.Parameter p = Grib2DataPanel.this.cust.getParameter(this.discipline, this.pds.getParameterCategory(), this.pds.getParameterNumber());
            return p == null ? "?" : p.getUnit();
        }

        public final String getCenter() {
            return this.id.getCenter_id() + "/" + this.id.getSubcenter_id();
        }

        public final String getTable() {
            return this.id.getMaster_table_version() + "-" + this.id.getLocal_table_version();
        }
    }

    private class DateCount
    implements Comparable<DateCount> {
        CalendarDate d;
        int count;

        private DateCount(CalendarDate d) {
            this.d = d;
        }

        @Override
        public int compareTo(DateCount o) {
            return this.d.compareTo(o.d);
        }
    }
}

