/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.util.Indent;
import ucar.unidata.io.RandomAccessFile;

public class BufrDataProcess {
    private PrintStream out;
    private Indent indent = new Indent(2);
    private boolean showData = false;
    private boolean showMess = false;
    private boolean showFile = true;

    public BufrDataProcess(String filename, OutputStream os, FileFilter ff) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            System.out.println(filename + " does not exist");
            return;
        }
        if (f.isDirectory()) {
            Counter gtotal = new Counter();
            int nmess = this.processAllInDir(f, os, ff, gtotal);
            this.out.format("%nGrand Total nmess=%d count=%d miss=%d %f %% %n", nmess, gtotal.nvals, gtotal.nmiss, gtotal.percent());
        } else {
            this.processOneFile(f.getPath(), os, null);
        }
    }

    public int processAllInDir(File dir, OutputStream os, FileFilter ff, Counter gtotal) throws IOException {
        File[] allFiles;
        int nmess = 0;
        System.out.println("---------------Reading directory " + dir.getPath());
        for (File f : allFiles = dir.listFiles()) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || ff != null && !ff.accept(f)) continue;
            nmess += this.processOneFile(f.getPath(), os, gtotal);
        }
        for (File f : allFiles) {
            if (!f.isDirectory()) continue;
            nmess += this.processAllInDir(f, os, ff, gtotal);
        }
        return nmess;
    }

    int processOneFile(String filename, OutputStream os, Counter gtotal) throws IOException {
        int nmess;
        this.out = new PrintStream(os);
        if (this.showFile) {
            this.out.format("Process %s%n", filename);
        }
        this.indent.setIndentLevel(0);
        try {
            Counter total = new Counter();
            nmess = this.scanBufrFile(filename, total);
            if (this.showFile) {
                this.out.format("%nTotal nmess=%d count=%d miss=%d %f %% %n", nmess, total.nvals, total.nmiss, total.percent());
            }
            if (gtotal != null) {
                gtotal.add(total);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        this.out.flush();
        return nmess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scanBufrFile(String filename, Counter total) throws Exception {
        int count = 0;
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(filename, "r");
            MessageScanner scan = new MessageScanner(raf);
            while (scan.hasNext()) {
                Message m = scan.next();
                if (m == null) continue;
                try {
                    if (this.showMess) {
                        this.out.format("%sMessage %d header=%s%n", this.indent, count, m.getHeader());
                    }
                    ++count;
                    Counter counter = new Counter();
                    this.processBufrMessageAsDataset(scan, m, counter);
                    if (this.showMess) {
                        this.out.format("%scount=%d miss=%d%n", this.indent, counter.nvals, counter.nmiss);
                    }
                    total.add(counter);
                }
                catch (Exception e) {
                    System.out.printf("  BARF:%s on %s%n", e.getMessage(), m.getHeader());
                    this.indent.setIndentLevel(0);
                }
            }
        }
        return count;
    }

    private void processBufrMessageAsDataset(MessageScanner scan, Message m, Counter counter) throws Exception {
        byte[] mbytes = scan.getMessageBytes(m);
        NetcdfFile ncfile = NetcdfFile.openInMemory("test", mbytes, "ucar.nc2.iosp.bufr.BufrIosp");
        Sequence obs = (Sequence)ncfile.findVariable("obs");
        StructureDataIterator sdataIter = obs.getStructureIterator(-1);
        this.processSequence(obs, sdataIter, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSequence(Structure s, StructureDataIterator sdataIter, Counter counter) throws IOException {
        this.indent.incr();
        int count = 0;
        try {
            while (sdataIter.hasNext()) {
                if (this.showData) {
                    this.out.format("%sSequence %s count=%d%n", this.indent, s.getShortName(), count++);
                }
                StructureData sdata = sdataIter.next();
                this.indent.incr();
                for (StructureMembers.Member m : sdata.getMembers()) {
                    ArrayStructure data;
                    Structure sds;
                    Variable v = s.findVariable(m.getName());
                    if (m.getDataType().isString() || m.getDataType().isNumeric()) {
                        this.processVariable(v, sdata.getArray(m), counter);
                        continue;
                    }
                    if (m.getDataType() == DataType.STRUCTURE) {
                        sds = (Structure)v;
                        data = (ArrayStructure)sdata.getArray(m);
                        this.processSequence(sds, data.getStructureDataIterator(), counter);
                        continue;
                    }
                    if (m.getDataType() != DataType.SEQUENCE) continue;
                    sds = (Sequence)v;
                    data = (ArraySequence)sdata.getArray(m);
                    this.processSequence(sds, ((ArraySequence)data).getStructureDataIterator(), counter);
                }
                this.indent.decr();
            }
        }
        finally {
            sdataIter.finish();
        }
        this.indent.decr();
    }

    private void processVariable(Variable v, Array mdata, Counter count) throws IOException {
        int bitWidth;
        String name = v.getShortName();
        String units = v.getUnitsString();
        Attribute bwAtt = v.findAttribute("BUFR:bitWidth");
        int n = bitWidth = bwAtt == null ? 0 : bwAtt.getNumericValue().intValue();
        if (this.showData) {
            this.out.format("%svar='%s' units='%s' : ", this.indent, name, units);
        }
        mdata.resetLocalIterator();
        while (mdata.hasNext()) {
            ++count.nvals;
            if (v.isUnsigned()) {
                if (!this.isMissingUnsigned(v, mdata, bitWidth)) continue;
                ++count.nmiss;
                continue;
            }
            if (!this.isMissing(v, mdata, bitWidth)) continue;
            ++count.nmiss;
        }
        if (this.showData) {
            this.out.format("%n", new Object[0]);
        }
    }

    private boolean isMissing(Variable v, Array mdata, int bitWidth) {
        if (v.getDataType().isNumeric()) {
            long val = mdata.nextLong();
            boolean result = BufrNumbers.isMissing(val, bitWidth);
            if (this.showData) {
                this.out.format("%d %s,", val, result ? "(miss)" : "");
            }
            return result;
        }
        Object s = mdata.next();
        if (this.showData) {
            this.out.format("%s,", s);
        }
        return false;
    }

    private boolean isMissingUnsigned(Variable v, Array mdata, int bitWidth) {
        long val = 0L;
        switch (v.getDataType()) {
            case ENUM1: 
            case BYTE: {
                val = DataType.unsignedByteToShort(mdata.nextByte());
                break;
            }
            case ENUM2: 
            case SHORT: {
                val = DataType.unsignedShortToInt(mdata.nextShort());
                break;
            }
            case ENUM4: 
            case INT: {
                val = DataType.unsignedIntToLong(mdata.nextInt());
                break;
            }
            default: {
                throw new RuntimeException("illegal datatype " + (Object)((Object)v.getDataType()));
            }
        }
        boolean result = BufrNumbers.isMissing(val, bitWidth);
        if (this.showData) {
            this.out.format("%d %s,", val, result ? "(miss)" : "");
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        new BufrDataProcess("C:/data/formats/bufrRoy/", System.out, null);
    }

    private class Counter {
        int nvals;
        int nmiss;

        private Counter() {
        }

        void add(Counter c) {
            this.nvals += c.nvals;
            this.nmiss += c.nmiss;
        }

        double percent() {
            return 100.0 * (double)this.nmiss / (double)this.nvals;
        }
    }
}

