/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public abstract class StationTimeSeriesFeatureImpl
extends PointCollectionImpl
implements StationTimeSeriesFeature {
    protected Station s;

    public StationTimeSeriesFeatureImpl(String name, String desc, String wmoId, double lat, double lon, double alt, DateUnit timeUnit, String altUnits, int npts) {
        super(name, timeUnit, altUnits);
        this.s = new StationImpl(name, desc, wmoId, lat, lon, alt, npts);
        this.timeUnit = timeUnit;
        this.npts = npts;
    }

    public StationTimeSeriesFeatureImpl(Station s, DateUnit timeUnit, String altUnits, int npts) {
        super(s.getName(), timeUnit, altUnits);
        this.s = s;
        this.npts = npts;
        this.setBoundingBox(new LatLonRect(s.getLatLon(), 1.0E-4, 1.0E-4));
    }

    @Override
    public String getWmoId() {
        return this.s.getWmoId();
    }

    @Override
    public int size() {
        return this.npts;
    }

    public void setNumberPoints(int npts) {
        this.npts = npts;
    }

    @Override
    public String getName() {
        return this.s.getName();
    }

    @Override
    public String getDescription() {
        return this.s.getDescription();
    }

    @Override
    public double getLatitude() {
        return this.s.getLatitude();
    }

    @Override
    public double getLongitude() {
        return this.s.getLongitude();
    }

    @Override
    public double getAltitude() {
        return this.s.getAltitude();
    }

    @Override
    public LatLonPoint getLatLon() {
        return this.s.getLatLon();
    }

    @Override
    public boolean isMissing() {
        return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
    }

    @Override
    public FeatureType getCollectionFeatureType() {
        return FeatureType.STATION;
    }

    @Override
    public DateUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String toString() {
        return "StationFeatureImpl{s=" + this.s + ", timeUnit=" + this.timeUnit + ", npts=" + this.npts + '}';
    }

    @Override
    public StationTimeSeriesFeature subset(CalendarDateRange dateRange) throws IOException {
        if (dateRange == null) {
            return this;
        }
        return new StationFeatureSubset(this, dateRange);
    }

    @Override
    public StationTimeSeriesFeature subset(DateRange dateRange) throws IOException {
        if (dateRange == null) {
            return this;
        }
        return new StationFeatureSubset(this, CalendarDateRange.of(dateRange));
    }

    @Override
    public int compareTo(Station so) {
        return this.name.compareTo(so.getName());
    }

    private class StationFeatureSubset
    extends StationTimeSeriesFeatureImpl {
        StationTimeSeriesFeatureImpl from;

        StationFeatureSubset(StationTimeSeriesFeatureImpl from, CalendarDateRange filter_date) {
            super(from.s, from.getTimeUnit(), from.getAltUnits(), -1);
            this.from = from;
            this.dateRange = filter_date == null ? from.dateRange : (from.dateRange == null ? filter_date : from.dateRange.intersect(filter_date));
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            return new PointIteratorFiltered(this.from.getPointFeatureIterator(bufferSize), null, this.dateRange);
        }

        @Override
        public StructureData getFeatureData() throws IOException {
            return this.from.getFeatureData();
        }
    }
}

