/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Grib2Iosp
extends GribIosp {
    private static final Logger logger = LoggerFactory.getLogger(Grib2Iosp.class);
    private static final boolean debugTime = false;
    private static final boolean debugRead = false;
    private static final boolean debugName = false;
    private static boolean useGenType = false;
    private Grib2Customizer cust;

    public static String makeVariableNameFromTable(Grib2Customizer tables, GribCollection gribCollection, GribCollection.VariableIndex vindex) {
        String statName;
        String intvName;
        Formatter f = new Formatter();
        GribTables.Parameter param = tables.getParameter(vindex.discipline, vindex.category, vindex.parameter);
        if (param == null) {
            f.format("VAR%d-%d-%d_FROM_%d-%d-%d", vindex.discipline, vindex.category, vindex.parameter, gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.tableVersion);
        } else {
            f.format("%s", GribUtils.makeNameFromDescription(param.getName()));
        }
        if (!(useGenType || vindex.genProcessType != 6 && vindex.genProcessType != 7)) {
            f.format("_error", new Object[0]);
        }
        if (vindex.levelType != -9999) {
            f.format("_%s", tables.getLevelNameShort(vindex.levelType));
            if (vindex.isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if ((intvName = vindex.getTimeIntvName()) != null && !intvName.isEmpty()) {
            f.format("_%s", intvName);
        }
        if (vindex.intvType >= 0 && (statName = tables.getStatisticNameShort(vindex.intvType)) != null) {
            f.format("_%s", statName);
        }
        if (vindex.ensDerivedType >= 0) {
            f.format("_%s", tables.getProbabilityNameShort(vindex.ensDerivedType));
        } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            String s = StringUtil2.substitute(vindex.probabilityName, ".", "p");
            f.format("_probability_%s", s);
        } else if (vindex.isEnsemble) {
            f.format("_ens", new Object[0]);
        }
        if (vindex.genProcessType >= 0 && useGenType) {
            String genType = tables.getGeneratingProcessTypeName(vindex.genProcessType);
            String s = StringUtil2.substitute(genType, " ", "_");
            f.format("_%s", s);
        }
        return f.toString();
    }

    public static String makeVariableLongName(Grib2Customizer cust, GribCollection.VariableIndex vindex) {
        GribTables.Parameter gp;
        boolean isProb;
        Formatter f = new Formatter();
        boolean bl = isProb = vindex.probabilityName != null && vindex.probabilityName.length() > 0;
        if (isProb) {
            f.format("Probability ", new Object[0]);
        }
        if ((gp = cust.getParameter(vindex.discipline, vindex.category, vindex.parameter)) == null) {
            f.format("Unknown Parameter %d-%d-%d", vindex.discipline, vindex.category, vindex.parameter);
        } else {
            f.format("%s", gp.getName());
        }
        if (vindex.intvType >= 0 && vindex.getTimeIntvName() != null && !vindex.getTimeIntvName().isEmpty()) {
            String intvName = cust.getStatisticNameShort(vindex.intvType);
            if (intvName == null || intvName.equalsIgnoreCase("Missing")) {
                intvName = cust.getStatisticNameShort(vindex.intvType);
            }
            if (intvName == null) {
                f.format(" (%s)", vindex.getTimeIntvName());
            } else {
                f.format(" (%s %s)", vindex.getTimeIntvName(), intvName);
            }
        } else if (vindex.intvType >= 0) {
            String intvName = cust.getStatisticNameShort(vindex.intvType);
            f.format(" (%s)", intvName);
        }
        if (vindex.ensDerivedType >= 0) {
            f.format(" (%s)", cust.getTableValue("4.7", vindex.ensDerivedType));
        } else if (isProb) {
            f.format(" %s %s", vindex.probabilityName, Grib2Iosp.getVindexUnits(cust, vindex));
        }
        if (!(useGenType || vindex.genProcessType != 6 && vindex.genProcessType != 7)) {
            f.format(" error", new Object[0]);
        } else if (useGenType && vindex.genProcessType >= 0) {
            f.format(" %s", cust.getGeneratingProcessTypeName(vindex.genProcessType));
        }
        if (vindex.levelType != -9999) {
            f.format(" @ %s", cust.getTableValue("4.5", vindex.levelType));
            if (vindex.isLayer) {
                f.format(" layer", new Object[0]);
            }
        }
        return f.toString();
    }

    @Override
    protected String makeVariableNameFromRecord(GribCollection.VariableIndex vindex) {
        String intvName;
        Formatter f = new Formatter();
        f.format("VAR_%d-%d-%d", vindex.discipline, vindex.category, vindex.parameter);
        if (!(useGenType || vindex.genProcessType != 6 && vindex.genProcessType != 7)) {
            f.format("_error", new Object[0]);
        }
        if (vindex.levelType != -9999) {
            f.format("_L%d", vindex.levelType);
            if (vindex.isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if ((intvName = vindex.getTimeIntvName()) != null && !intvName.isEmpty()) {
            if (intvName.equals("Mixed_intervals")) {
                f.format("_Imixed", new Object[0]);
            } else {
                f.format("_I%s", intvName);
            }
        }
        if (vindex.intvType >= 0) {
            f.format("_S%s", vindex.intvType);
        }
        if (vindex.ensDerivedType >= 0) {
            f.format("_D%d", vindex.ensDerivedType);
        } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            String s = StringUtil2.substitute(vindex.probabilityName, ".", "p");
            f.format("_Prob_%s", s);
        }
        return f.toString();
    }

    @Override
    protected String makeVariableName(GribCollection.VariableIndex vindex) {
        return Grib2Iosp.makeVariableNameFromTable(this.cust, this.gribCollection, vindex);
    }

    @Override
    protected String makeVariableLongName(GribCollection.VariableIndex vindex) {
        return Grib2Iosp.makeVariableLongName(this.cust, vindex);
    }

    @Override
    protected String makeVariableUnits(GribCollection.VariableIndex vindex) {
        return Grib2Iosp.makeVariableUnits(this.cust, vindex);
    }

    public static String makeVariableUnits(Grib2Customizer tables, GribCollection.VariableIndex vindex) {
        if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            return "%";
        }
        return Grib2Iosp.getVindexUnits(tables, vindex);
    }

    private static String getVindexUnits(Grib2Customizer tables, GribCollection.VariableIndex vindex) {
        GribTables.Parameter gp = tables.getParameter(vindex.discipline, vindex.category, vindex.parameter);
        String val = gp == null ? "" : gp.getUnit();
        return val == null ? "" : val;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        GribCdmIndex.GribCollectionType type = GribCdmIndex.getType(raf);
        if (type == GribCdmIndex.GribCollectionType.GRIB2) {
            return true;
        }
        if (type == GribCdmIndex.GribCollectionType.Partition2) {
            return true;
        }
        return Grib2RecordScanner.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.GRIB2.toString();
    }

    @Override
    public String getFileTypeDescription() {
        return "GRIB2 Collection";
    }

    public Grib2Iosp() {
        super(false, logger);
    }

    public Grib2Iosp(GribCollection.GroupGC gHcs, GribCollection.Type gtype) {
        super(false, logger);
        this.gHcs = gHcs;
        this.owned = true;
        this.gtype = gtype;
    }

    public Grib2Iosp(GribCollection gc) {
        super(false, logger);
        this.gribCollection = gc;
        this.owned = true;
    }

    protected String getIntervalName(int id) {
        return this.cust.getStatisticName(id);
    }

    @Override
    protected GribTables createCustomizer() {
        this.cust = Grib2Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal(), this.gribCollection.getGenProcessId());
        return this.cust;
    }

    @Override
    protected void addGlobalAttributes(NetcdfFile ncfile) {
        String val = this.cust.getTableValue("4.3", this.gribCollection.getGenProcessType());
        if (val != null) {
            ncfile.addAttribute(null, new Attribute("Type_of_generating_process", val));
        }
        if ((val = this.cust.getGeneratingProcessName(this.gribCollection.getGenProcessId())) != null) {
            ncfile.addAttribute(null, new Attribute("Analysis_or_forecast_generating_process_identifier_defined_by_originating_centre", val));
        }
        if ((val = this.cust.getGeneratingProcessName(this.gribCollection.getBackProcessId())) != null) {
            ncfile.addAttribute(null, new Attribute("Background_generating_process_identifier_defined_by_originating_centre", val));
        }
    }

    @Override
    protected String getVerticalCoordDesc(int vc_code) {
        return this.cust.getTableValue("4.5", vc_code);
    }

    @Override
    protected GribTables.Parameter getParameter(GribCollection.VariableIndex vindex) {
        return this.cust.getParameter(vindex.discipline, vindex.category, vindex.parameter);
    }

    @Override
    protected void addVariableAttributes(Variable v, GribCollection.VariableIndex vindex) {
        GribTables.Parameter entry;
        String cat;
        v.addAttribute(new Attribute("Grib_Variable_Id", this.makeVariableNameFromRecord(vindex)));
        int[] param = new int[]{vindex.discipline, vindex.category, vindex.parameter};
        v.addAttribute(new Attribute("Grib2_Parameter", Array.factory(param)));
        String disc = this.cust.getTableValue("0.0", vindex.discipline);
        if (disc != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Discipline", disc));
        }
        if ((cat = this.cust.getCategory(vindex.discipline, vindex.category)) != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Category", cat));
        }
        if ((entry = this.cust.getParameter(vindex.discipline, vindex.category, vindex.parameter)) != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Name", entry.getName()));
        }
        if (vindex.levelType != 255) {
            String levelTypeName = this.cust.getLevelName(vindex.levelType);
            if (levelTypeName != null) {
                v.addAttribute(new Attribute("Grib2_Level_Type", levelTypeName));
            } else {
                v.addAttribute(new Attribute("Grib2_Level_Type", vindex.levelType));
            }
        }
        if (vindex.ensDerivedType >= 0) {
            v.addAttribute(new Attribute("Grib2_Ensemble_Derived_Type", vindex.ensDerivedType));
        } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            v.addAttribute(new Attribute("Grib2_Probability_Type", vindex.probType));
            v.addAttribute(new Attribute("Grib2_Probability_Name", vindex.probabilityName));
        }
        if (vindex.genProcessType >= 0) {
            String genProcessTypeName = this.cust.getGeneratingProcessTypeName(vindex.genProcessType);
            if (genProcessTypeName != null) {
                v.addAttribute(new Attribute("Grib2_Generating_Process_Type", genProcessTypeName));
            } else {
                v.addAttribute(new Attribute("Grib2_Generating_Process_Type", vindex.genProcessType));
            }
        }
    }

    @Override
    protected void show(RandomAccessFile rafData, long pos) throws IOException {
        Grib2Record gr = Grib2RecordScanner.findRecordByDrspos(rafData, pos);
        if (gr != null) {
            Formatter f = new Formatter();
            f.format("File=%s%n", rafData.getLocation());
            f.format("  Parameter=%s%n", this.cust.getVariableName(gr));
            f.format("  ReferenceDate=%s%n", gr.getReferenceDate());
            f.format("  ForecastDate=%s%n", this.cust.getForecastDate(gr));
            TimeCoord.TinvDate tinv = this.cust.getForecastTimeInterval(gr);
            if (tinv != null) {
                f.format("  TimeInterval=%s%n", tinv);
            }
            f.format("  ", new Object[0]);
            gr.getPDS().show(f);
            System.out.printf("%nGrib2Record.readData at drsPos %d = %s%n", pos, f.toString());
        }
    }

    @Override
    protected float[] readData(RandomAccessFile rafData, GribIosp.DataRecord dr) throws IOException {
        GdsHorizCoordSys hcs = dr.hcs;
        int scanMode = dr.scanMode == 9999 ? hcs.scanMode : dr.scanMode;
        return Grib2Record.readData(rafData, dr.dataPos, dr.bmsPos, hcs.gdsNumberPoints, scanMode, hcs.nxRaw, hcs.nyRaw, hcs.nptsInLine);
    }
}

