/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.HelpRequestedException;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrDataDescriptionSection;
import ucar.nc2.iosp.bufr.BufrDataSection;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.BufrIndicatorSection;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.writer.MessageDispatchDDS;
import ucar.unidata.io.InMemoryRandomAccessFile;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;

public class BufrSplitter {
    private static final Logger logger = LoggerFactory.getLogger(BufrSplitter.class);
    private static final KMPMatch matcher = new KMPMatch("BUFR".getBytes());
    File dirOut;
    MessageDispatchDDS dispatcher;
    Formatter out;
    private static AtomicInteger seqId = new AtomicInteger();
    int total_msgs = 0;
    int bad_msgs = 0;
    private boolean showRead = false;
    private long bytesRead = 0L;
    private int BUFFSIZE = 15000;

    public BufrSplitter(String dirName, Formatter out) throws IOException {
        this.out = out;
        this.dirOut = new File(dirName);
        if (this.dirOut.exists() && !this.dirOut.isDirectory()) {
            throw new IllegalArgumentException(this.dirOut + " must be a directory");
        }
        if (!this.dirOut.exists() && !this.dirOut.mkdirs()) {
            throw new IllegalArgumentException(this.dirOut + " filed to create");
        }
        this.dispatcher = new MessageDispatchDDS(null, this.dirOut);
    }

    public void execute(String filename) throws IOException {
        File input = new File(filename);
        this.out.format("BufrSplitter on %s length=%d%n", input.getPath(), input.length());
        try (FileInputStream is = new FileInputStream(input);){
            this.processStream(is);
        }
    }

    public void exit() {
        this.dispatcher.exit(this.out);
    }

    public void processStream(InputStream is) throws IOException {
        int pos = -1;
        Buffer b = null;
        do {
            b = pos < 0 ? this.readBuffer(is) : this.readBuffer(is, b, pos);
            pos = this.processBuffer(b, is);
        } while (!b.done);
    }

    private int processBuffer(Buffer b, InputStream is) throws IOException {
        int start = 0;
        while (start < b.have) {
            int matchPos = matcher.indexOf(b.buff, start, b.have - start);
            if (matchPos < 0) {
                if (start == 0) {
                    return b.have - 3;
                }
                return start;
            }
            if (matchPos + 6 >= b.have) {
                return start;
            }
            int b1 = b.buff[matchPos + 4] & 0xFF;
            int b2 = b.buff[matchPos + 5] & 0xFF;
            int b3 = b.buff[matchPos + 6] & 0xFF;
            int messLen = b1 << 16 | b2 << 8 | b3;
            System.out.println("match at=" + matchPos + " len= " + messLen);
            MessageTask task = new MessageTask(messLen);
            task.extractHeader(start, matchPos, b);
            int last = matchPos + messLen;
            if (last > b.have) {
                task.have = b.have - matchPos;
                System.arraycopy(b.buff, matchPos, task.mess, 0, task.have);
                if (!this.readBuffer(is, task.mess, task.have, task.len - task.have)) {
                    logger.warn("Failed to read remaining BUFR message");
                    break;
                }
            } else {
                task.have = task.len;
                System.arraycopy(b.buff, matchPos, task.mess, 0, task.have);
            }
            boolean ok = true;
            for (int i = task.len - 4; i < task.len; ++i) {
                byte bb = task.mess[i];
                if (bb == 55) continue;
                ok = false;
                ++this.bad_msgs;
            }
            if (ok) {
                this.processMessageTask(task);
            }
            ++this.total_msgs;
            start = matchPos + messLen + 1;
        }
        return -1;
    }

    void processMessageTask(MessageTask mtask) {
        try {
            Message m = this.getMessage(new InMemoryRandomAccessFile("BUFR", mtask.mess));
            if (null == m) {
                return;
            }
            m.setHeader(mtask.header);
            m.setRawBytes(mtask.mess);
            this.dispatcher.dispatch(m);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Message getMessage(RandomAccessFile raf) throws IOException {
        raf.seek(4L);
        BufrIndicatorSection is = new BufrIndicatorSection(raf);
        BufrIdentificationSection ids = new BufrIdentificationSection(raf, is);
        BufrDataDescriptionSection dds = new BufrDataDescriptionSection(raf);
        long dataPos = raf.getFilePointer();
        int dataLength = BufrNumbers.uint3(raf);
        BufrDataSection dataSection = new BufrDataSection(dataPos, dataLength);
        if (is.getBufrEdition() > 4 || is.getBufrEdition() < 2) {
            logger.warn("Edition " + is.getBufrEdition() + " is not supported");
            ++this.bad_msgs;
            return null;
        }
        return new Message(raf, is, ids, dds, dataSection);
    }

    private boolean readBuffer(InputStream is, byte[] dest, int start, int want) throws IOException {
        int done;
        int got;
        for (done = 0; done < want; done += got) {
            got = is.read(dest, start + done, want - done);
            if (got >= 0) continue;
            return false;
        }
        if (this.showRead) {
            System.out.println("Read buffer at " + this.bytesRead + " len=" + done);
        }
        this.bytesRead += (long)done;
        return true;
    }

    private Buffer readBuffer(InputStream is) throws IOException {
        Buffer b = new Buffer();
        int want = this.BUFFSIZE;
        while (b.have < want) {
            int got = is.read(b.buff, b.have, want - b.have);
            if (got < 0) {
                b.done = true;
                break;
            }
            b.have += got;
        }
        if (this.showRead) {
            System.out.println("Read buffer at " + this.bytesRead + " len=" + b.have);
        }
        this.bytesRead += (long)b.have;
        return b;
    }

    private Buffer readBuffer(InputStream is, Buffer prev, int pos) throws IOException {
        Buffer b = new Buffer();
        int remain = prev.have - pos;
        System.arraycopy(prev.buff, pos, b.buff, 0, remain);
        b.have = remain;
        int want = this.BUFFSIZE;
        while (b.have < want) {
            int got = is.read(b.buff, b.have, want - b.have);
            if (got < 0) {
                b.done = true;
                break;
            }
            b.have += got;
        }
        if (this.showRead) {
            System.out.println("Read buffer at " + this.bytesRead + " len=" + b.have);
        }
        this.bytesRead += (long)b.have;
        return b;
    }

    void printOptions(Options opt) {
        System.out.printf("Options are ok:%n", new Object[0]);
        System.out.printf(" fileSpec= %s%n", opt.getFileSpec());
        System.out.printf(" dirOut= %s%n", opt.getDirOut());
    }

    public static void main(String[] args) {
        try {
            Options options = args == null ? CliFactory.parseArguments(Options.class, "--fileSpec", "E:/data/work/manross/gdas.adpsfc.t00z.20120603.bufr.le", "--dirOut", "E:/data/work/manross/split_adpsfc") : CliFactory.parseArguments(Options.class, args);
            BufrSplitter splitter = new BufrSplitter(options.getDirOut(), new Formatter(System.out));
            splitter.execute(options.getFileSpec());
            splitter.exit();
        }
        catch (HelpRequestedException e) {
            System.out.printf("BufrSpitter: %s%n", e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Options {
        @Option
        public String getFileSpec();

        @Option
        public String getDirOut();

        @Option(helpRequest=true)
        public boolean getHelp();
    }

    private class Buffer {
        byte[] buff;
        int have;
        boolean done;

        Buffer() {
            this.buff = new byte[BufrSplitter.this.BUFFSIZE];
            this.have = 0;
            this.done = false;
        }
    }

    private class MessageTask {
        byte[] mess;
        int len;
        int have;
        int id;
        String header;

        MessageTask(int messlen) {
            this.len = messlen;
            this.mess = new byte[messlen];
            this.have = 0;
            this.id = seqId.getAndIncrement();
        }

        void extractHeader(int startScan, int messagePos, Buffer buff) {
            byte b;
            int sizeHeader = messagePos - startScan;
            if (sizeHeader > 30) {
                sizeHeader = 30;
            }
            byte[] headerb = new byte[sizeHeader];
            int startHeader = messagePos - sizeHeader;
            System.arraycopy(buff.buff, startHeader, headerb, 0, sizeHeader);
            for (int start = 0; start < headerb.length && (b = headerb[start]) != 73 && b != 74; ++start) {
            }
            byte[] bb = new byte[sizeHeader];
            int count = 0;
            for (int i = start; i < headerb.length; ++i) {
                byte b2 = headerb[i];
                if (b2 < 32 || b2 >= 127) continue;
                bb[count++] = b2;
            }
            this.header = new String(bb, 0, count);
        }
    }
}

