/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.writer.MessageDispatchDDS;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;

public class BufrSplitter2 {
    private static final Logger logger = LoggerFactory.getLogger(BufrSplitter2.class);
    private static final KMPMatch matcher = new KMPMatch("BUFR".getBytes());
    File dirOut;
    MessageDispatchDDS dispatcher;
    Formatter out;
    int total_msgs = 0;

    public BufrSplitter2(String dirName, Formatter out) throws IOException {
        this.out = out;
        this.dirOut = new File(dirName);
        if (this.dirOut.exists() && !this.dirOut.isDirectory()) {
            throw new IllegalArgumentException(this.dirOut + " must be a directory");
        }
        if (!this.dirOut.exists() && !this.dirOut.mkdirs()) {
            throw new IllegalArgumentException(this.dirOut + " filed to create");
        }
        this.dispatcher = new MessageDispatchDDS(null, this.dirOut);
    }

    public void execute(String filename) throws IOException {
        try (RandomAccessFile mraf = new RandomAccessFile(filename, "r");){
            MessageScanner scanner = new MessageScanner(mraf);
            while (scanner.hasNext()) {
                Message m = scanner.next();
                if (m == null) continue;
                ++this.total_msgs;
                if (m.getNumberDatasets() == 0) continue;
                m.setRawBytes(scanner.getMessageBytes(m));
                this.dispatcher.dispatch(m);
            }
            this.dispatcher.resetBufrTableMessages();
        }
    }

    public void exit() {
        this.dispatcher.exit(this.out);
    }
}

