/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrTableLookup;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.writer.MessageWriter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;

public class MessageDispatchDDS {
    private static final Logger logger = LoggerFactory.getLogger(MessageDispatchDDS.class);
    private File dispatchDir;
    private String inputFilenameOut;
    private Set<Integer> badHashSet = new HashSet<Integer>(200);
    private Map<String, Integer> nameMap = new HashMap<String, Integer>(200);
    private Map<Integer, MessType> typeMap = new HashMap<Integer, MessType>(200);
    private Map<String, MessageWriter> writers = new HashMap<String, MessageWriter>(100);
    private List<Message> bufrTableMessages = new ArrayList<Message>();
    int total_msgs = 0;
    int match = 0;
    int badCount = 0;
    long badBytes = 0L;
    int failWrite = 0;
    int ignored = 0;
    long total_bytes;
    int total_obs;
    boolean showMatch = false;
    boolean showBad = false;
    boolean showConfig = false;
    boolean dayRollover = true;
    boolean useCatSubdirs = true;
    boolean useHeader = false;
    boolean writeIndex = false;
    boolean writeSamples = false;
    WritableByteChannel badWbc;
    WritableByteChannel sampleWbc;
    WritableByteChannel allWbc;

    MessageDispatchDDS(String configFilename, File dispatchDir) throws IOException {
        File inputFile;
        this.dispatchDir = dispatchDir;
        if (configFilename != null && (inputFile = new File(configFilename)).exists()) {
            try (BufferedReader dataIS = new BufferedReader(new InputStreamReader(new FileInputStream(inputFile)));){
                String line;
                while ((line = dataIS.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) {
                        break;
                    }
                    if (line.charAt(0) == '#') continue;
                    String[] toke = line.split(",");
                    Integer hash = Integer.parseInt(toke[0]);
                    String bitsOk = toke.length > 8 ? toke[7].trim() : "";
                    this.typeMap.put(hash, new MessType(hash, toke[1], toke[2], toke[3], bitsOk));
                }
            }
        }
    }

    public void setInputFilenameOut(String inputFilenameOut) {
        this.inputFilenameOut = inputFilenameOut;
    }

    void resetBufrTableMessages() {
        this.bufrTableMessages = new ArrayList<Message>();
    }

    void dispatch(Message m) throws IOException {
        ++this.total_msgs;
        this.total_bytes += (long)m.getRawBytes().length;
        this.total_obs += m.getNumberDatasets();
        boolean isTable = m.containsBufrTable();
        if (isTable) {
            this.bufrTableMessages.add(m);
            return;
        }
        MessType matched = this.typeMap.get(m.hashCode());
        boolean newOne = false;
        if (matched == null) {
            matched = new MessType(m);
            this.typeMap.put(m.hashCode(), matched);
            this.writeSample(m, this.allWbc);
            newOne = true;
        } else if (matched.proto == null) {
            matched.proto = m;
            this.writeSample(m, this.allWbc);
            newOne = true;
        }
        ++matched.count;
        matched.countObs += m.getNumberDatasets();
        if (matched.ignore) {
            ++this.ignored;
            return;
        }
        if (matched.checkBad && this.checkIfBad(m)) {
            ++matched.nbad;
            return;
        }
        boolean written = matched.scheduleWrite(m);
        if (written) {
            matched.countBytes += (float)(m.getRawBytes().length + m.getHeader().length());
        }
        if (written && newOne) {
            this.writeSample(m, this.sampleWbc);
        }
    }

    boolean checkIfBad(Message m) {
        boolean isBad;
        try {
            isBad = m.isTablesComplete() && !m.isBitCountOk();
        }
        catch (Exception e) {
            isBad = true;
        }
        if (isBad) {
            if (!this.badHashSet.contains(m.hashCode())) {
                this.badHashSet.add(m.hashCode());
                try {
                    this.badWbc.write(ByteBuffer.wrap(m.getHeader().getBytes()));
                    this.badWbc.write(ByteBuffer.wrap(m.getRawBytes()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.showBad) {
                logger.warn("bad <" + m.getHeader() + ">");
            }
            ++this.badCount;
            this.badBytes += (long)(m.getRawBytes().length + m.getHeader().length());
        }
        return isBad;
    }

    void writeSample(Message m, WritableByteChannel wbc) {
        if (!this.writeSamples) {
            return;
        }
        try {
            if (m.getHeader() != null) {
                wbc.write(ByteBuffer.wrap(m.getHeader().getBytes()));
            }
            wbc.write(ByteBuffer.wrap(m.getRawBytes()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void exit(Formatter out) {
        int avg_obs;
        try {
            for (MessageWriter writer : this.writers.values()) {
                writer.close();
            }
            if (this.badWbc != null) {
                this.badWbc.close();
            }
            if (this.sampleWbc != null) {
                this.sampleWbc.close();
            }
            if (this.allWbc != null) {
                this.allWbc.close();
            }
        }
        catch (IOException ioe) {
            logger.error("MessageDispatchDDS.exit", ioe);
        }
        if (out != null) {
            out.format("%n===============================================%n", new Object[0]);
        }
        int avg_msg = this.total_msgs == 0 ? 0 : (int)(this.total_bytes / (long)this.total_msgs);
        int n = avg_obs = this.total_msgs == 0 ? 0 : this.total_obs / this.total_msgs;
        if (out != null) {
            out.format("total_msgs=%d total_obs=%d total_bytes=%d avg_msg_size=%d avg_obs/msg=%d %n", this.total_msgs, this.total_obs, this.total_bytes, avg_msg, avg_obs);
            out.format("matched=%d types=%d bad=%d badTypes=%d badBytes=%d ignored=%d failWrite=%d %n", this.match, this.typeMap.size(), this.badCount, this.badHashSet.size(), this.badBytes, this.ignored, this.failWrite);
        }
        if (this.inputFilenameOut != null) {
            try (FileOutputStream cout = new FileOutputStream(this.inputFilenameOut);){
                Formatter cfg = new Formatter(cout);
                cfg.format("#    hash, filename, wmo, index, nmess, nobs, kBytes, complete, bitsOk, nbad, center, table, edition, category%n", new Object[0]);
                ArrayList<MessType> mtypes = new ArrayList<MessType>(this.typeMap.values());
                Collections.sort(mtypes, new MessTypeSorter());
                for (MessType mtype : mtypes) {
                    if (mtype.proto == null) {
                        if (out != null) {
                            out.format(" MessType %s count=%d fileout= %s%n", mtype.name, mtype.count, mtype.fileout);
                        }
                        cfg.format("Ox%x, %s, %s, %s, %5d, %8d, %5f %n", mtype.hash, mtype.fileout, mtype.name, mtype.index, mtype.count, mtype.countObs, Float.valueOf(mtype.countBytes / 1000.0f));
                        continue;
                    }
                    Message m = mtype.proto;
                    boolean hasBadMessages = this.badHashSet.contains(m.hashCode());
                    if (out != null) {
                        out.format(" MessType %s count=%d fileout= %s%n", mtype.name, mtype.count, mtype.fileout);
                    }
                    cfg.format("Ox%x, %s, %s, %s, %5d, %8d, %5f, %5s, %5s, %d, %s, %s, %s, %s%n", mtype.hash, mtype.fileout, mtype.name, mtype.index, mtype.count, mtype.countObs, Float.valueOf(mtype.countBytes / 1000.0f), m.isTablesComplete(), !hasBadMessages, mtype.nbad, m.getLookup().getCenterNo(), m.getLookup().getTableName(), m.is.getBufrEdition(), m.getLookup().getCategoryNo());
                }
                if (out != null) {
                    out.format("%n", new Object[0]);
                }
            }
            catch (IOException ioe) {
                logger.error("MessageDispatchDDS.exit", ioe);
            }
        }
    }

    private static class MessTypeSorter
    implements Comparator<MessType> {
        private MessTypeSorter() {
        }

        @Override
        public int compare(MessType o1, MessType o2) {
            return o1.name.compareTo(o2.name);
        }
    }

    private class MessType {
        int hash;
        String name;
        String fileout;
        String index;
        short fileno = 0;
        Message proto;
        int count;
        int countObs;
        int nbad;
        float countBytes;
        boolean ignore = false;
        boolean checkBad = false;

        MessType(int hash, String filename, String name, String index, String bitsOk) {
            this.hash = hash;
            this.fileout = filename.trim();
            this.name = name.trim();
            MessageDispatchDDS.this.nameMap.put(this.name, 0);
            this.ignore = this.fileout.equalsIgnoreCase("ignore");
            if (bitsOk.equalsIgnoreCase("true")) {
                this.checkBad = false;
            }
            if (MessageDispatchDDS.this.writeIndex) {
                this.index = index.trim();
                if (this.ignore || !this.index.equalsIgnoreCase("no")) {
                    // empty if block
                }
            }
            if (MessageDispatchDDS.this.showConfig) {
                System.out.printf(" add hash=%d name=%s filename=%s index=%s%n", hash, name, this.fileout, index);
            }
        }

        MessType(Message proto) {
            this.proto = proto;
            this.hash = proto.hashCode();
            if (MessageDispatchDDS.this.useHeader) {
                Integer nameCount;
                this.name = this.extractName(proto.getHeader());
                if (this.name == null) {
                    this.name = Integer.toHexString(this.hash);
                }
                if ((nameCount = (Integer)MessageDispatchDDS.this.nameMap.get(this.name)) != null) {
                    Integer n = nameCount;
                    Integer n2 = nameCount = Integer.valueOf(nameCount + 1);
                    MessageDispatchDDS.this.nameMap.put(this.name, nameCount);
                    this.name = this.name + "-" + nameCount;
                }
                MessageDispatchDDS.this.nameMap.put(this.name, 0);
            } else {
                this.name = Integer.toHexString(this.hash);
            }
            this.fileout = this.name;
            if (MessageDispatchDDS.this.showConfig) {
                System.out.println(" add new MessType <" + this.name + "> fileout= " + this.fileout);
            }
        }

        String extractName(String header) {
            if (header.length() < 12) {
                return null;
            }
            return header.substring(7, 11) + "-" + header.substring(0, 6);
        }

        boolean scheduleWrite(Message m) throws IOException {
            CalendarDate cd = m.ids.getReferenceTime();
            String writerName = MessageDispatchDDS.this.dayRollover ? this.fileout + "." + CalendarDateFormatter.toDateString(cd) : this.fileout;
            MessageWriter writer = (MessageWriter)MessageDispatchDDS.this.writers.get(writerName);
            if (writer == null) {
                try {
                    File file2write;
                    if (MessageDispatchDDS.this.useCatSubdirs) {
                        BufrTableLookup lookup = m.getLookup();
                        String catDir = "Category-" + lookup.getCategory() + "." + lookup.getSubCategory();
                        File dir2 = new File(MessageDispatchDDS.this.dispatchDir, catDir);
                        if (!dir2.exists() && !dir2.mkdirs()) {
                            logger.warn("Failed to make " + dir2.getPath());
                        }
                        String filename = MessageDispatchDDS.this.dayRollover ? this.fileout + "." + CalendarDateFormatter.toDateString(cd) : this.fileout;
                        file2write = new File(dir2, filename + ".bufr");
                        System.out.printf("Start %s internalTableMessages=%d%n   %s%n   %s%n", file2write, MessageDispatchDDS.this.bufrTableMessages.size(), lookup.getCenterName(), lookup.getCategoryFullName());
                    } else {
                        file2write = new File(MessageDispatchDDS.this.dispatchDir, writerName + ".bufr");
                    }
                    writer = new MessageWriter(file2write, this.fileno, MessageDispatchDDS.this.bufrTableMessages);
                    System.out.printf("Start %s internalTableMessages=%d%n", file2write, MessageDispatchDDS.this.bufrTableMessages.size());
                    MessageDispatchDDS.this.writers.put(writerName, writer);
                    this.fileno = (short)(this.fileno + 1);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            writer.write(m);
            if (MessageDispatchDDS.this.showMatch) {
                System.out.println("match <" + m.getHeader() + ">");
            }
            ++MessageDispatchDDS.this.match;
            return true;
        }
    }
}

