/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.util.Date;
import java.util.StringTokenizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.units.Converter;
import ucar.units.TimeScaleUnit;
import ucar.units.Unit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;

public class DateUnit {
    private double value;
    private String udunitString;
    private TimeUnit timeUnit = null;
    private Unit uu;

    public static Date getStandardDate(String text) {
        DateUnit du;
        String udunitString;
        double value;
        text = text.trim();
        StringTokenizer stoker = new StringTokenizer(text);
        String firstToke = stoker.nextToken();
        try {
            value = Double.parseDouble(firstToke);
            udunitString = text.substring(firstToke.length());
        }
        catch (NumberFormatException e) {
            value = 0.0;
            udunitString = text;
        }
        try {
            du = new DateUnit(udunitString);
        }
        catch (Exception e) {
            return null;
        }
        return du.makeDate(value);
    }

    public static Date getStandardOrISO(String text) {
        Date result = DateUnit.getStandardDate(text);
        if (result == null) {
            DateFormatter formatter = new DateFormatter();
            result = formatter.getISODate(text);
        }
        return result;
    }

    public static CalendarDate parseCalendarDate(String text) {
        Date result = DateUnit.getStandardDate(text);
        if (result == null) {
            DateFormatter formatter = new DateFormatter();
            result = formatter.getISODate(text);
        }
        return CalendarDate.of(result);
    }

    public static DateUnit getUnixDateUnit() {
        try {
            return new DateUnit("s since 1970-01-01 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DateUnit factory(String text) {
        try {
            return new DateUnit(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DateUnit(String text) throws Exception {
        String timeUnitString;
        text = text.trim();
        StringTokenizer stoker = new StringTokenizer(text);
        String firstToke = stoker.nextToken();
        try {
            this.value = Double.parseDouble(firstToke);
            this.udunitString = text.substring(firstToke.length());
            timeUnitString = stoker.nextToken();
        }
        catch (NumberFormatException e) {
            this.value = 0.0;
            this.udunitString = text;
            timeUnitString = firstToke;
        }
        this.uu = SimpleUnit.makeUnit(this.udunitString);
        this.timeUnit = new TimeUnit(timeUnitString);
    }

    public DateUnit(double value, String timeUnitString, Date since) throws Exception {
        this.value = value;
        DateFormatter df = new DateFormatter();
        this.udunitString = timeUnitString + " since " + df.toDateTimeStringISO(since);
        this.uu = SimpleUnit.makeUnit(this.udunitString);
        this.timeUnit = new TimeUnit(timeUnitString);
    }

    public Date getDateOrigin() {
        if (!(this.uu instanceof TimeScaleUnit)) {
            return null;
        }
        TimeScaleUnit tu = (TimeScaleUnit)this.uu;
        return tu.getOrigin();
    }

    public String getTimeUnitString() {
        return this.timeUnit.getUnitString();
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Date getDate() {
        double secs = this.timeUnit.getValueInSeconds(this.value);
        return new Date(this.getDateOrigin().getTime() + (long)(1000.0 * secs));
    }

    public CalendarDate makeCalendarDate(double val) {
        return CalendarDate.of(this.makeDate(val));
    }

    public Date makeDate(double val) {
        if (Double.isNaN(val)) {
            return null;
        }
        double secs = this.timeUnit.getValueInSeconds(val);
        return new Date(this.getDateOrigin().getTime() + (long)(1000.0 * secs));
    }

    public double makeValue(Date date) {
        double secs = date.getTime() / 1000L;
        double origin_secs = this.getDateOrigin().getTime() / 1000L;
        double diff = secs - origin_secs;
        try {
            this.timeUnit.setValueInSeconds(diff);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.timeUnit.getValue();
    }

    public String makeStandardDateString(double value) {
        Date date = this.makeDate(value);
        if (date == null) {
            return null;
        }
        DateFormatter formatter = new DateFormatter();
        return formatter.toDateTimeStringISO(date);
    }

    public String toString() {
        return this.value + " " + this.udunitString;
    }

    public String getUnitsString() {
        return this.udunitString;
    }

    public static void main(String[] args) throws Exception {
        UnitFormat udunit = UnitFormatManager.instance();
        String text2 = "days since 2009-06-14 04:00:00 +00:00";
        Unit uu2 = udunit.parse(text2);
        System.out.printf("%s == %s %n", text2, uu2);
        String text = "days since 2009-06-14 04:00:00";
        Unit uu = udunit.parse(text);
        System.out.printf("%s == %s %n", text, uu);
        Unit ref = udunit.parse("ms since 1970-01-01");
        Converter converter = uu.getConverterTo(ref);
        DateFormatter formatter = new DateFormatter();
        double val = converter.convert(1.0);
        Date d = new Date((long)val);
        System.out.printf(" val=%f date=%s (%s)%n", 1.0, d, formatter.toDateTimeStringISO(d));
        double val2 = converter.convert(2.0);
        Date d2 = new Date((long)val2);
        System.out.printf(" val=%f date=%s (%s)%n", 2.0, d, formatter.toDateTimeStringISO(d2));
    }
}

