/*
 * Decompiled with CFR 0.152.
 */
package opendap.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class iniFile {
    private boolean Debug = false;
    private String iniFile;
    private Vector sectionNames;
    private Vector sectionProperties;
    private int currentSection;
    private String errMsg;

    protected iniFile() {
    }

    public iniFile(String fname) {
        this(null, fname, false);
    }

    public iniFile(String path, String fname) {
        this(path, fname, false);
    }

    public iniFile(String path, String fname, boolean dbg) {
        this.Debug = dbg;
        if (path == null) {
            path = System.getProperty("user.home");
        }
        String fileSeperator = System.getProperty("file.separator");
        this.iniFile = path + fileSeperator + fname;
        this.errMsg = "The file: \"" + this.iniFile + "\" did not contain recognizable init information.";
        this.currentSection = -1;
        this.sectionNames = null;
        this.sectionProperties = null;
        this.parseFile();
        if (this.sectionNames == null) {
            System.err.println(this.errMsg);
        }
    }

    public String getFileName() {
        return this.iniFile;
    }

    private void parseFile() {
        try (BufferedReader fp = new BufferedReader(new InputStreamReader(new FileInputStream(this.iniFile)));){
            boolean done = false;
            while (!done) {
                String thisLine = fp.readLine().trim();
                if (thisLine != null) {
                    int eqidx;
                    if (this.Debug) {
                        System.out.println("Read: \"" + thisLine + "\"");
                    }
                    if (thisLine.startsWith(";") || thisLine.equalsIgnoreCase("")) {
                        if (!this.Debug) continue;
                        System.out.println("Ignoring comment or blank line...");
                        continue;
                    }
                    int cindx = thisLine.indexOf(";");
                    if (cindx > 0) {
                        thisLine = thisLine.substring(0, cindx).trim();
                    }
                    if (this.Debug) {
                        System.out.println("Comments removed: \"" + thisLine + "\"");
                    }
                    if (thisLine.startsWith("[") && thisLine.endsWith("]")) {
                        String sname = thisLine.substring(1, thisLine.length() - 1).trim();
                        if (this.Debug) {
                            System.out.println("Found Section Name: " + sname);
                        }
                        if (this.sectionNames == null) {
                            this.sectionNames = new Vector();
                        }
                        this.sectionNames.add(sname);
                        if (this.sectionProperties == null) {
                            this.sectionProperties = new Vector();
                        }
                        this.sectionProperties.add(new Vector());
                        continue;
                    }
                    if (this.sectionNames == null || this.sectionProperties == null || (eqidx = thisLine.indexOf("=")) == -1) continue;
                    String[] pair = new String[]{thisLine.substring(0, eqidx).trim(), thisLine.substring(eqidx + 1, thisLine.length()).trim()};
                    if (this.Debug) {
                        System.out.println("pair[0]: \"" + pair[0] + "\"   pair[1]: \"" + pair[1] + "\"");
                    }
                    ((Vector)this.sectionProperties.lastElement()).add(pair);
                    continue;
                }
                done = true;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could Not Find ini File: \"" + this.iniFile + "\"");
        }
        catch (IOException e) {
            System.err.println("Could Not Read ini File: \"" + this.iniFile + "\"");
        }
    }

    public Enumeration getPropList(String sectionName) {
        if (this.sectionNames == null) {
            System.err.println(this.errMsg);
            return null;
        }
        int sectionIndex = 0;
        Enumeration e = this.sectionNames.elements();
        boolean done = false;
        while (!done && e.hasMoreElements()) {
            String thisName = (String)e.nextElement();
            if (sectionName.equalsIgnoreCase(thisName)) {
                done = true;
                continue;
            }
            ++sectionIndex;
        }
        if (!done) {
            return null;
        }
        return ((Vector)this.sectionProperties.elementAt(sectionIndex)).elements();
    }

    public String getProperty(String propertyName) {
        if (this.currentSection < 0) {
            String msg = "You must use the setSection() method before you can use getProperty().";
            System.err.println(msg);
            return msg;
        }
        String[] pair = null;
        Enumeration e = ((Vector)this.sectionProperties.elementAt(this.currentSection)).elements();
        boolean done = false;
        while (!done && e.hasMoreElements()) {
            pair = (String[])e.nextElement();
            if (!pair[0].equalsIgnoreCase(propertyName)) continue;
            done = true;
        }
        if (done) {
            return pair[1];
        }
        return null;
    }

    public Enumeration getSectionList() {
        if (this.sectionNames == null) {
            return null;
        }
        return this.sectionNames.elements();
    }

    public void printProps(PrintStream ps) {
        Enumeration se = this.getSectionList();
        if (se == null) {
            ps.println(this.errMsg);
        } else {
            while (se.hasMoreElements()) {
                String sname = (String)se.nextElement();
                this.setSection(sname);
                ps.println("[" + sname + "]");
                Enumeration pe = this.getPropList(sname);
                while (pe.hasMoreElements()) {
                    String[] pair = (String[])pe.nextElement();
                    String prop = pair[0];
                    String valu = this.getProperty(prop);
                    ps.println("    \"" + prop + "\" = \"" + valu + "\"");
                }
            }
        }
    }

    public boolean setSection(String sectionName) {
        if (this.sectionNames == null) {
            System.err.println(this.errMsg);
            return false;
        }
        int sectionIndex = 0;
        Enumeration e = this.sectionNames.elements();
        boolean done = false;
        while (!done && e.hasMoreElements()) {
            String thisName = (String)e.nextElement();
            if (sectionName.equalsIgnoreCase(thisName)) {
                done = true;
                continue;
            }
            ++sectionIndex;
        }
        if (!done) {
            return false;
        }
        this.currentSection = sectionIndex;
        return true;
    }

    public static void main(String[] args) {
        boolean dbgFlag = true;
        iniFile inf = null;
        switch (args.length) {
            case 1: {
                inf = new iniFile(null, args[0], dbgFlag);
                break;
            }
            case 2: {
                inf = new iniFile(args[0], args[1], dbgFlag);
                break;
            }
            case 3: {
                if (args[2].equalsIgnoreCase("false")) {
                    dbgFlag = false;
                }
                inf = new iniFile(args[0], args[1], dbgFlag);
                break;
            }
            default: {
                System.err.println("Usage: test_iniFile [path] filename.ini [false]");
                System.exit(1);
            }
        }
        inf.printProps(System.out);
    }
}

