/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.DirectoryPartition;
import thredds.inventory.partition.IndexReader;
import ucar.nc2.util.Indent;

public class DirectoryBuilder {
    private static final boolean debug = false;
    private final String topCollectionName;
    private final String partitionName;
    private final Path dir;
    private final FileTime dirLastModified;
    private Path index;
    private FileTime indexLastModified;
    private long indexSize;
    private boolean childrenConstructed = false;
    private List<DirectoryBuilder> children = new ArrayList<DirectoryBuilder>(25);
    private PartitionStatus partitionStatus = PartitionStatus.unknown;

    public static MCollection factory(FeatureCollectionConfig config, Path topDir, IndexReader indexReader, Logger logger) throws IOException {
        DirectoryBuilder builder = new DirectoryBuilder(config.name, topDir.toString());
        DirectoryPartition dpart = new DirectoryPartition(config, topDir, indexReader, logger);
        if (!builder.isLeaf(indexReader)) {
            dpart.setLeaf(false);
            return dpart;
        }
        boolean hasIndex = builder.findIndex();
        if (hasIndex) {
            return dpart.makeChildCollection(builder);
        }
        DirectoryCollection result = new DirectoryCollection(config.name, topDir, logger);
        result.setLeaf(true);
        return result;
    }

    public DirectoryBuilder(String topCollectionName, String dirFilename) throws IOException {
        this(topCollectionName, Paths.get(dirFilename, new String[0]), null);
    }

    public DirectoryBuilder(String topCollectionName, Path dir, BasicFileAttributes attr) throws IOException {
        this.topCollectionName = topCollectionName;
        this.dir = dir;
        this.partitionName = DirectoryCollection.makeCollectionName(topCollectionName, dir);
        if (attr == null) {
            attr = Files.readAttributes(this.dir, BasicFileAttributes.class, new LinkOption[0]);
        }
        if (!attr.isDirectory()) {
            throw new IllegalArgumentException("DirectoryPartitionBuilder needs a directory");
        }
        this.dirLastModified = attr.lastModifiedTime();
        this.findIndex();
    }

    public boolean findIndex() throws IOException {
        Path indexPath = Paths.get(this.dir.toString(), this.partitionName + ".ncx2");
        if (Files.exists(indexPath, new LinkOption[0])) {
            this.index = indexPath;
            BasicFileAttributes attr = Files.readAttributes(indexPath, BasicFileAttributes.class, new LinkOption[0]);
            this.indexLastModified = attr.lastModifiedTime();
            this.indexSize = attr.size();
            return true;
        }
        return false;
    }

    public boolean isLeaf(IndexReader indexReader) throws IOException {
        if (this.partitionStatus == PartitionStatus.unknown) {
            DirectoryCollection dc = new DirectoryCollection(this.partitionName, this.dir, null);
            this.partitionStatus = dc.isLeafDirectory() ? PartitionStatus.isLeaf : PartitionStatus.isDirectoryPartition;
        }
        return this.partitionStatus == PartitionStatus.isLeaf;
    }

    public List<DirectoryBuilder> constructChildren(IndexReader indexReader, CollectionUpdateType forceCollection) throws IOException {
        if (this.childrenConstructed) {
            return this.children;
        }
        if (this.index != null && forceCollection == CollectionUpdateType.nocheck) {
            this.childrenConstructed = true;
            if (!indexReader.readChildren(this.index, new AddChild())) {
                this.partitionStatus = PartitionStatus.isLeaf;
                return this.children;
            }
        } else {
            this.scanForChildren();
        }
        this.partitionStatus = this.children.size() > 0 ? PartitionStatus.isDirectoryPartition : PartitionStatus.isLeaf;
        return this.children;
    }

    private DirectoryBuilder(String topCollectionName, Path indexFile, long indexLastModified) throws IOException {
        this.topCollectionName = topCollectionName;
        if (Files.exists(indexFile, new LinkOption[0])) {
            this.index = indexFile;
            this.indexLastModified = FileTime.fromMillis(indexLastModified);
        }
        this.dir = indexFile.getParent();
        this.partitionName = DirectoryCollection.makeCollectionName(topCollectionName, this.dir);
        BasicFileAttributes attr = Files.readAttributes(this.dir, BasicFileAttributes.class, new LinkOption[0]);
        if (!attr.isDirectory()) {
            throw new IllegalArgumentException("DirectoryPartition needs a directory");
        }
        this.dirLastModified = attr.lastModifiedTime();
    }

    private void scanForChildren() {
        int count = 0;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.dir);){
            for (Path p : ds) {
                BasicFileAttributes attr = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                if (attr.isDirectory()) {
                    this.children.add(new DirectoryBuilder(this.topCollectionName, p, attr));
                }
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.childrenConstructed = true;
    }

    public List<MFile> readFilesFromIndex(IndexReader indexReader) throws IOException {
        ArrayList<MFile> result = new ArrayList<MFile>(100);
        if (this.index == null) {
            return result;
        }
        indexReader.readMFiles(this.index, result);
        return result;
    }

    public Path getDir() {
        return this.dir;
    }

    public Path getIndex() {
        return this.index;
    }

    public List<DirectoryBuilder> getChildren() {
        return this.children;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void show(Formatter out) {
        out.format("Collection %s%n", this.partitionName);
        this.toString(out, new Indent(2));
        out.format("%n%n", new Object[0]);
    }

    private void toString(Formatter out, Indent indent) {
        out.format("%sDir '%s' (%s) index '%s' (%s)%n", indent, this.dir, this.dirLastModified, this.index, this.indexLastModified);
        indent.incr();
        for (DirectoryBuilder c : this.children) {
            c.toString(out, indent);
        }
        indent.decr();
    }

    private class AddChild
    implements IndexReader.AddChildCallback {
        private AddChild() {
        }

        @Override
        public void addChild(String dirName, String indexFilename, long lastModified) throws IOException {
            Path indexPath = Paths.get(indexFilename, new String[0]);
            DirectoryBuilder child = new DirectoryBuilder(DirectoryBuilder.this.topCollectionName, indexPath, lastModified);
            DirectoryBuilder.this.children.add(child);
        }
    }

    private static enum PartitionStatus {
        unknown,
        isDirectoryPartition,
        isLeaf;

    }
}

