/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.slf4j.Logger;
import thredds.inventory.CollectionSingleFile;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.PartitionManager;
import ucar.nc2.util.CloseableIterator;

public class FilePartition
extends DirectoryCollection
implements PartitionManager {
    public FilePartition(String topCollectionName, Path topDir, Logger logger) {
        super(topCollectionName, topDir, logger);
        this.collectionName = DirectoryCollection.makeCollectionName(this.topCollection, topDir);
    }

    @Override
    public Iterable<MCollection> makePartitions(CollectionUpdateType forceCollection) throws IOException {
        ArrayList<MCollection> result = new ArrayList<MCollection>(100);
        try (CloseableIterator<MFile> iter = this.getFileIterator();){
            while (iter.hasNext()) {
                CollectionSingleFile part = new CollectionSingleFile((MFile)iter.next(), this.logger);
                result.add(part);
                this.lastModified = Math.max(this.lastModified, part.getLastModified());
            }
        }
        return result;
    }
}

