/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;

public interface RadialDatasetSweep
extends TypedDataset,
FeatureDataset {
    public static final String LevelII = "Level II";
    public static final String UF = "Universal Format";

    public String getRadarID();

    public String getRadarName();

    public String getDataFormat();

    public Type getCommonType();

    public EarthLocation getCommonOrigin();

    public DateUnit getTimeUnits();

    public boolean isStationary();

    public void clearDatasetMemory();

    public boolean isVolume();

    @Override
    public List<VariableSimpleIF> getDataVariables();

    public static final class Type {
        private static List<Type> members = new ArrayList<Type>(20);
        public static final Type NONE = new Type("");
        private String name;

        private Type(String s) {
            this.name = s;
            members.add(this);
        }

        public static Collection getAllTypes() {
            return members;
        }

        public static Type getType(String name) {
            if (name == null) {
                return null;
            }
            for (Type m : members) {
                if (!m.name.equalsIgnoreCase(name)) continue;
                return m;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Sweep {
        public Type getType();

        public Variable getsweepVar();

        public int getRadialNumber();

        public int getGateNumber();

        public float getBeamWidth();

        public float getNyquistFrequency();

        public float getRangeToFirstGate();

        public float getGateSize();

        public float[] readData() throws IOException;

        public float[] readData(int var1) throws IOException;

        public float getElevation(int var1) throws IOException;

        public float[] getElevation() throws IOException;

        public float getMeanElevation();

        public float getAzimuth(int var1) throws IOException;

        public float[] getAzimuth() throws IOException;

        public float getMeanAzimuth();

        public EarthLocation getOrigin(int var1);

        public float getTime(int var1) throws IOException;

        public Date getStartingTime();

        public Date getEndingTime();

        public int getSweepIndex();

        public void clearSweepMemory();
    }

    public static interface RadialVariable
    extends VariableSimpleIF {
        public int getNumSweeps();

        public Sweep getSweep(int var1);

        public float[] readAllData() throws IOException;

        public void clearVariableMemory();
    }
}

