/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import thredds.inventory.TimedCollection;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.CompositeStationCollectionFlattened;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class CompositeStationCollection
extends StationTimeSeriesCollectionImpl
implements UpdateableCollection {
    private TimedCollection dataCollection;
    protected List<VariableSimpleIF> dataVariables;
    protected List<Attribute> globalAttributes;

    protected CompositeStationCollection(String name, DateUnit timeUnit, String altUnits, TimedCollection dataCollection) throws IOException {
        super(name, timeUnit, altUnits);
        this.dataCollection = dataCollection;
        TimedCollection.Dataset td = dataCollection.getPrototype();
        if (td == null) {
            throw new RuntimeException("No datasets in the collection");
        }
    }

    @Override
    protected StationHelper createStationHelper() throws IOException {
        TimedCollection.Dataset td = this.dataCollection.getPrototype();
        if (td == null) {
            throw new RuntimeException("No datasets in the collection");
        }
        Formatter errlog = new Formatter();
        try (FeatureDatasetPoint openDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);){
            StationHelper stationHelper = new StationHelper();
            List<FeatureCollection> fcList = openDataset.getPointFeatureCollectionList();
            StationTimeSeriesCollectionImpl openCollection = (StationTimeSeriesCollectionImpl)fcList.get(0);
            List<Station> stns = openCollection.getStations();
            for (Station s : stns) {
                StationTimeSeriesFeature stnFeature = openCollection.getStationFeature(s);
                stationHelper.addStation(new CompositeStationFeature(s, this.timeUnit, this.altUnits, stnFeature.getFeatureData(), this.dataCollection));
            }
            this.dataVariables = openDataset.getDataVariables();
            this.globalAttributes = openDataset.getGlobalAttributes();
            StationHelper stationHelper2 = stationHelper;
            return stationHelper2;
        }
    }

    public List<VariableSimpleIF> getDataVariables() {
        this.getStationHelper();
        return this.dataVariables;
    }

    public List<Attribute> getGlobalAttributes() {
        this.getStationHelper();
        return this.globalAttributes;
    }

    @Override
    public void update() throws IOException {
        this.dataCollection.update();
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        List<StationFeature> subset = this.getStationHelper().getStationFeatures(stations);
        return new CompositeStationCollectionSubset(this, subset);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        if (boundingBox == null) {
            return this;
        }
        List<StationFeature> subset = this.getStationHelper().getStationFeatures(boundingBox);
        return new CompositeStationCollectionSubset(this, subset);
    }

    @Override
    public StationTimeSeriesFeature getStationFeature(Station s) throws IOException {
        StationFeature stnFeature = this.getStationHelper().getStationFeature(s);
        return new CompositeStationFeature(stnFeature, this.timeUnit, this.altUnits, stnFeature.getFeatureData(), this.dataCollection);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        TimedCollection subsetCollection = dateRange != null ? this.dataCollection.subset(dateRange) : this.dataCollection;
        return new CompositeStationCollectionFlattened(this.getName(), this.getTimeUnit(), this.getAltUnits(), boundingBox, dateRange, subsetCollection);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stations, CalendarDateRange dateRange, List<VariableSimpleIF> varList) throws IOException {
        TimedCollection subsetCollection = dateRange != null ? this.dataCollection.subset(dateRange) : this.dataCollection;
        return new CompositeStationCollectionFlattened(this.getName(), this.getTimeUnit(), this.getAltUnits(), stations, dateRange, varList, subsetCollection);
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new PointFeatureCollectionIterator(){
            Iterator<Station> stationIter;
            {
                this.stationIter = CompositeStationCollection.this.getStationHelper().getStations().iterator();
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.stationIter.hasNext();
            }

            @Override
            public PointFeatureCollection next() throws IOException {
                return (PointFeatureCollection)((Object)this.stationIter.next());
            }

            @Override
            public void setBufferSize(int bytes) {
            }

            @Override
            public void finish() {
            }
        };
    }

    private class CompositeStationFeature
    extends StationTimeSeriesFeatureImpl {
        private TimedCollection collForFeature;
        private StructureData sdata;

        CompositeStationFeature(Station s, DateUnit timeUnit, String altUnits, StructureData sdata, TimedCollection collForFeature) {
            super(s, timeUnit, altUnits, -1);
            this.setCalendarDateRange(collForFeature.getDateRange());
            this.sdata = sdata;
            this.collForFeature = collForFeature;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            CompositeStationFeatureIterator iter = new CompositeStationFeatureIterator();
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }

        @Override
        public StationTimeSeriesFeature subset(CalendarDateRange dateRange) throws IOException {
            if (dateRange == null) {
                return this;
            }
            return new CompositeStationFeature(this.s, this.getTimeUnit(), this.getAltUnits(), this.sdata, this.collForFeature.subset(dateRange));
        }

        @Override
        public StructureData getFeatureData() throws IOException {
            return this.sdata;
        }

        @Override
        public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
            if (boundingBox != null) {
                if (!boundingBox.contains(this.s.getLatLon())) {
                    return null;
                }
                if (dateRange == null) {
                    return this;
                }
            }
            return this.subset(dateRange);
        }

        private class CompositeStationFeatureIterator
        extends PointIteratorAbstract {
            private int bufferSize = -1;
            private Iterator<TimedCollection.Dataset> iter;
            private FeatureDatasetPoint currentDataset;
            private PointFeatureIterator pfIter = null;
            private boolean finished = false;

            CompositeStationFeatureIterator() {
                this.iter = CompositeStationFeature.this.collForFeature.getDatasets().iterator();
            }

            private PointFeatureIterator getNextIterator() throws IOException {
                if (!this.iter.hasNext()) {
                    return null;
                }
                TimedCollection.Dataset td = this.iter.next();
                Formatter errlog = new Formatter();
                this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);
                List<FeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
                StationTimeSeriesFeatureCollection stnCollection = (StationTimeSeriesFeatureCollection)fcList.get(0);
                Station s = stnCollection.getStation(CompositeStationFeature.this.getName());
                if (s == null) {
                    System.out.printf("CompositeStationFeatureIterator dataset: %s missing station %s%n", td.getLocation(), CompositeStationFeature.this.getName());
                    return this.getNextIterator();
                }
                StationTimeSeriesFeature stnFeature = stnCollection.getStationFeature(s);
                if (CompositeDatasetFactory.debug) {
                    System.out.printf("CompositeStationFeatureIterator open dataset: %s for %s%n", td.getLocation(), s.getName());
                }
                return stnFeature.getPointFeatureIterator(this.bufferSize);
            }

            @Override
            public boolean hasNext() throws IOException {
                if (this.pfIter == null) {
                    this.pfIter = this.getNextIterator();
                    if (this.pfIter == null) {
                        this.finish();
                        return false;
                    }
                }
                if (!this.pfIter.hasNext()) {
                    this.pfIter.finish();
                    this.currentDataset.close();
                    if (CompositeDatasetFactory.debug) {
                        System.out.printf("CompositeStationFeatureIterator close dataset: %s%n", this.currentDataset.getLocation());
                    }
                    this.pfIter = this.getNextIterator();
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public PointFeature next() throws IOException {
                CompositeStationFeature.this.npts++;
                return this.pfIter.next();
            }

            @Override
            public void finish() {
                if (this.finished) {
                    return;
                }
                if (this.pfIter != null) {
                    this.pfIter.finish();
                }
                if (this.currentDataset != null) {
                    try {
                        this.currentDataset.close();
                        if (CompositeDatasetFactory.debug) {
                            System.out.printf("CompositeStationFeatureIterator close dataset: %s%n", this.currentDataset.getLocation());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.finishCalcBounds();
                this.finished = true;
            }

            @Override
            public void setBufferSize(int bytes) {
                this.bufferSize = bytes;
            }
        }
    }

    private static class CompositeStationCollectionSubset
    extends CompositeStationCollection {
        private final CompositeStationCollection from;
        private final List<StationFeature> stationFeats;

        private CompositeStationCollectionSubset(CompositeStationCollection from, List<StationFeature> stationFeats) throws IOException {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits(), from.dataCollection);
            this.from = Preconditions.checkNotNull(from, "from == null");
            Preconditions.checkArgument(stationFeats != null && !stationFeats.isEmpty(), "stationFeats == null || stationFeats.isEmpty(): %s", stationFeats);
            this.stationFeats = stationFeats;
        }

        @Override
        protected StationHelper createStationHelper() throws IOException {
            StationHelper stationHelper = new StationHelper();
            for (StationFeature stationFeat : this.stationFeats) {
                stationHelper.addStation(new CompositeStationFeature(stationFeat, this.timeUnit, this.altUnits, stationFeat.getFeatureData(), this.from.dataCollection));
            }
            return stationHelper;
        }
    }
}

