/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.geotiff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ucar.nc2.geotiff.FieldType;
import ucar.nc2.geotiff.GeoKey;
import ucar.nc2.geotiff.Tag;

class IFDEntry
implements Comparable {
    protected Tag tag;
    protected FieldType type;
    protected int count;
    protected int[] value;
    protected double[] valueD;
    protected String valueS;
    protected List<GeoKey> geokeys = null;

    IFDEntry(Tag tag, FieldType type) {
        this.tag = tag;
        this.type = type;
        this.count = 1;
    }

    IFDEntry(Tag tag, FieldType type, int count) {
        this.tag = tag;
        this.type = type;
        this.count = count;
    }

    public IFDEntry setValue(int v) {
        this.value = new int[1];
        this.value[0] = v;
        return this;
    }

    public IFDEntry setValue(int n, int d) {
        this.value = new int[2];
        this.value[0] = n;
        this.value[1] = d;
        return this;
    }

    public IFDEntry setValue(int n, int d, int f) {
        this.value = new int[3];
        this.value[0] = n;
        this.value[1] = d;
        this.value[2] = f;
        return this;
    }

    public IFDEntry setValue(int[] v) {
        this.count = v.length;
        this.value = (int[])v.clone();
        return this;
    }

    public IFDEntry setValue(double v) {
        this.count = 1;
        this.valueD = new double[1];
        this.valueD[0] = v;
        return this;
    }

    public IFDEntry setValue(double[] v) {
        this.count = v.length;
        this.valueD = (double[])v.clone();
        return this;
    }

    public IFDEntry setValue(String v) {
        this.count = v.length();
        this.valueS = v;
        return this;
    }

    public void addGeoKey(GeoKey geokey) {
        if (this.geokeys == null) {
            this.geokeys = new ArrayList<GeoKey>();
        }
        this.geokeys.add(geokey);
    }

    public int compareTo(Object o) {
        return this.tag.compareTo(((IFDEntry)o).tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IFDEntry{");
        sb.append("tag=").append(this.tag);
        sb.append(", type=").append(this.type);
        sb.append(", count=").append(this.count);
        if (this.type == FieldType.DOUBLE || this.type == FieldType.FLOAT) {
            sb.append(", valueD=").append(Arrays.toString(this.valueD));
        } else if (this.type == FieldType.ASCII) {
            sb.append(", valueS='").append(this.valueS).append('\'');
        } else if (this.type == FieldType.RATIONAL) {
            for (int i = 0; i < 2; i += 2) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.value[i]).append("/").append(this.value[i + 1]);
            }
        } else {
            sb.append(", value=").append(Arrays.toString(this.value));
        }
        sb.append(", geokeys=").append(this.geokeys);
        sb.append('}');
        return sb.toString();
    }
}

