/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateND;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateSharer;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.coord.Counter;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.Grib2CollectionWriter;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.CloseableIterator;

public class Grib2CollectionBuilder
extends GribCollectionBuilder {
    private final boolean intvMerge;
    private final boolean useGenType;
    private FeatureCollectionConfig.GribConfig gribConfig;
    private Grib2Customizer cust;

    public Grib2CollectionBuilder(String name, MCollection dcm, Logger logger) {
        super(false, name, dcm, logger);
        FeatureCollectionConfig config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
        this.gribConfig = config.gribConfig;
        Map<String, Boolean> pdsConfig = this.gribConfig.pdsHash;
        this.intvMerge = this.assignValue(pdsConfig, "intvMerge", true);
        this.useGenType = this.assignValue(pdsConfig, "useGenType", false);
    }

    private boolean assignValue(Map<String, Boolean> pdsHash, String key, boolean value) {
        Boolean b;
        if (pdsHash != null && (b = pdsHash.get(key)) != null) {
            value = b;
        }
        return value;
    }

    public List<Grib2CollectionWriter.Group> makeGroups(List<MFile> allFiles, Formatter errlog) throws IOException {
        HashMap<GribCollectionBuilder.GroupAndRuntime, Grib2CollectionWriter.Group> gdsMap = new HashMap<GribCollectionBuilder.GroupAndRuntime, Grib2CollectionWriter.Group>();
        this.logger.debug("Grib2CollectionBuilder {}: makeGroups", (Object)this.name);
        int fileno = 0;
        Counter statsAll = new Counter();
        this.logger.debug(" dcm={}", (Object)this.dcm);
        FeatureCollectionConfig config = (FeatureCollectionConfig)this.dcm.getAuxInfo("fcConfig");
        Map<String, Boolean> pdsConvert = config.gribConfig.pdsHash;
        FeatureCollectionConfig.GribIntvFilter intvMap = config.gribConfig.intvFilter;
        int totalRecords = 0;
        try (CloseableIterator<MFile> iter = this.dcm.getFileIterator();){
            while (iter.hasNext()) {
                Grib2Index index;
                MFile mfile = (MFile)iter.next();
                try {
                    index = (Grib2Index)GribIndex.readOrCreateIndexFromSingleFile(false, false, mfile, config.gribConfig, CollectionUpdateType.test, this.logger);
                    allFiles.add(mfile);
                }
                catch (IOException ioe) {
                    this.logger.error("Grib2CollectionBuilder " + this.name + " : reading/Creating gbx9 index for file " + mfile.getPath() + " failed", ioe);
                    continue;
                }
                int n = index.getNRecords();
                totalRecords += n;
                for (Grib2Record gr : index.getRecords()) {
                    if (this.cust == null) {
                        this.cust = Grib2Customizer.factory(gr);
                        this.cust.setTimeUnitConverter(config.gribConfig.getTimeUnitConverter());
                    }
                    if (this.filterOut(gr, intvMap)) {
                        ++statsAll.filter;
                        continue;
                    }
                    gr.setFile(fileno);
                    int gdsHash = gr.getGDSsection().getGDS().hashCode();
                    if (0 == (gdsHash = this.gribConfig.convertGdsHash(gdsHash))) continue;
                    CalendarDate runtime = gr.getReferenceDate();
                    GribCollectionBuilder.GroupAndRuntime gar = new GribCollectionBuilder.GroupAndRuntime(this, gdsHash, runtime.getMillis());
                    Grib2CollectionWriter.Group g = (Grib2CollectionWriter.Group)gdsMap.get(gar);
                    if (g == null) {
                        g = new Grib2CollectionWriter.Group(gr.getGDSsection(), gdsHash, runtime);
                        gdsMap.put(gar, g);
                    }
                    g.records.add(gr);
                }
                ++fileno;
                statsAll.recordsTotal += index.getRecords().size();
            }
        }
        if (totalRecords == 0) {
            this.logger.warn("No records found in files. Check Grib1/Grib2 for collection {}. If wrong, delete gbx9.", (Object)this.name);
            throw new IllegalStateException("No records found in dataset " + this.name);
        }
        ArrayList<Grib2CollectionWriter.Group> groups = new ArrayList<Grib2CollectionWriter.Group>(gdsMap.values());
        for (Grib2CollectionWriter.Group g : groups) {
            Counter stats = new Counter();
            Grib2Rectilyser rect = new Grib2Rectilyser(g.records, g.gdsHash, pdsConvert);
            rect.make(config.gribConfig, stats, errlog);
            g.gribVars = rect.gribvars;
            g.coords = rect.coords;
            statsAll.add(stats);
            if (config.gribConfig.gdsNamer == null) continue;
            g.nameOverride = config.gribConfig.gdsNamer.get(g.gdsHash);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(statsAll.show());
        }
        return groups;
    }

    private boolean filterOut(Grib2Record gr, FeatureCollectionConfig.GribIntvFilter intvFilter) {
        int timeUnit = gr.getPDS().getTimeUnit();
        if (Grib2Utils.getCalendarPeriod(timeUnit) == null) {
            this.logger.info("Skip record with unknown time Unit= {}", (Object)timeUnit);
            return true;
        }
        if (intvFilter == null) {
            return false;
        }
        int[] intv = this.cust.getForecastTimeIntervalOffset(gr);
        if (intv == null) {
            return false;
        }
        int haveLength = intv[1] - intv[0];
        if (haveLength == 0 && intvFilter.isZeroExcluded()) {
            return intv[0] == 0 && intv[1] == 0;
        }
        if (intvFilter.hasFilter()) {
            int discipline = gr.getIs().getDiscipline();
            Grib2Pds pds = gr.getPDS();
            int category = pds.getParameterCategory();
            int number = pds.getParameterNumber();
            int id = (discipline << 16) + (category << 8) + number;
            int prob = Integer.MIN_VALUE;
            if (pds.isProbability()) {
                Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds);
                prob = (int)(1000.0 * pdsProb.getProbabilityUpperLimit());
            }
            return !intvFilter.filterOk(id, haveLength, prob);
        }
        return false;
    }

    @Override
    protected boolean writeIndex(String name, String indexFilepath, CoordinateRuntime masterRuntime, List<? extends GribCollectionBuilder.Group> groups, List<MFile> files) throws IOException {
        Grib2CollectionWriter writer = new Grib2CollectionWriter(this.dcm, this.logger);
        ArrayList<Grib2CollectionWriter.Group> groups2 = new ArrayList<Grib2CollectionWriter.Group>();
        for (GribCollectionBuilder.Group group : groups) {
            groups2.add((Grib2CollectionWriter.Group)group);
        }
        File indexFileInCache = GribCollection.getFileInCache(indexFilepath);
        return writer.writeIndex(name, indexFileInCache, masterRuntime, groups2, files);
    }

    private int cdmVariableHash(Grib2Record gr, int gdsHash) {
        return Grib2CollectionBuilder.cdmVariableHash(this.cust, gr, gdsHash, this.intvMerge, this.useGenType, this.logger);
    }

    public static int cdmVariableHash(Grib2Customizer cust, Grib2Record gr, int gdsHash, boolean intvMerge, boolean useGenType, Logger logger) {
        int addHash;
        int genType;
        Grib2SectionGridDefinition gdss = gr.getGDSsection();
        Grib2Pds pds2 = gr.getPDS();
        int result = 17;
        result = gdsHash == 0 ? (result += result * 37 + gdss.getGDS().hashCode()) : (result += result * 37 + gdsHash);
        result += result * 37 + gr.getDiscipline();
        result += result * 37 + pds2.getLevelType1();
        if (Grib2Utils.isLayer(pds2)) {
            result += result * 37 + 1;
        }
        result += result * 37 + pds2.getParameterCategory();
        result += result * 37 + pds2.getTemplateNumber();
        if (pds2.isTimeInterval()) {
            if (!intvMerge) {
                double size;
                block14: {
                    size = 0.0;
                    try {
                        size = cust.getForecastTimeIntervalSizeInHours(pds2);
                    }
                    catch (Throwable t) {
                        if (logger == null) break block14;
                        logger.error("Failed on file = " + gr.getFile(), t);
                    }
                }
                result += result * (int)(37.0 + 1000.0 * size);
            }
            result += result * 37 + pds2.getStatisticalProcessType();
        }
        if (pds2.isSpatialInterval()) {
            result += result * 37 + pds2.getStatisticalProcessType();
        }
        result += result * 37 + pds2.getParameterNumber();
        int ensDerivedType = -1;
        if (pds2.isEnsembleDerived()) {
            Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
            ensDerivedType = pdsDerived.getDerivedForecastType();
            result += result * 37 + ensDerivedType;
        } else if (pds2.isEnsemble()) {
            result += result * 37 + 1;
        }
        int probType = -1;
        if (pds2.isProbability()) {
            Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds2);
            probType = pdsProb.getProbabilityType();
            result += result * 37 + pdsProb.getProbabilityHashcode();
        }
        if (pds2.getParameterCategory() > 191 || pds2.getParameterNumber() > 191 || pds2.getLevelType1() > 191 || pds2.isTimeInterval() && pds2.getStatisticalProcessType() > 191 || ensDerivedType > 191 || probType > 191) {
            Grib2SectionIdentification id = gr.getId();
            result += result * 37 + id.getCenter_id();
            if (id.getSubcenter_id() > 0) {
                result += result * 37 + id.getSubcenter_id();
            }
        }
        if ((genType = pds2.getGenProcessType()) == 6 || genType == 7 || useGenType && genType > 0) {
            result += result * 37 + genType;
        }
        if ((addHash = cust.addVariableHash(gr)) != 0) {
            result += result * 37 + addHash;
        }
        return result;
    }

    private class Grib2Rectilyser {
        private final int gdsHash;
        private final List<Grib2Record> records;
        private List<VariableBag> gribvars;
        private List<Coordinate> coords;

        Grib2Rectilyser(List<Grib2Record> records, int gdsHash, Map<String, Boolean> pdsConfig) {
            this.records = records;
            this.gdsHash = gdsHash;
        }

        public void make(FeatureCollectionConfig.GribConfig config, Counter counter, Formatter info) throws IOException {
            boolean isDense = "dense".equals(config.getParameter("CoordSys"));
            CalendarPeriod userTimeUnit = config.getUserTimeUnit();
            HashMap<Integer, VariableBag> vbHash = new HashMap<Integer, VariableBag>(100);
            for (Grib2Record gr : this.records) {
                int cdmHash = Grib2CollectionBuilder.this.cdmVariableHash(gr, this.gdsHash);
                VariableBag bag = (VariableBag)vbHash.get(cdmHash);
                if (bag == null) {
                    bag = new VariableBag(gr, cdmHash);
                    vbHash.put(cdmHash, bag);
                }
                bag.atomList.add(gr);
            }
            this.gribvars = new ArrayList(vbHash.values());
            Collections.sort(this.gribvars);
            for (VariableBag vb : this.gribvars) {
                VertCoord.VertUnit vertUnit;
                Grib2Pds pdsFirst = vb.first.getPDS();
                int code = Grib2CollectionBuilder.this.cust.convertTimeUnit(pdsFirst.getTimeUnit());
                vb.timeUnit = userTimeUnit == null ? Grib2Utils.getCalendarPeriod(code) : userTimeUnit;
                vb.coordND = new CoordinateND();
                boolean isTimeInterval = vb.first.getPDS().isTimeInterval();
                if (isDense) {
                    vb.coordND.addBuilder(new CoordinateRuntime.Builder2(vb.timeUnit));
                    if (isTimeInterval) {
                        vb.coordND.addBuilder(new CoordinateTimeIntv.Builder2(Grib2CollectionBuilder.this.cust, code, vb.timeUnit, null));
                    } else {
                        vb.coordND.addBuilder(new CoordinateTime.Builder2(code, vb.timeUnit, null));
                    }
                } else {
                    vb.coordND.addBuilder(new CoordinateRuntime.Builder2(vb.timeUnit));
                    vb.coordND.addBuilder(new CoordinateTime2D.Builder2(isTimeInterval, Grib2CollectionBuilder.this.cust, vb.timeUnit, code));
                }
                if (vb.first.getPDS().isEnsemble()) {
                    vb.coordND.addBuilder(new CoordinateEns.Builder2(0));
                }
                if ((vertUnit = Grib2Utils.getLevelUnit(pdsFirst.getLevelType1())).isVerticalCoordinate()) {
                    vb.coordND.addBuilder(new CoordinateVert.Builder2(pdsFirst.getLevelType1()));
                }
                for (Grib2Record gr : vb.atomList) {
                    vb.coordND.addRecord(gr);
                }
                vb.coordND.finish(vb.atomList, info);
            }
            CoordinateSharer<Grib2Record> sharify = new CoordinateSharer<Grib2Record>(isDense);
            for (VariableBag vb : this.gribvars) {
                sharify.addCoords(vb.coordND.getCoordinates());
            }
            sharify.finish();
            this.coords = sharify.getUnionCoords();
            int tot_used = 0;
            int tot_dups = 0;
            int total = 0;
            for (VariableBag vb : this.gribvars) {
                vb.coordND = sharify.reindex(vb.coordND);
                vb.coordIndex = sharify.reindex2shared(vb.coordND.getCoordinates());
                tot_used += vb.coordND.getSparseArray().countNotMissing();
                tot_dups += vb.coordND.getSparseArray().getNduplicates();
                total += vb.coordND.getSparseArray().getTotalSize();
            }
            counter.recordsUnique += tot_used;
            counter.dups += tot_dups;
            counter.vars += this.gribvars.size();
            counter.recordsTotal += total;
        }

        public void showInfo(Formatter f, Grib2Customizer tables) {
            Counter all = new Counter();
            for (VariableBag vb : this.gribvars) {
                f.format("Variable %s (%d)%n", tables.getVariableName(vb.first), vb.cdmHash);
                vb.coordND.showInfo(f, all);
                f.format("%n", new Object[0]);
            }
            f.format("%n all= %s", all.show());
        }
    }

    class VariableBag
    implements Comparable<VariableBag> {
        public Grib2Record first;
        public int cdmHash;
        public List<Grib2Record> atomList = new ArrayList<Grib2Record>(100);
        public CoordinateND<Grib2Record> coordND;
        CalendarPeriod timeUnit;
        public List<Integer> coordIndex;
        long pos;
        int length;

        private VariableBag(Grib2Record first, int cdmHash) {
            this.first = first;
            this.cdmHash = cdmHash;
        }

        @Override
        public int compareTo(VariableBag o) {
            return Grib2Utils.getVariableName(this.first).compareTo(Grib2Utils.getVariableName(o.first));
        }
    }
}

