/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import ucar.unidata.util.StringUtil2;

public class NcepHtmlScraper {
    String dirOut = "C:/tmp/ncep/";
    private boolean debugParam = false;
    private boolean debug = false;
    private boolean show = false;

    void parseTopDoc() throws IOException {
        String source = "http://www.nco.ncep.noaa.gov/pmb/docs/grib2/grib2_doc.shtml";
        org.jsoup.nodes.Document doc = Jsoup.parse(new URL(source), 5000);
        Elements links = doc.select("a[href]");
        for (Element link : links) {
            Node sib = link.nextSibling();
            String title = null;
            if (sib != null) {
                String sibt = sib.toString();
                title = StringUtil2.remove(sibt, "-").trim();
            }
            if (link.text().equals("Table 4.2")) {
                this.parseTable42(link.attr("abs:href"), link.text(), title);
                continue;
            }
            if (!link.text().startsWith("Table 4")) continue;
            this.parseCodeTable(link.attr("abs:href"), link.text(), title);
        }
    }

    void parseCodeTable(String url, String tableName, String title) throws IOException {
        System.out.printf("parseCodeTable url=%s tableName=%s title=%s%n", url, tableName, title);
        org.jsoup.nodes.Document doc = Jsoup.parse(new URL(url), 5000);
        if (title == null) {
            title = "NCEP GRIB-2 Code Table";
        }
        Element table = doc.select("table").first();
        ArrayList<Code> stuff = new ArrayList<Code>();
        Elements rows = table.select("tr");
        for (Element row : rows) {
            Elements cols = row.select("td");
            if (this.debug) {
                System.out.printf(" #cols=%d: ", cols.size());
                for (Element col : cols) {
                    System.out.printf("%s:", col.text());
                }
                System.out.printf("%n", new Object[0]);
            }
            if (cols.size() < 2) continue;
            String snum = StringUtil2.cleanup(cols.get(0).text()).trim();
            String desc = StringUtil2.cleanup(cols.get(1).text()).trim();
            if (snum.contains("Reserved") || desc.contains("Reserved")) {
                if (!this.debug) continue;
                System.out.printf("*** Skip Reserved %s%n", row.text());
                continue;
            }
            try {
                int pnum = Integer.parseInt(snum);
                if (this.debug) {
                    System.out.printf("val %d == %s%n", pnum, desc);
                }
                stuff.add(new Code(pnum, desc));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        String filename = StringUtil2.removeWhitespace(tableName);
        this.writeCodeTableXml(filename, title, url, tableName, stuff);
    }

    private void writeCodeTableXml(String filename, String title, String source, String tableName, List<Code> stuff) throws IOException {
        org.jdom2.Element rootElem = new org.jdom2.Element("codeTable");
        Document doc = new Document(rootElem);
        rootElem.addContent(new org.jdom2.Element("table").setText(tableName));
        rootElem.addContent(new org.jdom2.Element("title").setText(title));
        rootElem.addContent(new org.jdom2.Element("source").setText(source));
        for (Code p : stuff) {
            org.jdom2.Element paramElem = new org.jdom2.Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.no));
            paramElem.addContent(new org.jdom2.Element("description").setText(p.desc));
            rootElem.addContent(paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        try (FileOutputStream fout = new FileOutputStream(this.dirOut + filename + ".xml");){
            fout.write(x.getBytes());
        }
        if (this.show) {
            System.out.printf("%s%n", x);
        }
    }

    void parseTable42(String url, String tableName, String title) throws IOException {
        System.out.printf("parseTable42 url=%s tableName=%s title=%s%n", url, tableName, title);
        org.jsoup.nodes.Document doc = Jsoup.parse(new URL(url), 5000);
        Elements links = doc.select("a[href]");
        for (Element link : links) {
            this.parseParamTable(link.attr("abs:href"), link.text());
        }
    }

    void parseParamTable(String url, String title) throws IOException {
        String match = "grib2_table4";
        if (!url.contains(match)) {
            return;
        }
        System.out.printf("parseParamTable url=%s title=%s%n", url, title);
        org.jsoup.nodes.Document doc = Jsoup.parse(new URL(url), 5000);
        if (title == null) {
            title = "NCEP GRIB-2 Param Table";
        }
        Element table = doc.select("table").first();
        ArrayList<Param> stuff = new ArrayList<Param>();
        Elements rows = table.select("tr");
        for (Element row : rows) {
            String units;
            String desc;
            String snum;
            Elements cols = row.select("td");
            if (this.debugParam) {
                System.out.printf(" #cols=%d: ", cols.size());
                for (Element col : cols) {
                    System.out.printf("%s:", col.text());
                }
                System.out.printf("%n", new Object[0]);
            }
            if (cols.size() == 4) {
                snum = StringUtil2.cleanup(cols.get(0).text()).trim();
                desc = StringUtil2.cleanup(cols.get(1).text()).trim();
                if (snum.contains("Reserved") || desc.contains("Reserved") || desc.contains("Missing")) {
                    if (!this.debugParam) continue;
                    System.out.printf("*** Skip Reserved %s%n", row.text());
                    continue;
                }
                try {
                    int pnum = Integer.parseInt(snum);
                    units = cols.get(2).text();
                    String abbrev = cols.get(3).text();
                    if (this.debugParam) {
                        System.out.printf("val %d == %s %s %s%n", pnum, desc, units, abbrev);
                    }
                    stuff.add(new Param(pnum, desc, units, abbrev));
                }
                catch (NumberFormatException e) {
                    System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
                }
                continue;
            }
            if (cols.size() != 3) continue;
            snum = StringUtil2.cleanup(cols.get(0).text()).trim();
            desc = StringUtil2.cleanup(cols.get(1).text()).trim();
            if (snum.contains("Reserved") || desc.contains("Reserved") || desc.contains("Missing")) {
                if (!this.debugParam) continue;
                System.out.printf("*** Skip Reserved %s%n", row.text());
                continue;
            }
            try {
                int pnum = Integer.parseInt(snum);
                units = cols.get(2).text();
                if (this.debugParam) {
                    System.out.printf("val %d == %s %s%n", pnum, desc, units);
                }
                stuff.add(new Param(pnum, desc, units, null));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        int pos = url.indexOf(match) + match.length();
        int lastPos = url.lastIndexOf(46);
        String filename = "Table4" + url.substring(pos, lastPos);
        filename = StringUtil2.removeWhitespace(filename);
        filename = StringUtil2.substitute(filename, "-", ".");
        this.writeParamTableXml(filename, title, url, filename, stuff);
    }

    private void writeParamTableXml(String filename, String title, String source, String tableName, List<Param> stuff) throws IOException {
        org.jdom2.Element rootElem = new org.jdom2.Element("parameterMap");
        Document doc = new Document(rootElem);
        rootElem.addContent(new org.jdom2.Element("table").setText(tableName));
        rootElem.addContent(new org.jdom2.Element("title").setText(title));
        rootElem.addContent(new org.jdom2.Element("source").setText(source));
        for (Param p : stuff) {
            org.jdom2.Element paramElem = new org.jdom2.Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.pnum));
            paramElem.addContent(new org.jdom2.Element("shortName").setText(p.name));
            paramElem.addContent(new org.jdom2.Element("description").setText(p.desc));
            paramElem.addContent(new org.jdom2.Element("units").setText(p.unit));
            rootElem.addContent(paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        try (FileOutputStream fout = new FileOutputStream(this.dirOut + filename + ".xml");){
            fout.write(x.getBytes());
        }
        if (this.show) {
            System.out.printf("%s%n", x);
        }
    }

    private void writeTable2Wgrib(String name, String source, String filename, List<Param> params) throws IOException {
        Formatter f = new Formatter();
        f.format("# %s%n", name);
        f.format("# %s%n", source);
        for (Param p : params) {
            f.format("%3d:%s:%s [%s]%n", p.pnum, p.name, p.desc, p.unit);
        }
        FileOutputStream fout = new FileOutputStream(this.dirOut + filename);
        fout.write(f.toString().getBytes());
        fout.close();
        if (this.show) {
            System.out.printf("%s%n", f);
        }
    }

    public static void main(String[] args) throws IOException {
        NcepHtmlScraper scraper = new NcepHtmlScraper();
        scraper.parseTopDoc();
    }

    private class Param {
        int pnum;
        String desc;
        String unit;
        String name;

        private Param(int pnum, String desc, String unit, String name) {
            this.pnum = pnum;
            this.desc = desc;
            this.unit = StringUtil2.cleanup(unit);
            this.name = StringUtil2.cleanup(name);
        }
    }

    private class Code {
        int no;
        String desc;

        private Code(int no, String desc) {
            this.no = no;
            this.desc = desc;
        }
    }
}

