/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.Gdc_To_Utm_Converter;
import ucar.unidata.geoloc.projection.Utm_To_Gdc_Converter;

public class UtmProjection
extends ProjectionImpl {
    public static final String GRID_MAPPING_NAME = "universal_transverse_mercator";
    public static final String UTM_ZONE1 = "utm_zone_number";
    public static final String UTM_ZONE2 = "UTM_zone";
    private final Utm_To_Gdc_Converter convert2latlon;
    private final Gdc_To_Utm_Converter convert2xy;
    private final SaveParams save;

    @Override
    public ProjectionImpl constructCopy() {
        UtmProjection result = this.save == null ? new UtmProjection(this.getZone(), this.isNorth()) : new UtmProjection(this.save.a, this.save.f, this.getZone(), this.isNorth());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    public UtmProjection() {
        this(5, true);
    }

    public UtmProjection(int zone, boolean isNorth) {
        super("UtmProjection", false);
        this.convert2latlon = new Utm_To_Gdc_Converter(zone, isNorth);
        this.convert2xy = new Gdc_To_Utm_Converter(zone, isNorth);
        this.save = new SaveParams(this.convert2latlon.getA(), 1.0 / this.convert2latlon.getF(), zone, isNorth);
        this.addParameter("grid_mapping_name", GRID_MAPPING_NAME);
        this.addParameter("semi_major_axis", this.convert2latlon.getA());
        this.addParameter("inverse_flattening", this.convert2latlon.getF());
        this.addParameter(UTM_ZONE1, zone);
    }

    public UtmProjection(double a, double f, int zone, boolean isNorth) {
        super("UtmProjection", false);
        this.save = new SaveParams(a, f, zone, isNorth);
        this.convert2latlon = new Utm_To_Gdc_Converter(a, f, zone, isNorth);
        this.convert2xy = new Gdc_To_Utm_Converter(a, f, zone, isNorth);
        this.addParameter("grid_mapping_name", GRID_MAPPING_NAME);
        this.addParameter("semi_major_axis", a);
        this.addParameter("inverse_flattening", f);
        this.addParameter(UTM_ZONE1, zone);
    }

    public int getZone() {
        return this.convert2latlon.getZone();
    }

    public boolean isNorth() {
        return this.convert2latlon.isNorth();
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Universal transverse mercator";
    }

    public double getCentralMeridian() {
        return this.convert2xy.getCentralMeridian();
    }

    @Override
    public String paramsToString() {
        return this.getZone() + " " + this.isNorth();
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UtmProjection that = (UtmProjection)o;
        return this.save.equals(that.save);
    }

    public int hashCode() {
        return this.save.hashCode();
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        return this.convert2xy.latLonToProj(fromLat, fromLon, result);
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        return this.convert2xy.latLonToProj(from, to, latIndex, lonIndex);
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        return this.convert2xy.latLonToProj(from, to, latIndex, lonIndex);
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        return this.convert2latlon.projToLatLon(world.getX(), world.getY(), result);
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        return this.convert2latlon.projToLatLon(from, to);
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        return this.convert2latlon.projToLatLon(from, to);
    }

    public static void main(String[] arg) {
        UtmProjection utm = new UtmProjection(17, true);
        LatLonPoint ll = utm.projToLatLon(577.8000000000001, 2951.8);
        System.out.printf("%15.12f %15.12f%n", ll.getLatitude(), ll.getLongitude());
        assert (Misc.closeEnough(ll.getLongitude(), -80.21802662821469, 1.0E-8));
        assert (Misc.closeEnough(ll.getLatitude(), 26.685132668190793, 1.0E-8));
    }

    private static class SaveParams {
        final double a;
        final double f;
        final int zone;
        final boolean isNorth;

        private SaveParams(double a, double f, int zone, boolean isNorth) {
            this.a = a;
            this.f = f;
            this.zone = zone;
            this.isNorth = isNorth;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SaveParams that = (SaveParams)o;
            if (Double.compare(that.a, this.a) != 0) {
                return false;
            }
            if (Double.compare(that.f, this.f) != 0) {
                return false;
            }
            if (this.isNorth != that.isNorth) {
                return false;
            }
            return this.zone == that.zone;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.a);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.f);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.zone;
            result = 31 * result + (this.isNorth ? 1 : 0);
            return result;
        }
    }
}

