/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.ConversionException;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.MultiplyException;
import ucar.units.OperationException;
import ucar.units.RaiseException;
import ucar.units.Unit;
import ucar.units.UnitImpl;
import ucar.units.UnitName;

public final class OffsetUnit
extends UnitImpl
implements DerivableUnit {
    private static final long serialVersionUID = 1L;
    private final double _offset;
    private final Unit _unit;
    private DerivedUnit _derivedUnit;

    public OffsetUnit(Unit unit, double offset) {
        this(unit, offset, null);
    }

    public OffsetUnit(Unit unit, double offset, UnitName id) {
        super(id);
        if (!(unit instanceof OffsetUnit)) {
            this._unit = unit;
            this._offset = offset;
        } else {
            this._unit = ((OffsetUnit)unit)._unit;
            this._offset = ((OffsetUnit)unit)._offset + offset;
        }
    }

    static Unit getInstance(Unit unit, double origin) {
        return origin == 0.0 ? unit : new OffsetUnit(unit, origin);
    }

    public Unit getUnit() {
        return this._unit;
    }

    public double getOffset() {
        return this._offset;
    }

    @Override
    public Unit clone(UnitName id) {
        return new OffsetUnit(this.getUnit(), this.getOffset(), id);
    }

    @Override
    public Unit multiplyBy(double scale) throws MultiplyException {
        if (scale == 0.0) {
            throw new MultiplyException(scale, (Unit)this);
        }
        return OffsetUnit.getInstance(this._unit.multiplyBy(scale), this._offset / scale);
    }

    @Override
    public Unit shiftTo(double origin) {
        return OffsetUnit.getInstance(this._unit, origin + this._offset);
    }

    @Override
    protected Unit myMultiplyBy(Unit that) throws MultiplyException {
        return that instanceof OffsetUnit ? this.getUnit().multiplyBy(((OffsetUnit)that).getUnit()) : this.getUnit().multiplyBy(that);
    }

    @Override
    protected Unit myDivideBy(Unit that) throws OperationException {
        return that instanceof OffsetUnit ? this.getUnit().divideBy(((OffsetUnit)that).getUnit()) : this.getUnit().divideBy(that);
    }

    @Override
    protected Unit myDivideInto(Unit that) throws OperationException {
        return that instanceof OffsetUnit ? this.getUnit().divideInto(((OffsetUnit)that).getUnit()) : this.getUnit().divideInto(that);
    }

    @Override
    protected Unit myRaiseTo(int power) throws RaiseException {
        return this.getUnit().raiseTo(power);
    }

    @Override
    public DerivedUnit getDerivedUnit() {
        if (this._derivedUnit == null) {
            this._derivedUnit = this.getUnit().getDerivedUnit();
        }
        return this._derivedUnit;
    }

    @Override
    public float toDerivedUnit(float amount) throws ConversionException {
        return (float)this.toDerivedUnit((double)amount);
    }

    @Override
    public double toDerivedUnit(double amount) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        return ((DerivableUnit)((Object)this.getUnit())).toDerivedUnit(amount + this.getOffset());
    }

    @Override
    public float[] toDerivedUnit(float[] input, float[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        float origin = (float)this.getOffset();
        int i = input.length;
        while (--i >= 0) {
            output[i] = input[i] + origin;
        }
        return ((DerivableUnit)((Object)this.getUnit())).toDerivedUnit(output, output);
    }

    @Override
    public double[] toDerivedUnit(double[] input, double[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this, this.getDerivedUnit());
        }
        double origin = this.getOffset();
        int i = input.length;
        while (--i >= 0) {
            output[i] = input[i] + origin;
        }
        return ((DerivableUnit)((Object)this.getUnit())).toDerivedUnit(output, output);
    }

    @Override
    public float fromDerivedUnit(float amount) throws ConversionException {
        return (float)this.fromDerivedUnit((double)amount);
    }

    @Override
    public double fromDerivedUnit(double amount) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        return ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(amount) - this.getOffset();
    }

    @Override
    public float[] fromDerivedUnit(float[] input, float[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(input, output);
        float origin = (float)this.getOffset();
        int i = input.length;
        while (--i >= 0) {
            int n = i;
            output[n] = output[n] - origin;
        }
        return output;
    }

    @Override
    public double[] fromDerivedUnit(double[] input, double[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException(this.getDerivedUnit(), this);
        }
        ((DerivableUnit)((Object)this.getUnit())).fromDerivedUnit(input, output);
        double origin = this.getOffset();
        int i = input.length;
        while (--i >= 0) {
            int n = i;
            output[n] = output[n] - origin;
        }
        return output;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this._offset == 0.0) {
            return object.equals(this._unit);
        }
        if (!(object instanceof OffsetUnit)) {
            return false;
        }
        OffsetUnit that = (OffsetUnit)object;
        return this._offset == that._offset && this._unit.equals(that._unit);
    }

    @Override
    public int hashCode() {
        return (this.getOffset() == 0.0 ? 0 : Double.valueOf(this.getOffset()).hashCode()) ^ this.getUnit().hashCode();
    }

    @Override
    public boolean isDimensionless() {
        return this.getUnit().isDimensionless();
    }

    @Override
    public String toString() {
        String string = super.toString();
        return string != null ? string : this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        return "(" + this.getUnit().toString() + ") @ " + this.getOffset();
    }
}

