/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.grid.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.grid.CoverageCS;
import ucar.nc2.ft.grid.impl.CoverageCSImpl;
import ucar.nc2.ft.grid.impl.FmrcCSImpl;
import ucar.nc2.ft.grid.impl.GridCSImpl;
import ucar.nc2.ft.grid.impl.SwathCSImpl;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.RotatedPole;

public class CoverageCSFactory {
    CoverageCS.Type type;
    CoordinateAxis vertAxis;
    CoordinateAxis timeAxis;
    List<CoordinateAxis> standardAxes;
    List<CoordinateAxis> otherAxes;

    public static CoverageCS make(NetcdfDataset ds, CoordinateSystem cs) {
        CoverageCSFactory fac = new CoverageCSFactory();
        fac.type = fac.classify(ds, cs, null);
        switch (fac.type) {
            case Curvilinear: 
            case Coverage: {
                return new CoverageCSImpl(ds, cs, fac);
            }
            case Grid: {
                return new GridCSImpl(ds, cs, fac);
            }
            case Fmrc: {
                return new FmrcCSImpl(ds, cs, fac);
            }
            case Swath: {
                return new SwathCSImpl(ds, cs, fac);
            }
        }
        return null;
    }

    public static String describe(Formatter f, NetcdfDataset ds) {
        CoverageCSFactory fac = new CoverageCSFactory();
        fac.type = fac.classify(ds, f);
        return fac.toString();
    }

    public static String describe(Formatter f, CoordinateSystem cs) {
        CoverageCSFactory fac = new CoverageCSFactory();
        fac.type = fac.classify(null, cs, f);
        return fac.toString();
    }

    CoverageCSFactory() {
    }

    CoverageCS.Type classify(NetcdfDataset ds, Formatter errlog) {
        CoordinateSystem cs;
        if (errlog != null) {
            errlog.format("CoverageFactory for '%s'%n", ds.getLocation());
        }
        ArrayList<CoordinateSystem> css = new ArrayList<CoordinateSystem>(ds.getCoordinateSystems());
        Collections.sort(css, new Comparator<CoordinateSystem>(){

            @Override
            public int compare(CoordinateSystem o1, CoordinateSystem o2) {
                return o2.getCoordinateAxes().size() - o1.getCoordinateAxes().size();
            }
        });
        CoverageCS.Type isMine = null;
        Iterator iterator = css.iterator();
        while (iterator.hasNext() && (isMine = this.classify(ds, cs = (CoordinateSystem)iterator.next(), errlog)) == null) {
        }
        if (errlog != null) {
            errlog.format("coverage = %s%n", new Object[]{isMine});
        }
        return isMine;
    }

    CoverageCS.Type classify(NetcdfDataset ds, CoordinateSystem cs, Formatter errlog) {
        CoordinateAxis rt;
        CoordinateAxis t;
        List<Dimension> xyDomain;
        CoordinateAxis yaxis;
        CoordinateAxis xaxis;
        block39: {
            if (cs.getRankDomain() < 2) {
                if (errlog != null) {
                    errlog.format("CoordinateSystem '%s': domain rank < 2%n", cs.getName());
                }
                return null;
            }
            if (!cs.isLatLon()) {
                if (cs.getXaxis() == null || cs.getYaxis() == null) {
                    if (errlog != null) {
                        errlog.format("%s: NO Lat,Lon or X,Y axis%n", cs.getName());
                    }
                    return null;
                }
                if (null == cs.getProjection()) {
                    if (errlog != null) {
                        errlog.format("%s: NO projection found%n", cs.getName());
                    }
                    return null;
                }
            }
            if (cs.isGeoXY()) {
                xaxis = cs.getXaxis();
                yaxis = cs.getYaxis();
                ProjectionImpl p = cs.getProjection();
                if (!(p instanceof RotatedPole)) {
                    if (!SimpleUnit.kmUnit.isCompatible(xaxis.getUnitsString()) && errlog != null) {
                        errlog.format("%s: X axis units are not convertible to km%n", cs.getName());
                    }
                    if (!SimpleUnit.kmUnit.isCompatible(yaxis.getUnitsString()) && errlog != null) {
                        errlog.format("%s: Y axis units are not convertible to km%n", cs.getName());
                    }
                }
            } else {
                xaxis = cs.getLonAxis();
                yaxis = cs.getLatAxis();
            }
            if (xaxis.getRank() > 2 || yaxis.getRank() > 2) {
                if (errlog != null) {
                    errlog.format("%s: X and Y axis rank must be <= 2%n", cs.getName());
                }
                return null;
            }
            if (xaxis.getSize() < 2L || yaxis.getSize() < 2L) {
                if (errlog != null) {
                    errlog.format("%s: X and Y axis size must be >= 2%n", cs.getName());
                }
                return null;
            }
            xyDomain = CoordinateSystem.makeDomain(new CoordinateAxis[]{xaxis, yaxis});
            if (xyDomain.size() < 2) {
                if (errlog != null) {
                    errlog.format("%s: X and Y axis must have 2 or more dimensions%n", cs.getName());
                }
                return null;
            }
            this.standardAxes = new ArrayList<CoordinateAxis>();
            this.standardAxes.add(xaxis);
            this.standardAxes.add(yaxis);
            this.vertAxis = cs.getHeightAxis();
            if ((this.vertAxis == null || this.vertAxis.getRank() > 1) && cs.getPressureAxis() != null) {
                this.vertAxis = cs.getPressureAxis();
            }
            if ((this.vertAxis == null || this.vertAxis.getRank() > 1) && cs.getZaxis() != null) {
                this.vertAxis = cs.getZaxis();
            }
            if (this.vertAxis != null) {
                this.standardAxes.add(this.vertAxis);
            }
            t = cs.getTaxis();
            rt = cs.findAxis(AxisType.RunTime);
            if (rt != null && !(rt instanceof CoordinateAxis1D)) {
                if (errlog != null) {
                    errlog.format("%s: RunTime axis must be 1D%n", cs.getName());
                }
                return null;
            }
            if (t != null && !(t instanceof CoordinateAxis1D) && t.getRank() != 0 && rt != null) {
                if (rt.getRank() != 1) {
                    if (errlog != null) {
                        errlog.format("%s: Runtime axis must be 1D%n", cs.getName());
                    }
                    return null;
                }
                if (!rt.getDimension(0).equals(t.getDimension(0))) {
                    if (errlog != null) {
                        errlog.format("%s: Time axis must use first RunTime dimension%n", cs.getName());
                    }
                    return null;
                }
            }
            if (ds != null && t != null) {
                if (t instanceof CoordinateAxis1D) {
                    try {
                        if (t instanceof CoordinateAxis1DTime) {
                            this.timeAxis = t;
                            break block39;
                        }
                        t = this.timeAxis = CoordinateAxis1DTime.factory(ds, t, errlog);
                    }
                    catch (Exception e) {
                        if (errlog != null) {
                            errlog.format("%s: Error reading time coord= %s err= %s%n", t.getDatasetLocation(), t.getFullName(), e.getMessage());
                        }
                        break block39;
                    }
                }
                this.timeAxis = t;
            }
        }
        if (t != null) {
            this.standardAxes.add(t);
        } else if (rt != null) {
            this.standardAxes.add(rt);
        }
        List<CoordinateAxis> css = cs.getCoordinateAxes();
        if (this.standardAxes.size() < css.size()) {
            this.otherAxes = new ArrayList<CoordinateAxis>(3);
            for (CoordinateAxis axis : css) {
                if (this.standardAxes.contains(axis)) continue;
                this.otherAxes.add(axis);
            }
        }
        CoverageCS.Type result = null;
        result = cs.isLatLon() && xaxis.getRank() == 2 && yaxis.getRank() == 2 ? (rt != null && t != null && t.getRank() == 2 ? CoverageCS.Type.Fmrc : (t != null ? (CoordinateSystem.isSubset(t.getDimensionsAll(), xyDomain) ? CoverageCS.Type.Swath : CoverageCS.Type.Curvilinear) : CoverageCS.Type.Curvilinear)) : (xaxis.getRank() == 1 && yaxis.getRank() == 1 && (this.vertAxis == null || this.vertAxis.getRank() == 1) ? (rt != null && t != null && t.getRank() == 2 ? CoverageCS.Type.Fmrc : CoverageCS.Type.Grid) : CoverageCS.Type.Coverage);
        return result;
    }

    public String toString() {
        if (this.type == null) {
            return "";
        }
        Formatter f2 = new Formatter();
        f2.format("%s", new Object[]{this.type});
        f2.format("(", new Object[0]);
        int count = 0;
        Collections.sort(this.standardAxes, new Comparator<CoordinateAxis>(){

            @Override
            public int compare(CoordinateAxis o1, CoordinateAxis o2) {
                AxisType t1 = o1.getAxisType();
                AxisType t2 = o2.getAxisType();
                if (t1 != null && t2 != null) {
                    return t1.axisOrder() - t2.axisOrder();
                }
                return t1 == null ? (t2 == null ? 0 : -1) : 1;
            }
        });
        for (CoordinateAxis axis : this.standardAxes) {
            if (count++ > 0) {
                f2.format(",", new Object[0]);
            }
            f2.format("%s", axis.getAxisType() == null ? "none" : axis.getAxisType().getCFAxisName());
        }
        f2.format(")", new Object[0]);
        if (this.otherAxes != null && this.otherAxes.size() > 0) {
            f2.format(": ", new Object[0]);
            count = 0;
            for (CoordinateAxis axis : this.otherAxes) {
                if (count++ > 0) {
                    f2.format(",", new Object[0]);
                }
                f2.format("%s", axis.getShortName());
            }
        }
        return f2.toString();
    }
}

