/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.iosp.LayoutTiled;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.MemTracker;
import ucar.nc2.iosp.hdf5.Tiling;
import ucar.unidata.io.RandomAccessFile;

public class DataBTree {
    private static final boolean debugDataBtree = false;
    private static final boolean debugDataChunk = false;
    private static final boolean debugChunkOrder = false;
    private static PrintStream debugOut = System.out;
    private final H5header h5;
    private final RandomAccessFile raf;
    private final MemTracker memTracker;
    private final long rootNodeAddress;
    private final Tiling tiling;
    private final int ndimStorage;
    private final int wantType;
    private Variable owner;

    DataBTree(H5header h5, long rootNodeAddress, int[] varShape, int[] storageSize, MemTracker memTracker) throws IOException {
        this.h5 = h5;
        this.raf = h5.raf;
        this.rootNodeAddress = rootNodeAddress;
        this.tiling = new Tiling(varShape, storageSize);
        this.ndimStorage = storageSize.length;
        this.memTracker = memTracker;
        this.wantType = 1;
    }

    void setOwner(Variable owner) {
        this.owner = owner;
    }

    DataChunkIterator getDataChunkIteratorFilter(Section want) throws IOException {
        return new DataChunkIterator(want);
    }

    LayoutTiled.DataChunkIterator getDataChunkIteratorNoFilter(Section want, int nChunkDim) throws IOException {
        return new DataChunkIteratorNoFilter(want, nChunkDim);
    }

    class DataChunk {
        int size;
        int filterMask;
        int[] offset;
        long filePos;

        DataChunk(int ndim, boolean last) throws IOException {
            this.size = DataBTree.this.raf.readInt();
            this.filterMask = DataBTree.this.raf.readInt();
            this.offset = new int[ndim];
            for (int i = 0; i < ndim; ++i) {
                long loffset = DataBTree.this.raf.readLong();
                assert (loffset < Integer.MAX_VALUE);
                this.offset[i] = (int)loffset;
            }
            long l = this.filePos = last ? -1L : DataBTree.this.h5.readAddress();
            if (DataBTree.this.memTracker != null) {
                DataBTree.this.memTracker.addByLen("Chunked Data (" + DataBTree.this.owner + ")", this.filePos, this.size);
            }
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("  ChunkedDataNode size=").append(this.size).append(" filterMask=").append(this.filterMask).append(" filePos=").append(this.filePos).append(" offsets= ");
            int[] nArray = this.offset;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long anOffset = nArray[i];
                sbuff.append(anOffset).append(" ");
            }
            return sbuff.toString();
        }
    }

    class Node {
        private long address;
        private int level;
        private int nentries;
        private Node currentNode;
        private List<DataChunk> myEntries;
        private int[][] offset;
        private long[] childPointer;
        private int currentEntry;

        Node(long address, long parent) throws IOException {
            DataBTree.this.raf.order(1);
            DataBTree.this.raf.seek(DataBTree.this.h5.getFileOffset(address));
            this.address = address;
            String magic = DataBTree.this.raf.readString(4);
            if (!magic.equals("TREE")) {
                throw new IllegalStateException("DataBTree doesnt start with TREE");
            }
            byte type = DataBTree.this.raf.readByte();
            this.level = DataBTree.this.raf.readByte();
            this.nentries = DataBTree.this.raf.readShort();
            if (type != DataBTree.this.wantType) {
                throw new IllegalStateException("DataBTree must be type " + DataBTree.this.wantType);
            }
            long size = (long)(8 + 2 * DataBTree.this.h5.getSizeOffsets()) + (long)this.nentries * (long)(8 + DataBTree.this.h5.getSizeOffsets() + 8 + DataBTree.this.ndimStorage);
            if (DataBTree.this.memTracker != null) {
                DataBTree.this.memTracker.addByLen("Data BTree (" + DataBTree.this.owner + ")", address, size);
            }
            long leftAddress = DataBTree.this.h5.readOffset();
            long rightAddress = DataBTree.this.h5.readOffset();
            if (this.level == 0) {
                this.myEntries = new ArrayList<DataChunk>();
                for (int i = 0; i <= this.nentries; ++i) {
                    DataChunk dc = new DataChunk(DataBTree.this.ndimStorage, i == this.nentries);
                    this.myEntries.add(dc);
                }
            } else {
                this.offset = new int[this.nentries + 1][DataBTree.this.ndimStorage];
                this.childPointer = new long[this.nentries + 1];
                for (int i = 0; i <= this.nentries; ++i) {
                    DataBTree.this.raf.skipBytes(8);
                    for (int j = 0; j < DataBTree.this.ndimStorage; ++j) {
                        long loffset = DataBTree.this.raf.readLong();
                        assert (loffset < Integer.MAX_VALUE);
                        this.offset[i][j] = (int)loffset;
                    }
                    this.childPointer[i] = i == this.nentries ? -1L : DataBTree.this.h5.readOffset();
                }
            }
        }

        void first(int[] wantOrigin) throws IOException {
            if (this.level == 0) {
                this.currentEntry = 0;
                this.currentEntry = 0;
                while (this.currentEntry < this.nentries - 1) {
                    DataChunk entry = this.myEntries.get(this.currentEntry + 1);
                    if (wantOrigin != null && DataBTree.this.tiling.compare(wantOrigin, entry.offset) >= 0) {
                        ++this.currentEntry;
                        continue;
                    }
                    break;
                }
            } else {
                this.currentNode = null;
                this.currentEntry = 0;
                while (this.currentEntry < this.nentries) {
                    if (wantOrigin == null || DataBTree.this.tiling.compare(wantOrigin, this.offset[this.currentEntry + 1]) < 0) {
                        this.currentNode = new Node(this.childPointer[this.currentEntry], this.address);
                        this.currentNode.first(wantOrigin);
                        break;
                    }
                    ++this.currentEntry;
                }
                if (this.currentNode == null) {
                    this.currentEntry = this.nentries - 1;
                    this.currentNode = new Node(this.childPointer[this.currentEntry], this.address);
                    this.currentNode.first(wantOrigin);
                }
            }
            assert (this.nentries == 0 || this.currentEntry < this.nentries) : this.currentEntry + " >= " + this.nentries;
        }

        boolean hasNext() {
            if (this.level == 0) {
                return this.currentEntry < this.nentries;
            }
            if (this.currentNode.hasNext()) {
                return true;
            }
            return this.currentEntry < this.nentries - 1;
        }

        DataChunk next() throws IOException {
            if (this.level == 0) {
                return this.myEntries.get(this.currentEntry++);
            }
            if (this.currentNode.hasNext()) {
                return this.currentNode.next();
            }
            ++this.currentEntry;
            this.currentNode = new Node(this.childPointer[this.currentEntry], this.address);
            this.currentNode.first(null);
            return this.currentNode.next();
        }
    }

    class DataChunkIterator {
        private Node root;
        private int[] wantOrigin;

        DataChunkIterator(Section want) throws IOException {
            this.root = new Node(DataBTree.this.rootNodeAddress, -1L);
            this.wantOrigin = want != null ? want.getOrigin() : null;
            this.root.first(this.wantOrigin);
        }

        public boolean hasNext() {
            return this.root.hasNext();
        }

        public DataChunk next() throws IOException {
            return this.root.next();
        }
    }

    class DataChunkIteratorNoFilter
    implements LayoutTiled.DataChunkIterator {
        private Node root;
        private int nChunkDim;

        DataChunkIteratorNoFilter(Section want, int nChunkDim) throws IOException {
            this.nChunkDim = nChunkDim;
            this.root = new Node(DataBTree.this.rootNodeAddress, -1L);
            int[] wantOrigin = want != null ? want.getOrigin() : null;
            this.root.first(wantOrigin);
        }

        @Override
        public boolean hasNext() {
            return this.root.hasNext();
        }

        @Override
        public LayoutTiled.DataChunk next() throws IOException {
            DataChunk dc = this.root.next();
            int[] offset = dc.offset;
            if (offset.length > this.nChunkDim) {
                offset = new int[this.nChunkDim];
                System.arraycopy(dc.offset, 0, offset, 0, this.nChunkDim);
            }
            return new LayoutTiled.DataChunk(offset, dc.filePos);
        }
    }
}

