/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3f;

public class UniverseBuilderJ3D {
    private Canvas3D canvas;
    private VirtualUniverse universe;
    private Locale locale;
    TransformGroup vpTrans;
    View view;
    private BranchGroup vpRoot;
    private ViewPlatform vp;
    private static long minimumFrameCycleTime = 0L;

    public UniverseBuilderJ3D(Canvas3D c) {
        this.canvas = c;
        this.universe = new VirtualUniverse();
        this.locale = new Locale(this.universe);
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        this.view = new View();
        this.view.addCanvas3D(c);
        this.view.setPhysicalBody(body);
        this.view.setPhysicalEnvironment(environment);
        if (minimumFrameCycleTime != 0L) {
            this.view.setMinimumFrameCycleTime(minimumFrameCycleTime);
        }
        this.vpRoot = new BranchGroup();
        this.vpRoot.setCapability(17);
        this.vpRoot.setCapability(12);
        Transform3D t = new Transform3D();
        t.set(new Vector3f(0.0f, 0.0f, 2.0f));
        this.vp = new ViewPlatform();
        this.vpTrans = new TransformGroup(t);
        this.vpTrans.setCapability(12);
        this.vpTrans.setCapability(17);
        this.vpTrans.setCapability(18);
        this.vpTrans.addChild((Node)this.vp);
        this.vpRoot.addChild((Node)this.vpTrans);
        this.view.attachViewPlatform(this.vp);
        this.locale.addBranchGraph(this.vpRoot);
    }

    public static void setMinimumFrameCycleTime(long ms) {
        minimumFrameCycleTime = ms;
    }

    public void addBranchGraph(BranchGroup bg) {
        if (this.locale != null) {
            this.locale.addBranchGraph(bg);
        }
    }

    public void destroy() {
        for (int idx = 0; idx < this.view.numCanvas3Ds(); ++idx) {
            Canvas3D cvs = this.view.getCanvas3D(idx);
            if (cvs.isOffScreen()) {
                cvs.setOffScreenBuffer(null);
            }
            this.view.removeCanvas3D(cvs);
        }
        try {
            this.view.attachViewPlatform(null);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.universe.removeAllLocales();
        this.canvas = null;
        this.universe = null;
        this.locale = null;
        this.vpTrans = null;
        this.view = null;
        this.vpRoot = null;
        this.vp = null;
    }
}

