/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.image.input;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import ucar.jpeg.jj2000.j2k.JJ2KExceptionHandler;
import ucar.jpeg.jj2000.j2k.image.DataBlk;
import ucar.jpeg.jj2000.j2k.image.DataBlkInt;
import ucar.jpeg.jj2000.j2k.image.input.ImgReader;
import ucar.jpeg.jj2000.j2k.io.EndianType;

public class ImgReaderPGX
extends ImgReader
implements EndianType {
    private int offset;
    private RandomAccessFile in;
    private int bitDepth;
    private boolean isSigned;
    private int packBytes;
    private int byteOrder;
    private byte[] buf;
    private DataBlkInt intBlk;

    public ImgReaderPGX(File in) throws IOException {
        String header;
        if (!in.exists()) {
            throw new IllegalArgumentException("PGX file " + in.getName() + " does not exist");
        }
        this.in = new RandomAccessFile(in, "r");
        try {
            header = this.in.readLine();
        }
        catch (IOException e) {
            throw new IOException(in.getName() + " is not a PGX file");
        }
        if (header == null) {
            throw new IOException(in.getName() + " is an empty file");
        }
        this.offset = header.length() + 1;
        StringTokenizer st = new StringTokenizer(header);
        try {
            int nTokens = st.countTokens();
            if (!st.nextToken().equals("PG")) {
                throw new IOException(in.getName() + " is not a PGX file");
            }
            String tmp = st.nextToken();
            if (tmp.equals("LM")) {
                this.byteOrder = 1;
            } else if (tmp.equals("ML")) {
                this.byteOrder = 0;
            } else {
                throw new IOException(in.getName() + " is not a PGX file");
            }
            if (nTokens == 6) {
                tmp = st.nextToken();
                if (tmp.equals("+")) {
                    this.isSigned = false;
                } else if (tmp.equals("-")) {
                    this.isSigned = true;
                } else {
                    throw new IOException(in.getName() + " is not a PGX file");
                }
            }
            try {
                this.bitDepth = new Integer(st.nextToken());
                if (this.bitDepth <= 0 || this.bitDepth > 31) {
                    throw new IOException(in.getName() + " is not a valid PGX file");
                }
                this.w = new Integer(st.nextToken());
                this.h = new Integer(st.nextToken());
            }
            catch (NumberFormatException e) {
                throw new IOException(in.getName() + " is not a PGX file");
            }
        }
        catch (NoSuchElementException e) {
            throw new IOException(in.getName() + " is not a PGX file");
        }
        this.nc = 1;
        this.packBytes = this.bitDepth <= 8 ? 1 : (this.bitDepth <= 16 ? 2 : 4);
    }

    public ImgReaderPGX(String inName) throws IOException {
        this(new File(inName));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    @Override
    public int getNomRangeBits(int c) {
        if (c != 0) {
            throw new IllegalArgumentException();
        }
        return this.bitDepth;
    }

    @Override
    public int getFixedPoint(int c) {
        if (c != 0) {
            throw new IllegalArgumentException();
        }
        return 0;
    }

    @Override
    public DataBlk getInternCompData(DataBlk blk, int c) {
        int[] barr;
        int levShift = 1 << this.bitDepth - 1;
        if (c != 0) {
            throw new IllegalArgumentException();
        }
        if (blk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(blk.ulx, blk.uly, blk.w, blk.h);
            } else {
                this.intBlk.ulx = blk.ulx;
                this.intBlk.uly = blk.uly;
                this.intBlk.w = blk.w;
                this.intBlk.h = blk.h;
            }
            blk = this.intBlk;
        }
        if ((barr = (int[])blk.getData()) == null || barr.length < blk.w * blk.h * this.packBytes) {
            barr = new int[blk.w * blk.h];
            blk.setData(barr);
        }
        int paddingLength = 32 - this.bitDepth;
        if (this.buf == null || this.buf.length < this.packBytes * blk.w) {
            this.buf = new byte[this.packBytes * blk.w];
        }
        try {
            switch (this.packBytes) {
                case 1: {
                    int mi = blk.uly + blk.h;
                    if (this.isSigned) {
                        for (int i = blk.uly; i < mi; ++i) {
                            this.in.seek(this.offset + i * this.w + blk.ulx);
                            this.in.read(this.buf, 0, blk.w);
                            int k = (i - blk.uly) * blk.w + blk.w - 1;
                            int j = blk.w - 1;
                            while (j >= 0) {
                                barr[k] = (this.buf[j--] & 0xFF) << paddingLength >> paddingLength;
                                --k;
                            }
                        }
                    } else {
                        for (int i = blk.uly; i < mi; ++i) {
                            this.in.seek(this.offset + i * this.w + blk.ulx);
                            this.in.read(this.buf, 0, blk.w);
                            int k = (i - blk.uly) * blk.w + blk.w - 1;
                            int j = blk.w - 1;
                            while (j >= 0) {
                                barr[k] = ((this.buf[j--] & 0xFF) << paddingLength >>> paddingLength) - levShift;
                                --k;
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    int mi = blk.uly + blk.h;
                    if (this.isSigned) {
                        block27: for (int i = blk.uly; i < mi; ++i) {
                            this.in.seek(this.offset + 2 * (i * this.w + blk.ulx));
                            this.in.read(this.buf, 0, blk.w << 1);
                            switch (this.byteOrder) {
                                case 1: {
                                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                                    int j = (blk.w << 1) - 1;
                                    while (j >= 0) {
                                        barr[k] = ((this.buf[j--] & 0xFF) << 8 | this.buf[j--] & 0xFF) << paddingLength >> paddingLength;
                                        --k;
                                    }
                                    continue block27;
                                }
                                case 0: {
                                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                                    int j = (blk.w << 1) - 1;
                                    while (j >= 0) {
                                        barr[k] = (this.buf[j--] & 0xFF | (this.buf[j--] & 0xFF) << 8) << paddingLength >> paddingLength;
                                        --k;
                                    }
                                    continue block27;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                        }
                    } else {
                        block30: for (int i = blk.uly; i < mi; ++i) {
                            this.in.seek(this.offset + 2 * (i * this.w + blk.ulx));
                            this.in.read(this.buf, 0, blk.w << 1);
                            switch (this.byteOrder) {
                                case 1: {
                                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                                    int j = (blk.w << 1) - 1;
                                    while (j >= 0) {
                                        barr[k] = (((this.buf[j--] & 0xFF) << 8 | this.buf[j--] & 0xFF) << paddingLength >>> paddingLength) - levShift;
                                        --k;
                                    }
                                    continue block30;
                                }
                                case 0: {
                                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                                    int j = (blk.w << 1) - 1;
                                    while (j >= 0) {
                                        barr[k] = ((this.buf[j--] & 0xFF | (this.buf[j--] & 0xFF) << 8) << paddingLength >>> paddingLength) - levShift;
                                        --k;
                                    }
                                    continue block30;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    int mi = blk.uly + blk.h;
                    if (this.isSigned) {
                        block33: for (int i = blk.uly; i < mi; ++i) {
                            this.in.seek(this.offset + 4 * (i * this.w + blk.ulx));
                            this.in.read(this.buf, 0, blk.w << 2);
                            switch (this.byteOrder) {
                                case 1: {
                                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                                    int j = (blk.w << 2) - 1;
                                    while (j >= 0) {
                                        barr[k] = ((this.buf[j--] & 0xFF) << 24 | (this.buf[j--] & 0xFF) << 16 | (this.buf[j--] & 0xFF) << 8 | this.buf[j--] & 0xFF) << paddingLength >> paddingLength;
                                        --k;
                                    }
                                    continue block33;
                                }
                                case 0: {
                                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                                    int j = (blk.w << 2) - 1;
                                    while (j >= 0) {
                                        barr[k] = (this.buf[j--] & 0xFF | (this.buf[j--] & 0xFF) << 8 | (this.buf[j--] & 0xFF) << 16 | (this.buf[j--] & 0xFF) << 24) << paddingLength >> paddingLength;
                                        --k;
                                    }
                                    continue block33;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                        }
                    } else {
                        block36: for (int i = blk.uly; i < mi; ++i) {
                            this.in.seek(this.offset + 4 * (i * this.w + blk.ulx));
                            this.in.read(this.buf, 0, blk.w << 2);
                            switch (this.byteOrder) {
                                case 1: {
                                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                                    int j = (blk.w << 2) - 1;
                                    while (j >= 0) {
                                        barr[k] = (((this.buf[j--] & 0xFF) << 24 | (this.buf[j--] & 0xFF) << 16 | (this.buf[j--] & 0xFF) << 8 | this.buf[j--] & 0xFF) << paddingLength >>> paddingLength) - levShift;
                                        --k;
                                    }
                                    continue block36;
                                }
                                case 0: {
                                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                                    int j = (blk.w << 2) - 1;
                                    while (j >= 0) {
                                        barr[k] = ((this.buf[j--] & 0xFF | (this.buf[j--] & 0xFF) << 8 | (this.buf[j--] & 0xFF) << 16 | (this.buf[j--] & 0xFF) << 24) << paddingLength >>> paddingLength) - levShift;
                                        --k;
                                    }
                                    continue block36;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new IOException("PGX supports only bit-depth between 1 and 31");
                }
            }
        }
        catch (IOException e) {
            JJ2KExceptionHandler.handleException(e);
        }
        blk.progressive = false;
        blk.offset = 0;
        blk.scanw = blk.w;
        return blk;
    }

    @Override
    public DataBlk getCompData(DataBlk blk, int c) {
        return this.getInternCompData(blk, c);
    }

    @Override
    public boolean isOrigSigned(int c) {
        if (c != 0) {
            throw new IllegalArgumentException();
        }
        return this.isSigned;
    }

    public String toString() {
        return "ImgReaderPGX: WxH = " + this.w + "x" + this.h + ", Component = 0" + ", Bit-depth = " + this.bitDepth + ", signed = " + this.isSigned + "\nUnderlying RandomAccessIO:\n" + this.in.toString();
    }
}

