/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.Tuple;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.fits.ExceptionStack;
import visad.data.fits.FitsAdapter;

public class FitsForm
extends Form
implements FormFileInformer {
    public FitsForm() {
        super("FitsForm");
    }

    public boolean isThisType(String name) {
        return name.endsWith(".fits");
    }

    public boolean isThisType(byte[] block) {
        String front = new String(block, 0, 9);
        if (!front.startsWith("SIMPLE  =")) {
            return false;
        }
        String back = new String(block, 9, 71);
        return (back = back.trim()).length() == 1 && back.charAt(0) == 'T';
    }

    public String[] getDefaultSuffixes() {
        String[] suff = new String[]{"fits"};
        return suff;
    }

    public synchronized void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        new FitsAdapter().save(id, data, replace);
    }

    public synchronized void add(String id, Data data, boolean replace) throws BadFormException {
        throw new RuntimeException("Can't yet add FITS objects");
    }

    private DataImpl extractData(FitsAdapter fits) throws RemoteException, VisADException {
        Data[] data;
        ExceptionStack eStack = null;
        try {
            data = fits.getData();
        }
        catch (ExceptionStack e) {
            eStack = e;
            fits.clearExceptionStack();
            data = fits.getData();
        }
        fits = null;
        if (data == null || data.length == 0) {
            if (eStack != null) {
                throw eStack;
            }
            return null;
        }
        DataImpl di = data.length == 1 ? (DataImpl)data[0] : new Tuple(data);
        data = null;
        return di;
    }

    public synchronized DataImpl open(String path) throws BadFormException, RemoteException, VisADException {
        return this.extractData(new FitsAdapter(path));
    }

    public synchronized DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        return this.extractData(new FitsAdapter(url));
    }

    public synchronized FormNode getForms(Data data) {
        throw new RuntimeException("Can't yet get FITS forms");
    }
}

